/*
 * @(#)MotifComboBoxUI.java	1.14 98/04/21
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
package com.sun.java.swing.plaf.motif;

import java.awt.*;
import com.sun.java.swing.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.basic.*;
import java.io.Serializable;
import java.awt.event.*;

/**
 * ComboBox motif look and feel
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.14 04/21/98
 * @author Arnaud Weber
 */
public class MotifComboBoxUI extends BasicComboBoxUI implements Serializable {
    Icon arrowIcon;
    static final int HORIZ_MARGIN = 3;

    public static ComponentUI createUI(JComponent c) {
        return new MotifComboBoxUI();
    }  

    public void installUI(JComponent c) {
        super.installUI(c);
        c.setBorder(new CompoundBorder(MotifBorderFactory.getFocusBorder(),
                                       MotifBorderFactory.getRaisedBevelBorder()));
        arrowIcon = new MotifComboBoxArrowIcon(UIManager.getColor("controlHighlight"),
                                               UIManager.getColor("controlShadow"),
                                               UIManager.getColor("control"));

        final Component edit = editor;
        SwingUtilities.invokeLater( new Runnable(){
                                    public void run(){
                                    if ( edit != null ){
                                    edit.setBackground( UIManager.getColor( "text" ) );}}});
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        c.setBorder(null);
    }

    protected ComboPopup createPopup() {
        return new MotifComboPopup( comboBox );
    }

    protected class MotifComboPopup extends BasicComboPopup {
        JComboBox cBox;
        public MotifComboPopup( JComboBox comboBox ) {
            super( comboBox );
            cBox = comboBox;
        }
        protected MouseMotionListener createListMouseMotionListener() {
            return new MouseMotionAdapter() {};
        }

        public KeyListener createKeyListener() {
            return new MotifKeyListener();
        }

        protected class MotifKeyListener extends InvocationKeyListener {
            public void keyReleased( KeyEvent e ) {
                if ( !cBox.isEditable() ) {
                    if ( e.getKeyCode() == KeyEvent.VK_DOWN ) {
                        if ( !isVisible() ) {
                            show();
                        }
                    }
                    else {
                        super.keyReleased( e );
                    }
                }
                else {
                    if ( e.getKeyCode() == KeyEvent.VK_UP ||
                         e.getKeyCode() == KeyEvent.VK_DOWN ) {
                        if ( !isVisible() ) {
                            show();
                        }
                    }
                }
            }
        }
    }

    protected void addSubComponents() {
        if ( comboBox.isEditable() ) {
            addEditor();
        }

        comboBox.add( currentValuePane );
    }

    protected void removeSubComponents() {
        removeEditor();
        comboBox.removeAll();
    }

    public void paint(Graphics g, JComponent c) {
        boolean hasFocus = comboBox.hasFocus();
        Rectangle r;

        g.setColor(comboBox.getBackground()/*UIManager.getColor("ComboBox.control")*/);
        g.fillRect(0,0,c.getWidth(),c.getHeight());

        if ( !comboBox.isEditable() ) {
            r = rectangleForCurrentValue();
            paintCurrentValue(g,r,hasFocus);
        }
        r = rectangleForArrowIcon();
        arrowIcon.paintIcon(c,g,r.x,r.y);
        if ( !comboBox.isEditable() ) {
            Border border = comboBox.getBorder();
            Insets in = border.getBorderInsets(comboBox);
            // Draw the separation
            r.x -= (HORIZ_MARGIN + 2);
            r.y = in.top;
            r.width = 1;
            r.height = comboBox.getBounds().height - in.bottom - in.top;
            g.setColor(UIManager.getColor("controlShadow"));
            g.fillRect(r.x,r.y,r.width,r.height);
            r.x++;
            g.setColor(UIManager.getColor("controlHighlight"));
            g.fillRect(r.x,r.y,r.width,r.height);
        }
    }

    public void paintCurrentValue(Graphics g,Rectangle bounds,boolean hasFocus) {
        ListCellRenderer renderer = comboBox.getRenderer();
        Component c;
        Dimension d;
        c = renderer.getListCellRendererComponent(listBox, comboBox.getSelectedItem(), -1, false, false);
        c.setFont(comboBox.getFont());
        if ( comboBox.isEnabled() ) {
            c.setForeground(comboBox.getForeground());
            c.setBackground(comboBox.getBackground());
        }
        else {
            c.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
            c.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
        }
        d  = c.getPreferredSize();
        currentValuePane.paintComponent(g,c,comboBox,bounds.x,bounds.y,
                                        bounds.width,d.height);
    }

    protected Rectangle rectangleForArrowIcon() {
        Rectangle b = comboBox.getBounds();
        Border border = comboBox.getBorder();
        Insets in = border.getBorderInsets(comboBox);
        b.x = in.left;
        b.y = in.top;
        b.width -= (in.left + in.right);
        b.height -= (in.top + in.bottom);

        b.x = b.x + b.width - HORIZ_MARGIN - arrowIcon.getIconWidth();
        b.y = b.y + (b.height - arrowIcon.getIconHeight()) / 2;
        b.width = arrowIcon.getIconWidth();
        b.height = arrowIcon.getIconHeight();
        return b;
    }

    protected Rectangle rectangleForCurrentValue() {
        Border b = comboBox.getBorder();
        Dimension cbSize = comboBox.getSize();
        Insets in = b.getBorderInsets(comboBox);
        return new Rectangle(in.left,in.top,cbSize.width - iconAreaWidth() - in.left -in.right,
                             cbSize.height - in.bottom - in.top);
    }

    public int iconAreaWidth() {
        if ( comboBox.isEditable() )
            return arrowIcon.getIconWidth() + (2 * HORIZ_MARGIN);
        else
            return arrowIcon.getIconWidth() + (3 * HORIZ_MARGIN) + 2;
    }

    public void configureEditor() {
        super.configureEditor();
        editor.setBackground( UIManager.getColor( "text" ) );
    }

    public void layoutContainer(Container parent) {
        if ( editor != null ) {
            Rectangle cvb = rectangleForCurrentValue();
            cvb.x += 1;
            cvb.y += 1;
            cvb.width -= 1;
            cvb.height -= 2;
            editor.setBounds(cvb);
        }
    }

    static class MotifComboBoxArrowIcon implements Icon, Serializable {
        private Color lightShadow;
        private Color darkShadow;
        private Color fill;

        public MotifComboBoxArrowIcon(Color lightShadow, Color darkShadow, Color fill) {
            this.lightShadow = lightShadow;
            this.darkShadow = darkShadow;
            this.fill = fill;
        }


        public void paintIcon(Component c, Graphics g, int xo, int yo) {
            int w = getIconWidth();
            int h = getIconHeight();

            g.setColor(lightShadow);
            g.drawLine(xo, yo, xo+w-1, yo);
            g.drawLine(xo, yo+1, xo+w-3, yo+1);
            g.setColor(darkShadow);
            g.drawLine(xo+w-2, yo+1, xo+w-1, yo+1);

            for ( int x = xo+1, y = yo+2, dx = w-6; y+1 < yo+h; y += 2 ) {
                g.setColor(lightShadow);
                g.drawLine(x, y,   x+1, y);
                g.drawLine(x, y+1, x+1, y+1);
                if ( dx > 0 ) {
                    g.setColor(fill);
                    g.drawLine(x+2, y,   x+1+dx, y);
                    g.drawLine(x+2, y+1, x+1+dx, y+1);
                }
                g.setColor(darkShadow);
                g.drawLine(x+dx+2, y,   x+dx+3, y);
                g.drawLine(x+dx+2, y+1, x+dx+3, y+1);
                x += 1;
                dx -= 2;
            }

            g.setColor(darkShadow);
            g.drawLine(xo+(w/2), yo+h-1, xo+(w/2), yo+h-1); 

        }

        public int getIconWidth() {
            return 11;
        }

        public int getIconHeight() {
            return 11;
        }
    }

    protected void selectNextPossibleValue() {
        super.selectNextPossibleValue();
    }

    protected void selectPreviousPossibleValue() {
        super.selectPreviousPossibleValue();
    }

    protected void addKeyAccelerators(JComponent comp) {
        super.addKeyAccelerators( comp );

        final JComboBox thisComboBox = comboBox;
        final MotifComboBoxUI thisUI = this;

        AbstractAction downAction = new AbstractAction() {
            public void actionPerformed( ActionEvent e ) {
                thisUI.selectNextPossibleValue();
            }
            public boolean isEnabled() {
                return thisComboBox.isEnabled() && popupIsVisible();
            }
        };

        thisComboBox.registerKeyboardAction( downAction,
                                             KeyStroke.getKeyStroke( KeyEvent.VK_DOWN, 0 ),
                                             JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);

        AbstractAction upAction = new AbstractAction() {
            public void actionPerformed( ActionEvent e ) {
                thisUI.selectPreviousPossibleValue();
            }
            public boolean isEnabled(){
                return thisComboBox.isEnabled() && popupIsVisible();
            }       
        };

        thisComboBox.registerKeyboardAction( upAction,
                                             KeyStroke.getKeyStroke( KeyEvent.VK_UP, 0 )
                                             ,JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
    }

    protected void removeKeyAccelerators(JComponent comp) {
        super.removeKeyAccelerators( comp );
        comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(KeyEvent.VK_DOWN,0));
        comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(KeyEvent.VK_UP,0));
    }
}


