/*
 * @(#)MotifCheckBoxMenuItemUI.java	1.31 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
 
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.*;
import com.sun.java.swing.event.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.plaf.basic.BasicButtonListener;
import com.sun.java.swing.plaf.basic.BasicCheckBoxMenuItemUI;
import com.sun.java.swing.plaf.basic.BasicGraphicsUtils;

import java.awt.*;
import java.awt.event.*;
import java.io.Serializable;


/**
 * MotifCheckboxMenuItem implementation
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.31 02/02/98
 * @author Georges Saab
 * @author Rich Schiavi
 */
public class MotifCheckBoxMenuItemUI extends BasicCheckBoxMenuItemUI
{
    protected ChangeListener changeListener;

    public static ComponentUI createUI(JComponent b) {
        return new MotifCheckBoxMenuItemUI();
    }

    protected void initListeners(JComponent c) {
	super.initListeners(c);
        changeListener = createChangeListener(c);
    }
    
    protected void addListeners(JComponent c) {
	super.addListeners(c);
        ((JMenuItem)c).addChangeListener(changeListener);	
    }

    protected void removeListeners(JComponent c) {
	super.removeListeners(c);
	((JMenuItem)c).removeChangeListener(changeListener);
    }

    protected ChangeListener createChangeListener(JComponent c) {
	return new MenuChangeListener();
    }

    protected class MenuChangeListener implements ChangeListener, Serializable {


	public void stateChanged(ChangeEvent e) {
	    JMenuItem c = (JMenuItem)e.getSource();
	    if (c.isArmed()) {
		c.setBorderPainted(true);
	    } else {
		c.setBorderPainted(false);
	    }
	}
    }

    public void paint(Graphics g, JComponent c) {
	MotifGraphicsUtils.paintMenuItem(g, c, ((JCheckBoxMenuItem)c).getSelectedIcon(),menuArrow,
					 pressedBackground, pressedForeground,
					 defaultTextIconGap);
    }


    public void processMouseEvent(JMenuItem item,MouseEvent e,MenuElement path[],MenuSelectionManager manager) {
        Point p = e.getPoint();
        if(p.x >= 0 && p.x < item.getWidth() &&
           p.y >= 0 && p.y < item.getHeight()) {
            if(e.getID() == MouseEvent.MOUSE_RELEASED) {
                manager.clearSelectedPath();
                item.doClick(0);
            } else if(e.getID() == MouseEvent.MOUSE_DRAGGED || e.getID() == MouseEvent.MOUSE_PRESSED)
                manager.setSelectedPath(path);
        } else if(item.getModel().isArmed() && e.getID() == MouseEvent.MOUSE_DRAGGED) {
            MenuElement newPath[] = new MenuElement[path.length-1];
            int i,c;
            for(i=0,c=path.length-1;i<c;i++)
                newPath[i] = path[i];
            manager.setSelectedPath(newPath);
        }
    }

}









