/*
 * @(#)MotifButtonUI.java	1.12 98/04/10
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
 
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.basic.*;
import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.plaf.*;

/**
 * MotifButton implementation
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.12 04/10/98
 * @author Rich Schiavi
 */
public class MotifButtonUI extends BasicButtonUI {
  /**
   * border & margin
   */
  protected final static Insets defaultMargin = new Insets(2,4,2,4);

  private final static MotifButtonUI motifButtonUI = new MotifButtonUI();


  public static ComponentUI createUI(JComponent c){
    return motifButtonUI;
  }
 
  protected BasicButtonListener createListener(JComponent c){
    return new MotifButtonListener((AbstractButton) c);
  }

  protected void paintFocus(Graphics g, AbstractButton b,
			    Rectangle viewRect, Rectangle textRect, Rectangle iconRect){
    // focus painting is handled by the border
  }

  protected void paintButtonPressed(Graphics g, AbstractButton b){
     Color oldColor = g.getColor();
     Dimension size = b.getSize();
     Insets insets = b.getInsets();
     Border border = b.getBorder();
     if (border instanceof BorderUIResource) {
         // Unfortunately the BorderUIResource hides the Border
         // it's wrapping, so we have to make an assumption here.
         border = MotifBorderFactory.getButtonBorder();
         insets = border.getBorderInsets(b);
     }
     g.setColor( getSelectColor());
     g.fillRect(insets.left, insets.top, 
                   size.width - insets.left - insets.right,
                   size.height - insets.top - insets.bottom);
     g.setColor(oldColor);
  }

  public Insets getDefaultMargin(AbstractButton b){
    return defaultMargin;
  }

}




							      
  
