/*
 * @(#)MotifBorderFactory.java	1.17 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.plaf.basic.BasicFieldBorder;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Dimension;
import java.awt.Color;
import java.awt.Graphics;
import java.io.Serializable;

/**
 * Factory object that can vend Icons appropriate for the basic L & F.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.17 02/02/98
 * @author Amy Fowler
 */
public class MotifBorderFactory implements Serializable
{
    private static Border loweredBevelBorder;
    private static Border raisedBevelBorder;
    private static Border buttonBorder;
    private static Border toggleButtonBorder;
    private static Border focusBorder;
    private static Border fieldBorder;
    private static Border menuBarBorder;


    public static Border getLoweredBevelBorder() {
	if (loweredBevelBorder == null) {
	    loweredBevelBorder = new BevelBorder(false);
	}
	return loweredBevelBorder;
    }

    public static Border getRaisedBevelBorder() {
	if (raisedBevelBorder == null) {
	    raisedBevelBorder = new BevelBorder(true);
	}
	return raisedBevelBorder;
    }

    public static Border getButtonBorder() {
       if (buttonBorder == null){
	   buttonBorder = new ButtonBorder();
       }
       return buttonBorder;
    }

    public static Border getFocusBorder() {
       if (focusBorder == null){
	   focusBorder = new FocusBorder();
       }
       return focusBorder;
    }

    public static Border getFieldBorder() {
       if (fieldBorder == null){
	   fieldBorder = new FieldBorder();
       }
       return fieldBorder;
    }

    public static Border getToggleButtonBorder() {
       if (toggleButtonBorder == null){
	   toggleButtonBorder = new ToggleButtonBorder();
       }
       return toggleButtonBorder;
    }

    public static Border getMenuBarBorder(){
      if (menuBarBorder == null){
	   menuBarBorder = new MenuBarBorder();
      }
      return menuBarBorder;
    }


    private static class BevelBorder extends AbstractBorder implements UIResource, Serializable
    {
	private Color darkShadow = UIManager.getColor("controlShadow");
	private Color lightShadow = UIManager.getColor("controlLtHighlight");
	private boolean isRaised;

	public BevelBorder(boolean isRaised) {
	    this.isRaised = isRaised;
	}

	public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
	    g.setColor((isRaised) ? lightShadow : darkShadow);
	    g.drawLine(x, y, x+w-1, y);           // top
	    g.drawLine(x, y+h-1, x, y+1);         // left

	    g.setColor((isRaised) ? darkShadow : lightShadow);
	    g.drawLine(x+1, y+h-1, x+w-1, y+h-1); // bottom
	    g.drawLine(x+w-1, y+h-1, x+w-1, y+1); // right
	}

	public Insets getBorderInsets(Component c) { 
	    return new Insets(1, 1, 1, 1);
	}

	public boolean isOpaque(Component c) { 
	    return true;
	}

    }


    private static class FocusBorder extends AbstractBorder implements UIResource, Serializable
    {
        private Color controlFocus;
	private Color control;

	public FocusBorder() {
	}

	public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
	    if (((JComponent)c).hasFocus()) {
                if(controlFocus == null)
                    controlFocus = UIManager.getColor("activeCaptionBorder");
	        g.setColor(controlFocus); 
		g.drawRect(x, y, w-1, h-1);
	    } else {
                if(control == null)
                    control = UIManager.getColor("control");
		g.setColor(control);
		g.drawRect(x, y, w-1, h-1);
	    }
	}

	public Insets getBorderInsets(Component c) { 
	    return new Insets(1,1,1,1);
	}

	final static Insets insets = new Insets(1, 1, 1, 1);
    }

    private static class MarginBorder extends AbstractBorder implements UIResource, Serializable
    {
	
	MarginBorder(Insets i) {
	    this.i = i;
	}

	public Insets getBorderInsets(Component c) { 
	    return i;
	}

	private Insets i;
    }

    private static class FieldBorder extends CompoundBorder implements UIResource, Serializable
{

	public FieldBorder() {
	    super(getFocusBorder(), new CompoundBorder(getLoweredBevelBorder(),
						       new MarginBorder(new Insets(3, 3, 3, 3))));
	}

/*
	public boolean isOpaque(Component c) { 
	    return true;
	}
	*/
    }

  static class ButtonBorder extends AbstractBorder implements UIResource, Serializable
  {
    final static Insets insets = new Insets(7, 7, 8, 8);

    private Color disabled = UIManager.getColor("controlDisabled");
    private Color controlFocus = UIManager.getColor("activeCaptionBorder");
    private Color controlShadow = UIManager.getColor("controlShadow");
    private Color lightShadow = UIManager.getColor("controlLtHighlight");
    private Color controlHighlight = UIManager.getColor("controlHighlight");
    private Color ltHighlight = UIManager.getColor("controlLtHightlight");
      
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
      boolean isPressed = false;
      boolean hasFocus = false;
      boolean isDefault = false;

      if (c instanceof AbstractButton) {
	AbstractButton b = (AbstractButton)c;
	ButtonModel model = b.getModel();

	isPressed = (model.isArmed() && model.isPressed());
	hasFocus = (model.isArmed() && isPressed) || 
	  (b.isFocusPainted() && b.hasFocus());
        if (b instanceof JButton) {
            isDefault = ((JButton)b).isDefaultButton();
        }
      }	
      if (isDefault) {
          if (hasFocus) {
              g.setColor(controlFocus);
              g.drawRect(x, y, w-1, h-1);
              hasFocus = false; // already drew focus
          }
          g.setColor(controlShadow);         
          g.drawRect(x+3, x+3, w-7, h-7);
      
          g.setColor(controlHighlight);    
          g.drawLine(x+4, y+h-4, x+w-4, y+h-4);
          g.drawLine(x+w-4, y+3, x+w-4, y+h-4);
      }          
      drawBezel(g, x+6, y+6, w-11, h-11, isPressed, hasFocus); 
          
    }
	
    public Insets getBorderInsets(Component c)
    {
      return insets;
    }

  }

  private static class ToggleButtonBorder extends AbstractBorder implements UIResource, Serializable
  {
    final static Insets insets = new Insets(2, 2, 3, 3);

    public void paintBorder(Component c, Graphics g, int x, int y, 
			    int width, int height) 
      {
	if (c instanceof AbstractButton) 
	  {
	    AbstractButton b = (AbstractButton)c;
	    ButtonModel model = b.getModel();

	    if (model.isArmed() && model.isPressed() || model.isSelected()) 
	      {
		drawBezel(g, x, y, width, height,
			  (model.isPressed() || model.isSelected()),
			  b.hasFocus());
	      } else 
		{
		  drawBezel(g, x, y, width, height, 
			    false, b.isFocusPainted() && b.hasFocus());
                }
	  } else 
	    {	
	      drawBezel(g, x, y, width, height, false, false);
            }
      }

    public Insets getBorderInsets(Component c)
      {
	return insets;
      }
  }

  private static class MenuBarBorder extends AbstractBorder implements UIResource, Serializable
  {
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
      JMenuBar menuBar = (JMenuBar)c;
      if (menuBar.isBorderPainted() == true)
	{
	  // this draws the MenuBar border
	  Dimension size = menuBar.getSize();
	  drawBezel(g,x,y,size.width,size.height,false,false);
	}
    }

    public Insets getBorderInsets(Component c)       {
      return new Insets(6,6,6,6);
    }
  }

 

  public static void drawBezel(Graphics g, int x, int y, int w, int h, 
			       boolean isPressed, boolean hasFocus)  {      

    Color disabled = UIManager.getColor("controlDisabled");
    Color controlFocus = UIManager.getColor("activeCaptionBorder");
    Color controlShadow = UIManager.getColor("controlShadow");
    Color controlDkShadow = UIManager.getColor("controlDkShadow");
    Color lightShadow = UIManager.getColor("controlLtHighlight");
    Color controlHighlight = UIManager.getColor("controlHighlight");

    Color oldColor = g.getColor();	
    g.translate(x, y);

    if (isPressed) {
      if (hasFocus){  
	g.setColor(controlFocus);
	g.drawRect(0, 0, w-1, h-1);
      }	  
      g.setColor(controlShadow);         // inner border
      g.drawRect(1, 1, w-3, h-3);
      
      g.setColor(controlHighlight);    // inner 3D border
      g.drawLine(2, h-3, w-3, h-3);
      g.drawLine(w-3, 2, w-3, h-4);
      
    } else {
      if (hasFocus) {
	g.setColor(controlFocus);
	g.drawRect(0, 0, w-1, h-1);
	
	g.setColor(controlHighlight);   // inner 3D border
	g.drawLine(1, 1, 1, h-3);
	g.drawLine(2, 1, w-4, 1);
	
	g.setColor(controlShadow);     
	g.drawLine(2, h-3, w-3, h-3);
	g.drawLine(w-3, 1, w-3, h-4);
	
	g.setColor(controlDkShadow);        // black drop shadow  __|
	g.drawLine(1, h-2, w-2, h-2);
	g.drawLine(w-2, h-2, w-2, 1);
      } else {
	g.setColor(controlHighlight);    // inner 3D border
	g.drawLine(1,1,1,h-3);
	g.drawLine(2,1,w-4,1);
	g.setColor(controlShadow);
	g.drawLine(2,h-3,w-3,h-3);
	g.drawLine(w-3,1,w-3,h-4);
	
	g.setColor(controlDkShadow);         // black drop shadow  __|
	g.drawLine(1,h-2,w-2,h-2);
	g.drawLine(w-2,h-2,w-2,0);
	
      }
      g.translate(-x, -y);
    }
    g.setColor(oldColor);
  }


}
