/*
 * @(#)MetalTreeUI.java	1.8 98/03/03
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.metal;

import com.sun.java.swing.*;
import com.sun.java.swing.event.*;
import com.sun.java.swing.text.DefaultTextUI;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.util.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.tree.*;

import com.sun.java.swing.plaf.basic.*;

/**
 * MetalTreeUI supports the client property "value-add" system of customization
 * It uses it to determine what style of line to draw.  There are three choices.
 * The default choice is a set of horiontal lines next to each root node.
 * Also available is a more variant with angled legs running from parent to child.
 * Lastly you can choose no lines at all.  Here is some code to turn on angled legs.
 * 
 * 	tree.putClientProperty("JTree.lineStyle", "Angled");
 * 
 * Here is some code to turn off lines all together.
 * 
 * 	tree.putClientProperty("JTree.lineStyle", "None");
 *
 * Also if you've used one of these options, and want to return to the default
 * horizontal line style you can use the following.
 *
 * 	tree.putClientProperty("JTree.lineStyle", "Horizontal");
 *
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.8 03/03/98
 * @author Tom Santos
 * @author Steve Wilson (value add stuff)
 */
public class MetalTreeUI extends BasicTreeUI {

    private static Color lineColor;
  
    private static final String LINE_STYLE = "JTree.lineStyle";

    private static final String LEG_LINE_STYLE_STRING = "Angled";
    private static final String HORIZ_STYLE_STRING = "Horizontal";
    private static final String NO_STYLE_STRING = "None";

    private static final int LEG_LINE_STYLE = 2; 
    private static final int HORIZ_LINE_STYLE = 1;
    private static final int NO_LINE_STYLE = 0;

    private int lineStyle = HORIZ_LINE_STYLE;
    private PropertyChangeListener lineStyleListener = new LineListener();

    // Boilerplate
    public static ComponentUI createUI(JComponent x) {
	return new MetalTreeUI();
    }

    public MetalTreeUI()
    {
	super();
    }

    protected int getHorizontalLegBuffer()
      {
	return 4;
      } 

    public void installUI( JComponent c ) {
        super.installUI( c );
	if ( !tree.isLargeModel() ) {
	    setRowHeight( 0 );
	}
	lineColor = UIManager.getColor( "Tree.line" );

	Object lineStyleFlag = c.getClientProperty( LINE_STYLE );
	decodeLineStyle(lineStyleFlag);
	c.addPropertyChangeListener(lineStyleListener);

    }

    public void uninstallUI( JComponent c) {
         c.removePropertyChangeListener(lineStyleListener);
	 super.uninstallUI(c);
    }

    /** this function converts between the string passed into the client property
      * and the internal representation (currently and int)
      *
      */
    protected void decodeLineStyle(Object lineStyleFlag) {
      if ( lineStyleFlag == null || lineStyleFlag.equals(HORIZ_STYLE_STRING) ){
	lineStyle = HORIZ_LINE_STYLE; // default case
      } else {
	  if ( lineStyleFlag.equals(LEG_LINE_STYLE_STRING) ) {
	      lineStyle = LEG_LINE_STYLE;
	  } else if ( lineStyleFlag.equals(NO_STYLE_STRING) ) {
	      lineStyle = NO_LINE_STYLE;
	  }
      }

    }
    protected boolean clickedInExpandControl( VisibleTreeNode node, LargeTreeModelNode eNode,
					      int row, int rowLevel, int mouseX, int mouseY )
      {
	if ( node != null && node.isLeaf() )
	  {
	    return false;
	  }

	int                     boxWidth;

	if(getExpandedIcon() != null)
	    boxWidth = getExpandedIcon().getIconWidth() + 6;
	else
	    boxWidth = 8;
	int    boxLeftX;
	if(this.getShowsRootHandles())
	    boxLeftX = ((rowLevel * totalChildIndent) +
			getLeftChildIndent()) - boxWidth/2;
	else
	    boxLeftX = (((rowLevel - 1) * totalChildIndent) +
			getLeftChildIndent()) - boxWidth/2;
	int boxRightX = boxLeftX + boxWidth;
	
	return mouseX >= boxLeftX && mouseX <= boxRightX;
      }


    public void paint(Graphics g, JComponent c) {
        super.paint( g, c );
 

	// Paint the lines
	if (lineStyle == HORIZ_LINE_STYLE && !largeModel) {
	    paintHorizontalSeparators(g,c);
	}
    }

    protected void paintHorizontalSeparators(Graphics g, JComponent c) {
        g.setColor( lineColor );

	Rectangle clipBounds = g.getClipBounds();
	int beginRow = getRowContainingYLocation( clipBounds.y );
	int endRow = getRowContainingYLocation( clipBounds.y + (clipBounds.height - 1) );

	if ( beginRow <= -1 || endRow <= -1 ) {
	    return;
	}

	for ( int i = beginRow; i <= endRow; ++i ) {
	    VisibleTreeNode node = getNode( i );
	    if ( node.getParent() == node.getRoot() ) {
	        // Draw a line at the top
	        g.drawLine( clipBounds.x, getNodeY( node ),
			    clipBounds.x + clipBounds.width, getNodeY( node ) );
	    }
	}

    }

    public void drawVerticalPartOfLeg( Graphics g, JComponent c, int depth, int parentY, int childY,
				       int parentRowHeight, int childRowHeight ) {
	if (lineStyle == LEG_LINE_STYLE) {
	    super.drawVerticalPartOfLeg( g, c, depth, parentY, childY, parentRowHeight, childRowHeight);
	}
    }

    public void drawHorizontalPartOfLeg( Graphics g, JComponent c, int lineY, int leftX, int rightX  ) {
	if (lineStyle == LEG_LINE_STYLE) {
	    super.drawHorizontalPartOfLeg( g, c, lineY, leftX, rightX);
	}
    }

    /** This class listens for changes in line style */
    class LineListener implements PropertyChangeListener, java.io.Serializable {
        public void propertyChange(PropertyChangeEvent e) {
	    String name = e.getPropertyName();
	    if ( name.equals( LINE_STYLE ) ) {
	        decodeLineStyle(e.getNewValue());
	    }
	}
    } // end class PaletteListener

}
