/*
 * @(#)MetalToolTipUI.java	1.8 98/04/08
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */

package com.sun.java.swing.plaf.metal;


import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.plaf.basic.BasicToolTipUI;


/**
 * A Metal L&F extension of BasicToolTipUI.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.8 04/08/98
 * @author Steve Wilson
 */
public class MetalToolTipUI extends BasicToolTipUI {

    static MetalToolTipUI sharedInstance = new MetalToolTipUI();
    Font smallFont;			    	     
    static JToolTip tip;
    public static final int padSpaceBetweenStrings = 12;

    public MetalToolTipUI() {
        super();
    }

    public static ComponentUI createUI(JComponent c) {
        return sharedInstance;
    }

    public void installUI(JComponent c) {
        super.installUI(c);
	tip = (JToolTip)c;
	Font f = c.getFont();
	smallFont = new Font( f.getName(), f.getStyle(), f.getSize() - 2 );
    }

    public void paint(Graphics g, JComponent c) {

        FontMetrics metrics = Toolkit.getDefaultToolkit().getFontMetrics(g.getFont());
        Dimension size = c.getSize();

        g.setColor(c.getBackground());
        g.fillRect(0, 0, size.width, size.height);

	g.setColor(c.getForeground());
	String tipText = ((JToolTip)c).getTipText();
	if (tipText == null) {
	    tipText = "";
	}
	String keyText = getAcceleratorString();
        g.drawString(tipText, 3, 2 + metrics.getAscent());
	if (! (keyText.equals(""))) {  // only draw control key if there is one
	    g.setFont(smallFont);
	    g.setColor( MetalLookAndFeel.getPrimaryControlDarkShadow() );
	    g.drawString(keyText, 
		         metrics.stringWidth(tipText) + 3 + padSpaceBetweenStrings, 
		         2 + metrics.getAscent());
	}
    }

    public Dimension getPreferredSize(JComponent c) {
        FontMetrics metrics = Toolkit.getDefaultToolkit().getFontMetrics(c.getFont());

	String tipText = ((JToolTip)c).getTipText();
	if (tipText == null) {
	    tipText = "";
	}

	Dimension d = new Dimension(metrics.stringWidth(tipText) + 6, metrics.getHeight() + 4);

	String key = getAcceleratorString();
	if (! (key.equals(""))) {
            metrics = Toolkit.getDefaultToolkit().getFontMetrics(smallFont);	
	    d.width += metrics.stringWidth(key) + padSpaceBetweenStrings;
	}
        return d;
    }
   
    public String getAcceleratorString() {
        JComponent comp = tip.getComponent();
	if (comp == null) {
	    return "";
	}
	KeyStroke[] keys =comp.getRegisteredKeyStrokes();
	String controlKeyStr = "";

	for (int i = 0; i < keys.length; i++) {

	  char c = (char)keys[i].getKeyCode();
	  int mod = keys[i].getModifiers();
	  if ( mod == InputEvent.CTRL_MASK ) {
	      controlKeyStr = "cntl+"+(char)keys[i].getKeyCode();
	      break;
	  } else if (mod == InputEvent.ALT_MASK) {
	      controlKeyStr = "alt+"+(char)keys[i].getKeyCode();
	      break;
	  } 
	}
	return controlKeyStr;
    }

}
