/*
 * @(#)MetalToolBarUI.java	1.5 98/04/09
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.metal;

import com.sun.java.swing.*;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.*;
import java.util.*;

import java.io.Serializable;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;

import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.plaf.basic.*;

/**
 * A Metal Look and Feel implementation of ToolBarUI.  This implementation 
 * is a "combined" view/controller.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.5 04/09/98
 * @author Jeff Shapiro
 */
public class MetalToolBarUI extends BasicToolBarUI implements ContainerListener
{
    protected static Border rolloverBorder = new MetalRolloverButtonBorder();

    protected static Border nonRolloverBorder = new MetalButtonBorder();

    protected Hashtable borderTable = new Hashtable();

    protected ContainerListener contListener;

    private boolean rolloverBorders = false;

    private PropertyChangeListener rolloverListener;

    protected static String IS_ROLLOVER = "JToolBar.isRollover";

    public static ComponentUI createUI( JComponent c )
    {
	return new MetalToolBarUI();
    }

    public void installUI( JComponent c )
    {
        rolloverListener = new RolloverListener();
	c.addPropertyChangeListener( rolloverListener );

        super.installUI( c );

	Object rolloverProp = c.getClientProperty( IS_ROLLOVER );

	if ( rolloverProp != null )
	{
	    setRolloverBorders( ((Boolean)rolloverProp).booleanValue() );
	}
	else
	{
	    setRolloverBorders( false );
	}
    }

    public void uninstallUI( JComponent c )
    {
        c.removePropertyChangeListener( rolloverListener );

        super.uninstallUI( c );

	installNormalBorders( c );
   }

    protected void installListeners( JComponent c )
    {
        super.installListeners( c );

        if ( (contListener = createContainerListener(c)) != null )
	{
            c.addContainerListener( contListener );
        }
    }

    protected void uninstallListeners( JComponent c )
    {
        super.uninstallListeners( c );

        if ( contListener != null )
	{
            c.removeContainerListener( contListener );
            contListener = null;
        }
    }

    protected ContainerListener createContainerListener( JComponent c )
    {
        return this;
    }

    protected DockingListener createDockingListener( JToolBar toolbar )
    {
	return new MetalDockingListener( toolbar );
    }

    protected void setDragOffset( Point p )
    {
        if (dragWindow == null)
	    dragWindow = createDragWindow(toolBar);

        dragWindow.setOffset( p );
    }

    public boolean isRolloverBorders()
    {
        return rolloverBorders;
    }

    public void setRolloverBorders( boolean rollover )
    {
        rolloverBorders = rollover;
	    
	if ( rolloverBorders )
	{
	    installRolloverBorders( toolBar );
	}
	else
	{
	    installNonRolloverBorders( toolBar );
	}
    }

    protected void installRolloverBorders ( JComponent c )
    {
	// Put rollover borders on buttons
	Component[] components = c.getComponents();

	for ( int i = 0; i < components.length; ++i )
	{
	  if ( components[ i ] instanceof JComponent )
	  {
	      ( (JComponent)components[ i ] ).updateUI();

	      setBorderToRollover( components[ i ] );
	  }
	}
    }

    protected void installNonRolloverBorders ( JComponent c )
    {
	// Put nonrollover borders on buttons
	Component[] components = c.getComponents();

	for ( int i = 0; i < components.length; ++i )
	{
	  if ( components[ i ] instanceof JComponent )
	  {
	      ( (JComponent)components[ i ] ).updateUI();

	      setBorderToNonRollover( components[ i ] );
	  }
	}
    }

    protected void installNormalBorders ( JComponent c )
    {
	// Put back the normal borders on buttons
	Component[] components = c.getComponents();

	for ( int i = 0; i < components.length; ++i )
	{
	    setBorderToNormal( components[ i ] );
	}
    }

    protected void setBorderToRollover( Component c )
    {
        if ( c instanceof JButton )
	{
	    JButton b = (JButton)c;

	    if ( b.getUI() instanceof MetalButtonUI )
	    {
	        if ( b.getBorder() instanceof UIResource )
		{
		    borderTable.put( b, b.getBorder() );
		}

		if ( b.getBorder() instanceof UIResource || b.getBorder() == nonRolloverBorder )
		{
		    b.setBorder( rolloverBorder );
		}
		
		b.setRolloverEnabled( true );
	    }
	}
    }

    protected void setBorderToNonRollover( Component c )
    {
        if ( c instanceof JButton )
	{
	    JButton b = (JButton)c;

	    if ( b.getUI() instanceof MetalButtonUI )
	    {
	        if ( b.getBorder() instanceof UIResource )
		{
		    borderTable.put( b, b.getBorder() );
		}

		if ( b.getBorder() instanceof UIResource || b.getBorder() == rolloverBorder )
		{
		    b.setBorder( nonRolloverBorder );
		}

		b.setRolloverEnabled( false );
	    }
	}
    }

    protected void setBorderToNormal( Component c )
    {
        if ( c instanceof JButton )
	{
	    JButton b = (JButton)c;

	    if ( b.getUI() instanceof MetalButtonUI )
	    {
	        if ( b.getBorder() == rolloverBorder || b.getBorder() == nonRolloverBorder )
		{
		    b.setBorder( (Border)borderTable.remove( b ) );
		}

		b.setRolloverEnabled( false );
	    }
	}
    }

    // ContainerListener overrides

    public void componentAdded( ContainerEvent e )
    {
        Component c = e.getChild();

        if ( rolloverBorders )
	{
	    setBorderToRollover( c );
	}
	else
	{
	    setBorderToNonRollover( c );
	}
    }

    public void componentRemoved( ContainerEvent e )
    {
        Component c = e.getChild();
	setBorderToNormal( c );
    }

    class RolloverListener implements PropertyChangeListener, Serializable
    {
        public void propertyChange( PropertyChangeEvent e )
	{
	    String name = e.getPropertyName();

	    if ( name.equals( IS_ROLLOVER ) )
	    {
	        if ( e.getNewValue() != null )
		{
		    setRolloverBorders( ((Boolean)e.getNewValue()).booleanValue() );
		}
		else
		{
		    setRolloverBorders( false );
		}
	    }
	}
    } // end class RolloverListener

    protected class MetalDockingListener extends DockingListener
    {
        protected boolean pressedInBumps = false;

	public MetalDockingListener( JToolBar t )
	{
	    super( t );
	} 

	public void mousePressed( MouseEvent e )
	{ 
	    super.mousePressed( e );
	    setDragOffset( e.getPoint() );
	    pressedInBumps = false;

	    Rectangle bumpRect = new Rectangle();

	    if ( toolBar.getSize().height <= toolBar.getSize().width )  // horizontal
	    {
		bumpRect.setBounds( 0, 0, 14, toolBar.getSize().height );
	    }
	    else  // vertical
	    {
		bumpRect.setBounds( 0, 0, toolBar.getSize().width, 14 );
	    }

	    if ( bumpRect.contains( e.getPoint() ) )
	    {
	        pressedInBumps = true;
	    }
	}

	public void mouseDragged( MouseEvent e )
	{
	    if ( pressedInBumps )
	    {
	        super.mouseDragged( e );
	    }
	}

    } // end class MetalDockingListener

}


