/*
 * @(#)MetalToggleButtonUI.java	1.8 98/04/13
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
 
package com.sun.java.swing.plaf.metal;

import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.plaf.basic.BasicToggleButtonUI;

import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.*;
import com.sun.java.swing.plaf.basic.BasicGraphicsUtils;

import java.io.Serializable;

/**
 * MetalToggleButton implementation
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.8 04/13/98
 * @author Tom Santos
 */
public class MetalToggleButtonUI extends BasicToggleButtonUI {
    private static Color selectedColor;
    private static Color disabledTextColor;
    private static Color focusColor;

    protected final static Insets defaultMargin = new Insets(2,14,2,14);

    private static final MetalToggleButtonUI metalToggleButtonUI = new MetalToggleButtonUI();

    public static ComponentUI createUI(JComponent b) {
        return metalToggleButtonUI;
    }

    public void installUI(JComponent c) {
        super.installUI(c);
	selectedColor = UIManager.getColor("ToggleButton.selected");
	disabledTextColor = UIManager.getColor("ToggleButton.disabledText");
	focusColor = UIManager.getColor("ToggleButton.focus");
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        Dimension size = b.getSize();
	g.setColor( selectedColor );
	g.fillRect( 0, 0, size.width, size.height );
    }

    public Insets getDefaultMargin( AbstractButton b ) {
        return defaultMargin;
    }

    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
	AbstractButton b = (AbstractButton) c;			     
	ButtonModel model = b.getModel();
	FontMetrics fm = g.getFontMetrics();

	/* Draw the Text */
	if(model.isEnabled()) {
	    /*** paint the text normally */
	    g.setColor(b.getForeground());
	    BasicGraphicsUtils.drawString(g,text, model.getMnemonic(),
					  textRect.x,
					  textRect.y + fm.getAscent());
	}
	else {
	    /*** paint the text disabled ***/
	    if (model.isSelected())
		g.setColor(UIManager.getColor("Button.background"));
	    else
	        g.setColor(UIManager.getColor("Button.disabledText"));
	    BasicGraphicsUtils.drawString(g,text,model.getMnemonic(),
					  textRect.x, textRect.y + fm.getAscent());

	}
    }

    static class MetalToggleButtonBorder extends MetalButtonBorder {
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
	    JToggleButton button = (JToggleButton)c;
	    ButtonModel model = button.getModel();

	    if (! c.isEnabled() ) {
	        MetalUtils.drawDisabledBorder(g, x, y, w, h);
	    } else {
	        if ( model.isPressed() && model.isArmed() ) {
		    MetalUtils.drawPressed3DBorder( g, x, y, w, h );
		} else if ( model.isSelected() ) {
		    MetalUtils.drawDark3DBorder( g, x, y, w, h );
		} else {
		    MetalUtils.drawFlush3DBorder( g, x, y, w, h );
		}
	    }
	}
    }

    protected void paintFocus(Graphics g, AbstractButton b,
			      Rectangle viewRect, Rectangle textRect, Rectangle iconRect){

        Rectangle focusRect = new Rectangle();
	String text = b.getText();
	boolean isIcon = b.getIcon() != null;

        // If there is text
        if ( text != null & !text.equals( "" ) ) {
  	    if ( !isIcon ) {
	        focusRect.setBounds( textRect );
	    }
	    else {
	        focusRect.setBounds( iconRect.union( textRect ) );
	    }
        }
        // If there is an icon and no text
        else if ( isIcon ) {
  	    focusRect.setBounds( iconRect );
        }

        g.setColor(focusColor);
	g.drawRect((focusRect.x-1), (focusRect.y-1),
		  focusRect.width+1, focusRect.height+1);
	
    }
}
