/*
 * @(#)MetalTextFieldUI.java	1.2 98/03/03
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
package com.sun.java.swing.plaf.metal;

import java.awt.*;
import java.beans.*;

import com.sun.java.swing.*;

import com.sun.java.swing.text.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.plaf.basic.*;

/**
 * Basis of a look and feel for a JTextField.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @author  Steve Wilson
 * @version 1.2 03/03/98
 */
public class MetalTextFieldUI extends BasicTextFieldUI {

    public static ComponentUI createUI(JComponent c) {
        return new MetalTextFieldUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
	editableChanged(c, ((JTextComponent)c).isEditable());
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("editable")) {
	    JComponent source = (JComponent)e.getSource();
	    Color background = source.getBackground();
	    boolean editable =  ((Boolean)e.getNewValue()).booleanValue();
	    editableChanged( source, editable);

	}
    }
    private void editableChanged(JComponent c, boolean editable) {
	    Color background = c.getBackground();
	    if (editable == false) {
 	        if (background instanceof UIResource) {
		   c.setBackground(UIManager.getColor("control"));
		}
	    } else {
	         if (background instanceof UIResource) {
		    c.setBackground(UIManager.getColor("TextField.background"));
		}
	    }
    }

    public static class TextFieldBorder extends Flush3DBorder {
        public void paintBorder(Component c, Graphics g, int x, int y, 
				int w, int h) {
	    if (c.isEnabled() && ((JTextComponent)c).isEditable()) {
	        MetalUtils.drawFlush3DBorder(g, x, y, w, h);
	    } else {
	        MetalUtils.drawDisabledBorder(g, x, y, w, h);
	    }

	}
    }
}
