/*
 * @(#)MetalSliderUI.java	1.14 98/02/04
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.metal;

import com.sun.java.swing.plaf.basic.BasicSliderUI;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Point;
import java.awt.Insets;
import java.awt.Color;
import java.io.Serializable;
import java.awt.IllegalComponentStateException;
import java.awt.Polygon;
import java.beans.*;

import com.sun.java.swing.border.AbstractBorder;

import com.sun.java.swing.*;
import com.sun.java.swing.event.*;
import com.sun.java.swing.plaf.*;

/**
 * A Java L&F implementation of SliderUI.  
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.14 02/04/98
 * @author Tom Santos
 */
public class MetalSliderUI extends BasicSliderUI implements PropertyChangeListener {
  
    protected final int TICK_BUFFER = 4;
    protected boolean filledSlider = false;
    protected static Color thumbColor;
    protected static Color highlightColor;
    protected static Color darkShadowColor;
    protected static int trackWidth;
    protected static int tickLength;
    protected static Icon horizThumbIcon;
    protected static Icon vertThumbIcon;


    protected final String SLIDER_FILL = "JSlider.isFilled";

    public static ComponentUI createUI(JComponent c)    {
        return new MetalSliderUI();
    }

    public MetalSliderUI() {
        super( null );
    }

    public void installUI( JComponent c ) {
	trackWidth = ((Integer)UIManager.get( "Slider.trackWidth" )).intValue();
	tickLength = ((Integer)UIManager.get( "Slider.majorTickLength" )).intValue();
	horizThumbIcon = UIManager.getIcon( "Slider.horizontalThumbIcon" );
	vertThumbIcon = UIManager.getIcon( "Slider.verticalThumbIcon" );

        super.installUI( c );

	thumbColor = UIManager.getColor("Slider.thumb");
	highlightColor = UIManager.getColor("Slider.highlight");
	darkShadowColor = UIManager.getColor("Slider.darkShadow");


	scrollListener.setScrollByBlock( false );

	c.addPropertyChangeListener( this ); // add to listen for filled slider change

	Object sliderFillProp = c.getClientProperty( SLIDER_FILL );
	if ( sliderFillProp != null ) {
	    filledSlider = ((Boolean)sliderFillProp).booleanValue();
	}

	//slider.setInverted( true );
    }

    public void uninstallUI( JComponent c ) {
 	c.removePropertyChangeListener( this );
	super.uninstallUI( c );
    }

    public void propertyChange( PropertyChangeEvent e ) {  // listen for slider fill
        super.propertyChange( e );

	String name = e.getPropertyName();
	if ( name.equals( SLIDER_FILL ) ) {
	    if ( e.getNewValue() != null ) {
	        filledSlider = ((Boolean)e.getNewValue()).booleanValue();
	    }
	    else {
		filledSlider = false;
	    }
        }
    }

    public void paintThumb(Graphics g)  {
	Rectangle knobBounds = getThumbRect();

        g.translate( knobBounds.x, knobBounds.y );

	if ( slider.getOrientation() == JSlider.HORIZONTAL ) {
	    horizThumbIcon.paintIcon( slider, g, 0, 0 );
	}
	else {
	    vertThumbIcon.paintIcon( slider, g, 0, 0 );
	}

	g.translate( -knobBounds.x, -knobBounds.y );
    }

    public void paintTrack(Graphics g)  {
	
	Rectangle trackBounds = getScrollTrackRect();

	Color trackColor = !slider.isEnabled() ? MetalLookAndFeel.getControlShadow() :
	                                         slider.getForeground();

	g.translate( trackBounds.x, trackBounds.y );

	int trackLeft = 0;
	int trackTop = 0;
	int trackRight = 0;
	int trackBottom = 0;

	// Draw the track
	if ( slider.getOrientation() == JSlider.HORIZONTAL ) {	    
	    trackLeft = trackBuffer;
	    trackTop = (trackBounds.height - getThumbOverhang()) - getTrackWidth();
	    trackRight = (trackBounds.width - 1) - trackBuffer;
	    trackBottom = (trackBounds.height - getThumbOverhang()) - 1;

	    if ( slider.isEnabled() ) {
	        MetalUtils.drawFlush3DBorder( g, trackLeft, trackTop, getTrackLength(), getTrackWidth() );
	    }
	    else {
	        Rectangle thumbBounds = getThumbRect();
		int middleOfThumb = thumbBounds.x + (thumbBounds.width / 2);

	        g.setColor( trackColor );
		g.drawRect( trackLeft, trackTop, getTrackLength(), getTrackWidth() - 2 );

		if ( filledSlider ) {
	  	    if ( slider.isEnabled() ) {
		        g.fillRect( trackLeft, trackTop, middleOfThumb - trackLeft, getTrackWidth() - 2 );
		    }
		    else {
		        g.fillRect( middleOfThumb, trackTop, trackRight - middleOfThumb, getTrackWidth() - 2 );
		    }
		}
	    }
	}
	else {
	    trackLeft = (trackBounds.width - getThumbOverhang()) - getTrackWidth();
	    trackTop = trackBuffer;
	    trackRight = (trackBounds.width - getThumbOverhang()) - 1;
	    trackBottom = (trackBounds.height - 1) - trackBuffer;

	    if ( slider.isEnabled() ) {
	        MetalUtils.drawFlush3DBorder( g, trackLeft, trackTop, getTrackWidth(), getTrackLength() );
	    }
	    else {
	        Rectangle thumbBounds = getThumbRect();
		int middleOfThumb = thumbBounds.y + (thumbBounds.height / 2);

	        g.setColor( trackColor );
		g.drawRect( trackLeft, trackTop, getTrackWidth() - 2, getTrackLength() );
		if ( filledSlider ) {
		    if ( slider.isEnabled() ) {
		        g.fillRect( trackLeft, middleOfThumb, getTrackWidth() - 2, trackBottom - middleOfThumb );
		    }
		    else {
		        g.fillRect( trackLeft, trackTop, getTrackWidth() - 2, middleOfThumb - trackLeft );
		    }
		}
	    }
	}

	// Draw the fill
	if ( !filledSlider ) {
	    if ( slider.isEnabled() ) {
	        g.setColor( slider.getForeground() );

	        if ( slider.getOrientation() == JSlider.HORIZONTAL ) {
		    g.fillRect( trackLeft + 2, trackTop + 2, getTrackLength() - 4, getTrackWidth() - 4 );

		    g.setColor( MetalLookAndFeel.getPrimaryControl() );
		    g.drawLine( trackLeft + 1, trackTop + 1, trackLeft + 1, trackBottom - 2 );
		    g.drawLine( trackLeft + 1, trackTop + 1, trackRight - 2, trackTop + 1 );

		    g.setColor( MetalLookAndFeel.getPrimaryControlDarkShadow() );
		    g.drawLine( trackLeft + 2, trackBottom - 1, trackRight - 1, trackBottom - 1 );
		    g.drawLine( trackRight - 1, trackTop + 2, trackRight - 1, trackBottom - 1 );
		}
		else {
		    g.fillRect( trackLeft + 2, trackTop + 2, getTrackWidth() - 4, getTrackLength() - 4 );

		    g.setColor( MetalLookAndFeel.getPrimaryControl() );
		    g.drawLine( trackLeft + 1, trackTop + 1, trackLeft + 1, trackBottom - 2 );
		    g.drawLine( trackLeft + 1, trackTop + 1, trackRight - 2, trackTop + 1 );

		    g.setColor( MetalLookAndFeel.getPrimaryControlDarkShadow() );
		    g.drawLine( trackRight - 1, trackTop + 2, trackRight - 1, trackBottom - 1 );
		    g.drawLine( trackLeft + 2, trackBottom - 1, trackRight - 1, trackBottom - 1 );
		}	    
	    }
	}
	else {
	    Color lightColor = MetalLookAndFeel.getPrimaryControl();
	    Color darkColor = MetalLookAndFeel.getPrimaryControlDarkShadow();

	    g.setColor( slider.getForeground() );

	    if ( slider.getOrientation() == JSlider.HORIZONTAL ) {
	        Rectangle thumbBounds = getThumbRect();
		int middleOfThumb = thumbBounds.x + (thumbBounds.width / 2);

	        if ( !slider.getInverted() ) {
		    g.fillRect( trackLeft + 2, trackTop + 2,
				(middleOfThumb - (trackLeft + 2)), getTrackWidth() - 4 );
		    g.setColor( lightColor );
		    g.drawLine( trackLeft + 2, trackTop + 1, middleOfThumb, trackTop + 1 );
		    g.drawLine( trackLeft + 1, trackTop + 1, trackLeft + 1, trackBottom - 1 );
		    g.setColor( darkColor );
		    g.drawLine( trackLeft + 2, trackBottom - 1, middleOfThumb, trackBottom - 1 );
		}
		else {
		    g.fillRect( middleOfThumb, trackTop + 2,
				(trackRight - 1) - middleOfThumb, getTrackWidth() - 4 );
		    g.setColor( lightColor );
		    g.drawLine( middleOfThumb, trackTop + 1, trackRight - 2, trackTop + 1 );
		    g.drawLine( trackRight - 1, trackTop + 1, trackRight - 1, trackBottom - 1 );
		    g.setColor( darkColor );
		    g.drawLine( middleOfThumb, trackBottom - 1, trackRight - 2, trackBottom - 1 );
		}
	    }
	    else {
	        Rectangle thumbBounds = getThumbRect();
		int middleOfThumb = thumbBounds.y + (thumbBounds.height / 2);

	        if ( !slider.getInverted() ) {
		    g.fillRect( trackLeft + 2, middleOfThumb,
				getTrackWidth() - 4, (trackBottom - 1) - middleOfThumb );
		    g.setColor( lightColor );
		    g.drawLine( trackLeft + 1, middleOfThumb, trackLeft + 1, trackBottom - 2 );
		    g.drawLine( trackLeft + 1, trackBottom - 1, trackRight - 1, trackBottom - 1 );
		    g.setColor( darkColor );
		    g.drawLine( trackRight - 1, middleOfThumb, trackRight - 1, trackBottom - 2 );
		}
		else {
		    g.fillRect( trackLeft + 2, trackTop + 2,
				getTrackWidth() - 4, middleOfThumb - (trackTop + 2) );
		    g.setColor( lightColor );
		    g.drawLine( trackLeft + 1, trackTop + 2, trackLeft + 1, middleOfThumb );
		    g.drawLine( trackLeft + 1, trackTop + 1, trackRight - 1, trackTop + 1 );
		    g.setColor( darkColor );
		    g.drawLine( trackRight - 1, trackTop + 2, trackRight - 1, middleOfThumb );
		}
	    }
	}

	g.translate( -trackBounds.x, -trackBounds.y );
    }
        
    public void paintFocus(Graphics g)  {        
        if (slider.hasFocus()) {
	    Rectangle r = slider.getBounds();
	    r.x = 0;
            r.y = 0;	    
	    if(slider.getBorder() != null) {
	         r = getFullContentArea();
	    } 
            g.setColor(getFocusColor());
            g.drawRect(r.x + 1, r.y + 1, r.width - 2, r.height - 2);
        }
    }

    /**
      * Subclasses of BasicSliderUI override this method to determine their own
      * thumb size.
      */
    public void calculateThumbBounds()	{
        final int thumbWidth = 15;
        int thumbLength = 16;

        if ( slider.getOrientation() == JSlider.HORIZONTAL ) {
	    int thumbX = xPositionForValue( slider.getValue( )) - getThumbRect().width / 2;
	    int thumbY = (getScrollTrackRect().y + getScrollTrackRect().height) - thumbLength;

	    setThumbBounds( thumbX, thumbY, thumbWidth, thumbLength );
        }
	else {
	    int thumbY = yPositionForValue(slider.getValue()) - getThumbRect().height / 2;
	    int thumbX = (getScrollTrackRect().x + getScrollTrackRect().width) - thumbLength;

	    setThumbBounds( thumbX, thumbY, thumbLength, thumbWidth );
	}
    }

    /**
     * Gets the height of the tick area for horizontal sliders and the width of the
     * tick area for vertical sliders.  BasicSliderUI uses the returned value to
     * determine the bounds of the tray rectangle and the tick area rectangle.
     */
    public int getTickSpace() {
        return slider.getOrientation() == JSlider.HORIZONTAL ? tickLength + TICK_BUFFER + 1 :
	                                                       tickLength + TICK_BUFFER + 3;
    }

    /**
     * Returns the shorter dimension of the track.
     */
    protected int getTrackWidth() {
        return trackWidth;
    }

    /**
     * Returns the longer dimension of the slide bar.  (The slide bar is only the
     * part that runs directly under the thumb)
     */
    protected int getTrackLength() {   
	Rectangle interiorRect = getFullContentArea();

	if ( slider.getOrientation() == JSlider.HORIZONTAL ) {
	    return getScrollTrackRect().width - (trackBuffer * 2);
	}
	return getScrollTrackRect().height - (trackBuffer * 2);
    }

    /**
     * Returns the amount that the thumb goes past the slide bar.
     */
    protected int getThumbOverhang() {
        return 4;
    }

    protected void scrollDueToClickInTrack( int dir ) {
        scrollByUnit( dir );
    }

    protected void paintMinorTickForHorizSlider( Graphics g, Rectangle tickBounds, int x ) {
	g.setColor( slider.isEnabled() ? slider.getForeground() : MetalLookAndFeel.getControlShadow() );
	g.drawLine( x, TICK_BUFFER, x, TICK_BUFFER + (tickLength / 2) );
    }

    protected void paintMajorTickForHorizSlider( Graphics g, Rectangle tickBounds, int x ) {
	g.setColor( slider.isEnabled() ? slider.getForeground() : MetalLookAndFeel.getControlShadow() );
	g.drawLine( x, TICK_BUFFER , x, TICK_BUFFER + (tickLength - 1) );
    }

    protected void paintMinorTickForVertSlider( Graphics g, Rectangle tickBounds, int y ) {
	g.setColor( slider.isEnabled() ? slider.getForeground() : MetalLookAndFeel.getControlShadow() );
	g.drawLine( TICK_BUFFER, y, TICK_BUFFER + (tickLength / 2), y );
    }

    protected void paintMajorTickForVertSlider( Graphics g, Rectangle tickBounds, int y ) {
	g.setColor( slider.isEnabled() ? slider.getForeground() : MetalLookAndFeel.getControlShadow() );
	g.drawLine( TICK_BUFFER, y, TICK_BUFFER + tickLength, y );
    }






}
