/*
 * @(#)MetalScrollPaneUI.java	1.4 98/03/13
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */

package com.sun.java.swing.plaf.metal;

import com.sun.java.swing.*;
import com.sun.java.swing.event.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.plaf.basic.*;

import java.awt.*;
import java.awt.event.*;


/**
 * A Metal L&F implementation of ScrollPaneUI.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @1.4 03/13/98
 * @author Steve Wilson
 */
public class MetalScrollPaneUI extends BasicScrollPaneUI
{

    public static ComponentUI createUI(JComponent x) {
	return new MetalScrollPaneUI();
    }

    /**
     * This method just delegates to super, but it
     * also marks the scrollbar with the JLF-specific
     * "value add" tag which says it should press flush 
     * agains the container.
     *
     * @see JScrollPane#createVerticalScrollBar
     */
    protected JScrollBar createVerticalScrollBar() {
        JScrollBar bar = scrollpane.createVerticalScrollBar();
	bar.putClientProperty( MetalScrollBarUI.FREE_STANDING_PROP, Boolean.FALSE);
	return bar;
    }

    /**
     * This method just delegates to super, but it
     * also marks the scrollbar with the JLF-specific
     * "value add" tag which says it should press flush 
     * agains the container.
     *
     * @returns scrollpane.createHorizontalScrollBar()
     * @see JScrollPane#createHorizontalScrollBar
     */
    protected JScrollBar createHorizontalScrollBar() {
        JScrollBar bar = scrollpane.createHorizontalScrollBar();
	bar.putClientProperty( MetalScrollBarUI.FREE_STANDING_PROP, Boolean.FALSE);
	return bar;
    }





public static class ScrollPaneBorder extends AbstractBorder {

 private static final Insets insets = new Insets(1, 1, 2, 2);

  public void paintBorder(Component c, Graphics g, int x, int y, 
			  int w, int h) {

      JScrollPane scroll = (JScrollPane)c;
      JComponent colHeader = scroll.getColumnHeader();
      int colHeaderHeight = 0;
      if (colHeader != null)
         colHeaderHeight = colHeader.getHeight();

      JComponent rowHeader = scroll.getRowHeader();
      int rowHeaderWidth = 0;
      if (rowHeader != null)
         rowHeaderWidth = rowHeader.getWidth();


      g.translate( x, y);

      g.setColor( MetalLookAndFeel.getControlDarkShadow() );
      g.drawRect( 0, 0, w-2, h-2 );
      g.setColor( MetalLookAndFeel.getControlHighlight() );

      g.drawLine( w-1, 1, w-1, h-1);
      g.drawLine( 1, h-1, w-1, h-1);

      g.setColor( MetalLookAndFeel.getControl() );
      g.drawLine( w-2, 2+colHeaderHeight, w-2, 2+colHeaderHeight );
      g.drawLine( 1+rowHeaderWidth, h-2, 1+rowHeaderWidth, h-2 );

      g.translate( -x, -y);

  }
  
  public Insets getBorderInsets(Component c)       {
    return insets;
  }
}

}
