/*
 * @(#)MetalRadioButtonUI.java	1.5 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.metal;

import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.plaf.basic.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.*;
import java.io.Serializable;


/**
 * RadioButtonUI implementation for MetalRadioButtonUI
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.5 02/02/98
 * @author Michael C. Albers
 */
public class MetalRadioButtonUI extends BasicRadioButtonUI {

    private static final MetalRadioButtonUI metalRadioButtonUI = new MetalRadioButtonUI();

    public static ComponentUI createUI(JComponent c) {
        return metalRadioButtonUI;
    }


    /************************** The View *************************/
    protected ButtonModel model;
    Font f;
    FontMetrics fm;
    Rectangle viewRect, iconRect, textRect;
    Icon altIcon, selectedIcon, disabledIcon;

    /**
     * paint the radio button
     */
    public synchronized void paint(Graphics g, JComponent c) {

	AbstractButton b = (AbstractButton) c;
	model = b.getModel();
	
	Dimension size = c.getSize();

	int w = size.width;
	int h = size.height;

	f = c.getFont();
	g.setFont(f);
	fm = g.getFontMetrics();

	viewRect = new Rectangle(size);
        iconRect = new Rectangle();
        textRect = new Rectangle();

	altIcon = b.getIcon();
	selectedIcon = null;
	disabledIcon = null;
	
        String text = SwingUtilities.layoutCompoundLabel(
            fm, b.getText(), altIcon != null ? altIcon : icon,
            b.getVerticalAlignment(), b.getHorizontalAlignment(),
            b.getVerticalTextPosition(), b.getHorizontalTextPosition(),
            viewRect, iconRect, textRect, getDefaultTextIconGap(b)
        );
	
        // fill background
	if(c.isOpaque()) {
	    g.setColor(b.getBackground());
	    g.fillRect(0,0, size.width, size.height); 
	}

	
	// Paint the radio button
        if(altIcon != null) { 

            if(!model.isEnabled()) {
                altIcon = b.getDisabledIcon();
            } else if(model.isPressed() && model.isArmed()) {
                altIcon = b.getPressedIcon();
                if(altIcon == null) {
                    // Use selected icon
                    altIcon = b.getSelectedIcon();
                } 
            } else if(model.isSelected()) {
                altIcon = b.getSelectedIcon();
	    } else if(b.isRolloverEnabled() && model.isRollover()) {
                altIcon = (Icon) b.getRolloverIcon();
            } 
	      
	    if(altIcon == null) {
		altIcon = b.getIcon();
	    }
	       
	    altIcon.paintIcon(c, g, iconRect.x, iconRect.y);

        } else {
	    icon.paintIcon(c, g, iconRect.x, iconRect.y);
	}


	// Draw the Text
	if(text != null) {
	    if(model.isEnabled()) {
		// *** paint the text normally
		g.setColor(b.getForeground());
                BasicGraphicsUtils.drawString(g,text,model.getMnemonic(),
                                              textRect.x,
					      textRect.y + fm.getAscent());
	    } else {
		// *** paint the text disabled
		g.setColor(b.getBackground().darker());
                BasicGraphicsUtils.drawString(g,text,model.getMnemonic(),
                                              textRect.x,
					      textRect.y + fm.getAscent());
	    }
            if(b.hasFocus() && b.isFocusPainted() &&
	       textRect.width > 0 && textRect.height > 0 ) {
		paintFocus(g,textRect,size);
            }
	}
    }

    protected void paintFocus(Graphics g, Rectangle t, Dimension d){
        g.setColor(UIManager.getColor("RadioButton.focus"));
        g.drawRect(t.x,t.y-1,t.width+1,t.height+1);
    } 
}
