/*
 * @(#)MetalProgressBarUI.java	1.10 98/04/11
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.metal;

import com.sun.java.swing.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.plaf.basic.*;
//import com.sun.java.swing.event.*;
import java.awt.*;

/**
 * The Metal implementation of ProgressBarUI.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.10 04/11/98
 * @author Michael C. Albers
 */
public class MetalProgressBarUI extends BasicProgressBarUI {

    public static ComponentUI createUI(JComponent c) {
	return new MetalProgressBarUI();
    }

    /**
     * The sole reason for this paint method to even be here is that
     * the JLF/Metal ProgressBar has a bit of special highlighting that
     * needs to get drawn. The core painting is defered to the
     * BasicProgressBar's paint method.
     */ 
    public void paint(Graphics g, JComponent c) {
	super.paint(g,c);

	JProgressBar progressBar = (JProgressBar)c;
	BoundedRangeModel model = progressBar.getModel();

	Dimension size = progressBar.getSize(); //total size
	Insets i = progressBar.getInsets(); // area for border
	Rectangle barRect = new Rectangle(size); // area to draw progress

	barRect.x += i.left;
	barRect.y += i.top;
	barRect.width -= (i.right + barRect.x);
	barRect.height -= (i.bottom + barRect.y);
	int amountFull = getAmountFull(c); // amount of progress to draw
	
	if (progressBar.getOrientation() == JProgressBar.HORIZONTAL) {
 	    // Highlighting
	    //     over the unfilled portion
	    //     actually, draw all the way across - let others draw over it
	    g.setColor(MetalLookAndFeel.getControlShadow());
	    g.drawLine(barRect.x,barRect.y, barRect.width,barRect.y);

	    //     line on left
	    if (model.getValue() == model.getMinimum()) { // haven't started
		g.setColor(MetalLookAndFeel.getControlShadow());
	    } else { // Some portion of bar is filled
		g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
	    }
	    g.drawLine(barRect.x,barRect.y, barRect.x,barRect.height);

	    //     over the filled portion
	    //     get color from "line on left" above
	    g.drawLine(barRect.x,barRect.y, amountFull,barRect.y);
	} else { // VERTICAL
	    // Highlighting
	    //     left of the unfilled portion
	    //     actually, draw all the way down - let others draw over it
	    g.setColor(MetalLookAndFeel.getControlShadow());
	    g.drawLine(barRect.x,barRect.y, barRect.x,barRect.height);

	    //     line on bottom
	    if (model.getValue() == model.getMinimum()) { // haven't started
		g.setColor(MetalLookAndFeel.getControlShadow());
	    } else { // Some portion of bar is filled
		g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
	    }
	    g.drawLine(barRect.x,     barRect.height,
		       barRect.width, barRect.height);

	    //     left of the filled portion
	    //     pick up color from the "line on bottom" above
	    g.drawLine(barRect.x, barRect.height,
		       barRect.x, barRect.height-amountFull);
	}
    }
}
