/*
 * @(#)MetalMenuItemBorder.java	1.7 98/02/02
 * 
 * Copyright (c) 1998 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.metal;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Color;
import java.awt.Component;
import com.sun.java.swing.*;
import com.sun.java.swing.border.AbstractBorder;

/**
 * Draws the Metal Menu Item border.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.7 02/02/98
 * @author Jeff Shapiro
 */
public class MetalMenuItemBorder extends AbstractBorder
{
    protected static Insets borderInsets = new Insets( 2, 2, 2, 2 );

    public void paintBorder( Component c, Graphics g, int x, int y, int w, int h )
    {
        JMenuItem b = (JMenuItem) c;
	ButtonModel model = b.getModel();

	g.translate( x, y );

	if ( c.getParent() instanceof JMenuBar )
	{
	  if ( model.isArmed() || model.isSelected() )
	  {
	    g.setColor( MetalLookAndFeel.getControlDarkShadow() );
	    g.drawLine( 0, 0, w - 2, 0 );
	    g.drawLine( 0, 0, 0, h - 1 );
	    g.drawLine( w - 2, 2, w - 2, h - 1 );

	    g.setColor( MetalLookAndFeel.getPrimaryControlHighlight() );
	    g.drawLine( w - 1, 1, w - 1, h - 1 );

	    g.setColor( MetalLookAndFeel.getMenuBackground() );
	    g.drawLine( w - 1, 0, w - 1, 0 );
	  }
	}
	else
	{
	  if (  model.isArmed() || ( c instanceof JMenu && model.isSelected() ) )
	  {
	    g.setColor( MetalLookAndFeel.getPrimaryControlDarkShadow() );
	    g.drawLine( 0, 0, w - 1, 0 );

	    g.setColor( MetalLookAndFeel.getPrimaryControlHighlight() );
	    g.drawLine( 0, h - 1, w - 1, h - 1 );
	  }
	  else
	  {
	    g.setColor( MetalLookAndFeel.getPrimaryControlHighlight() );
	    g.drawLine( 0, 0, 0, h - 1 );
	  }
	}

	g.translate( -x, -y );
    }

    public Insets getBorderInsets( Component c )
    {
        return borderInsets;
    }
}
