/*
 * @(#)MetalMenuBarBorder.java	1.6 98/02/02
 * 
 * Copyright (c) 1998 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.metal;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Color;
import java.awt.Component;
import com.sun.java.swing.border.AbstractBorder;

/**
 * Draws the Metal MenuBar border.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.6 02/02/98
 * @author Jeff Shapiro
 */
public class MetalMenuBarBorder extends AbstractBorder
{
    protected static Insets borderInsets = new Insets( 1, 0, 1, 0 );

    public void paintBorder( Component c, Graphics g, int x, int y, int w, int h )
    {
	g.translate( x, y );

        g.setColor( MetalLookAndFeel.getControlShadow() );
	g.drawLine( 0, h-1, w, h-1 );

	g.translate( -x, -y );

    }

    public Insets getBorderInsets( Component c )
    {
        return borderInsets;
    }
}
