/*   
 * @(#)MetalLookAndFeel.java	1.70 98/04/14
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.metal;

import java.awt.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.*;
import com.sun.java.swing.plaf.basic.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.text.JTextComponent;
import com.sun.java.swing.text.DefaultEditorKit;

import java.awt.Font;
import java.awt.Color;
import java.awt.SystemColor;
import java.awt.event.KeyEvent;
import java.awt.event.InputEvent;

import java.net.URL;
import java.io.Serializable;


/**
 * Implements The Metal Look and Feel.
 * <p>
 * For the keyboard keys defined for each component in this Look and
 * Feel (L&F), see 
 * <a href="../../doc-files/Key-Metal.html">Component Keystroke Actions for the Metal L&F</a>.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.70 04/14/98
 * @author Steve Wilson
 */
public class MetalLookAndFeel extends BasicLookAndFeel
{
  
    private static MetalTheme currentTheme;

    public String getName() {
        return "Metal";
    }

    public String getID() {
        return "Metal";
    }

    public String getDescription() {
        return "The Metal Look and Feel";
    }

    
    public boolean isNativeLookAndFeel() {
        return false;
    }


    public boolean isSupportedLookAndFeel() {
        return true;
    }
    
    /** 
     * Initialize the uiClassID to BasicComponentUI mapping.
     * The JComponent classes define their own uiClassID constants
     * (see AbstractComponent.getUIClassID).  This table must
     * map those constants to a BasicComponentUI class of the
     * appropriate type.
     * 
     * @see BasicLookAndFeel#getDefaults
     */
    protected void initClassDefaults(UIDefaults table)
    {
        String basicPackageName = "com.sun.java.swing.plaf.basic.";
        String metalPackageName = "com.sun.java.swing.plaf.metal.";

        Object[] uiDefaults = {
                   "ButtonUI", metalPackageName + "MetalButtonUI",
                 "CheckBoxUI", metalPackageName + "MetalCheckBoxUI",
             "ColorChooserUI", basicPackageName + "BasicColorChooserUI",
                  "MenuBarUI", basicPackageName + "BasicMenuBarUI",
                     "MenuUI", basicPackageName + "BasicMenuUI",
                 "MenuItemUI", basicPackageName + "BasicMenuItemUI",
         "CheckBoxMenuItemUI", basicPackageName + "BasicCheckBoxMenuItemUI",
      "RadioButtonMenuItemUI", basicPackageName + "BasicRadioButtonMenuItemUI",
              "RadioButtonUI", metalPackageName + "MetalRadioButtonUI",
             "ToggleButtonUI", metalPackageName + "MetalToggleButtonUI",
                "PopupMenuUI", basicPackageName + "BasicPopupMenuUI",
              "ProgressBarUI", metalPackageName + "MetalProgressBarUI",
                "ScrollBarUI", metalPackageName + "MetalScrollBarUI",
               "ScrollPaneUI", metalPackageName + "MetalScrollPaneUI",
                "SplitPaneUI", metalPackageName + "MetalSplitPaneUI",
                   "SliderUI", metalPackageName + "MetalSliderUI",
                  "SpinnerUI", basicPackageName + "BasicSpinnerUI",
                "SeparatorUI", metalPackageName + "MetalSeparatorUI",
               "TabbedPaneUI", metalPackageName + "MetalTabbedPaneUI",
                 "TextAreaUI", basicPackageName + "BasicTextAreaUI",
                "TextFieldUI", metalPackageName + "MetalTextFieldUI",
            "PasswordFieldUI", basicPackageName + "BasicPasswordFieldUI",
                 "TextPaneUI", basicPackageName + "BasicTextPaneUI",
               "EditorPaneUI", basicPackageName + "BasicEditorPaneUI",
                     "TreeUI", metalPackageName + "MetalTreeUI",
                    "LabelUI", metalPackageName + "MetalLabelUI",
                     "ListUI", basicPackageName + "BasicListUI",
                  "ToolBarUI", metalPackageName + "MetalToolBarUI",
                  "ToolTipUI", metalPackageName + "MetalToolTipUI",
                 "ComboBoxUI", metalPackageName + "MetalComboBoxUI",
                    "TableUI", basicPackageName + "BasicTableUI",
              "TableHeaderUI", basicPackageName + "BasicTableHeaderUI",
            "InternalFrameUI", metalPackageName + "MetalInternalFrameUI",
           "StandardDialogUI", basicPackageName + "BasicStandardDialogUI",
              "DesktopPaneUI", basicPackageName + "BasicDesktopPaneUI",
              "DesktopIconUI", metalPackageName + "MetalDesktopIconUI",
              "FileChooserUI", metalPackageName + "MetalFileChooserUI",
               "OptionPaneUI", basicPackageName + "BasicOptionPaneUI"
        };

        table.putDefaults(uiDefaults);
    }

    /**
     * Load the SystemColors into the defaults table.  The keys
     * for SystemColor defaults are the same as the names of
     * the public fields in SystemColor.
     */
    protected void initSystemColorDefaults(UIDefaults table)
    {
        Object[] systemColors = {
                "desktop", getDesktopColor(), /* Color of the desktop background */
          "activeCaption", getWindowTitleBackground(), /* Color for captions (title bars) when they are active. */
      "activeCaptionText", getWindowTitleForeground(), /* Text color for text in captions (title bars). */
    "activeCaptionBorder", getPrimaryControlShadow(), /* Border color for caption (title bar) window borders. */
        "inactiveCaption", getWindowTitleInactiveBackground(), /* Color for captions (title bars) when not active. */
    "inactiveCaptionText", getWindowTitleInactiveForeground(), /* Text color for text in inactive captions (title bars). */
  "inactiveCaptionBorder", getControlShadow(), /* Border color for inactive caption (title bar) window borders. */
                 "window", getWindowBackground(), /* Default color for the interior of windows */
           "windowBorder", getControl(), /* ??? */
             "windowText", getUserTextColor(), /* ??? */
                   "menu", getMenuBackground(), /* Background color for menus */
               "menuText", getMenuForeground(), /* Text color for menus  */
                   "text", getWindowBackground(), /* Text background color */
               "textText", getUserTextColor(), /* Text foreground color */
          "textHighlight", getTextHighlightColor(), /* Text background color when selected */
      "textHighlightText", getHighlightedTextColor(), /* Text color when selected */
       "textInactiveText", getInactiveSystemTextColor(), /* Text color when disabled */
                "control", getControl(), /* Default color for controls (buttons, sliders, etc) */
            "controlText", getControlTextColor(), /* Default color for text in controls */
       "controlHighlight", getControlHighlight(), /* Specular highlight (opposite of the shadow) */
     "controlLtHighlight", getControlHighlight(), /* Highlight color for controls */
          "controlShadow", getControlShadow(), /* Shadow color for controls */
        "controlDkShadow", getControlDarkShadow(), /* Dark shadow color for controls */
              "scrollbar", getControl(), /* Scrollbar background (usually the "track") */
                   "info", getPrimaryControl(), /* ToolTip Background */
               "infoText", getPrimaryControlInfo()  /* ToolTip Text */
        };

        for(int i = 0; i < systemColors.length; i += 2) {
            table.put((String)systemColors[i], systemColors[i + 1]);
        }
    }

    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults( table );

	Object fieldTextBorder = new BorderUIResource( new CompoundBorder(
						       new MetalTextFieldUI.TextFieldBorder(),
					               BasicMarginBorder.getMarginBorder()));


        Object textBorder = new BorderUIResource( new CompoundBorder(
                                                       new Flush3DBorder(),
                                                       BasicMarginBorder.getMarginBorder()));

	JTextComponent.KeyBinding[] fieldBindings = {
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_C, 
								 InputEvent.CTRL_MASK),
					  DefaultEditorKit.copyAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_V, 
								 InputEvent.CTRL_MASK),
					  DefaultEditorKit.pasteAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_X, 
								 InputEvent.CTRL_MASK),
					  DefaultEditorKit.cutAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_LEFT, 
								 InputEvent.SHIFT_MASK),
					  DefaultEditorKit.selectionBackwardAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_RIGHT, 
								 InputEvent.SHIFT_MASK),
					  DefaultEditorKit.selectionForwardAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_LEFT, 
								 InputEvent.CTRL_MASK),
					  DefaultEditorKit.previousWordAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_RIGHT, 
								 InputEvent.CTRL_MASK),
					  DefaultEditorKit.nextWordAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_LEFT, 
								 InputEvent.CTRL_MASK | 
								 InputEvent.SHIFT_MASK),
					  DefaultEditorKit.selectionPreviousWordAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_RIGHT, 
								 InputEvent.CTRL_MASK |
								 InputEvent.SHIFT_MASK),
					  DefaultEditorKit.selectionNextWordAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_A, 
								 InputEvent.CTRL_MASK),
					  DefaultEditorKit.selectAllAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_HOME, 0),
					  DefaultEditorKit.beginLineAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_END, 0),
					  DefaultEditorKit.endLineAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_HOME, 
								 InputEvent.SHIFT_MASK),
					  DefaultEditorKit.selectionBeginLineAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_END, 
								 InputEvent.SHIFT_MASK),
					  DefaultEditorKit.selectionEndLineAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0),
					  JTextField.notifyAction)
	};

	JTextComponent.KeyBinding[] multilineBindings = {
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_C, 
								 InputEvent.CTRL_MASK),
					  DefaultEditorKit.copyAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_V, 
								 InputEvent.CTRL_MASK),
					  DefaultEditorKit.pasteAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_X, 
								 InputEvent.CTRL_MASK),
					  DefaultEditorKit.cutAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_LEFT, 
								 InputEvent.SHIFT_MASK),
					  DefaultEditorKit.selectionBackwardAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_RIGHT, 
								 InputEvent.SHIFT_MASK),
					  DefaultEditorKit.selectionForwardAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_LEFT, 
								 InputEvent.CTRL_MASK),
					  DefaultEditorKit.previousWordAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_RIGHT, 
								 InputEvent.CTRL_MASK),
					  DefaultEditorKit.nextWordAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_LEFT, 
								 InputEvent.CTRL_MASK | 
								 InputEvent.SHIFT_MASK),
					  DefaultEditorKit.selectionPreviousWordAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_RIGHT, 
								 InputEvent.CTRL_MASK |
								 InputEvent.SHIFT_MASK),
					  DefaultEditorKit.selectionNextWordAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_A, 
								 InputEvent.CTRL_MASK),
					  DefaultEditorKit.selectAllAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_HOME, 0),
					  DefaultEditorKit.beginLineAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_END, 0),
					  DefaultEditorKit.endLineAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_HOME, 
								 InputEvent.SHIFT_MASK),
					  DefaultEditorKit.selectionBeginLineAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_END, 
								 InputEvent.SHIFT_MASK),
					  DefaultEditorKit.selectionEndLineAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_UP, 0),
					  DefaultEditorKit.upAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_DOWN, 0),
					  DefaultEditorKit.downAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_UP, 0),
					  DefaultEditorKit.pageUpAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_DOWN, 0),
					  DefaultEditorKit.pageDownAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_UP,
								 InputEvent.SHIFT_MASK),
					  DefaultEditorKit.selectionUpAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_DOWN,
								 InputEvent.SHIFT_MASK),
					  DefaultEditorKit.selectionDownAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0),
					  DefaultEditorKit.insertBreakAction),
	    new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_TAB, 0),
					  DefaultEditorKit.insertTabAction)
	};

        Object scrollPaneBorder = new BorderUIResource( new MetalScrollPaneUI.ScrollPaneBorder() );

        Object buttonBorder =  new BorderUIResource(new CompoundBorder(
                                           new MetalButtonBorder(),
                                           BasicMarginBorder.getMarginBorder()));

        Object toggleButtonBorder =  new BorderUIResource(new CompoundBorder(
                                      new MetalToggleButtonUI.MetalToggleButtonBorder(),
                                      BasicMarginBorder.getMarginBorder()));

        Object comboBoxEditorActiveValue  = new UIDefaults.ActiveValue() {
            public Object createValue(UIDefaults table) {
                return new MetalComboBoxEditor.UIResource();
            }
        };

        Object titledBorderBorder = new BorderUIResource(new LineBorder(table.getColor("controlShadow")));

        Object desktopIconBorder = new BorderUIResource(new CompoundBorder(
                                      new LineBorder(getControlDarkShadow(), 1),
                                      new MatteBorder (2,2,1,2, getControl())));
     
        Object internalFrameBorder = new BorderUIResource( new MetalInternalFrameBorder() );

        Object menuBarBorder = new BorderUIResource( new MetalMenuBarBorder() );
        Object popupMenuBorder = new BorderUIResource( new MetalPopupMenuBorder() );
        Object menuItemBorder = new BorderUIResource( new MetalMenuItemBorder() );
        Object toolBarBorder = new BorderUIResource( new MetalToolBarBorder() );

	Object progressBarBorder = new BorderUIResource(
	    new LineBorder(getControlDarkShadow(), 1));

        Object focusCellHighlightBorder = new BorderUIResource( 
                                              new LineBorder(getFocusColor()) );

        //
        // DEFAULTS TABLE
        //

	final int internalFrameIconSize = 12;

        Object[] defaults = {
            // Text (Note: many are inherited)
            "TextField.border", fieldTextBorder,
	    "TextField.font", getUserTextFont(),
	    "TextField.caretForeground", getUserTextColor(),

            "PasswordField.border", textBorder,
            "PasswordField.font", getUserTextFont(),
	    "PasswordField.caretForeground", getUserTextColor(),

            "TextArea.border", textBorder,
            "TextArea.font", getUserTextFont(),
            "TextArea.caretForeground", getUserTextColor(),

            "TextPane.border", textBorder,
            "TextPane.font", getUserTextFont(),
            "TextPane.caretForeground", getUserTextColor(),

            "EditorPane.border", BasicMarginBorder.getMarginBorder(),

	    "TextField.keyBindings", fieldBindings,
	    "PasswordField.keyBindings", fieldBindings,
	    "TextArea.keyBindings", multilineBindings,
	    "TextPane.keyBindings", multilineBindings,
	    "EditorPane.keyBindings", multilineBindings,
            
            // CheckBox
            "CheckBox.icon", new MetalCheckBoxIcon(),
            "CheckBox.font", getControlTextFont(),
            "CheckBox.focus", getFocusColor(),

            // Button
            "Button.background", getControl(),
            "Button.foreground", getControlTextColor(),
            "Button.pressed", getControlShadow(),
            "Button.disabledText", getInactiveControlTextColor(),
            "Button.disabled", getControl(),
            "Button.border", buttonBorder,
            "Button.font", getControlTextFont(),
            "Button.focus", getFocusColor(),

            // File View 
            "FileView.directoryIcon", MetalIconFactory.getTreeFolderIcon(),
            "FileView.fileIcon", MetalIconFactory.getTreeLeafIcon(),
            "FileView.computerIcon", MetalIconFactory.getTreeComputerIcon(),
            "FileView.hardDriveIcon", MetalIconFactory.getTreeHardDriveIcon(),
            "FileView.floppyDriveIcon", MetalIconFactory.getTreeFloppyDriveIcon(),

            // File Chooser
            "FileChooser.detailsViewIcon", MetalIconFactory.getFileChooserDetailViewIcon(),
            "FileChooser.homeFolderIcon", MetalIconFactory.getFileChooserHomeFolderIcon(),
            "FileChooser.listViewIcon", MetalIconFactory.getFileChooserListViewIcon(),
            "FileChooser.newFolderIcon", MetalIconFactory.getFileChooserNewFolderIcon(),
            "FileChooser.upFolderIcon", MetalIconFactory.getFileChooserUpFolderIcon(),

            // InternalFrame
            "InternalFrameTitlePane.closeIcon", MetalIconFactory.getInternalFrameCloseIcon(internalFrameIconSize),
            "InternalFrameTitlePane.maximizeIcon", MetalIconFactory.getInternalFrameMaximizeIcon(internalFrameIconSize),
            "InternalFrameTitlePane.iconizeIcon", MetalIconFactory.getInternalFrameMinimizeIcon(internalFrameIconSize),
            "InternalFrameTitlePane.altMaximizeIcon", MetalIconFactory.getInternalFrameAltMaximizeIcon(internalFrameIconSize),
            "InternalFrameTitlePane.font",  getWindowTitleFont(),

            // RadioButton
            "RadioButton.icon", MetalIconFactory.getRadioButtonIcon(),
            "RadioButton.font", getControlTextFont(),
            "RadioButton.focus", getFocusColor(),

            // ToolTip
            "ToolTip.font", getSystemTextFont(),
            "ToolTip.border", new LineBorder(getPrimaryControlDarkShadow()),
            "ToolTip.background", table.get("info"),
            "ToolTip.foreground", table.get("infoText"),

            // Toggle Button Defaults
            "ToggleButton.background", getControl(),
            "ToggleButton.foreground", getControlTextColor(),
            "ToggleButton.pressed", getControlShadow(),
            "ToggleButton.selected", getControlShadow(),
            "ToggleButton.disabledText", getInactiveControlTextColor(),
            "ToggleButton.disabledSelectedText", getControlDarkShadow(),
            "ToggleButton.disabledBackground", getControl(),
            "ToggleButton.disabledSelectedBackground", getControlShadow(),
            "ToggleButton.focus", getFocusColor(),
            "ToggleButton.border", toggleButtonBorder,
            "ToggleButton.font", getControlTextFont(),

            // Slider Defaults
            "Slider.border", null,
            "Slider.foreground", getPrimaryControlShadow(),
            "Slider.background", getControl(),
            "Slider.focus", getFocusColor(),
            "Slider.trackWidth", new Integer( 9 ),
            "Slider.majorTickLength", new Integer( 6 ),
            "Slider.horizontalThumbIcon", MetalIconFactory.getHorizontalSliderThumbIcon(),
            "Slider.verticalThumbIcon", MetalIconFactory.getVerticalSliderThumbIcon(),

            // Progress Bar
            "ProgressBar.foreground", getPrimaryControlShadow(), 
            "ProgressBar.background", getControl(),
            "ProgressBar.foregroundHighlight", getPrimaryControlShadow(), 
            "ProgressBar.backgroundHighlight", getControl(),
	    "ProgressBar.border", progressBarBorder,
            "ProgressBar.cellSpacing", new Integer(0),
            "ProgressBar.cellLength", new Integer(1),

            // Combo Box
            "ComboBox.background", table.get("control"),
            "ComboBox.foreground", table.get("controlText"),
            "ComboBox.selectedBackground", getPrimaryControlShadow(),
            "ComboBox.selectedForeground", getControlTextColor(),
            "ComboBox.listBackground", getControl(),
            "ComboBox.listForeground", getControlTextColor(),
            "ComboBox.font", getControlTextFont(),
            "ComboBox.editor", comboBoxEditorActiveValue,

            // Internal Frame Defaults
            "InternalFrame.icon", MetalIconFactory.getInternalFrameDefaultMenuIcon(),
            "InternalFrame.border", internalFrameBorder,

            // Desktop Icon
            "DesktopIcon.border", desktopIconBorder,
            "DesktopIcon.font", getControlTextFont(),
            "DesktopIcon.foreground", getControlTextColor(),
            "DesktopIcon.background", getControl(),

            // Titled Border
            "TitledBorder.font", getControlTextFont(),
            "TitledBorder.titleColor", getSystemTextColor(),
            "TitledBorder.border", titledBorderBorder,

            // Label
            "Label.font", getControlTextFont(),
            "Label.background", table.get("control"),
            "Label.foreground", getSystemTextColor(),
            "Label.disabled", getInactiveSystemTextColor(),

            // List
            "List.focusCellHighlightBorder", focusCellHighlightBorder,

            // ScrollBar
            "ScrollBar.background", getControl(),
            "ScrollBar.highlight", getControlHighlight(),
            "ScrollBar.shadow", getControlDarkShadow(),
            "ScrollBar.thumb", getPrimaryControlShadow(),
            "ScrollBar.thumbShadow", getPrimaryControlDarkShadow(),
            "ScrollBar.thumbHighlight", getPrimaryControl(),
            "ScrollBar.width", new Integer( 17 ),

	    // ScrollPane
	    "ScrollPane.border", scrollPaneBorder,
	    "ScrollPane.background", table.get("window"),

            // Tabbed Pane
            "TabbedPane.font", getControlTextFont(),
            "TabbedPane.tabBackground", getControl(),
            "TabbedPane.tabForeground", getControlTextColor(),
            "TabbedPane.tabHighlight", getControlHighlight(),
            "TabbedPane.tabDarkShadow", getControlDarkShadow(),
            "TabbedPane.focus", getPrimaryControlDarkShadow(),
            "TabbedPane.selected", getPrimaryControlShadow(),
            "TabbedPane.selectHighlight", getPrimaryControl(),
            
            // Table
            "Table.focusCellHighlightBorder", focusCellHighlightBorder,
            "Table.focusCellBackground", getFocusColor(),
            "Table.scrollPaneBorder", scrollPaneBorder,
      	    "Table.gridColor", getControlShadow(),  // grid line color

	    "TableHeader.cellBorder", new MetalUtils.TableHeaderBorder(),

            // MenuBar
            "MenuBar.border", menuBarBorder,
            "MenuBar.font", getMenuTextFont(),
            "MenuBar.foreground", getMenuForeground(),
            "MenuBar.background", getMenuBackground(),

            // Menu
            "Menu.border", menuItemBorder,
            "Menu.font", getMenuTextFont(),
            "Menu.foreground", getMenuForeground(),
            "Menu.background", getMenuBackground(),
            "Menu.pressedForeground", getMenuSelectedForeground(),
            "Menu.pressedBackground", getMenuSelectedBackground(),
            "Menu.arrowIcon", MetalIconFactory.getMenuArrowIcon(),

            // Menu Item
            "MenuItem.border", menuItemBorder,
            "MenuItem.borderPainted", Boolean.TRUE,
            "MenuItem.font", getMenuTextFont(),
            "MenuItem.acceleratorFont", getSubTextFont(),
            "MenuItem.acceleratorForeground", getAcceleratorForeground(),
            "MenuItem.acceleratorPressedForeground", getAcceleratorSelectedForeground(),
            "MenuItem.foreground", getMenuForeground(),
            "MenuItem.background", getMenuBackground(),
            "MenuItem.pressedForeground", getMenuSelectedForeground(),
            "MenuItem.pressedBackground", getMenuSelectedBackground(),
            "MenuItem.disabledForeground", getMenuDisabledForeground(),
            "MenuItem.acceleratorFont", getSubTextFont(),
            "MenuItem.acceleratorForeground", getAcceleratorForeground(),
            "MenuItem.acceleratorPressedForeground", getAcceleratorSelectedForeground(),
            "MenuItem.checkIcon", MetalIconFactory.getMenuItemCheckIcon(),
            "MenuItem.arrowIcon", MetalIconFactory.getMenuItemArrowIcon(),

            // Separator
            "Separator.background", getSeparatorBackground(),
            "Separator.foreground", getSeparatorForeground(),

            // Popup Menu
            "PopupMenu.background", getMenuBackground(),
            "PopupMenu.border", popupMenuBorder,          

            // CB & RB Menu Item
            "CheckBoxMenuItem.icon", MetalIconFactory.getCheckBoxMenuItemIcon(),
            "RadioButtonMenuItem.icon", MetalIconFactory.getRadioButtonMenuItemIcon(),

	    // SplitPane

	    "SplitPane.dividerSize", new Integer(8),

            // Tree
            "Tree.background", getWindowBackground(),
	    "Tree.font", getSystemTextFont(),
            "Tree.textSelectionColor", table.get("textHighlightText"),
            "Tree.textNonSelectionColor", table.get("textText"),
            "Tree.borderSelectionColor", getWindowBackground(),
            "Tree.backgroundSelectionColor", table.get("textHighlight"),
            "Tree.backgroundNonSelectionColor", getWindowBackground(),
            "Tree.openIcon", MetalIconFactory.getTreeFolderIcon(),
            "Tree.closedIcon", MetalIconFactory.getTreeFolderIcon(),
            "Tree.leafIcon", MetalIconFactory.getTreeLeafIcon(),
            "Tree.expandedIcon", MetalIconFactory.getTreeControlIcon( MetalIconFactory.DARK ),
            "Tree.collapsedIcon", MetalIconFactory.getTreeControlIcon( MetalIconFactory.LIGHT ),
            "Tree.line", getPrimaryControl(), // horiz lines
            "Tree.hash", getPrimaryControl(),  // legs

            // ToolBar
            "ToolBar.border", toolBarBorder,
            "ToolBar.background", getMenuBackground(),
            "ToolBar.foreground", getMenuForeground(),
            "ToolBar.font", getMenuTextFont(),
            "ToolBar.dockingColor", getMenuBackground(),
            "ToolBar.floatingColor", getMenuBackground(),
            "ToolBar.dockingBorderColor", getPrimaryControlDarkShadow(), 
            "ToolBar.floatingBorderColor", getPrimaryControl(),
        };

        table.putDefaults(defaults);
    }

    protected void createDefaultTheme() {
        if( currentTheme == null) 
        currentTheme =  new DefaultMetalTheme();
    }

    public UIDefaults getDefaults() {
        createDefaultTheme();
        UIDefaults table = super.getDefaults();
        currentTheme.addCustomEntriesToTable(table);
        return table;
    }

    public static void setCurrentTheme(MetalTheme theme) {
        if (theme == null) {
            throw new NullPointerException("Can't have null theme");
        }
        currentTheme = theme;
    }

    public static FontUIResource getControlTextFont() { return currentTheme.getControlTextFont();}
    public static FontUIResource getSystemTextFont() { return currentTheme.getSystemTextFont();}
    public static FontUIResource getUserTextFont() { return currentTheme.getUserTextFont();}
    public static FontUIResource getMenuTextFont() { return currentTheme.getMenuTextFont();}
    public static FontUIResource getWindowTitleFont() { return currentTheme.getWindowTitleFont();}
    public static FontUIResource getSubTextFont() { return currentTheme.getSubTextFont();}

    public static ColorUIResource getDesktopColor() { return currentTheme.getDesktopColor(); }
    public static ColorUIResource getFocusColor() { return currentTheme.getFocusColor(); }

    public static ColorUIResource getWhite() { return currentTheme.getWhite(); }
    public static ColorUIResource getBlack() { return currentTheme.getBlack(); }
    public static ColorUIResource getControl() { return currentTheme.getControl(); }
    public static ColorUIResource getControlShadow() { return currentTheme.getControlShadow(); }
    public static ColorUIResource getControlDarkShadow() { return currentTheme.getControlDarkShadow(); }
    public static ColorUIResource getControlInfo() { return currentTheme.getControlInfo(); } 
    public static ColorUIResource getControlHighlight() { return currentTheme.getControlHighlight(); }
    public static ColorUIResource getControlDisabled() { return currentTheme.getControlDisabled(); }

    public static ColorUIResource getPrimaryControl() { return currentTheme.getPrimaryControl(); }  
    public static ColorUIResource getPrimaryControlShadow() { return currentTheme.getPrimaryControlShadow(); }  
    public static ColorUIResource getPrimaryControlDarkShadow() { return currentTheme.getPrimaryControlDarkShadow(); }  
    public static ColorUIResource getPrimaryControlInfo() { return currentTheme.getPrimaryControlInfo(); } 
    public static ColorUIResource getPrimaryControlHighlight() { return currentTheme.getPrimaryControlHighlight(); }  

    public static ColorUIResource getSystemTextColor() { return currentTheme.getSystemTextColor(); }
    public static ColorUIResource getControlTextColor() { return currentTheme.getControlTextColor(); }  
    public static ColorUIResource getInactiveControlTextColor() { return currentTheme.getInactiveControlTextColor(); }  
    public static ColorUIResource getInactiveSystemTextColor() { return currentTheme.getInactiveSystemTextColor(); }
    public static ColorUIResource getUserTextColor() { return currentTheme.getUserTextColor(); }
    public static ColorUIResource getTextHighlightColor() { return currentTheme.getTextHighlightColor(); }
    public static ColorUIResource getHighlightedTextColor() { return currentTheme.getHighlightedTextColor(); }

    public static ColorUIResource getWindowBackground() { return currentTheme.getWindowBackground(); }
    public static ColorUIResource getWindowTitleBackground() { return currentTheme.getWindowTitleBackground(); }
    public static ColorUIResource getWindowTitleForeground() { return currentTheme.getWindowTitleForeground(); }
    public static ColorUIResource getWindowTitleInactiveBackground() { return currentTheme.getWindowTitleInactiveBackground(); }
    public static ColorUIResource getWindowTitleInactiveForeground() { return currentTheme.getWindowTitleInactiveForeground(); }

    public static ColorUIResource getMenuBackground() { return currentTheme.getMenuBackground(); }
    public static ColorUIResource getMenuForeground() { return currentTheme.getMenuForeground(); }
    public static ColorUIResource getMenuSelectedBackground() { return currentTheme.getMenuSelectedBackground(); }
    public static ColorUIResource getMenuSelectedForeground() { return currentTheme.getMenuSelectedForeground(); }
    public static ColorUIResource getMenuDisabledForeground() { return currentTheme.getMenuDisabledForeground(); }
    public static ColorUIResource getSeparatorBackground() { return currentTheme.getSeparatorBackground(); }
    public static ColorUIResource getSeparatorForeground() { return currentTheme.getSeparatorForeground(); }
    public static ColorUIResource getAcceleratorForeground() { return currentTheme.getAcceleratorForeground(); }
    public static ColorUIResource getAcceleratorSelectedForeground() { return currentTheme.getAcceleratorSelectedForeground(); }

}
