/*
 * @(#)MetalInternalFrameTitlePane.java	1.17 98/04/10
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.metal;

import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.event.InternalFrameEvent;
import java.util.EventListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.beans.PropertyVetoException;



/**
 * Package private class that manages a JLF title bar
 * @version 1.17 04/10/98
 * @author Steve Wilson
 */
// Could not extend BasicInternalFrameTitlePane because it's private
class MetalInternalFrameTitlePane extends JComponent 
                                implements LayoutManager, 
					   ActionListener, 
					   PropertyChangeListener {

  protected JMenuBar menuBar;
  protected boolean isPalette = false;					    
  JInternalFrame frame;
  // the three control buttons
  protected JButton iconButton;
  protected JButton maxButton;
  protected JButton closeButton;

  private static final Border handyEmptyBorder = new EmptyBorder(0,0,0,0);

  // the pictures/icons in these three buttons
  Icon maxIcon; 
  Icon altMaxIcon; 
  Icon iconIcon; 
  Icon closeIcon;

  int riseWidth = 0;	
  int interButtonSpacing = 3;
    
  MetalBumps activeBumps = new MetalBumps( 0, 0,
					   MetalLookAndFeel.getPrimaryControlHighlight(),
					   MetalLookAndFeel.getPrimaryControlDarkShadow(),
					   MetalLookAndFeel.getPrimaryControl() );
  MetalBumps inactiveBumps = new MetalBumps( 0, 0,
					     MetalLookAndFeel.getControlHighlight(),
					     MetalLookAndFeel.getControlDarkShadow(),
					     MetalLookAndFeel.getControl() );
					    
  public MetalInternalFrameTitlePane(JInternalFrame f) {
    frame = f;

    setFont( UIManager.getFont("InternalFrameTitlePane.font") );
    maxIcon = (Icon)UIManager.get("InternalFrameTitlePane.maximizeIcon");
    altMaxIcon = (Icon)UIManager.get("InternalFrameTitlePane.altMaximizeIcon");
    iconIcon = (Icon)UIManager.get("InternalFrameTitlePane.iconizeIcon");
    closeIcon = (Icon)UIManager.get("InternalFrameTitlePane.closeIcon");

/*    menuBar = new JMenuBar(){
      public boolean isFocusTraversable() { return false; }
      public void requestFocus() {}
      // PENDING(klobad) Should be able to configure Menu + Button instead
      public void paint(Graphics g) {}
      public boolean isOpaque() { return false; }
    };
    
    menuBar.setBorderPainted(false);*/
    
    iconButton = new JButton( iconIcon );
    iconButton.putClientProperty("paintActive", Boolean.TRUE);
    iconButton.setFocusPainted(false);
    iconButton.setBorder(handyEmptyBorder);
    iconButton.setOpaque(false);
    iconButton.addActionListener(this);
    iconButton.setActionCommand("Iconify");
    

    maxButton = new JButton( maxIcon );
    maxButton.putClientProperty("paintActive", Boolean.TRUE);
    maxButton.setBorder(handyEmptyBorder);
    maxButton.setOpaque(false);
    maxButton.setFocusPainted(false);
    maxButton.addActionListener(this);
    maxButton.setActionCommand("Maximize");
    

    closeButton = new JButton( closeIcon );
    closeButton.putClientProperty("paintActive", Boolean.TRUE);
    closeButton.setBorder(handyEmptyBorder);
    closeButton.setOpaque(false);
    closeButton.setFocusPainted(false);     
    closeButton.addActionListener(this);
    closeButton.setActionCommand("Close");
    
    setLayout(this);
    
    //    add(menuBar);
    add(iconButton);
    add(maxButton);
    add(closeButton);             
    
    // Make sure these are ok to leave on?
    frame.addPropertyChangeListener(this);

  }
					     


  public void paint(Graphics g)  {
    boolean isSelected = frame.isSelected();

    int width = getWidth();
    int height = getHeight();
    
    Color background;
    Color foreground;
    Color shadow;
    Color darkShadow;
    Color highlight;

    MetalBumps bumps;

    Color fillColor = ((JInternalFrame)getParent()).getContentPane().getBackground();

    if (isSelected) {
        background = MetalLookAndFeel.getWindowTitleBackground();
        foreground = MetalLookAndFeel.getWindowTitleForeground();
	shadow = MetalLookAndFeel.getPrimaryControlShadow();
	darkShadow = MetalLookAndFeel.getPrimaryControlDarkShadow();
	highlight = MetalLookAndFeel.getPrimaryControlHighlight();
	bumps = activeBumps;
    } else {
        background = MetalLookAndFeel.getWindowTitleInactiveBackground();
        foreground = MetalLookAndFeel.getWindowTitleInactiveForeground();
       	shadow = MetalLookAndFeel.getControlShadow();
	darkShadow = MetalLookAndFeel.getControlDarkShadow();
	highlight = MetalLookAndFeel.getControlHighlight();
	bumps = inactiveBumps;
    }



    g.setColor(background);
    g.fillRect(0, 0, width, height);

    g.setColor( highlight );
    g.drawRect( 0,0, width -1, width -1 );
    g.fillRect( 0,0, 2, 2 );

    g.setColor( shadow );
    g.drawLine ( 1, height - 2, width - 2, height -2);
    g.drawLine ( width -1 , 1, width - 1, height -2);

    g.setColor( darkShadow );
    g.drawLine ( 0, height - 1, width, height -1);
    g.drawLine ( 0, 0, 0 ,0);    
    g.drawLine ( width - 1, 0 , width -1, 0);

    int titleLength = 0;
    int xOffset = 5;

    if(frame.getTitle() != null) {
      Font f = getFont();
      g.setFont(f);
      FontMetrics fm = g.getFontMetrics();
      int fHeight = fm.getHeight();

      Icon icon = frame.getFrameIcon();
      if ( icon != null ) {
	int iconY = ((height / 2) - (icon.getIconHeight() /2));
	icon.paintIcon(frame, g, xOffset, iconY);
        xOffset += icon.getIconWidth()+2;
      }

      g.setColor(foreground);

      int yOffset = ( (height - fm.getHeight() ) / 2 ) + fm.getAscent();
      g.drawString(frame.getTitle(),
		   xOffset,
		   yOffset );

      titleLength = fm.stringWidth(frame.getTitle());
    }

    xOffset += titleLength + interButtonSpacing;
    int bumpLength = getWidth() - (xOffset + riseWidth + interButtonSpacing );
    int bumpHeight = getHeight() - (2 * interButtonSpacing) - 2;
    bumps.setBumpArea( bumpLength, bumpHeight );
    bumps.paintIcon( this, g, xOffset, interButtonSpacing);

    if (riseWidth != 0) {
        xOffset += ( bumpLength - 1 );

	g.setColor( background); // erase bumps to make angle
	g.fillRect( xOffset - 1, height - 7 ,  7 , 3);

	g.setColor( darkShadow );
	g.drawLine ( xOffset, height - 2, xOffset  + 1, height - 2);
	g.drawLine ( xOffset+2, height - 3, xOffset  + 2, height - 3);
	g.drawLine ( xOffset+3, height - 4, xOffset  + 4, height - 4);
	g.drawLine ( xOffset+5, height - 5, width, height - 5);

	g.setColor( shadow );
	g.drawLine ( xOffset - 1, height - 3, xOffset  + 1, height - 3);
	g.drawLine ( xOffset+1, height - 4, xOffset  + 2, height - 4);
	g.drawLine ( xOffset+2, height - 5, xOffset  + 4, height - 5);
	g.drawLine ( xOffset+4, height - 6, width, height - 6);

	g.setColor( fillColor );
	g.drawLine ( xOffset, height -1, width, height - 1);
	g.drawLine ( xOffset+2, height - 2, width, height - 2);
	g.drawLine ( xOffset+3, height - 3, width, height - 3);
	g.drawLine ( xOffset+5, height - 4, width, height - 4);


    }

    paintChildren(g); 
  }
					     
    /**
     * Post a WINDOW_CLOSING-like event to the frame, so that it can
     * be treated like a regular Frame.
     */
    void postClosingEvent(JInternalFrame frame) {
        InternalFrameEvent e = new InternalFrameEvent(
            frame, InternalFrameEvent.INTERNAL_FRAME_CLOSING);
        // Try posting event, unless there's a SecurityManager.
        if (JInternalFrame.class.getClassLoader() == null) {
            try {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(e);
                return;
            } catch (SecurityException se) {
                // Use dispatchEvent instead.
            }
        }
        frame.dispatchEvent(e);
    }

    public void actionPerformed(ActionEvent e) {
      if("Close".equals(e.getActionCommand()) && frame.isClosable())
          postClosingEvent(frame);
      else if("Iconify".equals(e.getActionCommand()) && frame.isIconifiable()) {
	if(!frame.isIcon())
	  try { frame.setIcon(true); } catch (PropertyVetoException e1) { }
	else
	  try { frame.setIcon(false); } catch (PropertyVetoException e1) { }

	  ButtonModel model = iconButton.getModel();
	  if ( model != null ) {
	      model.setRollover( false );
	  }
      } else if("Minimize".equals(e.getActionCommand()) && frame.isMaximizable()) {
	try { frame.setIcon(true); } catch (PropertyVetoException e2) { }
      } else if("Maximize".equals(e.getActionCommand()) && frame.isMaximizable()) {
	if(!frame.isMaximum()) {
	  try { frame.setMaximum(true); } catch (PropertyVetoException e5) { }
	} else {
	  try { frame.setMaximum(false); } catch (PropertyVetoException e6) { }
	}
      } else if("Restore".equals(e.getActionCommand()) && 
                frame.isMaximizable() && frame.isMaximum()) {
	try { frame.setMaximum(false); } catch (PropertyVetoException e4) { }
      } else if("Restore".equals(e.getActionCommand()) && 
                frame.isIconifiable() && frame.isIcon()) {
	try { frame.setIcon(false); } catch (PropertyVetoException e4) { }
      }
    }
					     
    public void propertyChange(PropertyChangeEvent evt) {
      String prop = (String)evt.getPropertyName();
      JInternalFrame f = (JInternalFrame)evt.getSource();
      boolean value = false;

      if ( frame.isSelected() ) {
	  iconButton.putClientProperty("paintActive", Boolean.TRUE);
	  closeButton.putClientProperty("paintActive", Boolean.TRUE);
	  maxButton.putClientProperty("paintActive", Boolean.TRUE);
	  repaint();
      } else {
	  iconButton.putClientProperty("paintActive", Boolean.FALSE);
	  closeButton.putClientProperty("paintActive", Boolean.FALSE);
	  maxButton.putClientProperty("paintActive", Boolean.FALSE);
	  repaint();
      }

      if(JInternalFrame.IS_SELECTED_PROPERTY.equals(prop)) {
	  repaint();
      } else if(JInternalFrame.IS_MAXIMUM_PROPERTY.equals(prop)) {
	value = ((Boolean)evt.getNewValue()).booleanValue();
	if(value)
       	  maxButton.setIcon(altMaxIcon);
	else
	  maxButton.setIcon(maxIcon);
      } else if(JInternalFrame.IS_ICON_PROPERTY.equals(prop)) {
	value = ((Boolean)evt.getNewValue()).booleanValue();
	if(value)
	  iconButton.setIcon(iconIcon);
	else
	  iconButton.setIcon(iconIcon);  
      } 
    }
    
    public void addLayoutComponent(String name, Component c) {}
    public void removeLayoutComponent(Component c) {}   
 
   public Dimension preferredLayoutSize(Container c)  {
       return getPreferredSize(c);
    }


    public Dimension getPreferredSize(Container c)  {
      return new Dimension(c.getSize().width, computeHeight());
    }

    public Dimension minimumLayoutSize(Container c) {
      return preferredLayoutSize(c);
    } 
    
    protected int computeHeight() {
      FontMetrics fm =  Toolkit.getDefaultToolkit().getFontMetrics(getFont());
      int fontHeight = fm.getHeight();
      fontHeight += 6;
      int iconHeight = frame.getFrameIcon().getIconHeight();
      iconHeight += 7;
      
      int finalHeight = Math.max( fontHeight, iconHeight );

      return finalHeight;
    }	
				    
    public void layoutContainer(Container c) {

      int w = getWidth();
      
      // These should really be derived from the size of the Icons in the buttons
      int buttonHeight = closeButton.getIcon().getIconHeight();  // this includes the border
      int buttonWidth = closeButton.getIcon().getIconWidth();  // this includes the border


      int x = (w) ;
      
      if(frame.isClosable()) {
	x -= (buttonWidth+interButtonSpacing);
	closeButton.setBounds(x , interButtonSpacing, buttonWidth, buttonHeight);
      } else if(closeButton.getParent() != null) {
	closeButton.getParent().remove(closeButton);
      }
      
      if(frame.isMaximizable()) {
	x -= (buttonWidth+interButtonSpacing);
	maxButton.setBounds(x, interButtonSpacing, buttonWidth, buttonHeight);
      } else if(maxButton.getParent() != null) {
	maxButton.getParent().remove(maxButton);
      }

      if(frame.isIconifiable()) {
	x -= (buttonWidth+interButtonSpacing);
	iconButton.setBounds(x, interButtonSpacing, buttonWidth, buttonHeight);

      } else if(iconButton.getParent() != null) {
	iconButton.getParent().remove(iconButton);
      }

      riseWidth = w-x;

      
    } 


    public void setPalette(boolean b) {
        isPalette = b;
	repaint();
    }

			     
};    /// End Title Pane Class
