/*
 * @(#)MetalInternalFrameBorder.java	1.4 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
 
package com.sun.java.swing.plaf.metal;

import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.basic.*;
import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.plaf.*;

/**
 * The Flush 3D border used for Metal buttons, text fields, etc.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.4 02/02/98
 * @author Steve Wilson
 */
public class MetalInternalFrameBorder extends AbstractBorder {

  private static final Insets insets = new Insets(6, 6, 6, 6);

  private static final int corner = 14;

  public void paintBorder(Component c, Graphics g, int x, int y, 
			  int w, int h) {

    Color background;
    Color highlight;
    Color shadow;

    if (c instanceof JInternalFrame && ((JInternalFrame)c).isSelected()) {
        background = MetalLookAndFeel.getPrimaryControlDarkShadow();
	highlight = MetalLookAndFeel.getPrimaryControlShadow();
	shadow = MetalLookAndFeel.getPrimaryControlInfo();
    } else {
        background = MetalLookAndFeel.getControlDarkShadow();
	highlight = MetalLookAndFeel.getControlShadow();
	shadow = MetalLookAndFeel.getControlInfo();
    }

      g.setColor(background);
      // Draw outermost lines
      g.drawLine( 1, 0, w-2, 0);
      g.drawLine( 0, 1, 0, h-2);
      g.drawLine( w-1, 1, w-1, h-2);
      g.drawLine( 1, h-1, w-2, h-1);

      // Draw the bulk of the border
      for (int i = 1; i < 6; i++) {
	  g.drawRect(x+i,y+i,w-(i*2)-1, h-(i*2)-1);
      }

      g.setColor(highlight);
      // Draw the Long highlight lines
      g.drawLine( corner, 1, w-corner-1, 1);
      g.drawLine( 1, corner, 1, h-corner-1);
      g.drawLine( w-5, corner, w-5, h-corner-1);
      g.drawLine( corner, h-5, w-corner-1, h-5);

      // Draw the short highlight lines
      g.drawLine( corner, 2, corner, 4);
      g.drawLine( 2, corner, 4, corner);
      g.drawLine( w-4, corner, w-2, corner);
      g.drawLine( corner, h-4, corner, h-2);

      // Draw the short shadow lines
      g.setColor(shadow);
      g.drawLine( w-corner-1, 2, w-corner-1, 4);
      g.drawLine( 2, h-corner-1, 4, h-corner-1);
      g.drawLine( w-4, h-corner-1, w-2, h-corner-1);
      g.drawLine( w-corner-1, h-4, w-corner-1, h-2);


  }
  
  public Insets getBorderInsets(Component c)       {
    return insets;
  }
}

