/*
 * @(#)MetalIconFactory.java	1.27 98/03/11
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.metal;

import com.sun.java.swing.*;
import com.sun.java.swing.plaf.UIResource;
import java.awt.*;
import java.io.Serializable;

/**
 * Factory object that can vend Icons appropriate for Metal.
 * These are used extensively in Metal via the defaults mechanism.
 * While other Look and Feels use GIFs for some of these, doing this
 * work in code facilitates things when switching to other Themes.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.27 03/11/98
 * @author Michael C. Albers
 */
public class MetalIconFactory implements Serializable {

    // List of code-drawn Icons
    private static Icon fileChooserDetailViewIcon;
    private static Icon fileChooserHomeFolderIcon;
    private static Icon fileChooserListViewIcon;
    private static Icon fileChooserNewFolderIcon;
    private static Icon fileChooserUpFolderIcon;
    private static Icon internalFrameAltMaximizeIcon;
    private static Icon internalFrameCloseIcon;
    private static Icon internalFrameDefaultMenuIcon;
    private static Icon internalFrameMaximizeIcon;
    private static Icon internalFrameMinimizeIcon;
    private static Icon radioButtonIcon; 
    private static Icon treeComputerIcon;
    private static Icon treeFloppyDriveIcon;
    private static Icon treeFolderIcon;
    private static Icon treeHardDriveIcon;
    private static Icon treeLeafIcon;
    private static Icon treeDarkControlIcon;
    private static Icon treeLightControlIcon;

    private static Icon menuArrowIcon;
    private static Icon menuItemCheckIcon;
    private static Icon menuItemArrowIcon;
    private static Icon checkBoxMenuItemIcon;
    private static Icon radioButtonMenuItemIcon;


    // Constants
    public static final boolean DARK = false;
    public static final boolean LIGHT = true;

    // Accessor functions for Icons. Does the caching work.
    public static Icon getFileChooserDetailViewIcon() {
	if (fileChooserDetailViewIcon == null) {
	    fileChooserDetailViewIcon = new FileChooserDetailViewIcon();
	}
	return fileChooserDetailViewIcon;
    }

    public static Icon getFileChooserHomeFolderIcon() {
	if (fileChooserHomeFolderIcon == null) {
	    fileChooserHomeFolderIcon = new FileChooserHomeFolderIcon();
	}
	return fileChooserHomeFolderIcon;
    }

    public static Icon getFileChooserListViewIcon() {
	if (fileChooserListViewIcon == null) {
	    fileChooserListViewIcon = new FileChooserListViewIcon();
	}
	return fileChooserListViewIcon;
    }

    public static Icon getFileChooserNewFolderIcon() {
	if (fileChooserNewFolderIcon == null) {
	    fileChooserNewFolderIcon = new FileChooserNewFolderIcon();
	}
	return fileChooserNewFolderIcon;
    }

    public static Icon getFileChooserUpFolderIcon() {
	if (fileChooserUpFolderIcon == null) {
	    fileChooserUpFolderIcon = new FileChooserUpFolderIcon();
	}
	return fileChooserUpFolderIcon;
    }

    public static Icon getInternalFrameAltMaximizeIcon(int size) {
	return new InternalFrameAltMaximizeIcon(size);
    }

    public static Icon getInternalFrameCloseIcon(int size) {
	return new InternalFrameCloseIcon(size);
    }

    public static Icon getInternalFrameDefaultMenuIcon() {
	if (internalFrameDefaultMenuIcon == null) {
	    internalFrameDefaultMenuIcon = new InternalFrameDefaultMenuIcon();
	}
	return internalFrameDefaultMenuIcon;
    }

    public static Icon getInternalFrameMaximizeIcon(int size) {
	return new InternalFrameMaximizeIcon(size);
    }

    public static Icon getInternalFrameMinimizeIcon(int size) {
	return new InternalFrameMinimizeIcon(size);
    }

    public static Icon getRadioButtonIcon() {
	if (radioButtonIcon == null) {
	    radioButtonIcon = new RadioButtonIcon();
	}
	return radioButtonIcon;
    }

    public static Icon getTreeComputerIcon() {
        if ( treeComputerIcon == null ) {
	    treeComputerIcon = new TreeComputerIcon();
	}
	return treeComputerIcon;
    }

    public static Icon getTreeFloppyDriveIcon() {
        if ( treeFloppyDriveIcon == null ) {
	    treeFloppyDriveIcon = new TreeFloppyDriveIcon();
	}
	return treeFloppyDriveIcon;
    }

    public static Icon getTreeFolderIcon() {
        if ( treeFolderIcon == null ) {
	    treeFolderIcon = new TreeFolderIcon();
	}
	return treeFolderIcon;
    }

    public static Icon getTreeHardDriveIcon() {
        if ( treeHardDriveIcon == null ) {
	    treeHardDriveIcon = new TreeHardDriveIcon();
	}
	return treeHardDriveIcon;
    }

    public static Icon getTreeLeafIcon() {
        if ( treeLeafIcon == null ) {
	    treeLeafIcon = new TreeLeafIcon();
	}
	return treeLeafIcon;
    }

    public static Icon getTreeControlIcon( boolean isLight ) {
        if ( isLight ) {
	    if ( treeLightControlIcon == null ) {
	        treeLightControlIcon = new TreeControlIcon( LIGHT );
	    }
	    return treeLightControlIcon;
	}
	else {
	    if ( treeDarkControlIcon == null ) {
	        treeDarkControlIcon = new TreeControlIcon( DARK );
	    }
	    return treeDarkControlIcon;
	}
    }

    public static Icon getMenuArrowIcon() {
	if (menuArrowIcon == null) {
	    menuArrowIcon = new MenuArrowIcon();
	}
	return menuArrowIcon;
    }

    public static Icon getMenuItemCheckIcon() {
	if (menuItemCheckIcon == null) {
	    menuItemCheckIcon = new MenuItemCheckIcon();
	}
	return menuItemCheckIcon;
    }

    public static Icon getMenuItemArrowIcon() {
	if (menuItemArrowIcon == null) {
	    menuItemArrowIcon = new MenuItemArrowIcon();
	}
	return menuItemArrowIcon;
    }

    public static Icon getCheckBoxMenuItemIcon() {
	if (checkBoxMenuItemIcon == null) {
	    checkBoxMenuItemIcon = new CheckBoxMenuItemIcon();
	}
	return checkBoxMenuItemIcon;
    }

    public static Icon getRadioButtonMenuItemIcon() {
	if (radioButtonMenuItemIcon == null) {
	    radioButtonMenuItemIcon = new RadioButtonMenuItemIcon();
	}
	return radioButtonMenuItemIcon;
    }

    public static Icon getHorizontalSliderThumbIcon() {
      // don't cache these, bumps don't get updated otherwise
	return new HorizontalSliderThumbIcon();
    }

    public static Icon getVerticalSliderThumbIcon() {
      // don't cache these, bumps don't get updated otherwise
	return new VerticalSliderThumbIcon();
    }

    // Internal Frame Close code
    private static class InternalFrameCloseIcon extends InternalFrameMaximizeIcon {
	Color slashColor;

        public InternalFrameCloseIcon(int size) { super(size); };

        public void paintIcon(Component c, Graphics g, int x, int y) {
	    super.paintIcon(c,g,x,y);

	    slashColor = MetalLookAndFeel.getPrimaryControlDarkShadow();

	    if (parentButton.getClientProperty("paintActive")  != Boolean.TRUE) {
		slashColor = MetalLookAndFeel.getControlDarkShadow();
	    }
	    else if (buttonModel.isPressed() && buttonModel.isArmed()) {
		slashColor = MetalLookAndFeel.getPrimaryControlInfo();
	    }

	    g.translate(x, y);

	    // draw slash (rectangles from bottom to top)
	    g.setColor(slashColor);
	    for (int i=2 ; iconSize >= i+4 ; i++) {
		g.fillRect(i, iconSize-i-2, 2,2);
	    }

	    g.translate(-x, -y);
	}
	
	public int getIconWidth() {
	    return iconSize;
	}

	public int getIconHeight() {
	    return iconSize;
	}
    }  // End class InternalFrameCloseIcon

    // File Chooser Detail View code
    private static class FileChooserDetailViewIcon implements Icon, UIResource, Serializable {
        public void paintIcon(Component c, Graphics g, int x, int y) {
	    g.translate(x, y);

	    // Draw outside edge of each of the documents
	    g.setColor(MetalLookAndFeel.getPrimaryControlInfo());
	    //     top
	    g.drawLine(2,2, 5,2); // top
	    g.drawLine(2,3, 2,7); // left
	    g.drawLine(3,7, 6,7); // bottom
	    g.drawLine(6,6, 6,3); // right
	    //     bottom
	    g.drawLine(2,10, 5,10); // top
	    g.drawLine(2,11, 2,15); // left
	    g.drawLine(3,15, 6,15); // bottom
	    g.drawLine(6,14, 6,11); // right

	    // Draw little dots next to documents
	    //     Same color as outside edge
	    g.drawLine(8,5, 15,5);     // top
	    g.drawLine(8,13, 15,13);   // bottom

	    // Draw inner highlight on documents
	    g.setColor(MetalLookAndFeel.getPrimaryControl());
	    g.drawRect(3,3, 2,3);   // top
	    g.drawRect(3,11, 2,3);  // bottom

	    // Draw inner inner highlight on documents
	    g.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
	    g.drawLine(4,4, 4,5);     // top
	    g.drawLine(4,12, 4,13);   // bottom
	    
	    g.translate(-x, -y);
	}
	
	public int getIconWidth() {
	    return 18;
	}
	
	public int getIconHeight() {
	    return 18;
	}
    }  // End class FileChooserDetailViewIcon

    // File Chooser Home Folder code
    private static class FileChooserHomeFolderIcon implements Icon, UIResource, Serializable {
        public void paintIcon(Component c, Graphics g, int x, int y) {
	    g.translate(x, y);

	    // Draw outside edge of house
	    g.setColor(MetalLookAndFeel.getPrimaryControlInfo());
	    g.drawLine(8,1, 1,8);  // left edge of roof
	    g.drawLine(8,1, 15,8); // right edge of roof
	    g.drawLine(11,2, 11,3); // left edge of chimney
	    g.drawLine(12,2, 12,4); // right edge of chimney
	    g.drawLine(3,7, 3,15); // left edge of house
	    g.drawLine(13,7, 13,15); // right edge of house
	    g.drawLine(4,15, 12,15); // bottom edge of house
	    // Draw door frame
	    //     same color as edge of house
	    g.drawLine( 6,9,  6,14); // left
	    g.drawLine(10,9, 10,14); // right
	    g.drawLine( 7,9,  9, 9); // top

	    // Draw roof body
    	    g.setColor(MetalLookAndFeel.getControlDarkShadow());
	    g.fillRect(8,2, 1,1); //top toward bottom
	    g.fillRect(7,3, 3,1);
	    g.fillRect(6,4, 5,1);
	    g.fillRect(5,5, 7,1);
	    g.fillRect(4,6, 9,2);
	    // Draw doornob
	    //     same color as roof body
	    g.drawLine(9,12, 9,12);

	    // Paint the house
	    g.setColor(MetalLookAndFeel.getPrimaryControl());
	    g.drawLine(4,8, 12,8); // above door
	    g.fillRect(4,9, 2,6); // left of door
	    g.fillRect(11,9, 2,6); // right of door

	    g.translate(-x, -y);
	}
	
	public int getIconWidth() {
	    return 18;
	}
	
	public int getIconHeight() {
	    return 18;
	}
    }  // End class FileChooserHomeFolderIcon

    // File Chooser List View code
    private static class FileChooserListViewIcon implements Icon, UIResource, Serializable {
        public void paintIcon(Component c, Graphics g, int x, int y) {
	    g.translate(x, y);

	    // Draw outside edge of each of the documents
	    g.setColor(MetalLookAndFeel.getPrimaryControlInfo());
	    //     top left
	    g.drawLine(2,2, 5,2); // top
	    g.drawLine(2,3, 2,7); // left
	    g.drawLine(3,7, 6,7); // bottom
	    g.drawLine(6,6, 6,3); // right
	    //     top right
	    g.drawLine(10,2, 13,2); // top
	    g.drawLine(10,3, 10,7); // left
	    g.drawLine(11,7, 14,7); // bottom
	    g.drawLine(14,6, 14,3); // right
	    //     bottom left
	    g.drawLine(2,10, 5,10); // top
	    g.drawLine(2,11, 2,15); // left
	    g.drawLine(3,15, 6,15); // bottom
	    g.drawLine(6,14, 6,11); // right
	    //     bottom right
	    g.drawLine(10,10, 13,10); // top
	    g.drawLine(10,11, 10,15); // left
	    g.drawLine(11,15, 14,15); // bottom
	    g.drawLine(14,14, 14,11); // right

	    // Draw little dots next to documents
	    //     Same color as outside edge
	    g.drawLine(8,5, 8,5);     // top left
	    g.drawLine(16,5, 16,5);   // top right
	    g.drawLine(8,13, 8,13);   // bottom left
	    g.drawLine(16,13, 16,13); // bottom right

	    // Draw inner highlight on documents
	    g.setColor(MetalLookAndFeel.getPrimaryControl());
	    g.drawRect(3,3, 2,3);   // top left
	    g.drawRect(11,3, 2,3);  // top right
	    g.drawRect(3,11, 2,3);  // bottom left
	    g.drawRect(11,11, 2,3); // bottom right

	    // Draw inner inner highlight on documents
	    g.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
	    g.drawLine(4,4, 4,5);     // top left
	    g.drawLine(12,4, 12,5);   // top right
	    g.drawLine(4,12, 4,13);   // bottom left
	    g.drawLine(12,12, 12,13); // bottom right
	    
	    g.translate(-x, -y);
	}
	
	public int getIconWidth() {
	    return 18;
	}
	
	public int getIconHeight() {
	    return 18;
	}
    }  // End class FileChooserListViewIcon

    // File Chooser New Folder code
    private static class FileChooserNewFolderIcon implements Icon, UIResource, Serializable {
        public void paintIcon(Component c, Graphics g, int x, int y) {
	    g.translate(x, y);

	    // Fill background
	    g.setColor(MetalLookAndFeel.getPrimaryControl());
	    g.fillRect(3,5, 12,9);

	    // Draw outside edge of folder
	    g.setColor(MetalLookAndFeel.getPrimaryControlInfo());
	    g.drawLine(1,6,    1,14); // left
	    g.drawLine(2,14,  15,14); // bottom
	    g.drawLine(15,13, 15,5);  // right
	    g.drawLine(2,5,    9,5);  // top left
	    g.drawLine(10,6,  14,6);  // top right

	    // Draw inner folder highlight
	    g.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
	    g.drawLine( 2,6,  2,13); // left
	    g.drawLine( 3,6,  9,6);  // top left
	    g.drawLine(10,7, 14,7);  // top right

	    // Draw tab on folder
	    g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
	    g.drawLine(11,3, 15,3); // top
	    g.drawLine(10,4, 15,4); // bottom

	    g.translate(-x, -y);
	}
	
	public int getIconWidth() {
	    return 18;
	}
	
	public int getIconHeight() {
	    return 18;
	}
    }  // End class FileChooserNewFolderIcon

    // File Chooser Up Folder code
    private static class FileChooserUpFolderIcon implements Icon, UIResource, Serializable {
        public void paintIcon(Component c, Graphics g, int x, int y) {
	    g.translate(x, y);

	    // Fill background
	    g.setColor(MetalLookAndFeel.getPrimaryControl());
	    g.fillRect(3,5, 12,9);

	    // Draw outside edge of folder
	    g.setColor(MetalLookAndFeel.getPrimaryControlInfo());
	    g.drawLine(1,6,    1,14); // left
	    g.drawLine(2,14,  15,14); // bottom
	    g.drawLine(15,13, 15,5);  // right
	    g.drawLine(2,5,    9,5);  // top left
	    g.drawLine(10,6,  14,6);  // top right
	    // Draw the UP arrow
	    //     same color as edge
	    g.drawLine(8,13,  8,16); // arrow shaft
	    g.drawLine(8, 9,  8, 9); // arrowhead top
	    g.drawLine(7,10,  9,10);
	    g.drawLine(6,11, 10,11);
	    g.drawLine(5,12, 11,12);

	    // Draw inner folder highlight
	    g.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
	    g.drawLine( 2,6,  2,13); // left
	    g.drawLine( 3,6,  9,6);  // top left
	    g.drawLine(10,7, 14,7);  // top right

	    // Draw tab on folder
	    g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
	    g.drawLine(11,3, 15,3); // top
	    g.drawLine(10,4, 15,4); // bottom

	    g.translate(-x, -y);
	}
	
	public int getIconWidth() {
	    return 18;
	}
	
	public int getIconHeight() {
	    return 18;
	}
    }  // End class FileChooserUpFolderIcon

    // Internal Frame Alternate Maximize code (actually, the un-maximize icon)
    private static class InternalFrameAltMaximizeIcon implements Icon, UIResource, Serializable {
	JButton parentButton;
	ButtonModel buttonModel;
	Color backgroundColor, titleColor, titleHighlight, edgeColor;
	Color smallEdgeColor, downRightHighlight, upLeftHighlight;
	int iconSize = 12;

        public InternalFrameAltMaximizeIcon(int size) {
	    iconSize = size;
	}

        public void paintIcon(Component c, Graphics g, int x, int y) {
	    parentButton = (JButton)c;
	    buttonModel = parentButton.getModel();

	    downRightHighlight = MetalLookAndFeel.getPrimaryControlHighlight();
	    upLeftHighlight = MetalLookAndFeel.getPrimaryControlShadow();
	    backgroundColor = MetalLookAndFeel.getPrimaryControl();
	    titleColor = MetalLookAndFeel.getPrimaryControlShadow();
	    titleHighlight = MetalLookAndFeel.getPrimaryControlDarkShadow();
	    edgeColor = MetalLookAndFeel.getPrimaryControlShadow();
	    smallEdgeColor = MetalLookAndFeel.getPrimaryControlInfo();

	    if (parentButton.getClientProperty("paintActive")  != Boolean.TRUE) {
		downRightHighlight = MetalLookAndFeel.getControlHighlight();
		upLeftHighlight = MetalLookAndFeel.getControlShadow();
		backgroundColor = MetalLookAndFeel.getControl();
		titleColor = MetalLookAndFeel.getControlShadow();
		titleHighlight = MetalLookAndFeel.getControlDarkShadow();
		edgeColor = MetalLookAndFeel.getControlShadow();
	    }
	    else if (buttonModel.isPressed() && buttonModel.isArmed()) {
		backgroundColor =  MetalLookAndFeel.getPrimaryControlShadow();
		titleColor = MetalLookAndFeel.getPrimaryControlDarkShadow();
		titleHighlight = MetalLookAndFeel.getPrimaryControlInfo();
		edgeColor = MetalLookAndFeel.getPrimaryControlDarkShadow();
	    }

	    // Some calculations that are needed more than once later on.
	    int oneThird = (int)(iconSize / 3);
	    int halfSize = (int)(iconSize / 2);

	    g.translate(x, y);

	    // fill background
	    g.setColor(backgroundColor);
	    g.fillRect(0,0, iconSize,iconSize);
	    
	    // draw downRight highlight
	    g.setColor(downRightHighlight);
	    g.drawLine(1,iconSize-1, iconSize-1,iconSize-1);
	    g.drawLine(iconSize-1,1, iconSize-1,iconSize-1);
	    
	    // draw upLeft highlight
	    g.setColor(upLeftHighlight);
	    g.drawLine(0,0, 0,iconSize-2);
	    g.drawLine(0,0, iconSize-2,0);

	    // draw line around big edge of icon
	    g.setColor(edgeColor);
	    g.drawRect(1,1, iconSize-3,iconSize-3); // entire edge

	    // draw line around small edge of window icon
	    g.setColor(smallEdgeColor);
	    g.drawRect(1,oneThird, halfSize,halfSize);

	    // draw background color for title area
	    g.setColor(titleColor);
	    g.fillRect(2,oneThird+1, halfSize-1,halfSize-oneThird);

	    // draw highlight for title area
	    g.setColor(titleHighlight);
	    g.drawLine(2,halfSize+1, oneThird,halfSize+1);
	    g.drawLine(oneThird+1,halfSize, halfSize,halfSize);

	    g.translate(-x, -y);
	}
	
	public int getIconWidth() {
	    return iconSize;
	}
	
	public int getIconHeight() {
	    return iconSize;
	}
    }  // End class InternalFrameAltMaximizeIcon

    // Code for the default icons that goes in the upper left corner
    private static class InternalFrameDefaultMenuIcon implements Icon, UIResource, Serializable {
	Color backgroundColor, titleColor, edgeColor, slashColor;

        public void paintIcon(Component c, Graphics g, int x, int y) {
	    // still need to do the work for the inactive state

	    backgroundColor = MetalLookAndFeel.getWindowBackground();
	    titleColor = MetalLookAndFeel.getPrimaryControl();
	    edgeColor = MetalLookAndFeel.getPrimaryControlDarkShadow();

	    g.translate(x, y);

	    // fill background
	    g.setColor(backgroundColor);
	    g.fillRect(0,0, 16,16);
	    
	    // draw background color for title area
	    g.setColor(titleColor);
	    g.fillRect(2,2, 12,2);
	    g.drawLine(2,4, 10,4);
	    g.drawLine(2,5,  9,5);

	    // draw line around edge of title and icon
	    g.setColor(edgeColor);
	    g.drawRect(0,0, 15,15); // entire edge - pixel 1
	    g.drawRect(1,1, 13,13); // entire edge - pixel 2
	    g.drawLine( 2,6,  9,6);
	    g.drawLine(10,5, 10,5);
	    g.drawLine(11,4, 13,4);
	    //   draw dark part of two "bumps" (same color)
	    g.drawLine(4,4, 4,4);
	    g.drawLine(7,4, 7,4);

	    //    draw light parts of two "bumps"
	    g.setColor(backgroundColor);
	    g.drawLine(3,3, 3,3);
	    g.drawLine(6,3, 6,3);

	    g.translate(-x, -y);
	}
	
	public int getIconWidth() {
	    return 16;
	}
	
	public int getIconHeight() {
	    return 16;
	}
    }  // End class InternalFrameDefaultMenuIcon

    // Internal Frame Maximize code
    private static class InternalFrameMaximizeIcon implements Icon, UIResource, Serializable {
	protected JButton parentButton;
	protected ButtonModel buttonModel;
	protected Color backgroundColor, titleColor, titleHighlight, edgeColor;
	protected Color downRightHighlight, upLeftHighlight;
	protected int iconSize = 12;

        public InternalFrameMaximizeIcon(int size) {
	    iconSize = size;
	}

        public void paintIcon(Component c, Graphics g, int x, int y) {
	    parentButton = (JButton)c;
	    buttonModel = parentButton.getModel();

	    downRightHighlight = MetalLookAndFeel.getPrimaryControlHighlight();
	    upLeftHighlight = MetalLookAndFeel.getPrimaryControlShadow();
	    backgroundColor = MetalLookAndFeel.getPrimaryControl();
	    titleColor = MetalLookAndFeel.getPrimaryControlShadow();
	    titleHighlight = MetalLookAndFeel.getPrimaryControlDarkShadow();
	    edgeColor = MetalLookAndFeel.getPrimaryControlInfo();

	    if (parentButton.getClientProperty("paintActive")  != Boolean.TRUE) {
		downRightHighlight = MetalLookAndFeel.getControlHighlight();
		upLeftHighlight = MetalLookAndFeel.getControlShadow();
		backgroundColor = MetalLookAndFeel.getControl();
		titleColor = MetalLookAndFeel.getControlShadow();
		titleHighlight = MetalLookAndFeel.getControlDarkShadow();
	    }
	    else if (buttonModel.isPressed() && buttonModel.isArmed()) {
		backgroundColor =  MetalLookAndFeel.getPrimaryControlShadow();
		titleColor = MetalLookAndFeel.getPrimaryControlDarkShadow();
		titleHighlight = MetalLookAndFeel.getPrimaryControlInfo();
	    }

	    // Some calculations that are needed more than once later on.
	    int oneThird = (int)(iconSize / 3);
	    int twoThirds = (int)(iconSize * 2 / 3);
	    int halfSize = (int)(iconSize / 2);

	    g.translate(x, y);

	    // fill background
	    g.setColor(backgroundColor);
	    g.fillRect(0,0, iconSize,iconSize);
	    
	    // draw downRight highlight
	    g.setColor(downRightHighlight);
	    g.drawLine(1,iconSize-1, iconSize-1,iconSize-1);
	    g.drawLine(iconSize-1,1, iconSize-1,iconSize-1);
	    
	    // draw upLeft highlight
	    g.setColor(upLeftHighlight);
	    g.drawLine(0,0, 0,iconSize-2);
	    g.drawLine(0,0, iconSize-2,0);

	    // draw background color for title area
	    g.setColor(titleColor);
	    g.fillRect(2,2, iconSize-3,oneThird-2);

	    // draw line around edge of icon
	    g.setColor(edgeColor);
	    g.drawRect(1,1, iconSize-3,iconSize-3); // entire edge

	    // draw highlight for title area
	    g.setColor(titleHighlight);
	    g.drawLine(2,oneThird, halfSize,oneThird);
	    g.drawLine(halfSize+1,oneThird-1, iconSize-3,oneThird-1);

	    g.translate(-x, -y);
	}
	
	public int getIconWidth() {
	    return iconSize;
	}
	
	public int getIconHeight() {
	    return iconSize;
	}
    }  // End class InternalFrameMaximizeIcon

    // Internal Frame Minimize code
    private static class InternalFrameMinimizeIcon implements Icon, UIResource, Serializable {
	JButton parentButton;
	ButtonModel buttonModel;
	Color backgroundColor, titleColor, edgeColor, highlightColor;
	Color downRightHighlight, upLeftHighlight;
	int iconSize = 12;

        public InternalFrameMinimizeIcon(int size) {
	    iconSize = size;
	}

        public void paintIcon(Component c, Graphics g, int x, int y) {
	    parentButton = (JButton)c;
	    buttonModel = parentButton.getModel();

	    downRightHighlight = MetalLookAndFeel.getPrimaryControlHighlight();
	    upLeftHighlight = MetalLookAndFeel.getPrimaryControlShadow();
	    backgroundColor = MetalLookAndFeel.getPrimaryControl();
	    titleColor = MetalLookAndFeel.getPrimaryControlShadow();
	    edgeColor = MetalLookAndFeel.getPrimaryControlShadow();
	    highlightColor = MetalLookAndFeel.getPrimaryControlInfo();

	    if (parentButton.getClientProperty("paintActive")  != Boolean.TRUE) {
		downRightHighlight = MetalLookAndFeel.getControlHighlight();
		upLeftHighlight = MetalLookAndFeel.getControlShadow();
		backgroundColor = MetalLookAndFeel.getControl();
		titleColor = MetalLookAndFeel.getControlShadow();
		edgeColor = MetalLookAndFeel.getControlShadow();
	    }
	    else if (buttonModel.isPressed() && buttonModel.isArmed() ) {
		backgroundColor =  MetalLookAndFeel.getPrimaryControlShadow();
		titleColor = MetalLookAndFeel.getPrimaryControlDarkShadow();
		edgeColor = MetalLookAndFeel.getPrimaryControlInfo();
	    }

	    // Some calculations that are needed more than once later on.
	    int twoThirds = (int)(iconSize * 2 / 3);
	    int threeQuarters = (int)(iconSize * 3 / 4);

	    g.translate(x, y);

	    // fill background
	    g.setColor(backgroundColor);
	    g.fillRect(0,0, iconSize,iconSize);

	    // draw downRight highlight
	    g.setColor(downRightHighlight);
	    g.drawLine(1,iconSize-1, iconSize-1,iconSize-1);
	    g.drawLine(iconSize-1,1, iconSize-1,iconSize-1);
	    
	    // draw upLeft highlight
	    g.setColor(upLeftHighlight);
	    g.drawLine(0,0, 0,iconSize-2);
	    g.drawLine(0,0, iconSize-2,0);

	    // draw line around entire edge area
	    g.setColor(edgeColor);
	    g.drawRect(1,1, iconSize-3,iconSize-3);

	    // draw background of title area
	    g.setColor(titleColor);
	    g.fillRect(1,twoThirds, iconSize-3,iconSize-twoThirds-2);

	    // draw highlight for title area
	    g.setColor(highlightColor);
	    g.drawRect(1,twoThirds, iconSize-3,iconSize-twoThirds-2);

	    g.translate(-x, -y);
	}
	
	public int getIconWidth() {
	    return iconSize;
	}
	
	public int getIconHeight() {
	    return iconSize;
	}
    }  // End class InternalFrameMinimizeIcon

    // Radio button code
    private static class RadioButtonIcon implements Icon, UIResource, Serializable {
	JRadioButton rb;
	ButtonModel model;
	boolean drawDot;
	// only use on the RHS of equations
	Color background, shadow;
	// use in setColor();
	Color darkCircle, dotColor, interiorColor;
	Color whiteInnerLeftArc, whiteOuterRightArc;

        public void paintIcon(Component c, Graphics g, int x, int y) {
	    rb = (JRadioButton)c;
	    model = rb.getModel();
	    drawDot = model.isSelected();

	    background = c.getBackground();
	    dotColor = c.getForeground();
	    shadow = MetalLookAndFeel.getControlShadow();
	    darkCircle = MetalLookAndFeel.getControlDarkShadow();
	    whiteInnerLeftArc = MetalLookAndFeel.getControlHighlight();
	    whiteOuterRightArc = MetalLookAndFeel.getControlHighlight();
	    interiorColor = background;

	    // Set up colors per RadioButtonModel condition
	    if ( !model.isEnabled() ) {
		whiteInnerLeftArc = whiteOuterRightArc = background;
		darkCircle = dotColor = shadow;
	    }
	    else if (model.isPressed() && model.isArmed() ) {
		whiteInnerLeftArc = interiorColor = shadow;
	    }
	    
	    g.translate(x, y);

	    // fill interior
	    g.setColor(interiorColor);
	    g.fillRect(2,2, 9,9);
	   
	    // draw Dark Circle (start at top, go clockwise)
	    g.setColor(darkCircle);
	    g.drawLine( 4, 0,  7, 0);
	    g.drawLine( 8, 1,  9, 1);
	    g.drawLine(10, 2, 10, 3);
	    g.drawLine(11, 4, 11, 7);
	    g.drawLine(10, 8, 10, 9);
	    g.drawLine( 9,10,  8,10);
	    g.drawLine( 7,11,  4,11);
	    g.drawLine( 3,10,  2,10);
	    g.drawLine( 1, 9,  1, 8);
	    g.drawLine( 0, 7,  0, 4);
	    g.drawLine( 1, 3,  1, 2);
	    g.drawLine( 2, 1,  3, 1);

	    // draw Inner Left (usually) White Arc
	    //  start at lower left corner, go clockwise
	    g.setColor(whiteInnerLeftArc);
	    g.drawLine( 2, 9,  2, 8);
	    g.drawLine( 1, 7,  1, 4);
	    g.drawLine( 2, 2,  2, 3);
	    g.drawLine( 2, 2,  3, 2);
	    g.drawLine( 4, 1,  7, 1);
	    g.drawLine( 8, 2,  9, 2);
	    // draw Outer Right White Arc
	    //  start at upper right corner, go clockwise
	    g.setColor(whiteOuterRightArc);
	    g.drawLine(10, 1, 10, 1);
	    g.drawLine(11, 2, 11, 3);
	    g.drawLine(12, 4, 12, 7);
	    g.drawLine(11, 8, 11, 9);
	    g.drawLine(10,10, 10,10);
	    g.drawLine( 9,11,  8,11);
	    g.drawLine( 7,12,  4,12);
	    g.drawLine( 3,11,  2,11);

	    // selected dot
	    if ( drawDot ) {
		g.setColor(dotColor);
		g.fillRect( 4, 4,  4, 4);
		g.drawLine( 4, 3,  7, 3);
		g.drawLine( 8, 4,  8, 7);
		g.drawLine( 7, 8,  4, 8);
		g.drawLine( 3, 7,  3, 4);
	    }

	    g.translate(-x, -y);
	}
	
	public int getIconWidth() {
	    return 13;
	}
	
	public int getIconHeight() {
	    return 13;
	}
    }  // End class RadioButtonIcon

    // Tree Computer Icon code
    private static class TreeComputerIcon implements Icon, UIResource, Serializable {
        public void paintIcon(Component c, Graphics g, int x, int y) {
	    g.translate(x, y);

	    // Fill glass portion of monitor
	    g.setColor(MetalLookAndFeel.getPrimaryControl());
	    g.fillRect(5,4, 6,4);

	    // Draw outside edge of monitor
	    g.setColor(MetalLookAndFeel.getPrimaryControlInfo());
	    g.drawLine( 2,2,  2,8); // left
	    g.drawLine(13,2, 13,8); // right
	    g.drawLine( 3,1, 12,1); // top
	    g.drawLine(12,9, 12,9); // bottom right base
	    g.drawLine( 3,9,  3,9); // bottom left base
	    // Draw the edge of the glass
	    g.drawLine( 4,4,  4,7); // left
	    g.drawLine( 5,3, 10,3); // top
	    g.drawLine(11,4, 11,7); // right
	    g.drawLine( 5,8, 10,8); // bottom
	    // Draw the edge of the CPU
	    g.drawLine( 1,10, 14,10); // top
	    g.drawLine(14,10, 14,14); // right
	    g.drawLine( 1,14, 14,14); // bottom
	    g.drawLine( 1,10,  1,14); // left

	    // Draw the disk drives
	    g.setColor(MetalLookAndFeel.getControlDarkShadow());
	    g.drawLine( 6,12,  8,12); // left
	    g.drawLine(10,12, 12,12); // right

	    g.translate(-x, -y);
	}
	
	public int getIconWidth() {
	    return 16;
	}
	
	public int getIconHeight() {
	    return 16;
	}
    }  // End class TreeComputerIcon

    // Tree HardDrive Icon code
    private static class TreeHardDriveIcon implements Icon, UIResource, Serializable {
        public void paintIcon(Component c, Graphics g, int x, int y) {
	    g.translate(x, y);

	    // Draw edges of the disks
	    g.setColor(MetalLookAndFeel.getPrimaryControlInfo());
	    //     top disk
	    g.drawLine(1,4, 1,5); // left
	    g.drawLine(2,3, 3,3);
	    g.drawLine(4,2, 11,2); // top
	    g.drawLine(12,3, 13,3);
	    g.drawLine(14,4, 14,5); // right
	    g.drawLine(12,6, 13,6);
	    g.drawLine(4,7, 11,7); // bottom
	    g.drawLine(2,6, 3,6);
	    //     middle disk
	    g.drawLine(1,7, 1,8); // left
	    g.drawLine(2,9, 3,9);
	    g.drawLine(4,10, 11,10); // bottom
	    g.drawLine(12,9, 13,9);
	    g.drawLine(14,7, 14, 8); // right
	    //     bottom disk
	    g.drawLine(1,10, 1,11); // left
	    g.drawLine(2,12, 3,12);
	    g.drawLine(4,13, 11,13); // bottom
	    g.drawLine(12,12, 13,12);
	    g.drawLine(14,10, 14,11); // right

	    // Draw the down right shadows
	    g.setColor(MetalLookAndFeel.getControlShadow());
	    //     top disk
	    g.drawLine(7,6, 7,6);
	    g.drawLine(9,6, 9,6);
	    g.drawLine(10,5, 10,5);
	    g.drawLine(11,6, 11,6);
	    g.drawLine(12,5, 13,5);
	    g.drawLine(13,4, 13,4);
	    //     middle disk
	    g.drawLine(7,9, 7,9);
	    g.drawLine(9,9, 9,9);
	    g.drawLine(10,8, 10,8);
	    g.drawLine(11,9, 11,9);
	    g.drawLine(12,8, 13,8);
	    g.drawLine(13,7, 13,7);
	    //     bottom disk
	    g.drawLine(7,12, 7,12);
	    g.drawLine(9,12, 9,12);
	    g.drawLine(10,11, 10,11);
	    g.drawLine(11,12, 11,12);
	    g.drawLine(12,11, 13,11);
	    g.drawLine(13,10, 13,10);

	    // Draw the up left highlight
	    g.setColor(MetalLookAndFeel.getControlHighlight());
	    //     top disk
	    g.drawLine(4,3, 5,3);
	    g.drawLine(7,3, 9,3);
	    g.drawLine(11,3, 11,3);
	    g.drawLine(2,4, 6,4);
	    g.drawLine(8,4, 8,4);
	    g.drawLine(2,5, 3,5);
	    g.drawLine(4,6, 4,6);
	    //     middle disk
	    g.drawLine(2,7, 3,7);
	    g.drawLine(2,8, 3,8);
	    g.drawLine(4,9, 4,9);
	    //     bottom disk
	    g.drawLine(2,10, 3,10);
	    g.drawLine(2,11, 3,11);
	    g.drawLine(4,12, 4,12);

	    g.translate(-x, -y);
	}
	
	public int getIconWidth() {
	    return 16;
	}
	
	public int getIconHeight() {
	    return 16;
	}
    }  // End class TreeHardDriveIcon

    // Tree FloppyDrive Icon code
    private static class TreeFloppyDriveIcon implements Icon, UIResource, Serializable {
        public void paintIcon(Component c, Graphics g, int x, int y) {
	    g.translate(x, y);

	    // Fill body of floppy
	    g.setColor(MetalLookAndFeel.getPrimaryControl());
	    g.fillRect(2,2, 12,12);

	    // Draw outside edge of floppy
	    g.setColor(MetalLookAndFeel.getPrimaryControlInfo());
	    g.drawLine( 1, 1, 13, 1); // top
	    g.drawLine(14, 2, 14,14); // right
	    g.drawLine( 1,14, 14,14); // bottom
	    g.drawLine( 1, 1,  1,14); // left

	    // Draw grey-ish highlights
	    g.setColor(MetalLookAndFeel.getControlDarkShadow());
	    g.fillRect(5,2, 6,5); // metal disk protector part
	    g.drawLine(4,8, 11,8); // top of label
	    g.drawLine(3,9, 3,13); // left of label
	    g.drawLine(12,9, 12,13); // right of label

	    // Draw label and exposed disk
	    g.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
	    g.fillRect(8,3, 2,3); // exposed disk
	    g.fillRect(4,9, 8,5); // label

	    // Draw text on label
	    g.setColor(MetalLookAndFeel.getPrimaryControlShadow());
	    g.drawLine(5,10, 9,10);
	    g.drawLine(5,12, 8,12);

	    g.translate(-x, -y);
	}
	
	public int getIconWidth() {
	    return 16;
	}
	
	public int getIconHeight() {
	    return 16;
	}
    }  // End class TreeFloppyDriveIcon


    static private final Dimension folderIcon16Size = new Dimension( 16, 16 );

    /**
     * <p>
     * Warning: serialized objects of this class will not be compatible with
     * future swing releases.  The current serialization support is appropriate
     * for short term storage or RMI between Swing1.0 applications.  It will
     * not be possible to load serialized Swing1.0 objects with future releases
     * of Swing.  The JDK1.2 release of Swing will be the compatibility
     * baseline for the serialized form of Swing objects.
     */
    public static class FolderIcon16 implements Icon, Serializable {
	public void paintIcon(Component c, Graphics g, int x, int y) {
	    g.translate( x, y + getShift() );

	    int right = folderIcon16Size.width - 1;
	    int bottom = folderIcon16Size.height - 1;

	    // Draw tab top
	    g.setColor( MetalLookAndFeel.getPrimaryControlDarkShadow() );
	    g.drawLine( right - 5, 3, right, 3 );
	    g.drawLine( right - 6, 4, right, 4 );

	    // Draw folder front
	    g.setColor( MetalLookAndFeel.getPrimaryControl() );
	    g.fillRect( 2, 7, 13, 8 );

	    // Draw tab bottom
	    g.setColor( MetalLookAndFeel.getPrimaryControlShadow() );
	    g.drawLine( right - 6, 5, right - 1, 5 );

	    // Draw outline
	    g.setColor( MetalLookAndFeel.getPrimaryControlInfo() );
	    g.drawLine( 0, 6, 0, bottom );            // left side
	    g.drawLine( 1, 5, right - 7, 5 );         // first part of top
	    g.drawLine( right - 6, 6, right - 1, 6 ); // second part of top
	    g.drawLine( right, 5, right, bottom );    // right side
	    g.drawLine( 0, bottom, right, bottom );   // bottom

	    // Draw highlight
	    g.setColor( MetalLookAndFeel.getPrimaryControlHighlight() );
	    g.drawLine( 1, 6, 1, bottom - 1 );
	    g.drawLine( 1, 6, right - 7, 6 );
	    g.drawLine( right - 6, 7, right - 1, 7 );

	    g.translate( -x, -(y + getShift()) );
	}

        public int getShift() { return 0; }
        public int getAdditionalHeight() { return 0; }

	public int getIconWidth() { return folderIcon16Size.width; }
	public int getIconHeight() { return folderIcon16Size.height + getAdditionalHeight(); }
    }

  
    /**
     * <p>
     * Warning: serialized objects of this class will not be compatible with
     * future swing releases.  The current serialization support is appropriate
     * for short term storage or RMI between Swing1.0 applications.  It will
     * not be possible to load serialized Swing1.0 objects with future releases
     * of Swing.  The JDK1.2 release of Swing will be the compatibility
     * baseline for the serialized form of Swing objects.
     */
    public static class TreeFolderIcon extends FolderIcon16 {
        public int getShift() { return -1; }
        public int getAdditionalHeight() { return 2; }
    }


    static private final Dimension fileIcon16Size = new Dimension( 16, 16 );

    /**
     * <p>
     * Warning: serialized objects of this class will not be compatible with
     * future swing releases.  The current serialization support is appropriate
     * for short term storage or RMI between Swing1.0 applications.  It will
     * not be possible to load serialized Swing1.0 objects with future releases
     * of Swing.  The JDK1.2 release of Swing will be the compatibility
     * baseline for the serialized form of Swing objects.
     */
    public static class FileIcon16 implements Icon, Serializable {
	public void paintIcon(Component c, Graphics g, int x, int y) {
	    g.translate( x, y + getShift() );

	    int right = fileIcon16Size.width - 1;
	    int bottom = fileIcon16Size.height - 1;

	    // Draw fill
	    g.setColor( MetalLookAndFeel.getWindowBackground() );
	    g.fillRect( 4, 2, 9, 12 );

	    // Draw frame
	    g.setColor( MetalLookAndFeel.getPrimaryControlInfo() );
	    g.drawLine( 2, 0, 2, bottom );                 // left
	    g.drawLine( 2, 0, right - 4, 0 );              // top
	    g.drawLine( 2, bottom, right - 1, bottom );    // bottom
	    g.drawLine( right - 1, 6, right - 1, bottom ); // right
	    g.drawLine( right - 6, 2, right - 2, 6 );      // slant 1
	    g.drawLine( right - 5, 1, right - 4, 1 );      // part of slant 2
	    g.drawLine( right - 3, 2, right - 3, 3 );      // part of slant 2
	    g.drawLine( right - 2, 4, right - 2, 5 );      // part of slant 2

	    // Draw highlight
	    g.setColor( MetalLookAndFeel.getPrimaryControl() );
	    g.drawLine( 3, 1, 3, bottom - 1 );                  // left
	    g.drawLine( 3, 1, right - 6, 1 );                   // top
	    g.drawLine( right - 2, 7, right - 2, bottom - 1 );  // right
	    g.drawLine( right - 5, 2, right - 3, 4 );           // slant
	    g.drawLine( 3, bottom - 1, right - 2, bottom - 1 ); // bottom

	    g.translate( -x, -(y + getShift()) );
	}

        public int getShift() { return 0; }
        public int getAdditionalHeight() { return 0; }

	public int getIconWidth() { return fileIcon16Size.width; }
	public int getIconHeight() { return fileIcon16Size.height + getAdditionalHeight(); }
    }


    public static class TreeLeafIcon extends FileIcon16 {
        public int getShift() { return 2; }
        public int getAdditionalHeight() { return 4; }
    }


    static private final Dimension treeControlSize = new Dimension( 8, 8 );

    /**
     * <p>
     * Warning: serialized objects of this class will not be compatible with
     * future swing releases.  The current serialization support is appropriate
     * for short term storage or RMI between Swing1.0 applications.  It will
     * not be possible to load serialized Swing1.0 objects with future releases
     * of Swing.  The JDK1.2 release of Swing will be the compatibility
     * baseline for the serialized form of Swing objects.
     */
    public static class TreeControlIcon implements Icon, Serializable {
        protected boolean isLight;

        public TreeControlIcon( boolean isLight ) {
	    this.isLight = isLight;
	}

	public void paintIcon(Component c, Graphics g, int x, int y) {
	    g.translate( x, y );

	    // Draw background
	    g.setColor( isLight ? MetalLookAndFeel.getPrimaryControl() :
			          MetalLookAndFeel.getPrimaryControlDarkShadow() );
	    g.fillRect( 1, 1, 6, 6 );

	    // Draw circle
	    g.setColor( MetalLookAndFeel.getPrimaryControlInfo() );
	    g.drawLine( 0, 2, 0, 5 );     // left
	    g.drawLine( 1, 1, 1, 1 );     // top left dot
	    g.drawLine( 2, 0, 5, 0 );     // top
	    g.drawLine( 6, 1, 6, 1 );     // top right dot
	    g.drawLine( 7, 2, 7, 5 );     // right
	    g.drawLine( 6, 6, 6, 6 );     // botom right dot
	    g.drawLine( 2, 7, 5, 7 );     // bottom
	    g.drawLine( 1, 6, 1, 6 );     // bottom left dot

	    // Draw highlight
	    g.setColor( isLight ? MetalLookAndFeel.getPrimaryControlHighlight() :
			          MetalLookAndFeel.getPrimaryControlShadow() );
	    g.drawLine( 1, 2, 1, 5 );     // left
	    g.drawLine( 2, 1, 5, 1 );     // top

	    g.translate( -x, -y );
	}

	public int getIconWidth() { return treeControlSize.width; }
	public int getIconHeight() { return treeControlSize.height; }
    }

  //
  // Menu Icons
  //

    static private final Dimension menuArrowIconSize = new Dimension( 4, 8 );
    static private final Dimension menuCheckIconSize = new Dimension( 12, 10 );
    static private final int xOff = 4;

    private static class MenuArrowIcon implements Icon, UIResource, Serializable
    {
	public void paintIcon( Component c, Graphics g, int x, int y )
	{
	    JMenuItem b = (JMenuItem) c;
	    ButtonModel model = b.getModel();

	    g.translate( x, y );

	    if ( !model.isEnabled() )
	    {
	        g.setColor( MetalLookAndFeel.getMenuDisabledForeground() );
	    }
	    else
	    {
	        if ( model.isArmed() || ( c instanceof JMenu && model.isSelected() ) )
		{
		    g.setColor( MetalLookAndFeel.getMenuSelectedForeground() );
		}
		else
		{
		    g.setColor( b.getForeground() );
		}
	    }

	    g.drawLine( 0, 0, 0, 7 );
	    g.drawLine( 1, 1, 1, 6 );
	    g.drawLine( 2, 2, 2, 5 );
	    g.drawLine( 3, 3, 3, 4 );

	    g.translate( -x, -y );
	}

	public int getIconWidth() { return menuArrowIconSize.width; }

	public int getIconHeight() { return menuArrowIconSize.height; }

    } // End class MenuArrowIcon

    private static class MenuItemCheckIcon implements Icon, UIResource, Serializable
    {
	public void paintIcon( Component c, Graphics g, int x, int y )
	{
	}

	public int getIconWidth() { return menuCheckIconSize.width; }

	public int getIconHeight() { return menuCheckIconSize.height; }

    } // End class MenuItemCheckIcon

    private static class MenuItemArrowIcon implements Icon, UIResource, Serializable
    {
	public void paintIcon( Component c, Graphics g, int x, int y )
	{
	}

	public int getIconWidth() { return menuArrowIconSize.width; }

	public int getIconHeight() { return menuArrowIconSize.height; }

    } // End class MenuItemArrowIcon

    private static class CheckBoxMenuItemIcon implements Icon, UIResource, Serializable
    {
	public void paintIcon( Component c, Graphics g, int x, int y )
	{
	    JMenuItem b = (JMenuItem) c;
	    ButtonModel model = b.getModel();

	    boolean isSelected = model.isSelected();
	    boolean isEnabled = model.isEnabled();
	    boolean isPressed = model.isPressed();
	    boolean isArmed = model.isArmed();
	    
	    g.translate( x + xOff, y );

	    if ( isEnabled )
	    {
	        if ( isPressed || isArmed )
		{
		    g.setColor( MetalLookAndFeel.getControlInfo()  );
		    g.drawLine( 0, 0, 8, 0 );
		    g.drawLine( 0, 0, 0, 8 );
		    g.drawLine( 8, 2, 8, 8 );
		    g.drawLine( 2, 8, 8, 8 );

		    g.setColor( MetalLookAndFeel.getPrimaryControl()  );
		    g.drawLine( 1, 1, 7, 1 );
		    g.drawLine( 1, 1, 1, 7 );
		    g.drawLine( 9, 1, 9, 9 );
		    g.drawLine( 1, 9, 9, 9 );
		}
		else
		{
		    g.setColor( MetalLookAndFeel.getControlDarkShadow()  );
		    g.drawLine( 0, 0, 8, 0 );
		    g.drawLine( 0, 0, 0, 8 );
		    g.drawLine( 8, 2, 8, 8 );
		    g.drawLine( 2, 8, 8, 8 );

		    g.setColor( MetalLookAndFeel.getControlHighlight()  );
		    g.drawLine( 1, 1, 7, 1 );
		    g.drawLine( 1, 1, 1, 7 );
		    g.drawLine( 9, 1, 9, 9 );
		    g.drawLine( 1, 9, 9, 9 );
		}
	    }
	    else
	    {
	        g.setColor( MetalLookAndFeel.getMenuDisabledForeground()  );
		g.drawRect( 0, 0, 8, 8 );
	    }

	    if ( isSelected )
	    {
	        if ( isEnabled )
		{
		    if ( model.isArmed() || ( c instanceof JMenu && model.isSelected() ) )
		    {
		        g.setColor( MetalLookAndFeel.getMenuSelectedForeground() );
		    }
		    else
		    {
		        g.setColor( b.getForeground() );
		    }
		}
		else
		{
		    g.setColor( MetalLookAndFeel.getMenuDisabledForeground()  );
		}

		g.drawLine( 2, 2, 2, 6 );
		g.drawLine( 3, 2, 3, 6 );
		g.drawLine( 4, 4, 8, 0 );
		g.drawLine( 4, 5, 9, 0 );
	    }

	    g.translate( -(x + xOff), -y );
	}

	public int getIconWidth() { return menuCheckIconSize.width; }

	public int getIconHeight() { return menuCheckIconSize.height; }

    }  // End class CheckBoxMenuItemIcon

    private static class RadioButtonMenuItemIcon implements Icon, UIResource, Serializable
    {
	public void paintIcon( Component c, Graphics g, int x, int y )
	{
	    JMenuItem b = (JMenuItem) c;
	    ButtonModel model = b.getModel();

	    boolean isSelected = model.isSelected();
	    boolean isEnabled = model.isEnabled();
	    boolean isPressed = model.isPressed();
	    boolean isArmed = model.isArmed();
	    
	    g.translate( x + xOff, y );

	    if ( isEnabled )
	    {
	        if ( isPressed || isArmed )
		{
		    g.setColor( MetalLookAndFeel.getPrimaryControl()  );
		    g.drawLine( 3, 1, 8, 1 );
		    g.drawLine( 2, 9, 7, 9 );
		    g.drawLine( 1, 3, 1, 8 );
		    g.drawLine( 9, 2, 9, 7 );
		    g.drawLine( 2, 2, 2, 2 );
		    g.drawLine( 8, 8, 8, 8 );

		    g.setColor( MetalLookAndFeel.getControlInfo()  );
		    g.drawLine( 2, 0, 6, 0 );
		    g.drawLine( 2, 8, 6, 8 );
		    g.drawLine( 0, 2, 0, 6 );
		    g.drawLine( 8, 2, 8, 6 );
		    g.drawLine( 1, 1, 1, 1 );
		    g.drawLine( 7, 1, 7, 1 );
		    g.drawLine( 1, 7, 1, 7 );
		    g.drawLine( 7, 7, 7, 7 );
		}
		else
		{
		    g.setColor( MetalLookAndFeel.getControlHighlight()  );
		    g.drawLine( 3, 1, 8, 1 );
		    g.drawLine( 2, 9, 7, 9 );
		    g.drawLine( 1, 3, 1, 8 );
		    g.drawLine( 9, 2, 9, 7 );
		    g.drawLine( 2, 2, 2, 2 );
		    g.drawLine( 8, 8, 8, 8 );

		    g.setColor( MetalLookAndFeel.getControlDarkShadow()  );
		    g.drawLine( 2, 0, 6, 0 );
		    g.drawLine( 2, 8, 6, 8 );
		    g.drawLine( 0, 2, 0, 6 );
		    g.drawLine( 8, 2, 8, 6 );
		    g.drawLine( 1, 1, 1, 1 );
		    g.drawLine( 7, 1, 7, 1 );
		    g.drawLine( 1, 7, 1, 7 );
		    g.drawLine( 7, 7, 7, 7 );
		}
	    }
	    else
	    {
	        g.setColor( MetalLookAndFeel.getMenuDisabledForeground()  );
		g.drawLine( 2, 0, 6, 0 );
		g.drawLine( 2, 8, 6, 8 );
		g.drawLine( 0, 2, 0, 6 );
		g.drawLine( 8, 2, 8, 6 );
		g.drawLine( 1, 1, 1, 1 );
		g.drawLine( 7, 1, 7, 1 );
		g.drawLine( 1, 7, 1, 7 );
		g.drawLine( 7, 7, 7, 7 );
	    }

	    if ( isSelected )
	    {
	        if ( isEnabled )
		{
		    if ( model.isArmed() || ( c instanceof JMenu && model.isSelected() ) )
		    {
		        g.setColor( MetalLookAndFeel.getMenuSelectedForeground() );
		    }
		    else
		    {
		        g.setColor( b.getForeground() );
		    }
		}
		else
		{
		    g.setColor( MetalLookAndFeel.getMenuDisabledForeground()  );
		}

		g.drawLine( 3, 2, 5, 2 );
		g.drawLine( 2, 3, 6, 3 );
		g.drawLine( 2, 4, 6, 4 );
		g.drawLine( 2, 5, 6, 5 );
		g.drawLine( 3, 6, 5, 6 );
	    }

	    g.translate( -(x + xOff), -y );
	}

	public int getIconWidth() { return menuCheckIconSize.width; }

	public int getIconHeight() { return menuCheckIconSize.height; }

    }  // End class RadioButtonMenuItemIcon

private static class VerticalSliderThumbIcon implements Icon, Serializable, UIResource {
    protected static MetalBumps bumps;

    public VerticalSliderThumbIcon() {
        bumps = new MetalBumps( 6, 10,
				MetalLookAndFeel.getPrimaryControl(),
				MetalLookAndFeel.getPrimaryControlDarkShadow(),
				MetalLookAndFeel.getPrimaryControlShadow() );   
    } 

    public void paintIcon( Component c, Graphics g, int x, int y ) {
        JSlider slider = (JSlider)c;

        g.translate( x, y );

	// Draw the frame
	g.setColor( slider.isEnabled() ? MetalLookAndFeel.getPrimaryControlInfo() :
		                         MetalLookAndFeel.getControlDarkShadow() );
	g.drawLine(  1,0  ,  8,0 );  // top
	g.drawLine(  0,1  ,  0,13 ); // left
	g.drawLine(  1,14 ,  8,14 ); // bottom
	g.drawLine(  9,1  , 15,7  ); // top slant
	g.drawLine(  9,13 , 15,7  ); // bottom slant

	// Fill in the background
	g.setColor( slider.isEnabled() ? c.getForeground() : MetalLookAndFeel.getControlShadow() );
	g.fillRect( 1,1, 8, 13 );

	g.drawLine(  9,2 ,  9,12 );
	g.drawLine( 10,3 , 10,11 );
	g.drawLine( 11,4 , 11,10 );
	g.drawLine( 12,5 , 12,9 );
	g.drawLine( 13,6 , 13,8 );
	g.drawLine( 14,7 , 14,7 );

	// Draw the bumps
	if ( slider.isEnabled() ) {
	    bumps.paintIcon( c, g, 3, 3 );
	}

        g.translate( -x, -y );
    }

    public int getIconWidth() {
        return 16;
    }

    public int getIconHeight() {
        return 15;
    }
}

private static class HorizontalSliderThumbIcon implements Icon, Serializable, UIResource {
    protected static MetalBumps bumps;

    public HorizontalSliderThumbIcon() {
        bumps = new MetalBumps( 10, 6,
				MetalLookAndFeel.getPrimaryControl(),
				MetalLookAndFeel.getPrimaryControlDarkShadow(),
				MetalLookAndFeel.getPrimaryControlShadow() );        
    }

    public void paintIcon( Component c, Graphics g, int x, int y ) {
        JSlider slider = (JSlider)c;

        g.translate( x, y );
	
	// Draw the frame
	g.setColor( slider.isEnabled() ? MetalLookAndFeel.getPrimaryControlInfo() :
		                         MetalLookAndFeel.getControlDarkShadow() );
	g.drawLine(  1,0  , 13,0 );  // top
	g.drawLine(  0,1  ,  0,8 );  // left
	g.drawLine( 14,1  , 14,8 );  // right
	g.drawLine(  1,9  ,  7,15 ); // left slant
	g.drawLine(  7,15 , 14,8 );  // right slant

	// Fill in the background
	g.setColor( slider.isEnabled() ? c.getForeground() : MetalLookAndFeel.getControlShadow() );
	g.fillRect( 1,1, 13, 8 );

	g.drawLine( 2,9  , 12,9 );
	g.drawLine( 3,10 , 11,10 );
	g.drawLine( 4,11 , 10,11 );
	g.drawLine( 5,12 ,  9,12 );
	g.drawLine( 6,13 ,  8,13 );
	g.drawLine( 7,14 ,  7,14 );

	// Draw the bumps
	if ( slider.isEnabled() ) {
	    bumps.paintIcon( c, g, 3, 3 );
	}

        g.translate( -x, -y );
    }

    public int getIconWidth() {
        return 15;
    }

    public int getIconHeight() {
        return 16;
    }
}

}
