/*
 * @(#)MetalFileChooserUI.java	1.1 98/04/14
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.metal;

import com.sun.java.swing.*;
import com.sun.java.swing.preview.*;
import com.sun.java.swing.preview.filechooser.*;
import com.sun.java.swing.event.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.plaf.basic.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.File;
import java.io.IOException;
import java.util.*;

/**
 * Temporary Metal L&F implementation of a FileChooser.  
 *
 * @version 1.1 04/14/98
 * @author Jeff Dinkins
 */
public class MetalFileChooserUI extends BasicFileChooserUI {
    // These are all private because we don't want to lock the internal
    // implementation down. If you really need to subtype MetalFileChooser,
    // copy the source and modify the copy.
    private JPanel centerPanel;

    private JComboBox directoryComboBox;	
    private DirectoryComboBoxModel directoryComboBoxModel;	
    private Action directoryComboBoxAction = new DirectoryComboBoxAction();

    private FilterComboBoxModel filterComboBoxModel;

    private JTextField filenameTextField;

    private JList list;

    private JButton approveButton;
    private JButton cancelButton;

    private JComboBox filterComboBox;

    private JPanel bodyPanel = null;

    private static final Dimension hstrut10 = new Dimension(10, 1);
    private static final Dimension hstrut25 = new Dimension(25, 1);
    private static final Dimension vstrut10 = new Dimension(1, 10);
    private static final Insets shrinkwrap = new Insets(0,0,0,0);

    private static int PREF_WIDTH = 500;
    private static int PREF_HEIGHT = 300;
    private static Dimension PREF_SIZE = new Dimension(PREF_WIDTH, PREF_HEIGHT);

    private static int MIN_WIDTH = 400;
    private static int MIN_HEIGHT = 200;
    private static Dimension MIN_SIZE = new Dimension(MIN_WIDTH, MIN_HEIGHT);

    private static int LIST_MIN_WIDTH = 400;
    private static int LIST_MIN_HEIGHT = 100;
    private static Dimension LIST_MIN_SIZE = new Dimension(LIST_MIN_WIDTH, LIST_MIN_HEIGHT);

    //
    // ComponentUI Interface Implementation methods
    //
    public static ComponentUI createUI(JComponent c) {
        return new MetalFileChooserUI((JFileChooser)c);
    }

    public MetalFileChooserUI(JFileChooser filechooser) {
	super(filechooser);
    }
            
    public void installUI(JComponent c) {
	super.installUI(c);
    }

    public void installComponents() {
	// set to a Y BoxLayout. The chooser will be layed out top to bottom.
	getFileChooser().setLayout(new BoxLayout(getFileChooser(), BoxLayout.Y_AXIS));
	getFileChooser().add(Box.createRigidArea(vstrut10));
	
	// ********************************* //
	// **** Construct the top panel **** //
	// ********************************* //

	// Directory manipulation buttons
	JPanel topPanel = new JPanel();
	topPanel.setLayout(new BoxLayout(topPanel, BoxLayout.X_AXIS));

	// Add the top panel to the fileChooser
	getFileChooser().add(topPanel);
	getFileChooser().add(Box.createRigidArea(vstrut10));
	
	// ComboBox Label
	JLabel l = new JLabel("Look in:");
	l.setAlignmentX(JComponent.LEFT_ALIGNMENT);
	l.setAlignmentY(JComponent.CENTER_ALIGNMENT);
	topPanel.add(Box.createRigidArea(hstrut10));
	topPanel.add(l);
	topPanel.add(Box.createRigidArea(hstrut25));
	
	// CurrentDir ComboBox
	directoryComboBox = new JComboBox();
	directoryComboBoxModel = createDirectoryComboBoxModel();
	directoryComboBox.setModel(directoryComboBoxModel);
	directoryComboBox.addActionListener(directoryComboBoxAction);
	directoryComboBox.setRenderer(createDirectoryComboBoxRenderer());
	directoryComboBox.setAlignmentX(JComponent.LEFT_ALIGNMENT);
	directoryComboBox.setAlignmentY(JComponent.CENTER_ALIGNMENT);

	topPanel.add(directoryComboBox);
	topPanel.add(Box.createRigidArea(hstrut10));
	
	// Up Button
	JButton b = new JButton(upFolderIcon);
	b.setToolTipText("Up One Level");
	b.setAlignmentX(JComponent.LEFT_ALIGNMENT);
	b.setAlignmentY(JComponent.CENTER_ALIGNMENT);
	b.setMargin(shrinkwrap);
	b.setFocusPainted(false);
	b.addActionListener(getChangeToParentDirectoryAction());
	topPanel.add(b);
	topPanel.add(Box.createRigidArea(hstrut10));
	
	// Home Button
	b = new JButton(homeFolderIcon);
	b.setToolTipText("Home");
	b.setAlignmentX(JComponent.LEFT_ALIGNMENT);
	b.setAlignmentY(JComponent.CENTER_ALIGNMENT);
	b.setMargin(shrinkwrap);
	b.setFocusPainted(false);
	b.addActionListener(getGoHomeAction());
	topPanel.add(b);
	topPanel.add(Box.createRigidArea(hstrut10));
	
	// New Directory Button
	b = new JButton(newFolderIcon);
	b.setToolTipText("Create New Folder");
	b.setAlignmentX(JComponent.LEFT_ALIGNMENT);
	b.setAlignmentY(JComponent.CENTER_ALIGNMENT);
	b.setMargin(shrinkwrap);
	b.setFocusPainted(false);
	b.addActionListener(getNewFolderAction());
	topPanel.add(b);
	topPanel.add(Box.createRigidArea(hstrut10));
	
	// List Button
	JToggleButton tb = new JToggleButton(listViewIcon);
	tb.setToolTipText("List");
	tb.setEnabled(false);
	tb.setFocusPainted(false);
	tb.setAlignmentX(JComponent.LEFT_ALIGNMENT);
	tb.setAlignmentY(JComponent.CENTER_ALIGNMENT);
	tb.setMargin(shrinkwrap);
	topPanel.add(tb);
	
	// Details Button
	tb = new JToggleButton(detailsViewIcon);
	tb.setToolTipText("Details");
	tb.setFocusPainted(false);
	tb.setSelected(true);
	tb.setEnabled(false);
	tb.setAlignmentX(JComponent.LEFT_ALIGNMENT);
	tb.setAlignmentY(JComponent.CENTER_ALIGNMENT);
	tb.setMargin(shrinkwrap);
	topPanel.add(tb);
	topPanel.add(Box.createRigidArea(hstrut10));

	// ************************************** //
	// ******* Add the directory pane ******* //
	// ************************************** //
	centerPanel = new JPanel(new BorderLayout());
	JPanel p = createList();
	p.setMinimumSize(LIST_MIN_SIZE);
	centerPanel.add(p, BorderLayout.CENTER);
	centerPanel.add(getAccessoryPanel(), BorderLayout.EAST);
	JComponent accessory = getFileChooser().getAccessory();
	if(accessory != null) {
	    getAccessoryPanel().add(accessory);
	}
	getFileChooser().add(centerPanel);

	// ********************************** //
	// **** Construct the bottom panel ** //
	// ********************************** //
	JPanel bottomPanel = new JPanel();
	bottomPanel.setLayout(new BoxLayout(bottomPanel, BoxLayout.X_AXIS));
	bottomPanel.add(Box.createRigidArea(hstrut10));

	// Add the bottom panel to file chooser
	getFileChooser().add(Box.createRigidArea(vstrut10));
	getFileChooser().add(bottomPanel);
	getFileChooser().add(Box.createRigidArea(vstrut10));
	
	// labels
	JPanel labelPanel = new JPanel();
	labelPanel.setLayout(new BoxLayout(labelPanel, BoxLayout.Y_AXIS));

	l = new JLabel("File name:");
	labelPanel.add(l);

	labelPanel.add(Box.createRigidArea(vstrut10));

	l = new JLabel("Files of type:");
	labelPanel.add(l);

	bottomPanel.add(labelPanel);
	bottomPanel.add(Box.createRigidArea(hstrut25));

	// file entry and filters
	JPanel fileAndFilterPanel = new JPanel();
	fileAndFilterPanel.setLayout(new BoxLayout(fileAndFilterPanel, BoxLayout.Y_AXIS));

	filenameTextField = new JTextField();
	filenameTextField.addActionListener(getApproveSelectionAction());
	File f = getFileChooser().getSelectedFile();
	if(f != null) {
	    setFileName(getFileChooser().getName(f));
	}

	fileAndFilterPanel.add(filenameTextField);
	
	fileAndFilterPanel.add(Box.createRigidArea(vstrut10));

	filterComboBoxModel = createFilterComboBoxModel();
	getFileChooser().addPropertyChangeListener(filterComboBoxModel);
	filterComboBox = new JComboBox(filterComboBoxModel);
	filterComboBox.setRenderer(createFilterComboBoxRenderer());
	fileAndFilterPanel.add(filterComboBox);

	bottomPanel.add(fileAndFilterPanel);
	bottomPanel.add(Box.createRigidArea(hstrut10));

	// buttons
	JPanel buttonPanel = new JPanel();
	buttonPanel.setLayout(new BoxLayout(buttonPanel, BoxLayout.Y_AXIS));
	
	approveButton = new JButton(getApproveButtonText()) {
	    public Dimension getMaximumSize() {
		return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
	    }
	};
	approveButton.addActionListener(getApproveSelectionAction());
	approveButton.setToolTipText(getApproveButtonToolTipText());
	buttonPanel.add(approveButton);
	buttonPanel.add(Box.createRigidArea(vstrut10));

	cancelButton = new JButton(cancelButtonText) {
	    public Dimension getMaximumSize() {
		return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
	    }
	};
	cancelButton.setToolTipText(cancelButtonToolTipText);
	cancelButton.addActionListener(getCancelSelectionAction());
	buttonPanel.add(cancelButton);

	bottomPanel.add(buttonPanel);
	bottomPanel.add(Box.createRigidArea(hstrut10));
    }

    protected JPanel createList() {
	JPanel p = new JPanel(new BorderLayout());
	list = new JList();
	// PENDING(jeff) - get this color from BasicLookAndFeel
	// list.setBackground(Color.white);
	list.setCellRenderer(new FileRenderer());
	list.setModel(model);
	list.addListSelectionListener(createListSelectionListener());
	list.addMouseListener(createDoubleClickListener(list));
	JScrollPane scrollpane = new JScrollPane(list);
	scrollpane.setBorder(BorderFactory.createLoweredBevelBorder());
	p.add(scrollpane, BorderLayout.CENTER);
	return p;
    }

    protected class FileRenderer extends BasicListCellRenderer  {

	public Component getListCellRendererComponent(JList list, Object value,
						      int index, boolean isSelected, 
						      boolean cellHasFocus) {

	    super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
	    File file = (File) value; 
	    String fileName = getFileChooser().getName(file);
	    setText(fileName);

	    Icon icon = getFileChooser().getIcon(file);
	    setIcon(icon);

	    return this;
	}
    }


    public void uninstallUI(JComponent c) {
	// Remove listeners
	getFileChooser().removePropertyChangeListener(filterComboBoxModel);
	cancelButton.removeActionListener(getCancelSelectionAction());
	approveButton.removeActionListener(getApproveSelectionAction());
	filenameTextField.removeActionListener(getApproveSelectionAction());

	super.uninstallUI(c);
    }

    public Dimension getPreferredSize(JComponent x) {
	return PREF_SIZE;
    }
    
    public Dimension getMinimumSize(JComponent x) {
	return MIN_SIZE;
    }
    
    public Dimension getMaximumSize(JComponent x) {
	return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }
    
    /*
     * Listen for filechooser property changes, such as
     * the selected file changing, or the type of the dialog changing.
     */
    public void propertyChange(PropertyChangeEvent e) {
	String prop = e.getPropertyName();
	if(prop.equals(JFileChooser.SELECTED_FILE_CHANGED_PROPERTY)) {
	    File f = (File) e.getNewValue();
	    if(f != null) {
		setFileName(getFileChooser().getName(f));
		if(model.contains(f)) {
		    list.setSelectedIndex(model.indexOf(e.getNewValue()));
		    list.ensureIndexIsVisible(list.getSelectedIndex());
		}
	    }
	} else if(prop.equals(JFileChooser.DIRECTORY_CHANGED_PROPERTY)) {
	    fileView.clearIconCache();
	    list.clearSelection();
	    File currentDirectory = getFileChooser().getCurrentDirectory();
	    if(currentDirectory != null) {
		directoryComboBoxModel.addItem(currentDirectory);
		// Enable the newFolder action if the current directory
		// is writable.
		// PENDING(jeff) - broken - fix
		getNewFolderAction().setEnabled(currentDirectory.canWrite());
	    }
	} else if(prop.equals(JFileChooser.FILE_SELECTION_MODE_CHANGED_PROPERTY)) {
	    fileView.clearIconCache();
	    list.clearSelection();
	} else if(prop == JFileChooser.ACCESSORY_CHANGED_PROPERTY) {
	    if(accessoryPanel != null) {
		if(e.getOldValue() != null) {
		    getAccessoryPanel().remove((JComponent) e.getOldValue());
		}
		JComponent accessory = (JComponent) e.getNewValue();
		if(accessory != null) {
		    getAccessoryPanel().add(accessory, BorderLayout.CENTER);
		}
	    }
	} else if(prop == JFileChooser.APPROVE_BUTTON_TEXT_CHANGED_PROPERTY ||
	   prop == JFileChooser.DIALOG_TYPE_CHANGED_PROPERTY) {
	    approveButton.setText(getApproveButtonText());
	    approveButton.setToolTipText(getApproveButtonToolTipText());
	}
    }

    public void ensureFileIsVisible(File f) {
	if(model.contains(f)) {
	    list.setSelectedIndex(model.indexOf(f));
	    list.ensureIndexIsVisible(list.getSelectedIndex());
	}
    }

    public void rescanCurrentDirectory() {
	model.invalidateFileCache();
	model.validateFileCache();
    }

    public String getFileName() {
	if(filenameTextField != null) {
	    return filenameTextField.getText();
	} else {
	    return null;
	}
    }

    public void setFileName(String filename) {
	if(filenameTextField != null) {
	    filenameTextField.setText(filename);
	}
    }

    public String getDirectoryName() {
	// PENDING(jeff) - get the name from the directory combobox
	return null;
    }

    public void setDirectoryName(String dirname) {
	// PENDING(jeff) - set the name in the directory combobox
    }

    protected DirectoryComboBoxRenderer createDirectoryComboBoxRenderer() {
	return new DirectoryComboBoxRenderer();
    }

    //
    // Renderer for DirectoryComboBox
    //
    class DirectoryComboBoxRenderer extends BasicListCellRenderer  {
	public Component getListCellRendererComponent(JList list, Object value,
						      int index, boolean isSelected, 
						      boolean cellHasFocus) {

	    super.getListCellRendererComponent(list, value, index,
					       isSelected, cellHasFocus);
	    File directory = (File) value; 
	    if(directory == null) {
		setText("");
		return this;
	    }
	    String fileName = getFileChooser().getName(directory);
	    setText(fileName);

	    // REMIND(jeff) - pay attention to parent heirarchy and
	    // indent accordingly
	    Icon icon = getFileChooser().getIcon(directory);
	    setIcon(icon);

	    return this;
	}
    }

    //
    // DataModel for DirectoryComboxbox
    //
    protected DirectoryComboBoxModel createDirectoryComboBoxModel() {
	return new DirectoryComboBoxModel();
    }

    /**
     * Data model for a type-face selection combo-box. 
     */
    protected class DirectoryComboBoxModel extends AbstractListModel implements ComboBoxModel {
	Vector directories = new Vector();
	File selectedDirectory;

	public DirectoryComboBoxModel() {
	    super();

	    File[] roots = getFileChooser().getFileSystemView().getRoots();
	    for(int i = 0; i < roots.length; i++) {
		addItem(roots[i]);
	    }
	    addItem(getFileChooser().getCurrentDirectory());
	}

	public void addItem(File directory) {
	    if(directory != null) {
		if(!directories.contains(directory)) {
		    directories.addElement(directory);
		}
		setSelectedItem(directory);
	    }
	}

	public void setSelectedItem(Object selectedDirectory) {
	    this.selectedDirectory = (File) selectedDirectory;
            fireContentsChanged(this, -1, -1);
	}

	public Object getSelectedItem() {
	    return selectedDirectory;
	}
	
	public int getSize() {
	    return directories.size();
	}

	public Object getElementAt(int index) {
	    return directories.elementAt(index);
	}
    }

    //
    // Renderer for Types ComboBox
    //
    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
	return new FilterComboBoxRenderer();
    }

    /**
     * Render different type sizes and styles.
     */
    public class FilterComboBoxRenderer extends BasicListCellRenderer {
	public Component getListCellRendererComponent(JList list,
	    Object value, int index, boolean isSelected, 
	    boolean cellHasFocus) {

	    super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);

	    FileFilter filter = (FileFilter) value;
	    if(filter != null) {
		setText(filter.getDescription());
	    } 
	    
	    return this;
	}
    }

    //
    // DataModel for Types Comboxbox
    //
    protected FilterComboBoxModel createFilterComboBoxModel() {
	return new FilterComboBoxModel();
    }
    
    /**
     * Data model for a type-face selection combo-box. 
     */
    protected class FilterComboBoxModel extends AbstractListModel implements ComboBoxModel, PropertyChangeListener {
	protected FileFilter[] filters;
	protected FilterComboBoxModel() {
	    super();
	    filters = getFileChooser().getChoosableFileFilters();
	}
	
	public void propertyChange(PropertyChangeEvent e) {
	    String prop = e.getPropertyName();
	    if(prop == JFileChooser.CHOOSABLE_FILE_FILTER_CHANGED_PROPERTY) {
		filters = (FileFilter[]) e.getNewValue();
		fireContentsChanged(this, -1, -1);
	    }
	}

	public void setSelectedItem(Object filter) {
	    if(filter != null) {
		getFileChooser().setFileFilter((FileFilter) filter);
		fireContentsChanged(this, -1, -1);
	    }
	}

	public Object getSelectedItem() {
	    // Ensure that the current filter is in the list.
	    // NOTE: we shouldnt' have to do this, since JFileChooser adds
	    // the filter to the choosable filters list when the filter
	    // is set. Lets be paranoid just in case someone overrides
	    // setFileFilter in JFileChooser.
	    FileFilter currentFilter = getFileChooser().getFileFilter();
	    boolean found = false;
	    if(currentFilter != null) {
		for(int i=0; i < filters.length; i++) {
		    if(filters[i] == currentFilter) {
			found = true;
		    }
		}
		if(found == false) {
		    getFileChooser().addChoosableFileFilter(currentFilter);
		}
	    }
	    return getFileChooser().getFileFilter();
	}
	
	public int getSize() {
	    if(filters != null) {
		return filters.length;
	    } else {
		return 0;
	    }
	}

	public Object getElementAt(int index) {
	    if(index > getSize() - 1) {
		// This shouldn't happen. Try to recover gracefully.
		return getFileChooser().getFileFilter();
	    }
	    if(filters != null) {
		return filters[index];
	    } else {
		return null;
	    }
	}
    }
					
    public void valueChanged(ListSelectionEvent e) {
	File f = getFileChooser().getSelectedFile();
	if (!e.getValueIsAdjusting() && f != null && !getFileChooser().isTraversable(f)) {
	    setFileName(getFileChooser().getName(f));
	}
    }

    /**
     * Acts when DirectoryComboBox has changed the selected item.
     */
    protected class DirectoryComboBoxAction extends AbstractAction {
	protected DirectoryComboBoxAction() {
	    super("DirectoryComboBoxAction");
	}
	
	public void actionPerformed(ActionEvent e) {
	    getFileChooser().setCurrentDirectory((File) directoryComboBox.getSelectedItem());
	}
    }
    
}

