/*
 * @(#)MetalDesktopIconUI.java	1.8 98/02/06
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.metal;

import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.*;
import java.beans.*;
import java.util.EventListener;
import java.io.Serializable;
import com.sun.java.swing.plaf.basic.BasicDesktopIconUI;

/**
 * Metal desktop icon.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.8 02/06/98
 * @author Steve Wilson
 */
public class MetalDesktopIconUI extends BasicDesktopIconUI implements Serializable
{

    JButton button;
    JLabel label;
    TitleListener titleListener;

    public static ComponentUI createUI(JComponent c)    {
        return new MetalDesktopIconUI();
    }

    public MetalDesktopIconUI() {
    }

    protected void installDefaults(JInternalFrame.JDesktopIcon dIcon) {
        super.installDefaults(dIcon);
        LookAndFeel.installColorsAndFont(dIcon, "DesktopIcon.background", "DesktopIcon.foreground", "DesktopIcon.font");
	dIcon.setOpaque(true);
    }
   
    protected void installComponents(JInternalFrame.JDesktopIcon dIcon) {
	JInternalFrame frame = dIcon.getInternalFrame();
	Icon icon = frame.getFrameIcon();
	String title = frame.getTitle();

	button = new JButton (title, icon);
	button.addActionListener( new ActionListener() {
	                          public void actionPerformed(ActionEvent e) { deiconize(); }} );
	button.setFont(dIcon.getFont());
	button.setBackground(dIcon.getBackground());
	button.setForeground(dIcon.getForeground());

	int buttonH = button.getPreferredSize().height;

	Icon drag = new MetalBumps((buttonH/3), buttonH,
				   MetalLookAndFeel.getControlHighlight(),
				   MetalLookAndFeel.getControlDarkShadow(),
				   MetalLookAndFeel.getControl());
	label = new JLabel(drag);
	label.setBorder( new MatteBorder( 0, 2, 0, 1, dIcon.getBackground()) );
	dIcon.setLayout(new BorderLayout(2, 0));
	dIcon.add(button, BorderLayout.CENTER);
	dIcon.add(label, BorderLayout.WEST);
	dIcon.getInternalFrame().addPropertyChangeListener( titleListener = new TitleListener() );
    }

    protected void uninstallComponents(JInternalFrame.JDesktopIcon dIcon) {
	dIcon.setLayout(null);
	dIcon.remove(label);
	dIcon.remove(button);
	dIcon.getInternalFrame().removePropertyChangeListener(titleListener);	
    }
 
    public Dimension getPreferredSize(JComponent c) {
	return null;
    }
  
    class TitleListener implements PropertyChangeListener, Serializable {
        public void propertyChange (PropertyChangeEvent e) {
  	  if (e.getPropertyName().equals("title")) {
	    button.setText((String)e.getNewValue());
	  }
	}
    }
}


