/*
 * @(#)MetalComboBoxUI.java	1.10 98/04/21
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.metal;

import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.basic.*;
import java.io.Serializable;
import java.beans.*;


/**
 * Metal UI for JComboBox
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @see MetalComboBoxListCellRenderer
 * @see MetalPopupMenuBorder
 * @version 1.10 04/21/98
 * @author Tom Santos
 */
public class MetalComboBoxUI extends BasicComboBoxUI {

    public static ComponentUI createUI(JComponent c) {
        return new MetalComboBoxUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        comboBox.setRequestFocusEnabled( false );
    }

    public void uninstallUI( JComponent c ) {
        super.uninstallUI( c ); 
    }

    public void paint(Graphics g, JComponent c) {
    }

    protected ComboPopup createPopup() {
        return new MetalComboPopup( comboBox );
    }

    protected JButton createArrowButton() {
        JButton button = new MetalComboBoxButton( comboBox,
                                                  new MetalComboBoxIcon(),
                                                  comboBox.isEditable() ? true : false,
                                                  currentValuePane,
                                                  listBox );
        button.setMargin( new Insets( 0, 1, 1, 3 ) );
        return button;
    }

    public PropertyChangeListener createPropertyChangeListener() {
        return new MetalPropertyChangeListener();
    }

    protected class MetalPropertyChangeListener extends ComboBoxPropertyChangeListener {
        public void propertyChange(PropertyChangeEvent e) {
            super.propertyChange( e );

            String propertyName = e.getPropertyName();

            if ( propertyName.equals( "editable" ) ) {
                editablePropertyChanged( e );
            }
        }
    }

    protected void editablePropertyChanged( PropertyChangeEvent e ) {
        if ( arrowButton instanceof MetalComboBoxButton ) {
            MetalComboBoxButton button = (MetalComboBoxButton)arrowButton;
            button.setIconOnly( comboBox.isEditable() );
        }
    }

    protected LayoutManager createLayoutManager() {
        return new MetalComboBoxLayoutManager();
    }

    protected class MetalComboBoxLayoutManager extends ComboBoxLayoutManager {
        public void layoutContainer( Container parent ) {
            layoutComboBox( parent, this );
        }
        public void superLayout( Container parent ) {
            super.layoutContainer( parent );
        }
    }

    // This is here because of a bug in the compiler.  When 1.1.6 comes out we
    // should move this into MetalComboBoxLayoutManager.
    public void layoutComboBox( Container parent, MetalComboBoxLayoutManager manager ) {
        if ( comboBox.isEditable() ) {
            manager.superLayout( parent );
        }
        else {
            if ( arrowButton != null ) {
                Insets insets = comboBox.getInsets();
                int width = comboBox.getWidth();
                int height = comboBox.getHeight();
                arrowButton.setBounds( insets.left, insets.top,
                                       width - (insets.left + insets.right),
                                       height - (insets.top + insets.bottom) );
            }
        }
    }

    public boolean isFocusTraversable() {
        return false;
    }

    protected void installListeners( JComponent c ) {
        comboBox.addItemListener( itemListener );
        comboBox.addPropertyChangeListener( propertyChangeListener );
    }

    protected void removeListeners( JComponent c ) {
        comboBox.removeItemListener( itemListener );
        comboBox.removePropertyChangeListener( propertyChangeListener );
    }

    public void configureEditor() {
        super.configureEditor();
        editor.removeKeyListener( popupKeyListener );
    }

    public void configureArrowButton() {
        if ( arrowButton != null ) {
            arrowButton.setRequestFocusEnabled( true );
            arrowButton.addKeyListener( keyListener );
            arrowButton.addKeyListener( popupKeyListener );
            arrowButton.addFocusListener( focusListener );
            arrowButton.addMouseListener( popupMouseListener );
            arrowButton.addMouseMotionListener( popupMouseMotionListener );
        }
    }

    public void unconfigureArrowButton() {
        if ( arrowButton != null ) {
            super.unconfigureArrowButton();

            arrowButton.removeKeyListener( keyListener );
            arrowButton.removeKeyListener( popupKeyListener );
            arrowButton.removeFocusListener( focusListener );
        }
    }

    public Dimension getMinimumSize( JComponent c ) {
        Dimension size = null;

        if ( !comboBox.isEditable() &&
             arrowButton != null &&
             arrowButton instanceof MetalComboBoxButton ) {

            MetalComboBoxButton button = (MetalComboBoxButton)arrowButton;
            Insets buttonInsets = button.getInsets();
            Insets insets = comboBox.getInsets();

            size = getDisplaySize();
            size.width += insets.left + insets.right;
            size.width += buttonInsets.left + buttonInsets.right;
            size.width += buttonInsets.right + button.getComboIcon().getIconWidth();
            size.height += insets.top + insets.bottom;
            size.height += buttonInsets.top + buttonInsets.bottom;
        }
        else if ( comboBox.isEditable() &&
		  arrowButton != null &&
		  editor != null ) {
           size = super.getMinimumSize( c );
           Insets margin = arrowButton.getMargin();
	   Insets insets = comboBox.getInsets();
	   if ( editor instanceof JComponent ) {
	       Insets editorInsets = ((JComponent)editor).getInsets();
	       size.height += editorInsets.top + editorInsets.bottom;
	   }
	   size.height += margin.top + margin.bottom;
           size.height += insets.top + insets.bottom;
	   //size.height += 2; // This is to make editable combo boxes the same height as non-editable.
        }
        else {
            size = super.getMinimumSize( c );
        }
        return size;
    }

    protected void selectNextPossibleValue() { super.selectNextPossibleValue();}
    protected void selectPreviousPossibleValue() { super.selectPreviousPossibleValue();}

    protected void addKeyAccelerators(JComponent comp) {
        super.addKeyAccelerators( comp );

        final JComboBox cBox = comboBox;
        final JButton button = arrowButton;

        AbstractAction downAction = new AbstractAction() {
            public void actionPerformed(ActionEvent e) {
                selectNextPossibleValue();
            }
            public boolean isEnabled() {
                return cBox.isEnabled();
            }
        };

        button.registerKeyboardAction( downAction,
                                       KeyStroke.getKeyStroke(KeyEvent.VK_DOWN,0),
                                       JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);

        AbstractAction upAction = new AbstractAction() {
            public void actionPerformed(ActionEvent e) {
                selectPreviousPossibleValue();
            }
            public boolean isEnabled() {
                return cBox.isEnabled();
            }
        };

        button.registerKeyboardAction( upAction,
                                       KeyStroke.getKeyStroke(KeyEvent.VK_UP,0),
                                       JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
    }

    protected void removeKeyAccelerators(JComponent comp) {
        super.removeKeyAccelerators( comp );
        comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(KeyEvent.VK_DOWN,0));
        comboBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(KeyEvent.VK_UP,0));
    }

    protected static class MetalComboPopup extends BasicComboPopup {
        public MetalComboPopup( JComboBox cBox ) {
            super( cBox );
        }

        public void delegateFocus( MouseEvent e ) {}
    }
}


