/*
 * @(#)MetalButtonUI.java	1.14 98/04/10
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
 
package com.sun.java.swing.plaf.metal;

import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.basic.*;
import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.plaf.*;

/**
 * MetalButtonUI implementation
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.14 04/10/98
 * @author Tom Santos
 */
public class MetalButtonUI extends BasicButtonUI {

    protected Color getSelectColor()       { return UIManager.getColor("Button.pressed"); }
    protected Color getDisabledTextColor() { return UIManager.getColor("Button.disabledText"); }
    protected Color getFocusColor()        { return UIManager.getColor("Button.focus"); }

    private final static MetalButtonUI metalButtonUI = new MetalButtonUI(); 

 
    public static ComponentUI createUI(JComponent c) {
        return metalButtonUI;
    }
 
    public void installUI(JComponent c) {
        super.installUI(c);
        c.setOpaque(true);
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        if (b.isOpaque() ) {
            Dimension size = b.getSize();
	    g.setColor( getSelectColor() );
	    g.fillRect( 0, 0, size.width, size.height );
	}
    }

    protected void paintFocus(Graphics g, AbstractButton b,
			      Rectangle viewRect, Rectangle textRect, Rectangle iconRect){

        Rectangle focusRect = new Rectangle();
	String text = b.getText();
	boolean isIcon = b.getIcon() != null;

        // If there is text
        if ( text != null & !text.equals( "" ) ) {
  	    if ( !isIcon ) {
	        focusRect.setBounds( textRect );
	    }
	    else {
	        focusRect.setBounds( iconRect.union( textRect ) );
	    }
        }
        // If there is an icon and no text
        else if ( isIcon ) {
  	    focusRect.setBounds( iconRect );
        }

        g.setColor(getFocusColor());
	g.drawRect((focusRect.x-1), (focusRect.y-1),
		  focusRect.width+1, focusRect.height+1);


        /*
        g.setColor(getFocusColor());
	if (b instanceof JButton) {
            if ( ((JButton)b).isDefaultButton() ) {
	        g.drawRect(3,3, size.width-7, size.height-7);	
	    }
	}
	g.drawRect(2,2, size.width-5, size.height-5);
	*/	
    }


    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
	AbstractButton b = (AbstractButton) c;			     
	ButtonModel model = b.getModel();
	FontMetrics fm = g.getFontMetrics();

	/* Draw the Text */
	if(model.isEnabled()) {
	    /*** paint the text normally */
	    g.setColor(b.getForeground());
	    BasicGraphicsUtils.drawString(g,text, model.getMnemonic(),
					  textRect.x,
					  textRect.y + fm.getAscent());
	}
	else {
	    /*** paint the text disabled ***/
	    g.setColor(UIManager.getColor("Button.disabledText"));
	    BasicGraphicsUtils.drawString(g,text,model.getMnemonic(),
					  textRect.x, textRect.y + fm.getAscent());

	}
    }

    protected BasicButtonListener createListener(JComponent c) {
	return new MetalButtonListener((AbstractButton) c);
    }

}

class MetalButtonListener extends BasicButtonListener
{

    public MetalButtonListener(AbstractButton b) {
      super(b);  
    }

    public void focusGained(FocusEvent e) { 
        Component c = (Component)e.getSource();
	c.repaint();
    }
}
   

