/*   
 * @(#)MetalBumps.java	1.12 98/03/05
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.metal;

import java.awt.*;
import com.sun.java.swing.*;
import java.io.*;
import java.util.*;

/**
 * Implements the Metal Look and Feel.
 * 
 * @version 1.12 03/05/98
 * @author Tom Santos
 */


class MetalBumps implements Icon, Serializable {

    protected int xBumps;
    protected int yBumps;
    protected Color topColor = MetalLookAndFeel.getPrimaryControlHighlight();
    protected Color shadowColor = MetalLookAndFeel.getPrimaryControlDarkShadow();
    protected Color backColor = MetalLookAndFeel.getPrimaryControlShadow();

    protected static Vector buffers = new Vector();
    protected BumpBuffer buffer;
    
    public MetalBumps( Dimension bumpArea ) {
        this( bumpArea.width, bumpArea.height );
    }

    public MetalBumps( int width, int height ) {
        setBumpArea( width, height );
	buffer = getBuffer( topColor, shadowColor, backColor );
	if ( buffer == null ) {
	    createBuffer();
	}
    }

    public MetalBumps( int width, int height,
		       Color newTopColor, Color newShadowColor, Color newBackColor ) {
        setBumpArea( width, height );
	setBumpColors( newTopColor, newShadowColor, newBackColor );
	buffer = getBuffer( topColor, shadowColor, backColor );
	if ( buffer == null ) {
	    createBuffer();
	}
    }

    protected void createBuffer() {
        buffer = new BumpBuffer( topColor, shadowColor, backColor );
	buffers.addElement( buffer );
    }

    protected BumpBuffer getBuffer( Color aTopColor, Color aShadowColor, Color aBackColor ) {
        BumpBuffer result = null;

        Enumeration elements = buffers.elements();

	while ( elements.hasMoreElements() ) {
	    BumpBuffer aBuffer = (BumpBuffer)elements.nextElement();
	    if ( aBuffer.hasSameColors( aTopColor, aShadowColor, aBackColor ) ) {
	        result = aBuffer;
		break;
	    } 
	}

	return result;
    }

    public void setBumpArea( Dimension bumpArea ) {
        setBumpArea( bumpArea.width, bumpArea.height );
    }

    public void setBumpArea( int width, int height ) {
        xBumps = width / 2;
	yBumps = height / 2;
    }

    public void setBumpColors( Color newTopColor, Color newShadowColor, Color newBackColor ) {
        topColor = newTopColor;
	shadowColor = newShadowColor;
	backColor = newBackColor;
	buffer = getBuffer( topColor, shadowColor, backColor );
	if ( buffer == null ) {
	    createBuffer();
	}
    }

    public void paintIcon( Component c, Graphics g, int x, int y ) {
	Rectangle oldClip = g.getClipBounds();
	Rectangle desiredClip = new Rectangle( x, y, getIconWidth(), getIconHeight() );
	Rectangle clip = desiredClip.intersection(oldClip);
	g.setClip( clip.x, clip.y, clip.width, clip.height);

	int bufferWidth = buffer.getImageSize().width;
	int bufferHeight = buffer.getImageSize().height;
	int xTiles = (getIconWidth() / bufferWidth) + 1;
	int yTiles = (getIconHeight() / bufferHeight) + 1;

	for ( int row = 0; row < yTiles; ++row ) {
	    for ( int column = 0; column < xTiles; ++column ) {
	        g.drawImage( buffer.getImage(), x + (column * bufferWidth), y + (row * bufferHeight), null );
	    }
	}

	g.setClip( oldClip.x, oldClip.y, oldClip.width, oldClip.height );
    }

    public int getIconWidth() {
        return xBumps * 2;
    }

    public int getIconHeight() {
        return yBumps * 2;
    }
}


class BumpBuffer implements Serializable {

    static Frame frame;
    static Component component;

    static final int IMAGE_SIZE = 100;
    static Dimension imageSize = new Dimension( IMAGE_SIZE, IMAGE_SIZE );

    transient Image image;
    Color topColor;
    Color shadowColor;
    Color backColor;

    public BumpBuffer( Color aTopColor, Color aShadowColor, Color aBackColor ) {
        createComponent();
        image = getComponent().createImage( IMAGE_SIZE, IMAGE_SIZE );
	topColor = aTopColor;
	shadowColor = aShadowColor;
	backColor = aBackColor;
	fillBumpBuffer();
    }

    public boolean hasSameColors( Color aTopColor, Color aShadowColor, Color aBackColor ) {
	return topColor.equals( aTopColor )       &&
	       shadowColor.equals( aShadowColor ) &&
	       backColor.equals( aBackColor );
    }

    public Image getImage() {
        if (image == null) {
	    image = getComponent().createImage( IMAGE_SIZE, IMAGE_SIZE );
	    fillBumpBuffer();
	}
        return image;
    }

    public Dimension getImageSize() {
        return imageSize;
    }

    protected void fillBumpBuffer() {
        Graphics g = image.getGraphics();

	g.setColor( backColor );
	g.fillRect( 0, 0, IMAGE_SIZE, IMAGE_SIZE );
	
	int columnX = 0;
	int xBumps = IMAGE_SIZE / 2;

        for ( int i = 0; i < xBumps; ++i, columnX += 2 ) {
	    paintColumn( g, columnX, i % 2 == 0 ? 0 : 2 );
	}
    }

    protected void paintColumn( Graphics g, int x, int y ) {
        while ( y <= IMAGE_SIZE - 1 ) {
	    g.setColor( topColor );
	    g.drawLine( x, y, x, y );

	    g.setColor( shadowColor );
	    g.drawLine( x + 1, y + 1, x + 1, y + 1 );

	    y += 4;
	}
    }
  
    protected Component getComponent() {return component;}

    protected void createComponent() {
        if (frame == null) {
	    frame = new Frame( "bufferCreator" );
	}

	if (component == null ) {
	    component = new Canvas();
	    frame.add( component, BorderLayout.CENTER );
	    frame.addNotify();
	}
    }

}
