/*
 * @(#)PressedFilter.java	1.2 98/01/30
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */
 
package com.sun.java.swing.plaf.mac;

import java.awt.image.*;
import java.awt.*;

/**
 * @version @(#)PressedFilter.java	1.0 1/25/98
 * @author Symantec
 */

public class PressedFilter extends RGBImageFilter
{
    /**
     * Creates a pressed (darker) icon image
     */
    public static Image createPressedImage (Image i) {
	PressedFilter filter = new PressedFilter();
	ImageProducer prod = new FilteredImageSource(i.getSource(), filter);
	Image pressedImage = Toolkit.getDefaultToolkit().createImage(prod);
	return pressedImage;
    }
    
    public PressedFilter() {
        canFilterIndexColorModel = true;
    }
    
    public int filterRGB(int x, int y, int rgb) {
	int red = (int) (((rgb >> 16) & 0xFF) * 0.7f);
	int green = (int) (((rgb >> 8) & 0xFF) * 0.7f);
	int blue = (int) ((rgb & 0xFF) * 0.7f);
        return (rgb & 0xff000000) | (red << 16) | (green << 8) | blue;
    }
}

