/*
 * @(#)MacUtilities.java	1.4 98/01/30
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */
 
 
package com.sun.java.swing.plaf.mac;

import java.awt.Color;
import com.sun.java.swing.plaf.ColorUIResource;


/**
 * @version @(#)MacUtilities.java	1.0 12/01/97
 * @author Symantec
 */

public class MacUtilities
{
	/* Grayscale Appearance Color Ramp */

	public static final Color GrayscaleAppearanceB  = new ColorUIResource( Color.black );
	public static final Color GrayscaleAppearanceW  = new ColorUIResource( Color.white );
	public static final Color GrayscaleAppearance1  = new ColorUIResource(238, 238, 238);
	public static final Color GrayscaleAppearance2  = new ColorUIResource(221, 221, 221);
	public static final Color GrayscaleAppearance3  = new ColorUIResource(204, 204, 204);
	public static final Color GrayscaleAppearance4  = new ColorUIResource(187, 187, 187);
	public static final Color GrayscaleAppearance5  = new ColorUIResource(170, 170, 170);
	public static final Color GrayscaleAppearance6  = new ColorUIResource(153, 153, 153);
	public static final Color GrayscaleAppearance7  = new ColorUIResource(136, 136, 136);
	public static final Color GrayscaleAppearance8  = new ColorUIResource(119, 119, 119);
	public static final Color GrayscaleAppearance9  = new ColorUIResource(102, 102, 102);
	public static final Color GrayscaleAppearance10 = new ColorUIResource( 85,  85,  85);
	public static final Color GrayscaleAppearance11 = new ColorUIResource( 68,  68,  68);
	public static final Color GrayscaleAppearance12 = new ColorUIResource( 34,  34,  34);
	public static final Color GrayscaleAppearanceA1 = new ColorUIResource( 51,  51,  51);
	public static final Color GrayscaleAppearanceA2 = new ColorUIResource( 17,  17,  17);

	private static boolean inited = false;
	private static boolean isMacOS;
	public static boolean IsMacOS() {
		if (!inited)
		{
			String osName = System.getProperty("os.name");
			isMacOS = (osName != null) && (osName.indexOf("Mac") != -1);
			inited = true;
		}
		return isMacOS;
    }

	public static final String GetAppearanceName() {
		String accent = "Lavender";
		if (IsMacOS())
		{
			java.util.Properties properties = new java.util.Properties();
			String sep = java.io.File.separator;
			try {
				String homeDir = System.getProperty("java.home");
				String propertiesFileName = homeDir + sep + "lib" + sep + "swing.properties";
				java.io.File propertiesFile = new java.io.File(propertiesFileName);
				java.io.BufferedInputStream ins = new java.io.BufferedInputStream(new java.io.FileInputStream(propertiesFile));
				properties.load(ins);
				ins.close();
            } 
			catch (Exception e) {
				properties.clear();
			}
			accent = properties.getProperty("macos.appearance.accent", accent); 	
		}

		return accent;
	}

}
