/*
 * @(#)MacTreeCellRenderer.java	1.6 98/02/02
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */
 
package com.sun.java.swing.plaf.mac;

import com.sun.java.swing.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.tree.*;
import com.sun.java.swing.plaf.basic.BasicTreeCellRenderer;
import com.sun.java.accessibility.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.util.*;

/**
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version @(#)MacTreeCellRenderer.java	1.0 11/24/97
 * @author Symantec
 */
public class MacTreeCellRenderer extends BasicTreeCellRenderer
{
	public MacTreeCellRenderer()
	{
		setSelectedIcon(defaultSelectedIcon);
		setSelectedLeafIcon(defaultSelectedLeafIcon);
		setFont(UIManager.getFont("Tree.font"));
		setIconTextGap(getIconTextGap() + 1);
	}

    /**
     * Returns the graphic image (glyph, icon) that the node displays when selected.
     *
     * @return an Icon
     * @see #setSelectedIcon
     */
    public Icon getSelectedIcon()
    {
        return selectedIcon;
    }

    /**
     * Defines the icon this component will display when selected.  If
     * the value of icon is null, the normal icon is displayed.
     * <p>
     * This is a JavaBeans bound property.  
     * 
     * @see #getSelectedIcon
     */
    public void setSelectedIcon(Icon icon)
    {
        Icon oldValue = icon;
        selectedIcon = icon;
        firePropertyChange("selectedIcon", oldValue, selectedIcon);

        AccessibleContext ac = getAccessibleContext();
        if ((ac != null) && (oldValue != selectedIcon))
        {
        	ac.firePropertyChange(AccessibleContext.ACCESSIBLE_VISIBLE_DATA_PROPERTY, oldValue, selectedIcon);
        }

        repaint(10);
    }

    /**
     * Returns the graphic image (glyph, icon) that a leaf node displays when selected.
     *
     * @return an Icon
     * @see #setSelectedLeafIcon
     */
    public Icon getSelectedLeafIcon()
    {
        return selectedLeafIcon;
    }

    /**
     * Defines the icon this component will display when a leaf is selected.  If
     * the value of icon is null, the normal icon is displayed.
     * <p>
     * This is a JavaBeans bound property.  
     * 
     * @see #getSelectedLeafIcon
     */
    public void setSelectedLeafIcon(Icon icon)
    {
        Icon oldValue = icon;
        selectedLeafIcon = icon;
        firePropertyChange("selectedLeafIcon", oldValue, selectedLeafIcon);

        AccessibleContext ac = getAccessibleContext();
        if ((ac != null) && (oldValue != selectedLeafIcon))
        {
        	ac.firePropertyChange(AccessibleContext.ACCESSIBLE_VISIBLE_DATA_PROPERTY, oldValue, selectedLeafIcon);
        }

        repaint(10);
    }

    public Dimension getPreferredSize()
    {
		Dimension retDimension = super.getPreferredSize();
	
		if(retDimension != null)
		    retDimension = new Dimension(retDimension.width, retDimension.height + 2);
		    
		return retDimension;
    }

    /**
      * Configures the renderer based on the passed in components.
      * The value is set from messaging value with toString().
      * The foreground color is set based on the selection and the icon
      * is set based on on leaf and expanded.
      */
    public Component getTreeCellRendererComponent(JTree tree, Object value,
													  boolean sel,
													  boolean expanded,
													  boolean leaf, int row,
													  boolean hasFocus)
	{
		String stringValue = tree.convertValueToText(value, sel, expanded, leaf, row, hasFocus);
		
		setText(stringValue);
		selected = sel;

		if (leaf)
		{
			if (selected)
			{
				setIcon(getSelectedLeafIcon());
				return this;
			}
			else
			{
				setIcon(getLeafIcon());
				return this;
			}
		}
		
		if (selected)
		{
			Icon temp = getSelectedIcon();
			if(temp != null)
			{
				setIcon(temp);
				return this;
			}
		}
		
		if (expanded)
		{
			setIcon(getOpenIcon());
		}
		else
		{
			setIcon(getClosedIcon());
		}
		
		return this;
    }

	public void paint(java.awt.Graphics g)
	{
		g.setFont(getFont());
		
       	FontMetrics	fm				= g.getFontMetrics();
		int			stringWidth		= fm.stringWidth(getText());
		int			stringHeight	= fm.getAscent();// + fm.getLeading();
		int			xOffset			= 0;
		int			yOffset			= 0;
		Icon		currentIcon		= null;
    	
   		currentIcon = getIcon();

		if(currentIcon != null)
		{
			xOffset = currentIcon.getIconWidth() + getIconTextGap();
			currentIcon.paintIcon(this, g, 0, 0);
		}
		
		yOffset = ((getHeight() - 1 - stringHeight) >> 1) - 1;

		if(selected)
		{
       		g.setColor(textSelectionColor);
      		g.fillRect(xOffset - 1, yOffset, stringWidth + 2, stringHeight + fm.getDescent());
		}

		g.setColor(getTextNonSelectionColor());
       	g.drawString(getText(), xOffset, stringHeight - 1 + yOffset);
       	
   }

	transient protected static Icon defaultSelectedIcon		= UIManager.getIcon("Tree.selectedIcon");
	transient protected static Icon defaultSelectedLeafIcon = UIManager.getIcon("Tree.selectedLeafIcon");

    transient protected Icon selectedIcon		= null;
    transient protected Icon selectedLeafIcon	= null;
}
