/*
 * %W% %E%
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */
 
package com.sun.java.swing.plaf.mac;

import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.*;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Dimension;
import java.util.Vector;

/**
 * @version @(#)MacToggleButtonBorder.java	1.0 12/5/97
 * @author Symantec
 * @author Levi Brown
 */

class MacToggleButtonBorder extends AbstractBorder implements UIResource
{
	protected static final Insets	smallInsets		= new Insets(2, 2, 2, 2);
	protected static final Insets	mediumInsets	= new Insets(3, 3, 3, 3);
	protected static final Insets	largeInsets		= new Insets(4, 4, 4, 4);

	protected static final int		smallThreshold	= 25;
	protected static final int		largeThreshold	= 35;
	protected static final int		SMALL_SIZE		= 1;
	protected static final int		MEDIUM_SIZE		= 2;
	protected static final int		LARGE_SIZE		= 3;

	protected static Color GSA1Color	= UIManager.getColor("GrayscaleAppearanceA1");
	protected static Color GSA2Color	= UIManager.getColor("GrayscaleAppearanceA2");
	protected static Color GSWColor	= UIManager.getColor("GrayscaleAppearanceW");
	protected static Color GS1Color	= UIManager.getColor("GrayscaleAppearance1");
	protected static Color GS2Color	= UIManager.getColor("GrayscaleAppearance2");
	protected static Color GS3Color	= UIManager.getColor("GrayscaleAppearance3");
	protected static Color GS4Color	= UIManager.getColor("GrayscaleAppearance4");
	protected static Color GS5Color	= UIManager.getColor("GrayscaleAppearance5");
	protected static Color GS6Color	= UIManager.getColor("GrayscaleAppearance6");
	protected static Color GS7Color	= UIManager.getColor("GrayscaleAppearance7");
	protected static Color GS8Color	= UIManager.getColor("GrayscaleAppearance8");
	protected static Color GS9Color	= UIManager.getColor("GrayscaleAppearance9");
	protected static Color GS10Color	= UIManager.getColor("GrayscaleAppearance10");
	protected static Color GS11Color	= UIManager.getColor("GrayscaleAppearance11");

	protected static ImageIcon ldOnTB		= null;
	protected static ImageIcon ldOffTB;
	protected static ImageIcon lOnTB;
	protected static ImageIcon lPressedTB;
	protected static ImageIcon lOffTB;
	protected static ImageIcon mdOnTB;
	protected static ImageIcon mdOffTB;
	protected static ImageIcon mOnTB;
	protected static ImageIcon mPressedTB;
	protected static ImageIcon mOffTB;
	protected static ImageIcon sdOnTB;
	protected static ImageIcon sdOffTB;
	protected static ImageIcon sOnTB;
	protected static ImageIcon sPressedTB;
	protected static ImageIcon sOffTB;

	protected int buttonType;
	
	public MacToggleButtonBorder()
	{
		if(ldOnTB == null)
		{
			ldOnTB		= (ImageIcon) UIManager.getIcon("ToggleButton.largeDisabledOn");
			ldOffTB		= (ImageIcon) UIManager.getIcon("ToggleButton.largeDisabledOff");
			lOnTB		= (ImageIcon) UIManager.getIcon("ToggleButton.largeOn");
			lPressedTB	= (ImageIcon) UIManager.getIcon("ToggleButton.largePressed");
			lOffTB		= (ImageIcon) UIManager.getIcon("ToggleButton.largeOff");
			mdOnTB		= (ImageIcon) UIManager.getIcon("ToggleButton.mediumDisabledOn");
			mdOffTB		= (ImageIcon) UIManager.getIcon("ToggleButton.mediumDisabledOff");
			mOnTB		= (ImageIcon) UIManager.getIcon("ToggleButton.mediumOn");
			mPressedTB	= (ImageIcon) UIManager.getIcon("ToggleButton.mediumPressed");
			mOffTB		= (ImageIcon) UIManager.getIcon("ToggleButton.mediumOff");
			sdOnTB		= (ImageIcon) UIManager.getIcon("ToggleButton.smallDisabledOn");
			sdOffTB		= (ImageIcon) UIManager.getIcon("ToggleButton.smallDisabledOff");
			sOnTB		= (ImageIcon) UIManager.getIcon("ToggleButton.smallOn");
			sPressedTB	= (ImageIcon) UIManager.getIcon("ToggleButton.smallPressed");
			sOffTB		= (ImageIcon) UIManager.getIcon("ToggleButton.smallOff");
		}
	}
	
	public void paintBorder(Component c, Graphics g, int x, int y, int width, int height)
	{
		boolean	isPressed	= false;
		boolean	isSelected	= false;
		boolean	isEnabled	= true;
		boolean	isActive	= true;
		Vector		colors		= new Vector();
		ImageIcon	workingIcon	= null;
		
		if (c instanceof AbstractButton)
		{
			AbstractButton b = (AbstractButton)c;
			ButtonModel model = b.getModel();
			
			isPressed	= (model.isArmed() && model.isPressed());
			isSelected	= model.isSelected();
			isEnabled	= model.isEnabled();

			ComponentUI ui = b.getUI();
			if(ui instanceof MacToggleButtonUI)
			{
				isActive = ((MacToggleButtonUI)ui).isActive();
			}
		}
		
		
		determineButtonType(width, height);
		
		switch (buttonType)
		{
			case SMALL_SIZE:
				if(isEnabled && isActive)
				{
					if(isPressed)
					{
						workingIcon		= sPressedTB;
		
						colors.addElement(GSA2Color);	//Top and Left
						colors.addElement(GS11Color);	//Bottom and Right
						colors.addElement(GS10Color);	//Top and Left
						colors.addElement(GS5Color);	//Bottom and Right
					}
					//If it's released
					else
					{
						if(isSelected)
						{
							workingIcon		= sOnTB;
							
							colors.addElement(GSA2Color);	//Top and Left
							colors.addElement(GS11Color);	//Bottom and Right
							colors.addElement(GS10Color);	//Top and Left
							colors.addElement(GS5Color);	//Bottom and Right
						}
						//If it's off
						else
						{
							workingIcon		= sOffTB;
							
							colors.addElement(GS9Color);	//Top and Left
							colors.addElement(GSA1Color);	//Bottom and Right
							colors.addElement(GSWColor);	//Top and Left
							colors.addElement(GS7Color);	//Bottom and Right
						}
					}
				}
				//Disabled
				else
				{
						if(isSelected)
						{
							workingIcon		= sdOnTB;
							
							colors.addElement(GS8Color);	//Top and Left
							colors.addElement(GS6Color);	//Bottom and Right
							colors.addElement(GS4Color);	//Top and Left
							colors.addElement(GS4Color);	//Bottom and Right
						}
						//If it's off
						else
						{
							workingIcon		= sdOffTB;
							
							colors.addElement(GS5Color);	//Top and Left
							colors.addElement(GS6Color);	//Bottom and Right
							colors.addElement(GS2Color);	//Top and Left
							colors.addElement(GS2Color);	//Bottom and Right
						}
				}
				break;
				
			case MEDIUM_SIZE:
				if(isEnabled && isActive)
				{
					if(isPressed)
					{
						workingIcon		= mPressedTB;
		
						colors.addElement(GSA2Color);	//Top and Left
						colors.addElement(GS11Color);	//Bottom and Right
						colors.addElement(GS11Color);	//Top and Left
						colors.addElement(GS4Color);	//Bottom and Right
						colors.addElement(GS9Color);	//Top and Left
						colors.addElement(GS6Color);	//Bottom and Right
					}
					//If it's released
					else
					{
						if(isSelected)
						{
							workingIcon		= mOnTB;
							
							colors.addElement(GSA2Color);	//Top and Left
							colors.addElement(GS11Color);	//Bottom and Right
							colors.addElement(GS11Color);	//Top and Left
							colors.addElement(GS4Color);	//Bottom and Right
							colors.addElement(GS9Color);	//Top and Left
							colors.addElement(GS6Color);	//Bottom and Right
						}
						//If it's off
						else
						{
							workingIcon		= mOffTB;
							
							colors.addElement(GS9Color);	//Top and Left
							colors.addElement(GSA1Color);	//Bottom and Right
							colors.addElement(GS3Color);	//Top and Left
							colors.addElement(GS8Color);	//Bottom and Right
							colors.addElement(GSWColor);	//Top and Left
							colors.addElement(GS6Color);	//Bottom and Right
						}
					}
				}
				//Disabled
				else
				{
						if(isSelected)
						{
							workingIcon		= mdOnTB;
							
							colors.addElement(GS8Color);	//Top and Left
							colors.addElement(GS6Color);	//Bottom and Right
							colors.addElement(GS4Color);	//Top and Left
							colors.addElement(GS4Color);	//Bottom and Right
							colors.addElement(GS4Color);	//Top and Left
							colors.addElement(GS4Color);	//Bottom and Right
						}
						//If it's off
						else
						{
							workingIcon		= mdOffTB;
							
							colors.addElement(GS5Color);	//Top and Left
							colors.addElement(GS6Color);	//Bottom and Right
							colors.addElement(GS2Color);	//Top and Left
							colors.addElement(GS2Color);	//Bottom and Right
							colors.addElement(GS2Color);	//Top and Left
							colors.addElement(GS2Color);	//Bottom and Right
						}
				}
				break;
				
			case LARGE_SIZE:
				if(isEnabled && isActive)
				{
					if(isPressed)
					{
						workingIcon		= lPressedTB;
		
						colors.addElement(GSA2Color);	//Top and Left
						colors.addElement(GS11Color);	//Bottom and Right
						colors.addElement(GSA1Color);	//Top and Left
						colors.addElement(GS4Color);	//Bottom and Right
						colors.addElement(GS11Color);	//Top and Left
						colors.addElement(GS5Color);	//Bottom and Right
						colors.addElement(GS9Color);	//Top and Left
						colors.addElement(GS6Color);	//Bottom and Right
					}
					//If it's released
					else
					{
						if(isSelected)
						{
							workingIcon		= lOnTB;
							
							colors.addElement(GSA2Color);	//Top and Left
							colors.addElement(GS11Color);	//Bottom and Right
							colors.addElement(GSA1Color);	//Top and Left
							colors.addElement(GS4Color);	//Bottom and Right
							colors.addElement(GS11Color);	//Top and Left
							colors.addElement(GS5Color);	//Bottom and Right
							colors.addElement(GS9Color);	//Top and Left
							colors.addElement(GS6Color);	//Bottom and Right
						}
						//If it's off
						else
						{
							workingIcon		= lOffTB;
							
							colors.addElement(GS9Color);	//Top and Left
							colors.addElement(GSA1Color);	//Bottom and Right
							colors.addElement(GS3Color);	//Top and Left
							colors.addElement(GS10Color);	//Bottom and Right
							colors.addElement(GS1Color);	//Top and Left
							colors.addElement(GS8Color);	//Bottom and Right
							colors.addElement(GSWColor);	//Top and Left
							colors.addElement(GS6Color);	//Bottom and Right
						}
					}
				}
				//Disabled
				else
				{
						if(isSelected)
						{
							workingIcon		= ldOnTB;
							
							colors.addElement(GS8Color);	//Top and Left
							colors.addElement(GS6Color);	//Bottom and Right
							colors.addElement(GS4Color);	//Top and Left
							colors.addElement(GS4Color);	//Bottom and Right
							colors.addElement(GS4Color);	//Top and Left
							colors.addElement(GS4Color);	//Bottom and Right
							colors.addElement(GS4Color);	//Top and Left
							colors.addElement(GS4Color);	//Bottom and Right
						}
						//If it's off
						else
						{
							workingIcon		= ldOffTB;
							
							colors.addElement(GS5Color);	//Top and Left
							colors.addElement(GS7Color);	//Bottom and Right
							colors.addElement(GS2Color);	//Top and Left
							colors.addElement(GS2Color);	//Bottom and Right
							colors.addElement(GS2Color);	//Top and Left
							colors.addElement(GS2Color);	//Bottom and Right
							colors.addElement(GS2Color);	//Top and Left
							colors.addElement(GS2Color);	//Bottom and Right
						}
				}
				break;
		}
		
		MacBorderFactory.paintButtonBorder(c, g, workingIcon, colors, new Point(0, 0), new Dimension(width, height));
	}
	
	public Insets getBorderInsets(Component c)
	{
		determineButtonType(c);
		
		switch (buttonType)
		{
			case SMALL_SIZE:
				return smallInsets;
			case MEDIUM_SIZE:
				return mediumInsets;
			case LARGE_SIZE:
				return largeInsets;
		}
		
		//We should never get here.
		return mediumInsets;
	}
	
	protected void determineButtonType(int width, int height)
	{
		//Determine what type of button border to draw, based on the button's size
		int maxDim = Math.max(width, height);
		if(maxDim < smallThreshold)
			buttonType = SMALL_SIZE;
		else if(maxDim >= largeThreshold)
			buttonType = LARGE_SIZE;
		else
			buttonType = MEDIUM_SIZE;
	}
	
	protected void determineButtonType(Component c)
	{
		determineButtonType(c.getSize().width, c.getSize().height);
	}
}	
