/*
 * @(#)MacTextFieldUI.java	1.6 98/02/02
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */
 
 
package com.sun.java.swing.plaf.mac;

import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.plaf.basic.BasicTextFieldUI;
import com.sun.java.swing.border.*;
import com.sun.java.swing.event.*;
import com.sun.java.swing.text.*;
import com.sun.java.swing.plaf.*;

/**
 * Provides the Mac look and feel for a text field.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version @(#)MacTextFieldUI.java	1.0 11/24/97
 * @author Symantec
 */
public class MacTextFieldUI extends MacTextUI {

    /**
     * Creates a UI for a JTextField.
     *
     * @param c the text field
     * @return the UI
     */
    public static ComponentUI createUI(JComponent c) {
        return new MacTextFieldUI();
    }

    /**
     * Name used as a key to lookup properties through the
     * UIManager.  This is used as a prefix to all the standard
     * text properties.
     */
    protected String getPropertyPrefix() {
	return "TextField";
    }

    /**
     * Creates a view based on an element.
     *
     * @param elem the element
     * @return the view
     */
    public View create(Element elem) {
	return new FieldView(elem);
    }

    /**
     * Creates a view based on an element.
     *
     * @param elem the element
     * @param p0 the starting offset
     * @param p1 the ending offset
     * @return the view
     */
    public View create(Element elem, int p0, int p1) {
	throw new Error("unsupported");
    }

    /**
     * Creates the object to use for a caret.  By default an
     * instance of MacTextUI.MacCaret is created.  This method
     * can be redefined to provide something else that implements
     * the Caret interface.
     *
     * @return the caret object
     */
    protected Caret createCaret() {
	return new MacFieldCaret();
    }

    /**
     * Load the given keymap with default settings
     * appropriate for the UI being created.  This
     * is implemented to do the superclass behavior 
     * as well as load the settings appropriate for
     * a single-line text editor.
     */
    protected void loadDefaultKeymap(Keymap map) {
	super.loadDefaultKeymap(map);
	JTextComponent.loadKeymap(map, fieldBindings, 
					 getComponent().getActions());
    }

    /**
     * Paints the background of the field.
     *
     * @param g the graphics context
     */
 /*   protected void paintBackground(Graphics g) {
	JTextField field = (JTextField) getComponent();
	if(field.isOpaque()) {
	    g.setColor(field.getBackground());
	    Dimension d = field.getSize();
	    g.fillRect(-field.getScrollOffset(), 0, d.width, d.height);
	}
    }
*/
    /**
     * Default bindings multi-line editor keymaps implementing the Mac feel.
     */
    static final JTextComponent.KeyBinding[] fieldBindings = {
	new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0),
				       JTextField.notifyAction)
    };

    /**
     * <p>
     * Warning: serialized objects of this class will not be compatible with
     * future swing releases.  The current serialization support is appropriate
     * for short term storage or RMI between Swing1.0 applications.  It will
     * not be possible to load serialized Swing1.0 objects with future releases
     * of Swing.  The JDK1.2 release of Swing will be the compatibility
     * baseline for the serialized form of Swing objects.
     */
    public class MacFieldCaret extends MacTextUI.MacCaret {

		/**
		 * Creates a new controller to serve an editor.
		 *
		 * @param editor the text editor
		 */
		public MacFieldCaret() 
		{
		    super();
		}
	
		/**
		 * Repaint the entire component to paint the focus rectangle
		 */
                public void focusGained(FocusEvent e)
		{
		    super.focusGained(e);
		    getComponent().repaint();
		}
	
	        /**
		 * Repaint the entire component to paint the focus rectangle
		 */
                public void focusLost(FocusEvent e)
		{
	            super.focusLost(e);
		    getComponent().repaint();
		    
		}
    }

}
