/*
 * @(#)MacTextAreaUI.java	1.6 98/02/02
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */
 
 
package com.sun.java.swing.plaf.mac;

import java.awt.*;
import java.awt.event.KeyEvent;
import java.awt.event.InputEvent;
import com.sun.java.swing.*;
import com.sun.java.swing.text.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.plaf.basic.BasicTextAreaUI;

/**
 * Provides the look and feel for a plain text editor.  In this
 * implementation the default UI is extended to act as a simple
 * view factory.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version @(#)MacTextAreaUI.java	1.0 11/24/97
 * @author Symantec
 */
public class MacTextAreaUI extends MacTextUI {

    /**
     * Creates a UI for a JTextArea.
     *
     * @param ta a text area
     * @return the UI
     */
    public static ComponentUI createUI(JComponent ta) {
        return new MacTextAreaUI();
    }

    /**
     * Name used as a key to lookup properties through the
     * UIManager.  This is used as a prefix to all the standard
     * text properties.
     */
    protected String getPropertyPrefix() {
	return "TextArea";
    }

    /**
     * Creates the view for an element.
     *
     * @param elem the element
     * @return the view
     */
    public View create(Element elem) {
	return new PlainView(elem);
    }
    
    /**
     * Creates the view for an element.  Since there is
     * no formatting for the associated component, this 
     * should never be called.
     *
     * @param elem the element
     * @param p0 the starting offset
     * @param p1 the ending offset
     * @return the view
     */
    public View create(Element elem, int p0, int p1) {
	throw new Error("unsupported");
    }

    /**
     * Load the given keymap with default settings
     * appropriate for the UI being created.  This
     * is implemented to do the superclass behavior 
     * as well as load the settings appropriate for
     * a multi-line text editor.
     */
    protected void loadDefaultKeymap(Keymap map) {
	super.loadDefaultKeymap(map);
	JTextComponent.loadKeymap(map, multilineBindings, 
					 getComponent().getActions());
    }

    /**
     * Default bindings multi-line editor keymaps implementing the Mac feel.
     */
    static final JTextComponent.KeyBinding[] multilineBindings = {
	new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_UP, 0),
				       DefaultEditorKit.pageUpAction),
	new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_PAGE_DOWN, 0),
				       DefaultEditorKit.pageDownAction),
	new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0),
				       DefaultEditorKit.insertBreakAction),
	new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_TAB, 0),
				       DefaultEditorKit.insertTabAction),
	new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_V, 
								    InputEvent.ALT_MASK),
					     DefaultEditorKit.pageUpAction),
	new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_V,
								    InputEvent.CTRL_MASK),
					     DefaultEditorKit.pageDownAction),
	new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_N,
								    InputEvent.CTRL_MASK),
					     DefaultEditorKit.downAction),
	new JTextComponent.KeyBinding(KeyStroke.getKeyStroke(KeyEvent.VK_P,
								    InputEvent.CTRL_MASK),
					     DefaultEditorKit.upAction),
	new JTextComponent.KeyBinding(
	    KeyStroke.getKeyStroke(KeyEvent.VK_COMMA, InputEvent.ALT_MASK | InputEvent.SHIFT_MASK),
	    DefaultEditorKit.beginAction),
	new JTextComponent.KeyBinding(
	    KeyStroke.getKeyStroke(KeyEvent.VK_PERIOD, InputEvent.ALT_MASK | InputEvent.SHIFT_MASK),
	    DefaultEditorKit.endAction),
    };

}
