/*
 * @(#)MacTableHeaderUI.java	1.5 98/02/05
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */


package com.sun.java.swing.plaf.mac;

import com.sun.java.swing.plaf.basic.*;
import com.sun.java.swing.table.*;
import com.sun.java.swing.*;
import com.sun.java.swing.event.*;
import java.util.Enumeration;
import java.awt.event.*;
import java.awt.*;
import com.sun.java.swing.plaf.*;
import java.io.Serializable;

/**
 * MacTableHeaderUI implementation
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.0 01/15/98
 * @author Symantec
 * @author David Bustin
 */
public class MacTableHeaderUI extends BasicTableHeaderUI
{
  private Color headerSelectionBackground;
  private Color headerSelectionForeground;
  private Color headerBackground;
  private Color headerForeground;

  private int lastSelectedColumn;

//
// Install/Deinstall UI
//

    public static ComponentUI createUI(JComponent h) {
        return new MacTableHeaderUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);

    headerSelectionBackground = UIManager.getColor("TableHeader.selectionBackground");
    headerSelectionForeground = UIManager.getColor("TableHeader.selectionForeground");

    headerBackground = UIManager.getColor("TableHeader.background");
    headerForeground = UIManager.getColor("TableHeader.foreground");
	header.setBackground(headerBackground);
	header.setForeground(headerForeground);

	lastSelectedColumn = -1;
    }

    public void uninstallUI(JComponent c) {
       super.uninstallUI(c);
    }

	protected int getLastSelectedColumn() {
		return lastSelectedColumn;
	}

	protected void repaintLastSelectedColumn() {
		if (lastSelectedColumn == -1)
			return;
		Rectangle r = header.getHeaderRect(lastSelectedColumn);
		header.repaint(r.x, r.y, r.width, r.height);
		lastSelectedColumn = -1;
	}

    public void paint(Graphics g, JComponent c) {
		String column_name;
		Rectangle r;
		int selectedColumn;

		super.paint(g,c);

		if (!header.getTable().getColumnSelectionAllowed())
			return;

		selectedColumn =  header.getTable().getSelectedColumn();

		// de-select last column header selection

		if (lastSelectedColumn != -1 && lastSelectedColumn != selectedColumn)
			{
			r = header.getHeaderRect(lastSelectedColumn);
			g.setColor(headerBackground);
			header.repaint(r.x, r.y, r.width, r.height);
			lastSelectedColumn = -1;
			}

		// high-light column header

		if (selectedColumn != -1)
			{
			r = header.getHeaderRect(selectedColumn);
			g.setColor(headerSelectionBackground);
			g.fillRect(r.x, r.y, r.width, r.height);

			column_name = super.header.getTable().getColumnName(selectedColumn);
			g.setColor(headerSelectionForeground);
            MacGraphicsUtils.drawStringInRect(g, column_name,
                                                r.x, r.y+2, r.width, r.height,
                                                SwingConstants.CENTER, null);
 			lastSelectedColumn = selectedColumn;
 			}
	}
}  // End of Class MacTableHeaderUI

