/*
 * @(#)MacSplitPaneDivider.java	1.6 98/02/02
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */
 
package com.sun.java.swing.plaf.mac;

import java.awt.*;
import com.sun.java.swing.JSplitPane;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.basic.BasicSplitPaneUI;
import com.sun.java.swing.plaf.basic.BasicSplitPaneDivider;

/**
 * Divider used for Mac split pane.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version @(#)MacSplitPaneDivider.java	1.0 11/24/97
 * @author Symantec
 * @author David Bustin
 */
public class MacSplitPaneDivider extends BasicSplitPaneDivider
{
    public static final int minimumSize = 6;
    public static final int defaultDividerSize = 6;

    protected Color highlightColor;
    protected Color shadowColor;

    /**
     * Creates a new Mac SplitPaneDivider
     */
    public MacSplitPaneDivider(BasicSplitPaneUI ui) {
		super(ui);
		highlightColor = UIManager.getColor("SplitPane.highlight");
		shadowColor = UIManager.getColor("SplitPane.shadow");
		setDividerSize(defaultDividerSize);
    }

    /**
     * overrides to hardcode the size of the divider
     */
    public void setDividerSize(int newSize) {
        if (newSize < minimumSize) {
            setDividerSize(minimumSize);
        } else {
            super.setDividerSize(newSize);
        }                  
    }

    /**
      * Paints the divider.
      */
    public void paint(Graphics g) {
	Color               bgColor = getBackground();
	Dimension           size = getSize();

	// fill
	g.setColor(getBackground());
	g.fillRect(0, 0, size.width-1, size.height-1);
	
	if (getBasicSplitPaneUI().getOrientation() == JSplitPane.HORIZONTAL_SPLIT) 
		{
		g.setColor(Color.black);
	    g.drawLine(0, 0, 0, size.height-1);

	    g.setColor(highlightColor);
	    g.drawLine(1, 0, 1, size.height-1);

	    g.setColor(shadowColor);
	    g.drawLine(size.width-1, 0, size.width-1, size.height-1);
		} 
	else 
		{
		g.setColor(Color.black);
	    g.drawLine(0, 0, size.width-1, 0);

	    g.setColor(highlightColor);
	    g.drawLine(0, 1, size.width-1, 1);

	    g.setColor(shadowColor);
	    g.drawLine(0, size.height-1, size.width-1, size.height-1);
		}
    super.paint(g);
    }

    /**
      * The minimums size is the same as the preferredSize
      */
    public Dimension getMinimumSize() {
	return getPreferredSize();
    }

}
