/*
 * @(#)MacSpinnerUI.java	1.4 98/02/02
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */
 
package com.sun.java.swing.plaf.mac;

import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.plaf.basic.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.*;

import java.io.Serializable;


/**
 * MacSpinner implementation
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @author Symantec
 * @author David Bustin
 */
public class MacSpinnerUI extends BasicSpinnerUI
{
	protected Color GS10Color;
	protected Color spinnerFieldBackground;
	protected Color spinnerFieldForeground;
	
	public class RoundedLineBorder extends LineBorder {
		RoundedLineBorder(Color c)	{
			super(c);
			roundedCorners = true;
		}
		public boolean getRoundedCorners() { return roundedCorners; }
	}
  // Shared UI object
  protected static MacSpinnerUI macSpinnerUI = new MacSpinnerUI();

  private static Border macInactiveBorder = new EmptyBorder(0,0,0,0);
  private static Point buttonSize = new Point( 13, 13);

  public static ComponentUI createUI(JComponent s)  {
    return macSpinnerUI;
  }
  
  public void installUI(JComponent c) {
    Spinner spinner = (Spinner)c;
    installBorder(c);

    super.installUI(c);

	GS10Color = UIManager.getColor("GrayscaleAppearance10");
	spinnerFieldBackground = UIManager.getColor("Spinner.fieldBackground");
	spinnerFieldForeground = UIManager.getColor("Spinner.fieldForeground");
	
    JButton up = new MacSpinnerButton(new MacArrowIcon(true));
    up.addActionListener( new SpinnerIncrementer(spinner));

    JButton down = new MacSpinnerButton(new MacArrowIcon(false));
    down.addActionListener( new SpinnerDecrementer(spinner));

    Dimension size = getPreferredSize(c);

	RoundedLineBorder lb = new RoundedLineBorder(Color.black);
	up.setBorder(lb);
	down.setBorder(lb);

    up.setBounds ( size.width-buttonSize.x, 3, buttonSize.x, buttonSize.y);
    down.setBounds (  size.width-buttonSize.x, buttonSize.y+2, buttonSize.x,buttonSize.y);
    c.setLayout(null);

    c.add(up);
    c.add(down);
  }
  
  public void uninstallUI(JComponent c) {
    Border b = c.getBorder();
    if(b == macInactiveBorder)
      c.setBorder(null);

    Component[] children = c.getComponents();
    for (int i = 0; i < children.length; i++) {
      if (children[i] instanceof MacSpinnerButton ){
        c.remove(children[i]);
      }
    }
    super.uninstallUI(c);
  }
    
  public void paint(Graphics g, JComponent c) {
    Spinner spinner = ((Spinner)(c));
    Insets bi = spinner.getBorder().getBorderInsets(spinner);

    Dimension size = c.getSize();
    Color back = spinner.getBackground();
    g.setColor(back);
    g.fillRect(bi.left,bi.top,size.width-(bi.left+bi.right),size.height-(bi.top+bi.bottom));   

    final int offset = 4;
    Dimension spinnerArea = getMinimumSize(c);
    bi.top += offset;
    spinnerArea.height += offset;
    paintSpinnerArea(g, spinner, spinnerArea, bi);

    int entryWidth = spinnerArea.width;
    int entryHeight = spinnerArea.height + bi.top;

	g.setColor(GS10Color);
	g.drawRect( 0, offset, entryWidth, entryHeight-offset-offset);
  }

  protected void paintSpinnerArea(Graphics g, Spinner spinner, Dimension d, Insets bi) 
	{
    if (spinner.hasFocus()) 
		{
		g.setColor(getFocusColor());
		g.fillRect(bi.left+2, bi.top+2, d.width-(bi.left+bi.right+4), d.height-(bi.top+bi.bottom+4));
		g.setColor(spinnerFieldForeground);
		}
    else
		{
		Color forG = spinner.getForeground(); 
		g.setColor(forG);
		}
    
    String s;
	if(spinner instanceof StringSpinner)
		{
      	StringSpinner spinner2 = ((StringSpinner)(spinner));
      	s = spinner2.getValueName() + (spinner2.getText()!=null ? spinner2.getText() : "");

		if (spinner2.getTypedString()==null)
      		{
			g.drawString(s, bi.left+2, ascent + bi.top+2);
      		}
      	else  
			{
			g.setColor(spinnerFieldForeground);
			g.drawString(s, bi.left+2, ascent+bi.top+2);
			g.setColor(Color.white);
			g.drawString(s.substring(0,spinner2.getTypedString().length()),bi.left+2 , ascent+bi.top+2);
			}
		}
    else
    	{
		s = Integer.toString(spinner.getValue());
      
		if (spinner.getLeadingPad() != -1)
			{
			int j = spinner.getDigits()-s.length();
			String lp = Integer.toString(spinner.getLeadingPad());
			for(int i=0; i<j; i++) 
				{ s = lp +s;}
			}
		s += (spinner.getText()!=null ? spinner.getText() : "");
		g.drawString(s, d.width-fm.stringWidth(s) - bi.right-2, ascent + bi.top+2); // fixed bug
		}
	}

  protected void installBorder (JComponent c) {
   Border b = c.getBorder();
    if( b == null)
      c.setBorder(macInactiveBorder);
  }

  public Dimension getPreferredSize(JComponent c) {
    Dimension size = getMinimumSize(c);
    size.width += 20;
    size.height +=10;
    return size;
  }

  public Dimension getMaximumSize(JComponent c) 
  {
    return getMinimumSize(c);
  }

  public Dimension getMinimumSize(JComponent c) 
  {
    Spinner s = ((Spinner)(c));
    fm = s.getFontMetrics(s.getFont());
    int w=0;
    
    if (s instanceof StringSpinner)
	    {
		StringSpinner s2 = ((StringSpinner)(s));
	
		String[] names = s2.getNameArray();
		if (names != null)	// maybe null during initialization
			{
			for (int i = names.length; --i>=0; ) 
				{
		    	int tw = fm.stringWidth(names[i]);
		    	if (tw>w) 
		    		w = tw;
				}
			}
		else
			w = fm.stringWidth("0")*s.getDigits();
		}
    else
	    {
		w = fm.stringWidth("0")*s.getDigits();
		}

    if (s.getText()!=null) 
    	w+=fm.stringWidth(s.getText());
    Insets bi = s.getBorder().getBorderInsets(s);
    d = new Dimension(w+bi.left+bi.right+4, fm.getHeight()+bi.top+bi.bottom+4);
    ascent = fm.getAscent();
    return d;
  }

  protected Color getFocusColor() {
      return spinnerFieldBackground;
  }


}


class MacSpinnerButton extends MacAutoRepeatButton {


  public MacSpinnerButton (Icon icon) {
    super(icon);
  }

  public boolean isFocusTraversable() {  // here to prevent focus aquisition
    return false;
  }
  public void requestFocus() {} // stubbed to prevent focus aquisition
}


abstract class SpinnerAdaptor implements ActionListener {

  protected Spinner spinner;

  public SpinnerAdaptor(Spinner s) {
    spinner = s;
  }

}

class SpinnerIncrementer extends SpinnerAdaptor {


  public SpinnerIncrementer(Spinner s) {
    super(s);
  }

  public void actionPerformed(ActionEvent e) {
      int value = spinner.getValue();
      int inc = spinner.getUnitIncrement();
      value += inc;
      spinner.setValue(value);
  }
}

class SpinnerDecrementer extends SpinnerAdaptor {

  public SpinnerDecrementer(Spinner s) {
    super(s);
  }

  public void actionPerformed(ActionEvent e) {
     int value = spinner.getValue();
      int inc = spinner.getUnitIncrement();
      value -= inc;
      spinner.setValue(value);
  }
}
