/*
 * @(#)MacSliderUI.java	1.8 98/02/02
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */
 
package com.sun.java.swing.plaf.mac;

import com.sun.java.swing.plaf.basic.BasicSliderUI;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Point;
import java.awt.Insets;
import java.awt.Color;
import java.io.Serializable;
import java.awt.IllegalComponentStateException;
import java.awt.Polygon;
import java.beans.*;

import java.awt.event.MouseListener;
import java.awt.event.MouseEvent;

import com.sun.java.swing.border.AbstractBorder;

import com.sun.java.swing.*;
import com.sun.java.swing.event.*;
import com.sun.java.swing.plaf.*;

/**
 * Mac Slider
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version @(#)MacSliderUI.java	1.0 11/24/97
 * @author Symantec
 */
public class MacSliderUI extends BasicSliderUI implements MouseListener
{
	// Enabled state
	private static final int ENABLED = 0;
	private static final int PRESSED = 1;
	private static final int DISABLED = 2;

	// Orientation
	private static final int CENTER = 0;
	private static final int RIGHT = 1;
	private static final int DOWN = 1;

	private static final int TICK_LENGTH = 8;
	private static final int TRACK_OVERHANG = 4;	// The track hangs past the thumb by this much at each end
	private static final int TRACK_WIDTH = 7;

	private static final int PREFERRED_LENGTH = 164;

	private static ImageIcon[][][] indicatorIcons = null;
	private static Color tickColorEnabled;
	private static Color tickColorDisabled;
	private static Color tickHilite;
	private static Color tickShadow;

	private static Color trackBorderEnabled;
	private static Color trackFillEnabled;
	private static Color trackBorderDisabled;
	private static Color trackFillDisabled;
	private static Color trackBevelIn;
	private static Color trackBevelOut;

	private boolean drawSliderPressed = false;

	protected ActivationHelper activationHelper;
	protected ChangeListener changeListener;
	protected boolean isActive = true;

    public static ComponentUI createUI(JComponent c)
    {
        return new MacSliderUI((JSlider) c);
    }

    public MacSliderUI(JSlider c)
    {
        super(c);
    }

    public void installUI( JComponent c )
    {
        if (indicatorIcons == null)
        {
        	indicatorIcons = new ImageIcon[2][3][2];
        	
			indicatorIcons[JSlider.HORIZONTAL][ENABLED][CENTER]	= (ImageIcon) UIManager.getIcon("Slider.indicatorHorizontalEnabled");
			AppearanceFilter.FilterImageIcon(c,indicatorIcons[JSlider.HORIZONTAL][ENABLED][CENTER]);
			indicatorIcons[JSlider.HORIZONTAL][ENABLED][DOWN]	= (ImageIcon) UIManager.getIcon("Slider.indicatorHorizontalDownEnabled");
			AppearanceFilter.FilterImageIcon(c,indicatorIcons[JSlider.HORIZONTAL][ENABLED][DOWN]);
			indicatorIcons[JSlider.HORIZONTAL][PRESSED][CENTER]	= (ImageIcon) UIManager.getIcon("Slider.indicatorHorizontalPressed");
			AppearanceFilter.FilterImageIcon(c,indicatorIcons[JSlider.HORIZONTAL][PRESSED][CENTER]);
			indicatorIcons[JSlider.HORIZONTAL][PRESSED][DOWN]	= (ImageIcon) UIManager.getIcon("Slider.indicatorHorizontalDownPressed");
			AppearanceFilter.FilterImageIcon(c,indicatorIcons[JSlider.HORIZONTAL][PRESSED][DOWN]);
			indicatorIcons[JSlider.HORIZONTAL][DISABLED][CENTER]= (ImageIcon) UIManager.getIcon("Slider.indicatorHorizontalDisabled");
			indicatorIcons[JSlider.HORIZONTAL][DISABLED][DOWN]	= (ImageIcon) UIManager.getIcon("Slider.indicatorHorizontalDownDisabled");

			indicatorIcons[JSlider.VERTICAL][ENABLED][CENTER]	= (ImageIcon) UIManager.getIcon("Slider.indicatorVerticalEnabled");
			AppearanceFilter.FilterImageIcon(c,indicatorIcons[JSlider.VERTICAL][ENABLED][CENTER]);
			indicatorIcons[JSlider.VERTICAL][ENABLED][RIGHT]	= (ImageIcon) UIManager.getIcon("Slider.indicatorVerticalRightEnabled");
			AppearanceFilter.FilterImageIcon(c,indicatorIcons[JSlider.VERTICAL][ENABLED][RIGHT]);
			indicatorIcons[JSlider.VERTICAL][PRESSED][CENTER]	= (ImageIcon) UIManager.getIcon("Slider.indicatorVerticalPressed");
			AppearanceFilter.FilterImageIcon(c,indicatorIcons[JSlider.VERTICAL][PRESSED][CENTER]);
			indicatorIcons[JSlider.VERTICAL][PRESSED][RIGHT]	= (ImageIcon) UIManager.getIcon("Slider.indicatorVerticalRightPressed");
			AppearanceFilter.FilterImageIcon(c,indicatorIcons[JSlider.VERTICAL][PRESSED][RIGHT]);
			indicatorIcons[JSlider.VERTICAL][DISABLED][CENTER]	= (ImageIcon) UIManager.getIcon("Slider.indicatorVerticalDisabled");
			indicatorIcons[JSlider.VERTICAL][DISABLED][RIGHT]	= (ImageIcon) UIManager.getIcon("Slider.indicatorVerticalRightDisabled");

 
			tickColorEnabled = UIManager.getColor("Slider.tickColorEnabled");
			tickColorDisabled = UIManager.getColor("Slider.tickColorDisabled");
			tickHilite = UIManager.getColor("Slider.tickHilite");
			tickShadow = UIManager.getColor("Slider.tickShadow");

			trackBorderEnabled = UIManager.getColor("Slider.trackBorderEnabled");
			trackFillEnabled = UIManager.getColor("Slider.trackFillEnabled");
			trackBorderDisabled = UIManager.getColor("Slider.trackBorderDisabled");
			trackFillDisabled = UIManager.getColor("Slider.trackFillDisabled");
			trackBevelIn = UIManager.getColor("Slider.trackBevelIn");
			trackBevelOut = UIManager.getColor("Slider.trackBevelOut");
		}

        super.installUI( c );
        recalcTrackBuffer();

		c.addMouseListener(this);
		activationHelper	= new ActivationHelper(c);
		changeListener		= new ChangeListener();
		activationHelper.addPropertyChangeListener(changeListener);
    }

    public void uninstallUI( JComponent c )
    {
		super.uninstallUI( c );
	
		c.removeMouseListener(this);
		activationHelper.removePropertyChangeListener(changeListener);
		activationHelper = null;
		changeListener = null;
    }
	
    public boolean isActive()
    {
    	return isActive;
    }

	public Dimension getPreferredHorizontalSize()
	{
		return new Dimension(PREFERRED_LENGTH, getCurrentThumbDimensions().height + 1);
	}
	
	public Dimension getPreferredVerticalSize()
	{
		return new Dimension(getCurrentThumbDimensions().width + 1, PREFERRED_LENGTH);
	}
	
	public Dimension getMinimumHorizontalSize()
	{
		Dimension dim = getCurrentThumbDimensions();
		return new Dimension((TRACK_OVERHANG * 2) + dim.width, dim.height + 1);
	}
	
	public Dimension getMinimumVerticalSize()
	{
		Dimension dim = getCurrentThumbDimensions();
		return new Dimension(dim.width + 1, (TRACK_OVERHANG * 2) + dim.height);
	}

	protected void recalcTrackBuffer()
	{
		super.recalcTrackBuffer();

		// Now, adjust for the overhang area (because the slider extends past the thumb)
		trackBuffer += TRACK_OVERHANG;
	}

    public void paintThumb(Graphics g)
	{
		Rectangle knobBounds = getThumbRect();

		getCurrentThumbImage().paintIcon(slider, g, knobBounds.x, knobBounds.y);
	}

    public void paintTrack(Graphics g)
    {
		Rectangle trackBounds = getScrollTrackRect();

		Color upperRightColor;
		Color trackBorderColor;
		Color trackFillColor;

		if (slider.getOrientation() == JSlider.HORIZONTAL)
		{
			trackBounds.y += (trackBounds.height - TRACK_WIDTH) / 2;
			trackBounds.height = TRACK_WIDTH;
			
			upperRightColor = trackBevelIn;
		}
		else
		{
			trackBounds.x += (trackBounds.width - TRACK_WIDTH) / 2;
			trackBounds.width = TRACK_WIDTH;
			
			upperRightColor = trackBevelOut;
		}

		g.translate(trackBounds.x, trackBounds.y);

		if (slider.isEnabled() && isActive)
		{
			//
			// Draw the Bevel around the track if the slider is enabled
			//

			// Draw beveled-in edges:
			g.setColor(trackBevelIn);
			
			// upper-left edge
			g.drawLine(1, 0, trackBounds.width - 2, 0);
			g.drawLine(0, 1, 1, 1);
			g.drawLine(0, 2, 0, trackBounds.height - 2);

			// upper-right edge
			g.setColor(upperRightColor);
			g.drawLine(trackBounds.width - 1, 1, trackBounds.width - 1, 1);

			// Draw beveled-out edges:
			g.setColor(trackBevelOut);

			// lower-left edge
			g.drawLine(1, trackBounds.height - 1, 1, trackBounds.height - 1);
			g.drawLine(2, trackBounds.height, trackBounds.width - 1, trackBounds.height);
	
			// lower-right edge
			g.drawLine(trackBounds.width - 1, trackBounds.height - 1, trackBounds.width, trackBounds.height - 1);
			g.drawLine(trackBounds.width, 2, trackBounds.width, trackBounds.height - 2);

			trackBorderColor = trackBorderEnabled;
			trackFillColor = trackFillEnabled;
		}
		else
		{
			trackBorderColor = trackBorderDisabled;
			trackFillColor = trackFillDisabled;
		}

		// Draw boundary
		g.setColor(trackBorderColor);
		g.drawLine(2, 1, trackBounds.width - 2, 1);												// Top
		g.drawLine(1, 2, 1, trackBounds.height - 2);											// Left
		g.drawLine(trackBounds.width - 1, 2, trackBounds.width - 1, trackBounds.height - 2);	// Bottom
		g.drawLine(2, trackBounds.height - 1, trackBounds.width - 2, trackBounds.height - 1);	// Right

		// Draw fill
		g.setColor(trackFillColor);
		g.fillRect(2, 2, trackBounds.width - 4, trackBounds.height - 4);

		g.translate(-trackBounds.x, -trackBounds.y);
    }

    protected void paintMinorTickForHorizSlider( Graphics g, Rectangle tickBounds, int x )
    {
		g.setColor(slider.isEnabled() && isActive ? tickColorEnabled : tickColorDisabled);
        g.drawLine( x, 0, x, 2 );
    }

    protected void paintMajorTickForHorizSlider( Graphics g, Rectangle tickBounds, int x )
    {
        paintTick( g, x, 0, x, TICK_LENGTH - 1, slider.isEnabled());
    }

    protected void paintMinorTickForVertSlider( Graphics g, Rectangle tickBounds, int y )
    {
		g.setColor(slider.isEnabled() && isActive ? tickColorEnabled : tickColorDisabled);
        g.drawLine( 0, y, 2, y );
    }

    protected void paintMajorTickForVertSlider( Graphics g, Rectangle tickBounds, int y )
    {
        paintTick( g, 1, y, TICK_LENGTH - 1, y, slider.isEnabled() );
    }

	private void paintTick(Graphics g, int x, int y, int endX, int endY, boolean isEnabled)
	{
		if (isEnabled && isActive)
		{
			// Draw top left hilite
			g.setColor(tickHilite);
			g.drawLine(x - 1, y - 1, endX, y - 1);			// top hilite
			g.drawLine(x - 1, y, x - 1, endY);				// left hilite
			
			// Draw the tick
			g.setColor(tickColorEnabled);
			g.drawLine(x, y, endX, endY);

			// Draw bottom right shadow
			g.setColor(tickShadow);
			g.drawLine(x, endY + 1, endX + 1, endY + 1);	// bottom shadow
			g.drawLine(endX + 1, y, endX + 1, endY);		// right shadow
		}
		else
		{
			// Draw the tick
			g.setColor(tickColorDisabled);
			g.drawLine(x, y, endX, endY);
		}
	}

	public void paintFocus(Graphics g) {}
	              		  
	/**
	  * Subclasses of BasicSliderUI override this method to determine their own
	  * thumb size.
	  */
	public void calculateThumbBounds()
	{
		int thumbX;
		int thumbY;
		Dimension dim = getCurrentThumbDimensions();
		Rectangle trackRect = getScrollTrackRect();

		if ( slider.getOrientation() == JSlider.HORIZONTAL ) {
			thumbX = xPositionForValue(slider.getValue()) - (dim.width / 2);
			thumbY = (trackRect.y + trackRect.height) - dim.height;
		} else {
			thumbX = (trackRect.x + trackRect.width) - dim.width;
			thumbY = yPositionForValue(slider.getValue()) - (dim.height / 2);
		}

		setThumbBounds(thumbX, thumbY, dim.width, dim.height);
	}

	public int getTickSpace()
    {
    	return TICK_LENGTH;
    }
    
    /**
     * Gets the height of the tick area for horizontal sliders and the width of the
     * tick area for vertical sliders.  BasicSliderUI uses the returned value to
     * determine the bounds of the tray rectangle and the tick area rectangle.
     */
    public int getTickSize()
    {
    	return TICK_LENGTH;
    }

    public void scrollByBlock(int direction)
    {
		synchronized(slider)
		{
			int oldValue = slider.getValue();
			int blockIncrement = slider.getMajorTickSpacing();
			if (blockIncrement == 0)
				blockIncrement = slider.getMinorTickSpacing();
			if (blockIncrement == 0)
				blockIncrement = 1;
			int delta = blockIncrement * ((direction > 0) ? POSITIVE_SCROLL : NEGATIVE_SCROLL);
		
			slider.setValue(oldValue + delta);			
		}
	}

	private Icon getCurrentThumbImage()
	{
		int orientation = slider.getOrientation();
		int enabled = slider.isEnabled() && isActive ? (drawSliderPressed ? PRESSED : ENABLED) : DISABLED;
		int pointer = slider.getPaintTicks() ? RIGHT /* == DOWN */ : CENTER;

		return indicatorIcons[orientation][enabled][pointer];
	}

	private Dimension getCurrentThumbDimensions()
	{
		int orientation = slider.getOrientation();
		int pointer = slider.getPaintTicks() ? RIGHT /* == DOWN */ : CENTER;

		Icon img = indicatorIcons[orientation][DISABLED][pointer];
		return new Dimension(img.getIconWidth(), img.getIconHeight());
	}
	
    class ChangeListener implements java.beans.PropertyChangeListener
    {
		public void propertyChange(java.beans.PropertyChangeEvent evt)
		{
			if(evt.getPropertyName().equals("activated"))
			{
				boolean oldActive = isActive;
				isActive = ((Boolean) evt.getNewValue()).booleanValue();
				if(isActive != oldActive)
				{
					Object obj = evt.getSource();
					if(obj instanceof ActivationHelper)
					{
						((ActivationHelper)obj).getComponent().repaint();
					}
				}
			}
		}
    }

	/* MouseListener functions */

    public void mouseEntered(MouseEvent e) {}
 
    public void mouseExited(MouseEvent e) {}

    public void mouseClicked(MouseEvent e) {}

	public void mousePressed(MouseEvent e)
	{
		if (slider.getValueIsAdjusting())
		{
			drawSliderPressed = true;
			slider.repaint(getThumbRect());	// Paint the slider correctly
		}
	}

	public void mouseReleased(MouseEvent e)
	{
		if (drawSliderPressed)
		{
			drawSliderPressed = false;
			slider.repaint(getThumbRect());	// Paint the slider correctly
		}
	}
}
