/*
 * @(#)MacSeparatorUI.java	1.5 98/02/06
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */
 
 
package com.sun.java.swing.plaf.mac;

import com.sun.java.swing.*;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import com.sun.java.swing.plaf.*;
import java.io.Serializable;

/**
 * A Mac L&F implementation of SeparatorUI.  This implementation 
 * is a "combined" view/controller.
 *
 * @version @(#)MacSeparatorUI.java	1.0 11/24/97
 * @author Symantec
 */

public class MacSeparatorUI extends SeparatorUI implements Serializable
{
    public static ComponentUI createUI(JComponent x) {
	return new MacSeparatorUI();
    }
    public void installUI(JComponent c) {
    }
    public void uninstallUI(JComponent c) {
    }

    public void paint(Graphics g, JComponent c) {
		Dimension s = c.getSize();

		Color oldColor = g.getColor();	// Make no net change to g

		g.setColor(MacUtilities.GrayscaleAppearance7);
		g.drawLine(0, 2, s.width-1, 2);
	
		g.setColor(MacUtilities.GrayscaleAppearanceW);
		g.drawLine(1, 3, s.width, 3);
	
		g.setColor(oldColor);
    }

	public Dimension getPreferredSize(JComponent c) { 
		return new Dimension(0, 6);
	}

    public Dimension getMinimumSize(JComponent c) { return null;}
    public Dimension getMaximumSize(JComponent c) { return null;}
    public Insets getInsets(JComponent c) { return null;}
}
