/*
 * @(#)MacScrollBarUI.java	1.6 98/02/02
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */
 
package com.sun.java.swing.plaf.mac;

import com.sun.java.swing.*;
import com.sun.java.swing.event.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.basic.BasicScrollBarUI;

import java.awt.event.MouseListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;

import java.awt.Container;
import java.awt.Window;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Graphics;
import java.awt.Color;

/**
 * Implementation of ScrollBarUI for the Mac Look and Feel
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version @(#)MacScrollBarUI.java	1.0 11/24/97
 * @author Symantec
 */
public class MacScrollBarUI extends BasicScrollBarUI implements MouseListener
{
	private static boolean scrollBarColorsInitialized = false;
	
	private static Color scrollBarBackgroundEnabled;
	private static Color scrollBarBackgroundDisabled;

	private static Color scrollBarBorderActive;
	private static Color scrollBarBorderInactive;

	private static Color scrollBarBevelIn1;
	private static Color scrollBarBevelIn2;
	private static Color scrollBarBevelCorner;
	private static Color scrollBarBevelOut2;
	private static Color scrollBarBevelOut1;

	private static ImageIcon scrollBoxVerticalEnabled;
	private static ImageIcon scrollBoxVerticalPressed;
	private static ImageIcon scrollBoxHorizontalEnabled;
	private static ImageIcon scrollBoxHorizontalPressed;

	private static Dimension scrollBoxVerticalSize;
	private static Dimension scrollBoxHorizontalSize;

	private boolean drawScrollBoxPressed = false;
	private ImageIcon scrollBoxEnabled;
	private ImageIcon scrollBoxPressed;

	private Dimension scrollBoxSize = new Dimension(16, 16);	// Defaults
    private Rectangle thumbBevel = new Rectangle(0, 0, 0, 0);
    
	protected ActivationHelper activationHelper;
	protected ChangeListener changeListener;
	protected boolean isActive = true;

	public static ComponentUI createUI(JComponent c)
	{
		return new MacScrollBarUI();
	}
	
	public void installUI(JComponent c)
	{
		super.installUI(c);

		c.addMouseListener(this);
		activationHelper	= new ActivationHelper(c);
		changeListener		= new ChangeListener();
		activationHelper.addPropertyChangeListener(changeListener);
	}
	
	public void uninstallUI(JComponent c)
	{
		c.removeMouseListener(this);
		activationHelper.removePropertyChangeListener(changeListener);
		activationHelper = null;
		changeListener = null;

		super.uninstallUI(c);
	}
	
    public boolean isActive()
    {
    	return isActive;
    }

	protected void configureScrollBarColors()
	{
		if (!scrollBarColorsInitialized)
		{
			scrollBarBackgroundEnabled = UIManager.getColor("ScrollBar.backgroundEnabled");
			scrollBarBackgroundDisabled = UIManager.getColor("ScrollBar.backgroundDisabled");

			scrollBarBorderActive = UIManager.getColor("ScrollBar.borderActive");
			scrollBarBorderInactive = UIManager.getColor("ScrollBar.borderInactive");

			scrollBarBevelIn1 = UIManager.getColor("ScrollBar.bevelIn1");
			scrollBarBevelIn2 = UIManager.getColor("ScrollBar.bevelIn2");
			scrollBarBevelCorner = UIManager.getColor("ScrollBar.bevelCorner");
			scrollBarBevelOut2 = UIManager.getColor("ScrollBar.bevelOut2");
			scrollBarBevelOut1 = UIManager.getColor("ScrollBar.bevelOut1");

			scrollBoxVerticalEnabled = (ImageIcon) UIManager.getIcon("ScrollBar.verticalBoxEnabled");
			scrollBoxVerticalPressed = (ImageIcon) UIManager.getIcon("ScrollBar.verticalBoxPressed");
			scrollBoxHorizontalEnabled = (ImageIcon) UIManager.getIcon("ScrollBar.horizontalBoxEnabled");
			scrollBoxHorizontalPressed = (ImageIcon) UIManager.getIcon("ScrollBar.horizontalBoxPressed");

			scrollBoxVerticalSize = new Dimension(scrollBoxVerticalEnabled.getIconWidth(), scrollBoxVerticalEnabled.getIconHeight());
			scrollBoxHorizontalSize = new Dimension(scrollBoxHorizontalEnabled.getIconWidth(), scrollBoxHorizontalEnabled.getIconHeight());

			AppearanceFilter.FilterImageIcon(scrollbar, scrollBoxVerticalEnabled);
			AppearanceFilter.FilterImageIcon(scrollbar, scrollBoxVerticalPressed);
			AppearanceFilter.FilterImageIcon(scrollbar, scrollBoxHorizontalEnabled);
			AppearanceFilter.FilterImageIcon(scrollbar, scrollBoxHorizontalPressed);

			scrollBarColorsInitialized = true;
		}

		switch (scrollbar.getOrientation())
		{
			case JScrollBar.VERTICAL:
				scrollBoxEnabled = scrollBoxVerticalEnabled;
				scrollBoxPressed = scrollBoxVerticalPressed;
				scrollBoxSize.setSize(scrollBoxVerticalSize);
				break;
			
			case JScrollBar.HORIZONTAL:
				scrollBoxEnabled = scrollBoxHorizontalEnabled;
				scrollBoxPressed = scrollBoxHorizontalPressed;
				scrollBoxSize.setSize(scrollBoxHorizontalSize);
				break;
		}
	}
	
	public Dimension getPreferredSize(JComponent c)
	{
		Insets insets = c.getInsets();
		int dx = insets.left + insets.right;
		int dy = insets.top + insets.bottom;
		return (scrollbar.getOrientation() == JScrollBar.VERTICAL)
			? new Dimension(dx + 16, dy + 32)
			: new Dimension(dx + 32, dy + 16);
	}
	
	protected Dimension getMinimumThumbSize()
	{
		return scrollBoxSize;
	}
	
	protected Dimension getMaximumThumbSize()
	{
		return scrollBoxSize;
	}

    /**
     * Set the bounds of the thumb and force a repaint that includes
     * the old thumbBounds and the new one.
     * Overridden to repaint the Thumb's bevel
     *
     * @see #getThumbBounds
     */
    protected void setThumbBounds(int x, int y, int width, int height)
    {
    	Rectangle oldThumbBevel = new Rectangle(thumbBevel);

		super.setThumbBounds(x, y, width, height);

    	if (!oldThumbBevel.isEmpty())
    		scrollbar.repaint(oldThumbBevel);		// Un paint the existing thumb Bevel

		/* Calculate the new thumb Bevel
		*/
		if (scrollbar.getOrientation() == JScrollBar.VERTICAL)
		{
			y += height;
			if (y + 2 > incrButton.getY())
				height = 0;
			else
				height = 2;
		}
		else
		{
			x += width;
			if (x + 2 > incrButton.getX())
				width = 0;
			else
				width = 2;
		}
		thumbBevel.setBounds(x, y, width, height);

    	if (!thumbBevel.isEmpty())
    		scrollbar.repaint(thumbBevel);		// Paint the new thumb Bevel
    }
	
	protected JButton createDecreaseButton(int orientation)
	{
		return new ScrollBarButton(orientation);
	} 
	
	protected JButton createIncreaseButton(int orientation)
	{
		return new ScrollBarButton(orientation);
	}
	
	private void paintVerticalContentBevel(Graphics g, int x, int y, int width, int height)
	{
        g.translate(x, y);

        g.setColor(scrollBarBevelIn1);
        g.drawLine(0, 0, width-1, 0);
        g.drawLine(0, 1, 0, height);

        g.setColor(scrollBarBevelIn2);
        g.drawLine(1, 1, width-2, 1);
        g.drawLine(1, 2, 1, height);

        g.setColor(scrollBarBevelCorner);
        g.drawLine(width, 0, width, 0);
        g.drawLine(width-1, 1, width-1, 1);

        g.setColor(scrollBarBevelOut2);
        g.drawLine(width-1, 2, width-1, height);
        
        g.setColor(scrollBarBevelOut1);
        g.drawLine(width, 1, width, height);

        g.translate(-x, -y);
	}

	private void paintHorizontalContentBevel(Graphics g, int x, int y, int width, int height)
	{
        g.translate(x, y);

        g.setColor(scrollBarBevelIn1);
        g.drawLine(0, 0, width, 0);
        g.drawLine(0, 1, 0, height-1);

        g.setColor(scrollBarBevelIn2);
        g.drawLine(1, 1, width, 1);
        g.drawLine(1, 2, 1, height-2);

        g.setColor(scrollBarBevelCorner);
        g.drawLine(1, height-1, 1, height-1);
        g.drawLine(0, height, 0, height);

        g.setColor(scrollBarBevelOut2);
        g.drawLine(2, height, width, height);
        
        g.setColor(scrollBarBevelOut1);
        g.drawLine(1, height, width, height);

        g.translate(-x, -y);
	}

	protected void paintBackground(Graphics g, JComponent c)
	{
		g.setColor(c.getBackground());
		g.fillRect(0,0,c.getWidth(),c.getHeight());

		// Determine the coordinates of the control area of the scroll bar.
		Insets insets = scrollbar.getInsets();
		int x = insets.left;
		int y = insets.top;
		int w = scrollbar.getWidth() - insets.right - x - 1;
		int h = scrollbar.getHeight() - insets.bottom - y - 1;
		
		if (!isActive)
		{
			g.setColor(scrollBarBackgroundDisabled);
			g.fillRect(x, y, w, h);

			g.setColor(scrollBarBorderInactive);
			g.drawRect(x, y, w, h);
		}
		else
		{
			// Paint the border
			g.setColor(scrollBarBorderActive);
			g.drawRect(x, y, w, h);

			x += 1;
			y += 1;
			w -= 2;
			h -= 2;

			if (scrollbar.isEnabled() && (scrollbar.getValue() >= 0) && (scrollbar.getMinimum() < scrollbar.getMaximum()))
			{
				// First, fill the scrollbar with the background color
				g.setColor(scrollBarBackgroundEnabled);
				g.fillRect(x, y, w, h);

				Rectangle thumbR = getThumbBounds();

				// Draw Top & Bottom background area
				if (scrollbar.getOrientation() == JScrollBar.VERTICAL)
				{
					int topY = decrButton.getY() + decrButton.getHeight();
				    int topHeight = thumbR.y - topY;
				    if (topHeight > 0)
				    	paintVerticalContentBevel(g, x, topY, w, topHeight);

					int botY = thumbR.y + thumbR.height;
				    int botHeight = incrButton.getY() - botY;
				    if (botHeight > 0)
				    	paintVerticalContentBevel(g, x, botY, w, botHeight);
				} 
				// Draw Left & Right background area
				else
				{
					int leftX = decrButton.getX() + decrButton.getWidth();
				    int leftWidth = thumbR.x - leftX;
				    if (leftWidth > 0)
				    	paintHorizontalContentBevel(g, leftX, y, leftWidth, h);

					int rightX = thumbR.x + thumbR.width;
				    int rightWidth = incrButton.getX() - rightX;
				    if (rightWidth > 0)
				    	paintHorizontalContentBevel(g, rightX, y, rightWidth, h);
				}
			}
			else
			{
				g.setColor(scrollBarBackgroundDisabled);
				g.fillRect(x, y, w, h);
			}
		}
	}

	public void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {}
	
	public void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds)
	{        
		if (thumbBounds.isEmpty() || !isActive || !scrollbar.isEnabled() || (scrollbar.getMinimum() >= scrollbar.getMaximum()))
			return;

		Icon img = drawScrollBoxPressed ? scrollBoxPressed : scrollBoxEnabled;
		img.paintIcon(c, g, thumbBounds.x, thumbBounds.y);
	}

    class ChangeListener implements java.beans.PropertyChangeListener
    {
		public void propertyChange(java.beans.PropertyChangeEvent evt)
		{
			if(evt.getPropertyName().equals("activated"))
			{
				boolean oldActive = isActive;
				isActive = ((Boolean) evt.getNewValue()).booleanValue();
				if(isActive != oldActive)
				{
					Object obj = evt.getSource();
					if(obj instanceof ActivationHelper)
					{
						((ActivationHelper)obj).getComponent().repaint();
					}
				}
			}
		}
    }

	/* MouseListener functions */

    public void mouseEntered(MouseEvent e) {}
 
    public void mouseExited(MouseEvent e) {}

    public void mouseClicked(MouseEvent e) {}

	public void mousePressed(MouseEvent e)
	{
		if (isDragging)
		{
			drawScrollBoxPressed = true;
			scrollbar.repaint(getThumbBounds());	// Paint the Thumb correctly
		}
	}
	
	public void mouseReleased(MouseEvent e)
	{
		if (drawScrollBoxPressed)
		{
			drawScrollBoxPressed = false;
			scrollbar.repaint(getThumbBounds());	// Paint the Thumb correctly
		}
	}
	
	class ScrollBarButton extends JButton implements SwingConstants
	{
		private int direction = NORTH;
		private Icon scrollArrowDisabled;
		private Icon scrollArrowEnabled;
		private Icon scrollArrowPressed;
	
		public ScrollBarButton(int direction)
		{
			switch (direction) {
			case NORTH:
				scrollArrowDisabled = UIManager.getIcon("ScrollBar.upArrowDisabled");
				scrollArrowEnabled = UIManager.getIcon("ScrollBar.upArrowEnabled");
				scrollArrowPressed = UIManager.getIcon("ScrollBar.upArrowPressed");
				break;
			case SOUTH:
				scrollArrowDisabled = UIManager.getIcon("ScrollBar.downArrowDisabled");
				scrollArrowEnabled = UIManager.getIcon("ScrollBar.downArrowEnabled");
				scrollArrowPressed = UIManager.getIcon("ScrollBar.downArrowPressed");
				break;
			case EAST:
				scrollArrowDisabled = UIManager.getIcon("ScrollBar.rightArrowDisabled");
				scrollArrowEnabled = UIManager.getIcon("ScrollBar.rightArrowEnabled");
				scrollArrowPressed = UIManager.getIcon("ScrollBar.rightArrowPressed");
				break;
			case WEST:
				scrollArrowDisabled = UIManager.getIcon("ScrollBar.leftArrowDisabled");
				scrollArrowEnabled = UIManager.getIcon("ScrollBar.leftArrowEnabled");
				scrollArrowPressed = UIManager.getIcon("ScrollBar.leftArrowPressed");
				break;
			default:
				throw new IllegalArgumentException("invalid direction");
			}
			this.direction = direction;
			
			setRequestFocusEnabled(false);
			setOpaque(true);
		}
		
		public Dimension getPreferredSize()
		{
			return new Dimension(16, 16);
		}
		
		public Dimension getMinimumSize()
		{
			return getPreferredSize();
		}
		
		public Dimension getMaximumSize()
		{
			return getPreferredSize();
		}
		
		public boolean isFocusTraversable()
		{
			return false;
		}
		
		public void paint(Graphics g) 
		{
			if (isActive)
			{
				boolean isPressed = getModel().isPressed();
				boolean isEnabled = isEnabled();
				Icon img;
		
				if (isPressed)
					img = scrollArrowPressed;
				else if (isEnabled)
					img = scrollArrowEnabled;
				else
					img = scrollArrowDisabled;
			
				img.paintIcon(this, g, 0 /*x*/, 0 /*y*/);
			}
		}
	}
}
