/*
 * @(#)MacRadioButtonUI.java	1.7 98/02/02
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */
 
package com.sun.java.swing.plaf.mac;

import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.basic.BasicRadioButtonUI;

import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.plaf.*;
import java.io.Serializable;

/**
 * RadioButtonUI implementation for BasicRadioButtonUI
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version @(#)MacRadioButtonUI.java	1.0 11/24/97
 * @author Symantec
 */
public class MacRadioButtonUI extends BasicRadioButtonUI
{
	protected ActivationHelper activationHelper;
	protected ChangeListener changeListener;
	protected boolean isActive = true;

	public static ComponentUI createUI(JComponent c)
	{
        return new MacRadioButtonUI();
	}

    public boolean isActive()
    {
    	return isActive;
    }

	/************************** The View *************************/
	

	/**
	 * paint the radio button
	 */
	public synchronized void paint(Graphics g, JComponent c)
	{
		AbstractButton b = (AbstractButton) c;
		ButtonModel model = b.getModel();
		
		Dimension size = c.getSize();
		
		int w = size.width;
		int h = size.height;
		
		Font f = c.getFont();
		g.setFont(f);
		FontMetrics fm = g.getFontMetrics();
		
		Rectangle viewRect = new Rectangle(size);
		Rectangle iconRect = new Rectangle();
		Rectangle textRect = new Rectangle();
		Insets i = c.getInsets();
		
		viewRect.x += i.left;
		
		Icon altIcon = b.getIcon();
		Icon selectedIcon = null;
		Icon disabledIcon = null;
		
		String text = SwingUtilities.layoutCompoundLabel(
							fm, b.getText(), altIcon != null ? altIcon : icon,
							b.getVerticalAlignment(), b.getHorizontalAlignment(),
							b.getVerticalTextPosition(), b.getHorizontalTextPosition(),
							viewRect, iconRect, textRect, getDefaultTextIconGap(b)
						);
		
		// fill background
		if (c.isOpaque())
		{
			g.setColor(b.getBackground());
			g.fillRect(0,0, size.width, size.height); 
		}
		
		
		// Paint the radio button
		if (altIcon != null)
		{ 
			
			if (!model.isEnabled() || !isActive)
			{
				altIcon = b.getDisabledIcon();
			}
			else if (model.isPressed() && model.isArmed())
			{
				altIcon = b.getPressedIcon();
				if (altIcon == null)
				{
					// Use selected icon
					altIcon = b.getSelectedIcon();
				} 
			}
			else if (model.isSelected())
			{
				altIcon = b.getSelectedIcon();
			}
			else if (b.isRolloverEnabled() && model.isRollover())
			{
				altIcon = (Icon) b.getRolloverIcon();
			} 
			
			if (altIcon == null)
			{
				altIcon = b.getIcon();
			}
			
			altIcon.paintIcon(c, g, iconRect.x, iconRect.y);

		}
		else
		{
			icon.paintIcon(c, g, iconRect.x, iconRect.y);
		}
		
		
		// Draw the Text
		if (text != null)
		{

			if (model.isEnabled() && isActive)
			{
				// *** paint the text normally
				g.setColor(b.getForeground());
			}
			else
			{
				// *** paint the text disabled
				g.setColor(UIManager.getColor("Control.disabledForeground"));
			}
			g.drawString(text, textRect.x, textRect.y + fm.getAscent());

			if (b.hasFocus() && b.isFocusPainted() && textRect.width > 0 && textRect.height > 0 )
			{
				paintFocus(g,textRect,size);
			}
		}
	}

	protected void installListeners(JComponent c)
	{
		super.installListeners(c);
		
		activationHelper	= new ActivationHelper(c);
		changeListener		= new ChangeListener();
		activationHelper.addPropertyChangeListener(changeListener);
	}
	
	protected void uninstallListeners(JComponent c)
	{
		super.uninstallListeners(c);
		activationHelper.removePropertyChangeListener(changeListener);
		activationHelper = null;
		changeListener = null;
	}

    class ChangeListener implements java.beans.PropertyChangeListener
    {
		public void propertyChange(java.beans.PropertyChangeEvent evt)
		{
			if(evt.getPropertyName().equals("activated"))
			{
				boolean oldActive = isActive;
				isActive = ((Boolean) evt.getNewValue()).booleanValue();
				if(isActive != oldActive)
				{
					Object obj = evt.getSource();
					if(obj instanceof ActivationHelper)
					{
						((ActivationHelper)obj).getComponent().repaint();
					}
				}
			}
		}
    }
}
