/*
 * @(#)MacProgressBarUI.java	1.6 98/02/02
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */
 
package com.sun.java.swing.plaf.mac;

import java.awt.*;
import com.sun.java.swing.*;
import com.sun.java.swing.event.*;
import com.sun.java.swing.plaf.*;
import java.io.Serializable;

import com.sun.java.swing.plaf.basic.BasicProgressBarUI;


/**
 * A Mac ProgressBarUI.  
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version @(#)MacProgressBarUI.java	1.0 11/24/97
 * @author Symantec
 * @author David Bustin
 */
public class MacProgressBarUI extends BasicProgressBarUI
{
  private ImageIcon determHeadIcon;
  private ImageIcon determLeftIcon;
  private ImageIcon determTopIcon;
  private ImageIcon determBottomIcon;

  private Color progressBarForeground;
  private Color progressBarOuter5;
  private Color progressBarOuterW;
  private Color progressBarInner1;
  private Color progressBarInner2;
  private Color progressBarInner3;
  private Color progressBarInner4;
  private Color progressBarInner5;
  private Color progressBarInner7;
  private Color progressBarInner8;
  private Color progressBarInner10;
  private Color progressBarInner12;
  private Color progressBarEdge;
  private Color progressBarDisabledEdge;

  static protected final Dimension PREFERRED_INNER_HORIZONTAL 
                                   = new Dimension(146, 14);
  
  static protected final Dimension PREFERRED_INNER_VERTICAL
                                   = new Dimension(14, 146);

  // Space between border and progress bar
  static protected final int BORDER_BUFFER = 0;

  static protected final int CELL_SPACING = 0;
  static protected final int CELL_LENGTH = 4;
  static protected final int LEFT_CELL_LENGTH = 4;
  static protected final int CELL_HEIGHT = 4;
  static protected final int BOTTOM_CELL_HEIGHT = 4;
  
  protected ActivationHelper activationHelper;
  protected ChangeListener changeListener;
  protected boolean isActive = true;


    public boolean isActive()
    {
    	return isActive;
    }

    /**
     * The default size of a horizontal progress bar
     */
    public Dimension getPreferredInnerHorizontal() {
	return PREFERRED_INNER_HORIZONTAL;
    }

    /**
     * The default size of a vertical progress bar
     */
    public Dimension getPreferredInnerVertical() {
	return PREFERRED_INNER_VERTICAL;
    }

    /**
     * Don't leave space between the interior and the border
     */
    public int getBorderBuffer() {
	return BORDER_BUFFER;
    }

    /**
     * The default length of a cell
     */
    public int getCellLength() {
	return CELL_LENGTH;
    }

    /**
     * Don't leave any gap between cells
     */
    public int getCellSpacing() {
	return CELL_SPACING;
    }
  
  public static ComponentUI createUI(JComponent c) {
    return new MacProgressBarUI();
  }
  
  public void installUI(JComponent c) {
    super.installUI(c);

    determHeadIcon = (ImageIcon)UIManager.getIcon("ProgressBar.determHead");
    determLeftIcon = (ImageIcon)UIManager.getIcon("ProgressBar.determLeft");
    determTopIcon = (ImageIcon)UIManager.getIcon("ProgressBar.determTop");
    determBottomIcon = (ImageIcon)UIManager.getIcon("ProgressBar.determBottom");
    
    AppearanceFilter.FilterImageIcon(c,determHeadIcon);
    AppearanceFilter.FilterImageIcon(c,determLeftIcon);
    AppearanceFilter.FilterImageIcon(c,determTopIcon);
    AppearanceFilter.FilterImageIcon(c,determBottomIcon);
    
    progressBarForeground = UIManager.getColor("ProgressBar.foreground");
    progressBarOuter5 = UIManager.getColor("ProgressBar.outer5");
    progressBarOuterW = UIManager.getColor("ProgressBar.outerW");
    progressBarInner1 = AppearanceFilter.FilterColor(UIManager.getColor("ProgressBar.inner1"));
    progressBarInner2 = AppearanceFilter.FilterColor(UIManager.getColor("ProgressBar.inner2"));
    progressBarInner3 = AppearanceFilter.FilterColor(UIManager.getColor("ProgressBar.inner3"));
    progressBarInner4 = AppearanceFilter.FilterColor(UIManager.getColor("ProgressBar.inner4"));
    progressBarInner5 = AppearanceFilter.FilterColor(UIManager.getColor("ProgressBar.inner5"));
    progressBarInner7 = AppearanceFilter.FilterColor(UIManager.getColor("ProgressBar.inner7"));
    progressBarInner8 = AppearanceFilter.FilterColor(UIManager.getColor("ProgressBar.inner8"));
    progressBarInner10 = AppearanceFilter.FilterColor(UIManager.getColor("ProgressBar.inner10"));
    progressBarInner12 = AppearanceFilter.FilterColor(UIManager.getColor("ProgressBar.inner12"));
    progressBarEdge = UIManager.getColor("ProgressBar.edge");
    progressBarDisabledEdge = UIManager.getColor("ProgressBar.disabledEdge");
  }
  

  public void paint(Graphics g, JComponent c) {

    Dimension size = c.getSize();
    int x, y;
    int span;
    JProgressBar progressBar = (JProgressBar)c;
    BoundedRangeModel model = progressBar.getModel();
    Insets b = getBorderInsets(c);
    boolean enabled = c.isEnabled();
   
    span = model.getMaximum() - model.getMinimum();
      
    if (progressBar.getOrientation() == JProgressBar.HORIZONTAL) 
	{
	if (size.height > PREFERRED_INNER_HORIZONTAL.height)
	{
		size.height = PREFERRED_INNER_HORIZONTAL.height;
	}
	int increment = CELL_LENGTH + CELL_SPACING;
	x = b.left;
	y = b.top;
	int length = (span != 0) ? size.width*model.getValue()/span : 0;
	length = length - length % CELL_LENGTH;	// Round to Cell Length
	int max = x + length;
	if (enabled && isActive)
		max -= LEFT_CELL_LENGTH;
	else
		max -= 2;
	int start = max;

	if (start < 0)
		{
		start = 0;
		max = 0;
		}

	if (enabled && isActive)
		{
		g.setColor(progressBarOuter5);
		g.drawLine(0, 0, 0, size.height-2);
		g.drawLine(0, 0, size.width-2, 0);
		g.setColor(progressBarEdge);
		}
	else
		{
		g.setColor(progressBarDisabledEdge);
		}

	g.drawRect(1, 1, size.width-3, size.height-3);
		
	if (enabled && isActive)
		{
		g.setColor(progressBarInner7);
		g.drawLine(start + 2, 2, size.width-3, 2);
			
		g.setColor(progressBarInner2);
		g.drawLine(size.width-3, 2, size.width-3, size.height-3);
		g.drawLine(start + 2, size.height-3, size.width-3, size.height-3);

		if (progressBar.isOpaque())
			{
			g.setColor(progressBarInner4);
			g.fillRect(start+2, 3, size.width-2-start-2, size.height-6);
			}
		else
			g.clearRect(start+2, 3, size.width-2-start-2, size.height-6);

		g.setColor(progressBarOuterW);
		g.drawLine(size.width-1, 0, size.width-1, size.height-1);
		g.drawLine(1, size.height-1, size.width-1, size.height-1);
		}
	else
		{
		if (progressBar.isOpaque())
			{
			g.setColor(progressBarInner4);
			g.fillRect(start+2, 2, size.width-2-start-2, size.height-4);
			}
		else
			g.clearRect(start+2, 2, size.width-2-start-2, size.height-4);
		g.setColor(c.getParent().getBackground());
		g.drawRect(0, 0, size.width-1, size.height-1);
		}
	
	// Draw constant left cell
	if (model.getValue() != 0) 
		{
		if (enabled && isActive)
			{
			g.setColor(progressBarInner8);
			g.drawLine(2, 2, 2, size.height-3);
			determLeftIcon.paintIcon(progressBar, g, x + 3, y + 2);
			}
		else
			{
			g.setColor(progressBarInner5);
			g.fillRect(x + 2, 2, 3, size.height-4);
			}
		}

	int left;
	if (enabled && isActive)
		left = x + LEFT_CELL_LENGTH;
	else
		left = x + 2;
	if (max > left)
		{
		if (enabled && isActive)
			{
			g.setColor(progressBarEdge);
			g.drawLine(left,y+1,max,y+1);
			g.drawLine(left,y+12,max,y+12);
			g.setColor(progressBarInner10);
			g.drawLine(left,y+2,max,y+2);
			g.drawLine(left,y+10,max,y+10);
			g.setColor(progressBarInner8);
			g.drawLine(left,y+3,max,y+3);
			g.drawLine(left,y+9,max,y+9);
			g.setColor(progressBarOuter5);
			g.drawLine(left,y,max,y);
			g.drawLine(left,y+4,max,y+4);
			g.drawLine(left,y+8,max,y+8);
			g.setColor(progressBarInner3);
			g.drawLine(left,y+5,max,y+5);
			g.drawLine(left,y+7,max,y+7);
			g.setColor(progressBarInner1);
			g.drawLine(left,y+6,max,y+6);
			g.setColor(progressBarInner12);
			g.drawLine(left,y+11,max,y+11);
			g.setColor(progressBarOuterW);
			g.drawLine(left,y+13,max,y+13);
			}
		else
			{
			g.setColor(progressBarInner5);
			g.fillRect(left,y+2,max-left+3,10);
			}
		}

	g.setColor(progressBarForeground);
     
	if (model.getValue() != 0) 
		{
		// Draw the head cell
		if (model.getValue() == model.getMaximum()) 
			{
			if (enabled && isActive)
				{
				g.setColor(progressBarForeground);
		        determHeadIcon.paintIcon(progressBar, g, size.width - 6, y + 2);
				g.setColor(progressBarEdge);
				g.drawLine(size.width-2, 1, size.width-2, size.height-2);
				g.setColor(progressBarOuterW);
				g.drawLine(size.width-1, 0, size.width-1, size.height-1);
				}
	 		else
				{
				g.setColor(progressBarDisabledEdge);
				g.drawLine(size.width-2,y+1,size.width-2,y+11);
				}
			}
		else
			{
 			if (enabled && isActive)
	       		determHeadIcon.paintIcon(progressBar, g, max, y + 2);
	 		else
				{
				g.setColor(progressBarDisabledEdge);
				g.drawLine(max+3,y+1,max+3,y+11);
				}
			}
       	}
	} 
    else 	// Vertical Bar section drawn from bottom to top
	{
	if (size.width > PREFERRED_INNER_VERTICAL.width)
	{
		size.width = PREFERRED_INNER_VERTICAL.width;
	}
	x = b.left;
	y = b.top;
	int height = (span != 0) ? size.height*model.getValue()/span : 0;
	height = height - height % CELL_HEIGHT;	// Round to Cell Height
	int bottom = y + size.height - height - BOTTOM_CELL_HEIGHT;

	if (bottom < 0)
		bottom = 0;

	int start = bottom;

	if (enabled && isActive)
		{
		g.setColor(progressBarOuter5);
		g.drawLine(0, size.height-1, size.width-1, size.height-1);
		g.drawLine(0, 1, 0, size.height-2);
		g.setColor(progressBarEdge);
		}
	else
		{
		g.setColor(progressBarDisabledEdge);
		}

	g.drawRect(1, 1, size.width-3, size.height-3);

	if (enabled && isActive)
		{
		g.setColor(progressBarInner7);
		g.drawLine(2, 2, 2, start+1);
	
		g.setColor(progressBarInner2);
		g.drawLine(3, 2, size.width-3, 2);
		g.drawLine(size.width-3, 3, size.width-3, start+1);
	
		if (progressBar.isOpaque())
			{
			g.setColor(progressBarInner4);
			g.fillRect(3, 3, size.width-6, start-1);
			}
		else
			g.clearRect(3, 3, size.width-6, start-1);
	
		g.setColor(progressBarOuterW);
		g.drawLine(0, 0, size.width-1, 0);
		g.drawLine(size.width-1, 1, size.width-1, size.height-2);
		}
	else
		{
		if (progressBar.isOpaque())
			{
			g.setColor(progressBarInner4);
			g.fillRect(2, 2, size.width-4, start);
			}
		else
			g.clearRect(2, 2, size.width-4, start);
		g.setColor(c.getParent().getBackground());
		g.drawRect(0, 0, size.width-1, size.height-1);
		}	
		
	// Draw constant bottom cell
	if (model.getValue() != 0) 
		{
		if (enabled && isActive)
			{
			g.setColor(progressBarInner8);
			g.drawLine(2, size.height-3, size.width-3, size.height-3);
			determBottomIcon.paintIcon(progressBar, g, x+2, size.height-4);
			}
		else
			{
			g.setColor(progressBarInner5);
			g.fillRect(2, size.height-4, size.width-4, 2);
			}
		}
		
	int end = size.height - BOTTOM_CELL_HEIGHT;

	if (bottom < end)
		{
		if (enabled && isActive)
			{
			g.setColor(progressBarEdge);
			g.drawLine(x+1,bottom,x+1,end);
			g.drawLine(x+12,bottom,x+12,end);
			g.setColor(progressBarInner10);
			g.drawLine(x+2,bottom,x+2,end);
			g.drawLine(x+10,bottom,x+10,end);
			g.setColor(progressBarInner8);
			g.drawLine(x+3,bottom,x+3,end);
			g.drawLine(x+9,bottom,x+9,end);
			g.setColor(progressBarOuter5);
			g.drawLine(x,bottom,x,end);
			g.drawLine(x+4,bottom,x+4,end);
			g.drawLine(x+8,bottom,x+8,end);
			g.setColor(progressBarInner3);
			g.drawLine(x+5,bottom,x+5,end);
			g.drawLine(x+7,bottom,x+7,end);
			g.setColor(progressBarInner1);
			g.drawLine(x+6,bottom,x+6,end);
			g.setColor(progressBarInner12);
			g.drawLine(x+11,bottom,x+11,end);
			g.setColor(progressBarOuterW);
			g.drawLine(x+13,bottom,x+13,end);
			}
		else
			{
			g.setColor(progressBarInner5);
			g.fillRect(x+2,bottom+2,x+10,end-bottom-2);
			}
		}

     
	if (model.getValue() != 0) 
		{
		// Draw the top cell
		if (model.getValue() == model.getMaximum()) 
			{
			if (enabled && isActive)
				{
				g.setColor(progressBarForeground);
	       		determTopIcon.paintIcon(progressBar, g, x+2, 0);
				}
		 	else
				{
				g.setColor(progressBarDisabledEdge);
				g.drawLine(x+2,1,11,1);
				}
	      	}
      	else
			{
 			if (enabled && isActive)
       			determTopIcon.paintIcon(progressBar, g, x+2, bottom);
	 		else
				{
				g.setColor(progressBarDisabledEdge);
				g.drawLine(x+2,bottom+2,11,bottom+2);
				}
       		}
       	}

	if (enabled && isActive)
		{
	 	g.setColor(progressBarEdge);
		g.drawLine(1,1, size.width-2, 1);
		g.setColor(progressBarOuterW);
		g.drawLine(0,0, size.width-1, 0);
		}
	else
		{
	 	g.setColor(progressBarDisabledEdge);
		g.drawLine(1,1, size.width-2, 1);
		}
	}
  }
  
	public Insets getBorderInsets(JComponent c) 
	{
		// no borders on MacProgressBar
		return new Insets(0, 0, 0, 0);
	}

	protected void installListeners(JComponent c)
	{
		super.installListeners(c);
		
		activationHelper	= new ActivationHelper(c);
		changeListener		= new ChangeListener();
		activationHelper.addPropertyChangeListener(changeListener);
	}
	
	protected void uninstallListeners(JComponent c)
	{
		super.uninstallListeners(c);
		activationHelper.removePropertyChangeListener(changeListener);
		activationHelper = null;
		changeListener = null;
	}
	
	class ChangeListener implements java.beans.PropertyChangeListener
	{
		public void propertyChange(java.beans.PropertyChangeEvent evt)
		{
			if(evt.getPropertyName().equals("activated"))
			{
				boolean oldActive = isActive;
				isActive = ((Boolean) evt.getNewValue()).booleanValue();
				if(isActive != oldActive)
				{
					Object obj = evt.getSource();
					if(obj instanceof ActivationHelper)
					{
						((ActivationHelper)obj).getComponent().repaint();
					}
				}
			}
		}
	}
}

