/*
 * @(#)MacMenuItemUI.java	1.7 98/02/02
 *
 * Copyright (c) 1998 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */

package com.sun.java.swing.plaf.mac;


import java.awt.*;
import com.sun.java.swing.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.plaf.basic.BasicMenuItemUI;


/**
 * MacMenuItem implementation
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version @(#)MacMenuItemUI.java	1.0 01/20/98
 * @author Symantec
 */

public class MacMenuItemUI extends BasicMenuItemUI
{
	static Color disabledForeground = UIManager.getColor("Control.disabledForeground");

	public static ComponentUI createUI(JComponent c) 
	{
		return new MacMenuItemUI();
	}
    
	public Dimension getPreferredSize(JComponent c) {
		return MacMenuUtilities.getPreferredMenuItemSize((JMenuItem) c, checkIcon, menuArrow);
	}

	public Insets getDefaultMargin(AbstractButton c) { 
        return MacMenuUtilities.menuItemMargin;
	}

	public synchronized void paint(Graphics g, JComponent c) {
		Color foreground = null;
		Color background = null;
		ButtonModel model = ((JMenuItem) c).getModel();
		boolean isHilited = model.isArmed();
		if (!model.isEnabled())
		{
			foreground = disabledForeground;
		}
		else if (isHilited)
		{
			foreground = pressedForeground;
			background = pressedBackground;
		}

		MacMenuUtilities.paintMenuItem(g, (JMenuItem) c, checkIcon, menuArrow,
										background, foreground);
    }
}








