/*
 * @(#)MacLookAndFeel.java	1.16 98/04/10
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */
 
 
package com.sun.java.swing.plaf.mac;


import java.awt.Color;
import java.awt.Font;
import java.net.URL;
import java.io.*;


import com.sun.java.swing.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.border.*;

import com.sun.java.swing.plaf.basic.BasicLookAndFeel;
import com.sun.java.swing.plaf.basic.BasicMarginBorder;
import com.sun.java.swing.plaf.basic.BasicComboBoxRenderer;
import com.sun.java.swing.plaf.basic.BasicComboBoxEditor;

/**
 * The base class for the Mac Look and Feel.
 * <p>
 * For the keyboard keys defined for each component in this Look and
 * Feel (L&F), see 
 * <a href="../../doc-files/Key-Mac.html">Component Keystroke Actions for the Mac L&F</a>.
 * <b>Note:</b> The link above is only a placeholder. It will not be valid
 *              until this L&F is released.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.16 04/10/98
 * @author Symantec
 */

public class MacLookAndFeel extends BasicLookAndFeel 
{
    public String getName() {
                return "Macintosh";
    }


        public String getID() {
                return "Macintosh";
    }


    public String getDescription() {
                return "The Macintosh Look and Feel";
    }


    public boolean isNativeLookAndFeel() {
        return MacUtilities.IsMacOS();
    }


    public boolean isSupportedLookAndFeel() {
	return isNativeLookAndFeel();
    }


    /**
     * Load the SystemColors into the defaults table.
     * Included is the ramp from the Grayscale Appearance
     * Specification
     */
    protected void initSystemColorDefaults(UIDefaults table)
    {
                Object[] grayscaleAppearanceColors =
                {
                        "GrayscaleAppearanceB",         MacUtilities.GrayscaleAppearanceB,      /* Grayscale Appearance Color B */
                        "GrayscaleAppearanceW",         MacUtilities.GrayscaleAppearanceW,      /* Grayscale Appearance Color W */
                        "GrayscaleAppearance1",         MacUtilities.GrayscaleAppearance1,      /* Grayscale Appearance Color 1 */
                        "GrayscaleAppearance2",         MacUtilities.GrayscaleAppearance2,      /* Grayscale Appearance Color 2 */
                        "GrayscaleAppearance3",         MacUtilities.GrayscaleAppearance3,      /* Grayscale Appearance Color 3 */
                        "GrayscaleAppearance4",         MacUtilities.GrayscaleAppearance4,      /* Grayscale Appearance Color 4 */
                        "GrayscaleAppearance5",         MacUtilities.GrayscaleAppearance5,      /* Grayscale Appearance Color 5 */
                        "GrayscaleAppearance6",         MacUtilities.GrayscaleAppearance6,      /* Grayscale Appearance Color 6 */
                        "GrayscaleAppearance7",         MacUtilities.GrayscaleAppearance7,      /* Grayscale Appearance Color 7 */
                        "GrayscaleAppearance8",         MacUtilities.GrayscaleAppearance8,      /* Grayscale Appearance Color 8 */
                        "GrayscaleAppearance9",         MacUtilities.GrayscaleAppearance9,      /* Grayscale Appearance Color 9 */
                        "GrayscaleAppearance10",        MacUtilities.GrayscaleAppearance10,     /* Grayscale Appearance Color 10 */
                        "GrayscaleAppearance11",        MacUtilities.GrayscaleAppearance11,     /* Grayscale Appearance Color 11 */
                        "GrayscaleAppearance12",        MacUtilities.GrayscaleAppearance12,     /* Grayscale Appearance Color 12 */
                        "GrayscaleAppearanceA1",        MacUtilities.GrayscaleAppearanceA1,     /* Grayscale Appearance Color A1 */
                        "GrayscaleAppearanceA2",        MacUtilities.GrayscaleAppearanceA2,     /* Grayscale Appearance Color A2 */

/*****************************************************
 *
 *                      Use these colors when an accent (tinged) version of the grayscale color is desired.
 *                      These entries are set in AppearanceFilter.setAppearance().
 *
 *                      "AccentAppearance1",            AppearanceFilter.FilterColor(MacUtilities.GrayscaleAppearance1),
 *                      "AccentAppearance2",            AppearanceFilter.FilterColor(MacUtilities.GrayscaleAppearance2),
 *                      "AccentAppearance3",            AppearanceFilter.FilterColor(MacUtilities.GrayscaleAppearance3),
 *                      "AccentAppearance4",            AppearanceFilter.FilterColor(MacUtilities.GrayscaleAppearance4),
 *                      "AccentAppearance5",            AppearanceFilter.FilterColor(MacUtilities.GrayscaleAppearance5),
 *                      "AccentAppearance6",            AppearanceFilter.FilterColor(MacUtilities.GrayscaleAppearance6),
 *                      "AccentAppearance7",            AppearanceFilter.FilterColor(MacUtilities.GrayscaleAppearance7),
 *                      "AccentAppearance8",            AppearanceFilter.FilterColor(MacUtilities.GrayscaleAppearance8),
 *                      "AccentAppearance9",            AppearanceFilter.FilterColor(MacUtilities.GrayscaleAppearance9),
 *                      "AccentAppearance10",           AppearanceFilter.FilterColor(MacUtilities.GrayscaleAppearance10),
 *                      "AccentAppearance11",           AppearanceFilter.FilterColor(MacUtilities.GrayscaleAppearance11),
 *                      "AccentAppearance12",           AppearanceFilter.FilterColor(MacUtilities.GrayscaleAppearance12),
 *                      "AccentAppearanceA1",           AppearanceFilter.FilterColor(MacUtilities.GrayscaleAppearanceA1),
 *                      "AccentAppearanceA2",           AppearanceFilter.FilterColor(MacUtilities.GrayscaleAppearanceA2),
 ******************************************************/
                };

                for(int i = 0; i < grayscaleAppearanceColors.length; i += 2)
                {
                    table.put((String)grayscaleAppearanceColors[i], grayscaleAppearanceColors[i + 1]);
                }

                
                
                // textHighlight is correct in SystemColor.
                ColorUIResource textHighlight;
                try {
                        textHighlight = new ColorUIResource((Color)(java.awt.SystemColor.class.getField("textHighlight").get(null)));
                } catch (Exception e) { 
                        textHighlight = null;
                }


                Object[] defaultSystemColors =
                {
                "desktop", "#005C5C",   MacUtilities.GrayscaleAppearance4,      /* Color of the desktop background */
          "activeCaption", "#000080",   MacUtilities.GrayscaleAppearance3,      /* Color for captions (title bars) when they are active. */
      "activeCaptionText", "#000000",                           null,                                   /* Text color for text in captions (title bars). */
    "activeCaptionBorder", "#CCCCCC",   MacUtilities.GrayscaleAppearance3,      /* Border color for caption (title bar) window borders. */
        "inactiveCaption", "#DDDDDD",   MacUtilities.GrayscaleAppearance2,      /* Color for captions (title bars) when not active. */
    "inactiveCaptionText", "#888888",   MacUtilities.GrayscaleAppearance7,      /* Text color for text in inactive captions (title bars). */
  "inactiveCaptionBorder", "#DDDDDD",   MacUtilities.GrayscaleAppearance2,      /* Border color for inactive caption (title bar) window borders. */
                 "window", "#FFFFFF",   MacUtilities.GrayscaleAppearance2,      /* Default color for the interior of windows */
           "windowBorder", "#DDDDDD",   MacUtilities.GrayscaleAppearance2,      /* ??? */
             "windowText", "#000000",                           null,                                   /* ??? */
                   "menu", "#DDDDDD",   MacUtilities.GrayscaleAppearance2,      /* Background color for menus */
               "menuText", "#000000",                           null,                                   /* Text color for menus  */
                   "text", "#C0C0C0",                           null,                                   /* Text background color */
               "textText", "#000000",                           null,                                   /* Text foreground color */
          "textHighlight", "#000000",                   textHighlight,                          /* Text background color when selected */
      "textHighlightText", "#C0C0C0",   MacUtilities.GrayscaleAppearanceB,      /* Text color when selected */
       "textInactiveText", "#808080",                           null,                                   /* Text color when disabled */
                "control", "#C0C0C0",   MacUtilities.GrayscaleAppearance2,      /* Default color for controls (buttons, sliders, etc) */
            "controlText", "#000000",                           null,                                   /* Default color for text in controls */
       "controlHighlight", "#FFFFFF",                           null,                                   /* Specular highlight (opposite of the shadow) */
     "controlLtHighlight", "#E0E0E0",                           null,                                   /* Highlight color for controls */
          "controlShadow", "#808080",                           null,                                   /* Shadow color for controls */
        "controlDkShadow", "#000000",                           null,                                   /* Dark shadow color for controls */
              "scrollbar", "#DDDDDD",   MacUtilities.GrayscaleAppearance2,      /* Scrollbar background (usually the "track") */
                   "info", "#FFFFCC",                           null,                                   
               "infoText", "#000000",                           null,                                   
     "controlLightShadow", "#9397A5",                           null,                                   /* Shadow color for controls */  
                };

                loadSystemColors(table, defaultSystemColors);
    }



    /**
     * If this is the native look and feel the initial values for the
     * system color properties are the same as the SystemColor constants.
     * If not we use the integer color values in the <code>systemColors</code>
     * argument.
     */
    protected void loadSystemColors(UIDefaults table, Object[] systemColors)
    {
                if (false && isNativeLookAndFeel()) {
                        for(int i = 0; i < systemColors.length; i += 3) {
                                Color color = Color.black;
                                try {
                                        String name = (String) systemColors[i];
                                        color = (Color)(java.awt.SystemColor.class.getField(name).get(null));
                                } catch (Exception e) { 
                                }
                                table.put((String) systemColors[i], new ColorUIResource(color));
                        }
                } else {
                        for(int i = 0; i < systemColors.length; i += 3) {
                                if (systemColors[i + 2] != null)
                                {
                                        table.put((String) systemColors[i], (ColorUIResource) systemColors[i + 2]);
                                }
                                else
                                {
                                        Color color = Color.black;
                                        try {
                                                color = Color.decode((String) systemColors[i + 1]);
                                        } 
                                        catch(NumberFormatException e) {
                                                e.printStackTrace();
                                        }
                                        table.put((String) systemColors[i], new ColorUIResource(color));
                                }
                        }
                }
        }

    protected void initClassDefaults(UIDefaults table)
    {
        super.initClassDefaults(table);

        String macPackageName = "com.sun.java.swing.plaf.mac.";
        Object[] uiDefaults = {
                "ButtonUI", macPackageName + "MacButtonUI",
              "CheckBoxUI", macPackageName + "MacCheckBoxUI",
                 "LabelUI", macPackageName + "MacLabelUI",
                  "ListUI", macPackageName + "MacListUI",
               "MenuBarUI", macPackageName + "MacMenuBarUI",
                  "MenuUI", macPackageName + "MacMenuUI",
              "MenuItemUI", macPackageName + "MacMenuItemUI",
      "CheckBoxMenuItemUI", macPackageName + "MacCheckBoxMenuItemUI",
   "RadioButtonMenuItemUI", macPackageName + "MacRadioButtonMenuItemUI",
           "RadioButtonUI", macPackageName + "MacRadioButtonUI",
          "ToggleButtonUI", macPackageName + "MacToggleButtonUI",
             "PopupMenuUI", macPackageName + "MacPopupMenuUI",
           "ProgressBarUI", macPackageName + "MacProgressBarUI",
             "ScrollBarUI", macPackageName + "MacScrollBarUI",
                "SliderUI", macPackageName + "MacSliderUI",
               "SpinnerUI", macPackageName + "MacSpinnerUI",
             "SplitPaneUI", macPackageName + "MacSplitPaneUI",
            "TabbedPaneUI", macPackageName + "MacTabbedPaneUI",
                 "TableUI", macPackageName + "MacTableUI",
           "TableHeaderUI", macPackageName + "MacTableHeaderUI",
              "TextAreaUI", macPackageName + "MacTextAreaUI",
             "TextFieldUI", macPackageName + "MacTextFieldUI",
         "PasswordFieldUI", macPackageName + "MacPasswordFieldUI",
              "TextPaneUI", macPackageName + "MacTextPaneUI",
            "EditorPaneUI", macPackageName + "MacEditorPaneUI",
                  "TreeUI", macPackageName + "MacTreeUI",
         "InternalFrameUI", macPackageName + "MacInternalFrameUI",
           "DesktopPaneUI", macPackageName + "MacDesktopPaneUI",
             "SeparatorUI", macPackageName + "MacSeparatorUI",
            "OptionPaneUI", macPackageName + "MacOptionPaneUI",
              "ComboBoxUI", macPackageName + "MacComboBoxUI",
      "ComboBoxMenuItemUI", macPackageName + "MacComboBoxMenuItemUI",
           "DesktopIconUI", macPackageName + "MacDesktopIconUI",
               "ToolTipUI", macPackageName + "MacToolTipUI",
        };

        table.putDefaults(uiDefaults);
    }


        /**
         * Utility method that creates a UIDefaults.ActiveValue that creates
         * an colorized grayscale Color UIResource for the specified <code>accent</code>
         * color.
         */
        private final Object makeAccentColor(final String accent)
        {
                return new UIDefaults.ActiveValue() {
                        public Object createValue(UIDefaults table) {
                                return table.get(accent);
                        }
                };
        }

    /**
     * Utility method that creates a UIDefaults.LazyValue that creates
     * an ImageIcon UIResource for the specified <code>gifFile</code>
     * filename.
     */
    private final Object makeIcon(final String gifFile)
    {
        return LookAndFeel.makeIcon(getClass(), gifFile);
    }

    /**
     * Utility method that creates a UIDefaults.LazyValue that creates
     * an ImageIcon (Not a UIResource) for the specified <code>gifFile</code>
     * filename.
     */
    private static Object makeImageIcon(final String gifFile)
    {
                return new UIDefaults.LazyValue()
                {
                        public Object createValue(UIDefaults table)
                        {
                                byte[] buffer = null;
                                try
                                {
                                        /* Copy resource into a byte array.  This is
                                        * necessary because several browsers consider
                                        * Class.getResource a security risk because it
                                        * can be used to load additional classes.
                                        * Class.getResourceAsStream just returns raw
                                        * bytes, which we can convert to an image.
                                        */
                                        InputStream resource = getClass().getResourceAsStream(gifFile);
                                        if (resource == null)
                                        {
                                                System.err.println(getClass().getName() + "/" + 
                                                gifFile + " not found.");
                                                return null; 
                                        }
                                        BufferedInputStream in = new BufferedInputStream(resource);
                                        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
                                        buffer = new byte[1024];
                                        int n;
                                        while ((n = in.read(buffer)) > 0)
                                        {
                                                out.write(buffer, 0, n);
                                        }
                                        in.close();
                                        out.flush();
                                        
                                        buffer = out.toByteArray();
                                        if (buffer.length == 0)
                                        {
                                                System.err.println("warning: " + gifFile + " is zero-length");
                                                return null;
                                        }
                                }
                                catch (IOException ioe)
                                {
                                        System.err.println(ioe.toString());
                                        return null;
                                }                               
                                return new ImageIcon(buffer);
                        }
                };
    }


    protected void initComponentDefaults(UIDefaults table)
    {
        super.initComponentDefaults(table);
        
        AppearanceFilter.setAppearance(getCurrentAppearance(), table);

        FontUIResource dialogPlain12 = new FontUIResource("Dialog", 
                                                          Font.PLAIN, 12);
        FontUIResource serifPlain12 = new FontUIResource("Serif", 
                                                          Font.PLAIN, 12);
        FontUIResource sansSerifPlain9 = new FontUIResource("SansSerif", 
                                                          Font.PLAIN, 9);
        FontUIResource sansSerifPlain10 = new FontUIResource("SansSerif", 
                                                          Font.PLAIN, 10);
        FontUIResource sansSerifPlain12 = new FontUIResource("SansSerif", 
                                                          Font.PLAIN, 12);
        FontUIResource monospacedPlain12 = new FontUIResource("Monospaced", 
                                                          Font.PLAIN, 12);
        ColorUIResource black = new ColorUIResource(Color.black);
        ColorUIResource white = new ColorUIResource(Color.white);
        ColorUIResource controlDarker = new ColorUIResource(147, 151, 165);  // slate blue

        Object loweredBevelBorder = new UIDefaults.LazyValue() {
            public Object createValue(UIDefaults table) {
                return MacBorderFactory.getLoweredBevelBorder();
            }
        };

        Object raisedBevelBorder = new UIDefaults.LazyValue() {
            public Object createValue(UIDefaults table) {
                return MacBorderFactory.getRaisedBevelBorder();
            }
        };

        Object buttonBorder = new UIDefaults.LazyValue() {
            public Object createValue(UIDefaults table) {
                return new BorderUIResource(new CompoundBorder(
                                                        MacBorderFactory.getButtonBorder(),
                                                        BasicMarginBorder.getMarginBorder()));
            }
        }; 
        
        Object textBorder = new UIDefaults.LazyValue() {
            public Object createValue(UIDefaults table) {
                return new CompoundBorder(
                    MacBorderFactory.getTextBorder(),
                    BasicMarginBorder.getMarginBorder());
            }
        };
        
        Object buttonToggleBorder = new UIDefaults.LazyValue() {
            public Object createValue(UIDefaults table) {
                return new CompoundBorder(
                    MacBorderFactory.getToggleButtonBorder(),
                    BasicMarginBorder.getMarginBorder());
            }
        };

        Object fieldTextBorder = new UIDefaults.LazyValue() {
            public Object createValue(UIDefaults table) {
                return MacBorderFactory.getFieldBorder();
            }
        };


        Object multilineTextBorder = new UIDefaults.LazyValue() {
            public Object createValue(UIDefaults table) {
                return MacBorderFactory.getTextBorder();
            }
        };

    Object comboBoxEditorActiveValue  = new UIDefaults.ActiveValue() {
        public Object createValue(UIDefaults table) {
            return new MacComboBoxEditor.UIResource();
        }
    };

        Object menuBarBorder = new UIDefaults.LazyValue(){
                public Object createValue(UIDefaults table) {
                return MacBorderFactory.getMenuBarBorder();
            }
        };

        Object popupMenuBorder = new UIDefaults.LazyValue(){
                public Object createValue(UIDefaults table) {
                return MacBorderFactory.getPopupMenuBorder();
            }
        };

        Object menuArrowIcon = new UIDefaults.LazyValue() {
            public Object createValue(UIDefaults table) {
                return MacMenuUtilities.getMenuArrowIcon();
            }
        };

        Object checkBoxMenuItemIcon = new UIDefaults.LazyValue() {
                public Object createValue(UIDefaults table) {
                return MacMenuUtilities.getCheckBoxMenuItemIcon();
            }
        };

        Object menuItemCheckIcon = new UIDefaults.LazyValue() {
            public Object createValue(UIDefaults table) {
                return MacMenuUtilities.getMenuItemCheckIcon();
            }
        };

        Object menuPressedBackground = makeAccentColor("AccentAppearance10");

        Object radioButtonIcon = new UIDefaults.LazyValue() {
                public Object createValue(UIDefaults table) {
                        return MacIconFactory.getRadioButtonIcon();
                }
        };
        
        Object checkBoxIcon = new UIDefaults.LazyValue() {
                public Object createValue(UIDefaults table) {
                        return MacIconFactory.getCheckBoxIcon();
                }
        };



        Object cellEditorBorder = new UIDefaults.LazyValue(){
          public Object createValue(UIDefaults table) {
            return new BorderUIResource(LineBorder.createBlackLineBorder());
          };
        };
        
        Object[] defaults = {

            "Button.border", buttonBorder,
            "Button.shadow", controlDarker,
            "Button.font", dialogPlain12,

                "Panel.background", table.get("window"),

                "Control.disabledForeground", MacUtilities.GrayscaleAppearance7,                // Gray
                "Control.disabledBackground", MacUtilities.GrayscaleAppearance2,                // LightGray
                "Control.pressedForeground", MacUtilities.GrayscaleAppearanceW,                 // White
                "Control.pressedBackground", MacUtilities.GrayscaleAppearance9,                 // DarkGray

            "ToggleButton.border", buttonToggleBorder,

            "MenuBar.border", menuBarBorder,

            "RadioButtonMenuItem.icon", checkBoxMenuItemIcon,
            "CheckBoxMenuItem.icon", checkBoxMenuItemIcon,

            "Menu.pressedForeground", MacUtilities.GrayscaleAppearanceW,
            "Menu.pressedBackground", menuPressedBackground,
            "Menu.arrowIcon", menuArrowIcon,

            "MenuItem.pressedForeground", MacUtilities.GrayscaleAppearanceW,
            "MenuItem.pressedBackground", menuPressedBackground,
            "MenuItem.checkIcon", menuItemCheckIcon,
            "MenuItem.arrowIcon", null,

                "PopupMenu.border", popupMenuBorder,        

            "Label.font", dialogPlain12,
            "Label.background", table.get("control"),
            "Label.foreground", table.get("controlText"),
            
            "List.selectedCellBackground", table.get("textHighlight"), 
            "List.selectedCellForeground", MacUtilities.GrayscaleAppearanceB,
            "List.defaultCellBackground", MacUtilities.GrayscaleAppearance8,
            "List.defaultCellForeground", MacUtilities.GrayscaleAppearanceB,
            "List.selectionBackground", table.get("textHighlight"), 
            "List.selectionForeground", MacUtilities.GrayscaleAppearanceB,
            "List.background", MacUtilities.GrayscaleAppearance3,
            "List.foreground", MacUtilities.GrayscaleAppearanceB,
            "List.focusCellHighlight", MacUtilities.GrayscaleAppearanceB,
            "List.font", dialogPlain12,
          //  "List.cellRenderer", listCellRendererActiveValue,
            

            "DesktopIcon.icon", makeImageIcon("icons/DesktopIcon.gif"),

	    "SplitPane.dividerSize", new Integer(8),

                // ProgressBar images and colors
                "ProgressBar.foreground", controlDarker,
                "ProgressBar.determLeft", makeImageIcon("icons/ProgressBarDetermLeft.gif"),
                "ProgressBar.determHead", makeImageIcon("icons/ProgressBarHead.gif"),
                "ProgressBar.determTop", makeImageIcon("icons/ProgressBarDetermTop.gif"),
                "ProgressBar.determBottom", makeImageIcon("icons/ProgressBarDetermBottom.gif"),
                "ProgressBar.outer5", MacUtilities.GrayscaleAppearance5,
                "ProgressBar.outerW", MacUtilities.GrayscaleAppearanceW,
                "ProgressBar.inner1", MacUtilities.GrayscaleAppearance1,
                "ProgressBar.inner2", MacUtilities.GrayscaleAppearance2,
                "ProgressBar.inner3", MacUtilities.GrayscaleAppearance3,
                "ProgressBar.inner4", MacUtilities.GrayscaleAppearance4,
                "ProgressBar.inner5", MacUtilities.GrayscaleAppearance5,
                "ProgressBar.inner7", MacUtilities.GrayscaleAppearance7,
                "ProgressBar.inner8", MacUtilities.GrayscaleAppearance8,
                "ProgressBar.inner10", MacUtilities.GrayscaleAppearance10,
                "ProgressBar.inner12", MacUtilities.GrayscaleAppearance12,
                "ProgressBar.edge", MacUtilities.GrayscaleAppearanceB,
                "ProgressBar.disabledEdge", MacUtilities.GrayscaleAppearance10,

                // PushButton images
                "PushButton.up", makeImageIcon("icons/PushButtonUp.gif"),
                "PushButton.down", makeImageIcon("icons/PushButtonDown.gif"),
                "PushButton.disabled", makeImageIcon("icons/PushButtonDisabled.gif"),
                "PushButton.defaultEnabled", makeImageIcon("icons/PushButtonDefaultEnabled.gif"),
                "PushButton.defaultDisabled", makeImageIcon("icons/PushButtonDefaultDisabled.gif"),

                //Toggle Button images
                //!!! LAB !!! Note "ToggleButtonLargeDisabledOff.gif", and "ToggleButtonSmallDisabledOff.gif"
                //are truncated to fit in the Mac filesystem.
                "ToggleButton.largeDisabledOn", makeImageIcon("icons/ToggleButtonLargeDisabledOn.gif"),
                "ToggleButton.largeDisabledOff", makeImageIcon("icons/ToggleButtonLargeDisabledOf.gif"),
                "ToggleButton.largeOn", makeImageIcon("icons/ToggleButtonLargeOn.gif"),
                "ToggleButton.largePressed", makeImageIcon("icons/ToggleButtonLargePressed.gif"),
                "ToggleButton.largeOff", makeImageIcon("icons/ToggleButtonLargeOff.gif"),
                "ToggleButton.mediumDisabledOn", makeImageIcon("icons/ToggleButtonMedDisabledOn.gif"),
                "ToggleButton.mediumDisabledOff", makeImageIcon("icons/ToggleButtonMedDisabledOff.gif"),
                "ToggleButton.mediumOn", makeImageIcon("icons/ToggleButtonMedOn.gif"),
                "ToggleButton.mediumPressed", makeImageIcon("icons/ToggleButtonMedPressed.gif"),
                "ToggleButton.mediumOff", makeImageIcon("icons/ToggleButtonMedOff.gif"),
                "ToggleButton.smallDisabledOn", makeImageIcon("icons/ToggleButtonSmallDisabledOn.gif"),
                "ToggleButton.smallDisabledOff", makeImageIcon("icons/ToggleButtonSmallDisabledOf.gif"),
                "ToggleButton.smallOn", makeImageIcon("icons/ToggleButtonSmallOn.gif"),
                "ToggleButton.smallPressed", makeImageIcon("icons/ToggleButtonSmallPressed.gif"),
                "ToggleButton.smallOff", makeImageIcon("icons/ToggleButtonSmallOff.gif"),

                // RadioButton images, colors, &c
                "RadioButton.background", null,
                "RadioButton.icon", radioButtonIcon,
                "RadioButton.enabledOff", makeIcon("icons/RadioButtonEnabledOff.gif"),
                "RadioButton.enabledOn", makeIcon("icons/RadioButtonEnabledOn.gif"),
                "RadioButton.pressedOff", makeIcon("icons/RadioButtonPressedOff.gif"),
                "RadioButton.pressedOn", makeIcon("icons/RadioButtonPressedOn.gif"),
                "RadioButton.disabledOff", makeIcon("icons/RadioButtonDisabledOff.gif"),
                "RadioButton.disabledOn", makeIcon("icons/RadioButtonDisabledOn.gif"),

                // CheckBox images, colors, &c
                "CheckBox.icon", checkBoxIcon,
                "CheckBox.enabledOff", makeIcon("icons/CheckBoxEnabledOff.gif"),
                "CheckBox.enabledOn", makeIcon("icons/CheckBoxEnabledOn.gif"),
                "CheckBox.pressedOff", makeIcon("icons/CheckBoxPressedOff.gif"),
                "CheckBox.pressedOn", makeIcon("icons/CheckBoxPressedOn.gif"),
                "CheckBox.disabledOff", makeIcon("icons/CheckBoxDisabledOff.gif"),
                "CheckBox.disabledOn", makeIcon("icons/CheckBoxDisabledOn.gif"),

                // ScrollBar images, colors, &c
            "ScrollBar.backgroundEnabled", MacUtilities.GrayscaleAppearance5,
            "ScrollBar.backgroundDisabled", MacUtilities.GrayscaleAppearance1,
            "ScrollBar.borderActive", MacUtilities.GrayscaleAppearanceB,
            "ScrollBar.borderInactive", MacUtilities.GrayscaleAppearance10,

            "ScrollBar.bevelIn1", MacUtilities.GrayscaleAppearance8,
            "ScrollBar.bevelIn2", MacUtilities.GrayscaleAppearance7,
            "ScrollBar.bevelCorner", MacUtilities.GrayscaleAppearance5,
            "ScrollBar.bevelOut2", MacUtilities.GrayscaleAppearance4,
            "ScrollBar.bevelOut1", MacUtilities.GrayscaleAppearance3,

            "ScrollBar.border", null,

                "ScrollBar.upArrowDisabled", makeIcon("icons/ScrollUpArrowDisabled.gif"),
                "ScrollBar.upArrowEnabled", makeIcon("icons/ScrollUpArrowEnabled.gif"),
                "ScrollBar.upArrowPressed", makeIcon("icons/ScrollUpArrowPressed.gif"),
                "ScrollBar.downArrowDisabled", makeIcon("icons/ScrollDownArrowDisabled.gif"),
                "ScrollBar.downArrowEnabled", makeIcon("icons/ScrollDownArrowEnabled.gif"),
                "ScrollBar.downArrowPressed", makeIcon("icons/ScrollDownArrowPressed.gif"),
                "ScrollBar.rightArrowDisabled", makeIcon("icons/ScrollRightArrowDisabled.gif"),
                "ScrollBar.rightArrowEnabled", makeIcon("icons/ScrollRightArrowEnabled.gif"),
                "ScrollBar.rightArrowPressed", makeIcon("icons/ScrollRightArrowPressed.gif"),
                "ScrollBar.leftArrowDisabled", makeIcon("icons/ScrollLeftArrowDisabled.gif"),
                "ScrollBar.leftArrowEnabled", makeIcon("icons/ScrollLeftArrowEnabled.gif"),
                "ScrollBar.leftArrowPressed", makeIcon("icons/ScrollLeftArrowPressed.gif"),

                "ScrollBar.horizontalBoxEnabled", makeImageIcon("icons/ScrollHorizontalBoxEnabled.gif"),
                "ScrollBar.horizontalBoxPressed", makeImageIcon("icons/ScrollHorizontalBoxPressed.gif"),
                "ScrollBar.verticalBoxEnabled", makeImageIcon("icons/ScrollVerticalBoxEnabled.gif"),
                "ScrollBar.verticalBoxPressed", makeImageIcon("icons/ScrollVerticalBoxPressed.gif"),
 
            "ScrollPane.border", null,
            "ScrollPane.viewportBorder", loweredBevelBorder,

//              "Slider.border", null,
                "Slider.background", null,

                "Slider.tickColorEnabled", MacUtilities.GrayscaleAppearanceB,
                "Slider.tickColorDisabled", MacUtilities.GrayscaleAppearance8,
                "Slider.tickHilite", MacUtilities.GrayscaleAppearanceW,
                "Slider.tickShadow", MacUtilities.GrayscaleAppearance7,

                "Slider.trackBorderEnabled", MacUtilities.GrayscaleAppearance12,
                "Slider.trackFillEnabled", MacUtilities.GrayscaleAppearance5,
                "Slider.trackBorderDisabled", MacUtilities.GrayscaleAppearance8,
                "Slider.trackFillDisabled", MacUtilities.GrayscaleAppearance4,
                "Slider.trackBevelIn", MacUtilities.GrayscaleAppearance5,
                "Slider.trackBevelOut", MacUtilities.GrayscaleAppearanceW,

                "Slider.indicatorHorizontalEnabled", makeImageIcon("icons/SliderHorizEnabled.gif"),
                "Slider.indicatorHorizontalDisabled", makeImageIcon("icons/SliderHorizDisabled.gif"),
                "Slider.indicatorHorizontalPressed", makeImageIcon("icons/SliderHorizPressed.gif"),
                "Slider.indicatorHorizontalDownEnabled", makeImageIcon("icons/SliderHorizDownEnabled.gif"),
                "Slider.indicatorHorizontalDownDisabled", makeImageIcon("icons/SliderHorizDownDisabled.gif"),
                "Slider.indicatorHorizontalDownPressed", makeImageIcon("icons/SliderHorizDownPressed.gif"),
                "Slider.indicatorHorizontalUpEnabled", makeImageIcon("icons/SliderHorizUpEnabled.gif"),
                "Slider.indicatorHorizontalUpDisabled", makeImageIcon("icons/SliderHorizUpDisabled.gif"),
                "Slider.indicatorHorizontalUpPressed", makeImageIcon("icons/SliderHorizUpPressed.gif"),

                "Slider.indicatorVerticalEnabled", makeImageIcon("icons/SliderVertEnabled.gif"),
                "Slider.indicatorVerticalDisabled", makeImageIcon("icons/SliderVertDisabled.gif"),
                "Slider.indicatorVerticalPressed", makeImageIcon("icons/SliderVertPressed.gif"),
                "Slider.indicatorVerticalLeftEnabled", makeImageIcon("icons/SliderVertLeftEnabled.gif"),
                "Slider.indicatorVerticalLeftDisabled", makeImageIcon("icons/SliderVertLeftDisabled.gif"),
                "Slider.indicatorVerticalLeftPressed", makeImageIcon("icons/SliderVertLeftPressed.gif"),
                "Slider.indicatorVerticalRightEnabled", makeImageIcon("icons/SliderVertRightEnabled.gif"),
                "Slider.indicatorVerticalRightDisabled", makeImageIcon("icons/SliderVertRightDisabled.gif"),
                "Slider.indicatorVerticalRightPressed", makeImageIcon("icons/SliderVertRightPressed.gif"),

            "Spinner.fieldBackground", table.get("textHighlight"),
            "Spinner.fieldForeground", MacUtilities.GrayscaleAppearanceB,

            "SplitPane.background", table.get("control"),
            "SplitPane.highlight", table.get("controlHighlight"),
            "SplitPane.shadow", table.get("controlShadow"),

                // Tabbed Pane font, colors & images
                "TabbedPane.font", dialogPlain12,
                "TabbedPane.enabledTabBackground", MacUtilities.GrayscaleAppearance3,
                "TabbedPane.enabledTabForeground", MacUtilities.GrayscaleAppearanceB,
                "TabbedPane.enabledTabHilite1", MacUtilities.GrayscaleAppearance3,
                "TabbedPane.enabledTabHilite2", MacUtilities.GrayscaleAppearance2,

                "TabbedPane.selectedTabBackground", MacUtilities.GrayscaleAppearance1,
                "TabbedPane.selectedTabForeground", MacUtilities.GrayscaleAppearanceB,
                "TabbedPane.selectedTabHilite1", MacUtilities.GrayscaleAppearance3,
                "TabbedPane.selectedTabHilite2", MacUtilities.GrayscaleAppearanceW,

                "TabbedPane.pressedTabBackground", MacUtilities.GrayscaleAppearance9,
                "TabbedPane.pressedTabForeground", MacUtilities.GrayscaleAppearanceW,
                "TabbedPane.pressedTabHilite1", MacUtilities.GrayscaleAppearance11,
                "TabbedPane.pressedTabHilite2", MacUtilities.GrayscaleAppearance10,

                "TabbedPane.disabledTabBackground", MacUtilities.GrayscaleAppearance2,
                "TabbedPane.disabledTabForeground", MacUtilities.GrayscaleAppearance7,
                "TabbedPane.disabledTabHilite1", MacUtilities.GrayscaleAppearance2,
                "TabbedPane.disabledTabHilite2", MacUtilities.GrayscaleAppearance2,

                "TabbedPane.enabledTabBorder", makeImageIcon("icons/TabbedPaneEnabledTabBorder.gif"),
                "TabbedPane.selectedTabBorder", makeImageIcon("icons/TabbedPaneSelectedTabBorder.gif"),
                "TabbedPane.pressededTabBorder", makeImageIcon("icons/TabbedPanePressedTabBorder.gif"),
                "TabbedPane.disabledTabBorder", makeImageIcon("icons/TabbedPaneDisabledTabBorder.gif"),

                "TabbedPane.enabledPaneBackground", MacUtilities.GrayscaleAppearance1,
                "TabbedPane.enabledPaneBorder", MacUtilities.GrayscaleAppearanceB,
                "TabbedPane.enabledPaneBevelHilite1", MacUtilities.GrayscaleAppearance3,
                "TabbedPane.enabledPaneBevelHilite2", MacUtilities.GrayscaleAppearanceW,
                "TabbedPane.enabledPaneBevelShadow1", MacUtilities.GrayscaleAppearance6,
                "TabbedPane.enabledPaneBevelShadow2", MacUtilities.GrayscaleAppearance4,
                "TabbedPane.enabledPaneBevelAccent1", MacUtilities.GrayscaleAppearance2,
                "TabbedPane.enabledPaneBevelAccent2", MacUtilities.GrayscaleAppearance1,
                "TabbedPane.enabledPaneBevelAccent3", MacUtilities.GrayscaleAppearance7,

                "TabbedPane.disabledPaneBackground", MacUtilities.GrayscaleAppearance2,
                "TabbedPane.disabledPaneBorder", MacUtilities.GrayscaleAppearance10,
                "TabbedPane.disabledPaneBevelHilite1", MacUtilities.GrayscaleAppearance2,
                "TabbedPane.disabledPaneBevelHilite2", MacUtilities.GrayscaleAppearance2,
                "TabbedPane.disabledPaneBevelShadow1", MacUtilities.GrayscaleAppearance2,
                "TabbedPane.disabledPaneBevelShadow2", MacUtilities.GrayscaleAppearance2,
                "TabbedPane.disabledPaneBevelAccent1", MacUtilities.GrayscaleAppearance2,
                "TabbedPane.disabledPaneBevelAccent2", MacUtilities.GrayscaleAppearance2,

            "Table.font", dialogPlain12,
            "Table.border", null, 
            "Table.foreground", table.get("controlText"),                  // cell text color
            "Table.background", MacUtilities.GrayscaleAppearance1,         // cell background color
            "Table.selectionForeground", MacUtilities.GrayscaleAppearanceB, 
            "Table.selectionBackground", MacUtilities.GrayscaleAppearance2,
            "Table.gridColor", MacUtilities.GrayscaleAppearanceW,          // grid line color
            "Table.cellSpacing", new DimensionUIResource(0, 0),            // inter-cell spacing
            "Table.cellEditorBorder", cellEditorBorder,                    // for currently edited cell

            "TableHeader.font", dialogPlain12, 
            "TableHeader.foreground", table.get("controlText"),            // header text color
            "TableHeader.background", MacUtilities.GrayscaleAppearance3,   // header background
            "TableHeader.selectionForeground", MacUtilities.GrayscaleAppearanceB,
            "TableHeader.selectionBackground", table.get("textHighlight"),
            "TableHeader.gridColor", MacUtilities.GrayscaleAppearanceW,    // color of lines between column headings        
                
                "Tree.showsRootHandles", new Boolean(true),
                "Tree.font", sansSerifPlain9,
            "Tree.background", MacUtilities.GrayscaleAppearance2,
            "Tree.textSelectionColor", table.get("textHighlight"),
            "Tree.textNonSelectionColor", table.get("textText"),
            "Tree.openIcon", makeIcon("icons/TreeOpen.gif"),
            "Tree.closedIcon", makeIcon("icons/TreeClosed.gif"),
            "Tree.selectedIcon", makeIcon("icons/TreeSelected.gif"),
            "Tree.selectedLeafIcon", makeIcon("icons/TreeLeafSelected.gif"),
            "Tree.leafIcon", makeIcon("icons/TreeLeaf.gif"),
            "Tree.expandedIcon", makeIcon("icons/TreeExpanded.gif"),
            "Tree.collapsedIcon", makeIcon("icons/TreeCollapsed.gif"),
            "Tree.collapsedPressedIcon", makeIcon("icons/TreeCollapsedPressed.gif"),
            "Tree.expandedPressedIcon", makeIcon("icons/TreeExpandedPressed.gif"),
            "Tree.intermediateIcon", makeIcon("icons/TreeIntermediate.gif"),

//        "ComboBox.renderer", comboBoxRendererActiveValue,
        "ComboBox.editor",   comboBoxEditorActiveValue,
                "ComboBox.background", null, //table.get("MenuItem.background"),
                "ComboBox.foreground", table.get("MenuItem.foreground"),
                "ComboBox.selectedBackground", table.get("MenuItem.background"),
                "ComboBox.selectedForeground", table.get("MenuItem.foreground"),
                "ComboBox.font", table.get("MenuItem.font"),
                
                "ComboBoxArrowBorder.enabled", makeImageIcon("icons/ComboBoxArrowEnabled.gif"),
                "ComboBoxArrowBorder.pressed", makeImageIcon("icons/ComboBoxArrowPressed.gif"),
                "ComboBoxArrowBorder.disabled", makeImageIcon("icons/ComboBoxArrowDisabled.gif"),
                "ComboBoxEditArrowBorder.enabled", makeImageIcon("icons/ComboBoxEditArrowEnabled.gif"),
                "ComboBoxEditArrowBorder.pressed", makeImageIcon("icons/ComboBoxEditArrowPressed.gif"),
                "ComboBoxEditArrowBorder.disabled", makeImageIcon("icons/ComboBoxEditArrowDisabled.gif"),
                "ComboBoxBorder.enabled", makeImageIcon("icons/ComboBoxEnabled.gif"),
                "ComboBoxBorder.pressed", makeImageIcon("icons/ComboBoxPressed.gif"),
                "ComboBoxBorder.disabled", makeImageIcon("icons/ComboBoxDisabled.gif"),

            "TextField.caretForeground", MacUtilities.GrayscaleAppearanceB,
            "TextField.caretBlinkRate", new Integer(500),
            "TextField.inactiveForeground", table.get("textInactiveText"),
            "TextField.selectionBackground", table.get("textHighlight"),
            "TextField.selectionForeground", table.get("textHighlightText"),
            "TextField.background", MacUtilities.GrayscaleAppearanceW,
            "TextField.foreground", table.get("textText"),
            "TextField.font", sansSerifPlain12,
            "TextField.border", fieldTextBorder,
            
            "PasswordField.caretForeground", MacUtilities.GrayscaleAppearanceB,
            "PasswordField.caretBlinkRate", new Integer(500),
            "PasswordField.inactiveForeground", table.get("textInactiveText"),
            "PasswordField.selectionBackground", table.get("textHighlight"),
            "PasswordField.selectionForeground", table.get("textHighlightText"),
            "PasswordField.background", MacUtilities.GrayscaleAppearanceW,
            "PasswordField.foreground", table.get("textText"),
            "PasswordField.font", sansSerifPlain12,
            "PasswordField.border", fieldTextBorder,
            
            "TextArea.caretForeground", MacUtilities.GrayscaleAppearanceB,
            "TextArea.caretBlinkRate", new Integer(500),
            "TextArea.inactiveForeground", table.get("textInactiveText"),
            "TextArea.selectionBackground", table.get("textHighlight"),
            "TextArea.selectionForeground", table.get("textHighlightText"),
            "TextArea.background", MacUtilities.GrayscaleAppearanceW,
            "TextArea.foreground", table.get("textText"),
            "TextArea.font", sansSerifPlain12,
            "TextArea.border", multilineTextBorder,
            
            "TextPane.caretForeground", MacUtilities.GrayscaleAppearanceB,
            "TextPane.caretBlinkRate", new Integer(500),
            "TextPane.inactiveForeground", table.get("textInactiveText"),
            "TextPane.selectionBackground", table.get("textHighlight"),
            "TextPane.selectionForeground", table.get("textHighlightText"),
            "TextPane.background", MacUtilities.GrayscaleAppearanceW,
            "TextPane.foreground", table.get("textText"),
            "TextPane.font", serifPlain12,
            "TextPane.border", multilineTextBorder,
            
            "EditorPane.caretForeground", MacUtilities.GrayscaleAppearanceB,
            "EditorPane.caretBlinkRate", new Integer(500),
            "EditorPane.inactiveForeground", table.get("textInactiveText"),
            "EditorPane.selectionBackground", table.get("textHighlight"),
            "EditorPane.selectionForeground", table.get("textHighlightText"),
            "EditorPane.background", MacUtilities.GrayscaleAppearanceW,
            "EditorPane.foreground", table.get("textText"),
            "EditorPane.font", serifPlain12,
            "EditorPane.border", null,

                "ToolTip.font", sansSerifPlain10,
            "ToolTip.border", null,
            "ToolTip.background", table.get("info"),
            "ToolTip.foreground", table.get("infoText"),

            "ToolBar.border", menuBarBorder,
            "ToolBar.background", table.get("control"),
            "ToolBar.foreground", table.get("controlText"),
            "ToolBar.font", dialogPlain12,
            "ToolBar.dockingColor", table.get("control"),
            "ToolBar.floatingColor", table.get("control"),
            "ToolBar.dockingBorderColor", AppearanceFilter.FilterColor(MacUtilities.GrayscaleAppearance8), 
            "ToolBar.floatingBorderColor", table.get("control"),
            
            "OptionPane.errorIcon", makeIcon("icons/Error.gif"),
            "OptionPane.informationIcon", makeIcon("icons/Inform.gif"),
            "OptionPane.warningIcon", makeIcon("icons/Warn.gif"),
            "OptionPane.questionIcon", makeIcon("icons/Inform.gif"),

            "FileChooser.newFolder", LookAndFeel.makeIcon(getClass(), "icons/NewFolder.gif"),
            "FileChooser.upFolder", LookAndFeel.makeIcon(getClass(), "icons/UpFolder.gif"),
            "FileChooser.homeFolder", LookAndFeel.makeIcon(getClass(), "icons/Folder.gif"),
            "FileChooser.detailsView", LookAndFeel.makeIcon(getClass(), "icons/DetailsView.gif"),
            "FileChooser.listView", LookAndFeel.makeIcon(getClass(), "icons/ListView.gif"),

            "DirectoryPane.directoryIcon", LookAndFeel.makeIcon(getClass(), "icons/Folder.gif"),
            "DirectoryPane.fileIcon", LookAndFeel.makeIcon(getClass(), "icons/File.gif"),
            "DirectoryPane.computerIcon", LookAndFeel.makeIcon(getClass(), "icons/Computer.gif"),
            "DirectoryPane.hardDriveIcon", LookAndFeel.makeIcon(getClass(), "icons/HardDrive.gif"),
            "DirectoryPane.floppyDriveIcon", LookAndFeel.makeIcon(getClass(), "icons/FloppyDrive.gif"),

                // Window images and colors
                "Window.closeEnabled", makeIcon("icons/WindowCloseEnabled.gif"),
                "Window.closePressed", makeIcon("icons/WindowClosePressed.gif"),
                "Window.sizeEnabled", makeIcon("icons/WindowSizeEnabled.gif"),
                "Window.zoomEnabled", makeIcon("icons/WindowZoomEnabled.gif"),
                "Window.zoomPressed", makeIcon("icons/WindowZoomPressed.gif"),
                "Window.minimizeEnabled", makeIcon("icons/WindowMinimizeEnabled.gif"),
                "Window.minimizePressed", makeIcon("icons/WindowMinimizePressed.gif"),

        };

        table.putDefaults(defaults);
    }


        private static String defaultAppearance = null;
        
        public static void setCurrentAppearance(String appearanceName) {
                defaultAppearance = appearanceName;
        }
        
        private static String getCurrentAppearance() {
                if (defaultAppearance != null)
                        return defaultAppearance;
                return MacUtilities.GetAppearanceName();
        }
}

