/*
 * @(#)MacListCellRenderer.java	1.4 98/02/02
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */
 
 
/*
 * @(#)BasicListUI.java	1.15 97/10/23
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing.plaf.mac;

import com.sun.java.swing.*;
import com.sun.java.swing.event.*;
import com.sun.java.swing.plaf.*;

import java.awt.*;
import java.awt.event.*;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeEvent;

import com.sun.java.swing.plaf.basic.BasicListUI;
import java.io.Serializable;


/*
public class MacListCellRenderer extends com.sun.java.swing.plaf.basic.BasicListCellRenderer
    {
    	//final ImageIcon testIcon = new ImageIcon("Icons/CheckBoxEnabledOff.gif");
    	static Image image;

		
		 public MacListCellRenderer() {
			super();
			image = Toolkit.getDefaultToolkit().getImage("test.gif");
    	
			MediaTracker tracker = new MediaTracker(this);
			tracker.addImage(image, 0);
		    try {
			tracker.waitForID(0);
		    } catch (InterruptedException e) {
			System.out.println("INTERRUPTED while loading Image");
		    }
		    
		    }


		public Component getListCellRendererComponent(
	        JList list, 
			Object value,
	        int index, 
	        boolean isSelected, 
	        boolean cellHasFocus)
	    {
		
			if (isSelected) {
			    setBackground(list.getSelectionBackground());
			    setForeground(list.getSelectionForeground());
			}
			else {
			    setBackground(list.getBackground());
			    setForeground(list.getForeground());
			}
			
			if (value instanceof Icon) {
			    setIcon((Icon)value);
			}
			else {
			    setText((value == null) ? "" : value.toString());
			}
		
			setFont(list.getFont());
			//setIcon(testIcon);
		
			return this;
	    }
	      
		public void paint(java.awt.Graphics g)
		{
       		int padding = 2;
       		
       		Icon icon = getIcon();
       		//if(icon != null)
       		{
       			System.out.println("Icon");
       			g.setColor(java.awt.Color.black);
       			//g.drawLine(0,0,10,10);
       			g.drawImage(image, 0,0,this);
       			
       		//	icon.paintIcon(this, g, 10, 10);
       		}
       			
       		Rectangle rect = new Rectangle(20,0,0, getHeight() );
       		
       		//set the beginning of the selection rectangle
       		if((icon != null) && (icon instanceof com.sun.java.swing.ImageIcon))
				rect.setLocation(icon.getIconWidth() + getIconTextGap() , 0 );
				    			
       		int length = g.getFontMetrics().stringWidth(getText());
       		rect.setSize(length, rect.height);
       		
       		g.setColor(getBackground());
       		g.fillRect(rect.x, rect.y, rect.width + padding + padding, rect.height);
       		
       		FontMetrics fm = g.getFontMetrics();
			int stringwidth = fm.stringWidth(getText());
			int y = fm.getAscent() + fm.getLeading();
			
			g.setColor(getForeground());
       		g.drawString(getText(), rect.x + padding, y);
       		
      		g.setColor(java.awt.Color.white);
       		g.drawLine(0, getHeight() - 1, getWidth(), getHeight() - 1);
       }
   }
  */
  

/**
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 */
public class MacListCellRenderer extends com.sun.java.swing.plaf.basic.BasicListCellRenderer
{
	JList list;
	Color highlightColor;
	Color backgroundColor;
	
	public Component getListCellRendererComponent(
	    JList list, 
		Object value,
	    int index, 
	    boolean isSelected, 
	    boolean cellHasFocus)
	{
		this.list = list;
	
		if (isSelected) {
			setBackground(list.getSelectionBackground());
			setForeground(list.getSelectionForeground());
			highlightColor = list.getSelectionBackground();
			backgroundColor = list.getBackground();
		}
		else {
			setBackground(list.getBackground());
			setForeground(list.getForeground());
			highlightColor = list.getBackground();
			backgroundColor = list.getBackground();
		}
				
		if (value instanceof Icon) {
			setIcon((Icon)value);
		}
		else {
			setText((value == null) ? "" : value.toString());
		}
	
		setFont(list.getFont());
	
		return this;
	}
	  
	public void paint(java.awt.Graphics g)
	{
       	int padding = 2;
       		
       	Rectangle rect = new Rectangle(0, 2, getWidth() - 1, getHeight() - 5 );

       	g.setColor(highlightColor);
       	
       	if(((com.sun.java.swing.plaf.mac.MacListUI)list.getUI()).isActivated())
       		g.fillRect(rect.x, rect.y, rect.width, rect.height);
       	else
       	{
       		g.setColor(backgroundColor);
       		g.fillRect(rect.x, rect.y, rect.width, rect.height);
       		g.setColor(highlightColor);
       		g.drawRect(rect.x, rect.y, rect.width, rect.height);
       	}

       	FontMetrics fm = g.getFontMetrics();
		int stringwidth = fm.stringWidth(getText());
		int y = fm.getAscent() + fm.getLeading();
		
		g.setColor(getForeground());
       	g.drawString(getText(), rect.x + padding, y);
       	
   //    	super.paint(g);
      	g.setColor(java.awt.Color.white);
       	g.drawLine(0, getHeight() - 1, getWidth(), getHeight() - 1);
   }
}
