/*
 * @(#)MacLabelUI.java	1.6 98/02/02
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */
 
package com.sun.java.swing.plaf.mac;

import java.awt.*;
import com.sun.java.swing.*;
import com.sun.java.swing.plaf.basic.BasicLabelUI;
import com.sun.java.swing.plaf.basic.BasicGraphicsUtils;
import com.sun.java.swing.plaf.ComponentUI;

/**
 * A Mac L&F implementation of LabelUI.
 * This merely sets up new default values in MacLookAndFeel.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version @(#)MacLabelUI.java	1.0 11/24/97
 * @author Symantec
 */

public class MacLabelUI extends BasicLabelUI 
{
	protected ActivationHelper activationHelper;
	protected ChangeListener changeListener;
	protected boolean isActive = true;

    public static ComponentUI createUI(JComponent c)
    {
        return new MacLabelUI();
    }

    public boolean isActive()
    {
    	return isActive;
    }

    public void installUI(JComponent c)
    { 
 		super.installUI(c);
 		
		activationHelper	= new ActivationHelper(c);
		changeListener		= new ChangeListener();
		activationHelper.addPropertyChangeListener(changeListener);
    }

    public void uninstallUI(JComponent c)
    {
    	super.uninstallUI(c);
    	
		activationHelper.removePropertyChangeListener(changeListener);
		activationHelper = null;
		changeListener = null;
    }
    
    /**
     * Paint the label text in the foreground color, if the label
     * is opaque then paint the entire background with the background
     * color.  The Label text is drawn by paintEnabledText() or
     * paintDisabledText().  The locations of the label parts are computed
     * by layoutCL.
     * 
     * @see #paintEnabledText
     * @see #paintDisabledText
     * @see #layoutCL
     */
    public void paint(Graphics g, JComponent c) 
    {
		JLabel label = (JLabel)c;
		String text = label.getText();
		Icon icon = (label.isEnabled()) ? label.getIcon() : label.getDisabledIcon();
	
		if ((icon == null) && (text == null))
		{
		    return;
		}
	
		FontMetrics fm = g.getFontMetrics();
		Rectangle iconR = new Rectangle();
		Rectangle textR = new Rectangle();
		Rectangle viewR = new Rectangle(c.getSize());
		Insets viewInsets = c.getInsets();
	
		viewR.x = viewInsets.left;
		viewR.y = viewInsets.top;
		viewR.width -= (viewInsets.left + viewInsets.right);
		viewR.height -= (viewInsets.top + viewInsets.bottom);
	
		String clippedText = layoutCL(label, fm, text, icon, viewR, iconR, textR);
	
		if (icon != null)
		{
		    icon.paintIcon(c, g, iconR.x, iconR.y);
		}
	
		if (text != null)
		{
		    int textX = textR.x;
		    int textY = textR.y + fm.getAscent();
	
		    if (label.isEnabled() && isActive)
		    {
				paintEnabledText(label, g, clippedText, textX, textY);
		    }
		    else
		    {
				paintDisabledText(label, g, clippedText, textX, textY);
		    }
		}
    }

    /**
     * Paint clippedText at textX, textY with the labels foreground color.
     * 
     * @see #paint
     * @see #paintDisabledText
     */
    protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY)
    {
		g.setColor(l.getForeground());
		BasicGraphicsUtils.drawString(g, s, 0, textX, textY);
    }

    /**
     * Paint clippedText at textX, textY with background.lighter() and then 
     * shifted down and to the right by one pixel with background.darker().
     * 
     * @see #paint
     * @see #paintEnabledText
     */
    protected void paintDisabledText(JLabel l, Graphics g, String s, int textX, int textY)
    {
		g.setColor(UIManager.getColor("Control.disabledForeground"));
		BasicGraphicsUtils.drawString(g, s, 0, textX, textY);
    }

    class ChangeListener implements java.beans.PropertyChangeListener
    {
		public void propertyChange(java.beans.PropertyChangeEvent evt)
		{
			if(evt.getPropertyName().equals("activated"))
			{
				boolean oldActive = isActive;
				isActive = ((Boolean) evt.getNewValue()).booleanValue();
				if(isActive != oldActive)
				{
					Object obj = evt.getSource();
					if(obj instanceof ActivationHelper)
					{
						((ActivationHelper)obj).getComponent().repaint();
					}
				}
			}
		}
    }
}
