/*
 * @(#)MacInternalFrameUI.java	1.8 98/02/05
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */
 
 
package com.sun.java.swing.plaf.mac;

import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import java.beans.*;
import java.util.EventListener;

import com.sun.java.swing.plaf.basic.*;
import com.sun.java.swing.plaf.*;

import java.io.Serializable;

/**
 * A Mac L&F implementation of InternalFrame.  
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version @(#)MacInternalFrameUI.java	1.0 11/24/97
 * @author Symantec
 * @author David Bustin
 */

public class MacInternalFrameUI extends BasicInternalFrameUI
{
    Color color;
    Color highlight;
    Color shadow;
    MacInternalFrameTitlePane titlePane;
	JInternalFrame frame;
	    
    // Window Shade support
    protected boolean windowShade; // true if window shade is supported	
    protected Dimension saveSize;  // used to save the dimension before collapsing frame
    protected boolean resizable;   // is the frame resizable?
    
/////////////////////////////////////////////////////////////////////////////
// ComponentUI Interface Implementation methods
/////////////////////////////////////////////////////////////////////////////
    public static ComponentUI createUI(JComponent w)    {
        return new MacInternalFrameUI((JInternalFrame)w);
    }

    public MacInternalFrameUI(JInternalFrame w)   {
        super(w);
    	frame = w;
    }
            
    public void installUI(JComponent c)   {
        if(((JInternalFrame)c).getBorder() == null)
            ((JInternalFrame)c).setBorder(
			new MacInternalFrameBorder((JInternalFrame)c));
        super.installUI(c);
        setColors();
        setWindowShade(true);
		frame.setMinimumSize(new Dimension(100, 26));
    }   

    public void uninstallUI(JComponent c) {
        if(frame.getBorder() instanceof MacInternalFrameBorder)
            frame.setBorder(null);                
        super.uninstallUI(c);
    }
        
    public JComponent createNorthPane(JInternalFrame w) {
        titlePane = new MacInternalFrameTitlePane(w);
        return titlePane;
    }

    public Dimension getMaximumSize(JComponent x) {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }
    
    /** This method is called when the frame becomes selected.
      */
    protected void activateFrame(JInternalFrame f) {
        super.activateFrame(f);
        setColors();
    }
    /** This method is called when the frame is no longer selected.
      */
    protected void deactivateFrame(JInternalFrame f) {
        setColors();
        super.deactivateFrame(f);
    }

    void setColors() {
        if (frame.isSelected()) {
            color = UIManager.getColor("activeCaptionBorder");
        } else {
            color = UIManager.getColor("inactiveCaptionBorder");
        }
        highlight = color.brighter();
        shadow = color.darker().darker();
        titlePane.setColors(color, highlight, shadow);
    }

    /** Window shade is on by default, call this method
    	with false to make the frame become an icon instead of 
    	collapsing it (Window Shade) upon iconify
      */

    public void setWindowShade(boolean b) {
    	windowShade = b;
    }

    /** This method is called when the user wants to iconify the frame.
      * This action is delegated to the desktopManager unless windowShade
      * is on.
      */
    protected void iconifyFrame(JInternalFrame f) {
	if (windowShade)
		{
		saveSize = frame.getSize();
		f.setSize(saveSize.width, 26);
	        resizable = f.isResizable();
	        f.setResizable(false);	// Disable resizing while iconfied
		}
	else
		getDesktopManager().iconifyFrame(f);
    }
    /** This method is called when the user wants to deiconify the frame.
      * This action is delegated to the desktopManager unless windowShade
      * is on.
      */
    protected void deiconifyFrame(JInternalFrame f) {
	if (windowShade) {
            if (saveSize != null) {
                f.setSize(saveSize);
            } else {
                f.setSize(f.getPreferredSize());
            }
            f.setResizable(resizable);
        }
	else
            getDesktopManager().deiconifyFrame(f);
    }

    protected EventListener createBorderListener(JInternalFrame w) {
        return new MacBorderListener();
    }

   protected DesktopManager getDesktopManager() {
		return super.getDesktopManager();
	}
	
    /////////////////////////////////////////////////////////////////////////
    /// MacBorderListener Class
    /////////////////////////////////////////////////////////////////////////        
    protected class MacBorderListener extends MouseAdapter 
        implements MouseMotionListener, SwingConstants, Serializable
    {
		
	// _x & _y are the mousePressed location in absolute coordinate system
        int _x, _y;
	// __x & __y are the mousePressed location in source view's coordinate system
		int __x, __y;
        Rectangle startingBounds;
        int resizeDir;
        
        protected final int RESIZE_NONE  = 0;
                
        int resizeCornerSize = 16;

        public void mouseReleased(MouseEvent e) {
		    if (resizeDir == RESIZE_NONE)
		        getDesktopManager().endDraggingFrame(frame);	
		    else
		        getDesktopManager().endResizingFrame(frame);	
	            _x = 0;
	            _y = 0;
	            __x = 0;
	            __y = 0;
	            startingBounds = null;
	            resizeDir = RESIZE_NONE;
	        }
                
        public void mousePressed(MouseEvent e) {
            Point p = SwingUtilities.convertPoint((Component)e.getSource(), 
                        e.getX(), e.getY(), null);
            __x = e.getX();
            __y = e.getY();
            _x = p.x;
            _y = p.y;
            startingBounds = frame.getBounds();

            if (!frame.isSelected()) {
                try { frame.setSelected(true); } catch (PropertyVetoException e1) { }
            }

            if (e.getClickCount() > 1 && e.getSource() == getNorthPane()) {
			if (frame.isIconifiable()) {
					if (frame.isIcon()) {
                    	try { frame.setIcon(false); } catch (PropertyVetoException e2) { }
					}
					else {
                    	try { frame.setIcon(true); } catch (PropertyVetoException e2) { }
					}
			} else if(frame.isMaximizable()) {
                    if(!frame.isMaximum())
                        try { frame.setMaximum(true); } catch (PropertyVetoException e2) { }
                    else
                        try { frame.setMaximum(false); } catch (PropertyVetoException e3) { }
				} 
            }

            if (!frame.isResizable() || e.getSource() == getNorthPane()) {
                resizeDir = RESIZE_NONE;
				getDesktopManager().beginDraggingFrame(frame);
                return;
            }       

            if (e.getSource() == frame) {
                Insets i = frame.getInsets();
                if(e.getX() <= i.left) {
                    if(e.getY() < resizeCornerSize + i.top)
                        resizeDir = NORTH_WEST;
                    else if(e.getY() > frame.getHeight() 
					- resizeCornerSize - i.bottom)
                        resizeDir = SOUTH_WEST;
                    else                
                        resizeDir = WEST;
                } else if(e.getX() >= frame.getWidth() - i.right) {
                    if(e.getY() < resizeCornerSize + i.top)
                        resizeDir = NORTH_EAST;
                    else if(e.getY() > frame.getHeight() 
					- resizeCornerSize - i.bottom)
                        resizeDir = SOUTH_EAST;
                    else                
                        resizeDir = EAST;
                } else if(e.getY() <= i.top) {
                    if(e.getX() < resizeCornerSize + i.left)
                        resizeDir = NORTH_WEST;
                    else if(e.getX() > frame.getWidth() 
					- resizeCornerSize - i.right)
                        resizeDir = NORTH_EAST;
                    else                
                        resizeDir = NORTH;
                } else if(e.getY() >= frame.getHeight() - i.bottom) {
                    if(e.getX() < resizeCornerSize + i.left)
                        resizeDir = SOUTH_WEST;
                    else if(e.getX() > frame.getWidth() 
						- resizeCornerSize - i.right)
                        resizeDir = SOUTH_EAST;
                    else                
                        resizeDir = SOUTH;
                } 
		        getDesktopManager().beginResizingFrame(frame, resizeDir);
                return;
            }
        }

        public void mouseDragged(MouseEvent e) {                                        
            Point p; 
		    int newX, newY, newW, newH;
            int deltaX;
            int deltaY;
		    Dimension min;
		    Dimension max;
            p = SwingUtilities.convertPoint((Component)e.getSource(), 
                                        e.getX(), e.getY(), null);
        
            // Handle a MOVE 
            if(e.getSource() == getNorthPane()) {
                if (frame.isMaximum()) {
                    return;  // don't allow moving of maximized frames.
                }
				Insets i = frame.getInsets();
				int pWidth, pHeight;
				Dimension s = frame.getParent().getSize();
				pWidth = s.width;
				pHeight = s.height;

		        newX = startingBounds.x - (_x - p.x);
		        newY = startingBounds.y - (_y - p.y);

				// Make sure we stay in-bounds
				if(newX + i.left <= -__x)
				    newX = -__x - i.left;
				if(newY + i.top <= -__y)
				    newY = -__y - i.top;
				if(newX + __x + i.right > pWidth)
				    newX = pWidth - __x - i.right;
				if(newY + __y + i.bottom > pHeight)
				    newY =  pHeight - __y - i.bottom;
		
				getDesktopManager().dragFrame(frame, newX, newY);
		        return;
            }

            if(!frame.isResizable()) {
                return;
            }

		    min = frame.getMinimumSize();
		    max = frame.getMaximumSize();
        
            deltaX = _x - p.x;
            deltaY = _y - p.y;

		    newX = frame.getX();
		    newY = frame.getY();
		    newW = frame.getWidth();
		    newH = frame.getHeight();

            switch(resizeDir) {
	            case RESIZE_NONE:
	                return;
	            case NORTH: 
					if(startingBounds.height + deltaY < min.height)
					    deltaY = -(startingBounds.height - min.height);
					else if(startingBounds.height + deltaY > max.height)
					    deltaY = (startingBounds.height - min.height);
			
					newX = startingBounds.x;
					newY = startingBounds.y - deltaY;
					newW = startingBounds.width;
					newH = startingBounds.height + deltaY;
	                break;
	            case NORTH_EAST:     
					if(startingBounds.height + deltaY < min.height)
					    deltaY = -(startingBounds.height - min.height);
					else if(startingBounds.height + deltaY > max.height)
					    deltaY = (startingBounds.height - min.height);
			
					if(startingBounds.width - deltaX < min.width)
					    deltaX = (startingBounds.width - min.width);
					else if(startingBounds.width - deltaX > max.width)
					    deltaX = -(startingBounds.width - min.width);
			
					newX = startingBounds.x;
					newY = startingBounds.y - deltaY;
					newW = startingBounds.width - deltaX;
					newH = startingBounds.height + deltaY;
	                break;
	            case EAST:      
					if(startingBounds.width - deltaX < min.width)
					    deltaX = (startingBounds.width - min.width);
					else if(startingBounds.width - deltaX > max.width)
					    deltaX = -(startingBounds.width - min.width);
			
					newW = startingBounds.width - deltaX;
					newH = startingBounds.height;
	                break;
	            case SOUTH_EAST:     
					if(startingBounds.width - deltaX < min.width)
					    deltaX = (startingBounds.width - min.width);
					else if(startingBounds.width - deltaX > max.width)
					    deltaX = -(startingBounds.width - min.width);
			
					if(startingBounds.height - deltaY < min.height)
					    deltaY = (startingBounds.height - min.height);
					else if(startingBounds.height - deltaY > max.height)
					    deltaY = -(startingBounds.height - min.height);
				
					newW = startingBounds.width - deltaX;
					newH = startingBounds.height - deltaY;
	                break;
	            case SOUTH:      
					if(startingBounds.height - deltaY < min.height)
					    deltaY = (startingBounds.height - min.height);
					else if(startingBounds.height - deltaY > max.height)
					    deltaY = -(startingBounds.height - min.height);
			
			 		newW = startingBounds.width;
					newH = startingBounds.height - deltaY;
	                break;
	            case SOUTH_WEST:
					if(startingBounds.height - deltaY < min.height)
					    deltaY = (startingBounds.height - min.height);
					else if(startingBounds.height - deltaY > max.height)
					    deltaY = -(startingBounds.height - min.height);
			
					if(startingBounds.width + deltaX < min.width)
					    deltaX = -(startingBounds.width - min.width);
					else if(startingBounds.width + deltaX > max.width)
					    deltaX = (startingBounds.width - min.width);
			
					newX = startingBounds.x - deltaX;
					newY = startingBounds.y;
					newW = startingBounds.width + deltaX;
					newH = startingBounds.height - deltaY;
	                break;
	            case WEST:      
					if(startingBounds.width + deltaX < min.width)
					    deltaX = -(startingBounds.width - min.width);
					else if(startingBounds.width + deltaX > max.width)
					    deltaX = (startingBounds.width - min.width);
			
					newX = startingBounds.x - deltaX;
					newY = startingBounds.y;
					newW = startingBounds.width + deltaX;
					newH = startingBounds.height;
	                break;
	            case NORTH_WEST:     
					if(startingBounds.width + deltaX < min.width)
					    deltaX = -(startingBounds.width - min.width);
					else if(startingBounds.width + deltaX > max.width)
					    deltaX = (startingBounds.width - min.width);
			
					if(startingBounds.height + deltaY < min.height)
					    deltaY = -(startingBounds.height - min.height);
					else if(startingBounds.height + deltaY > max.height)
					    deltaY = (startingBounds.height - min.height);
			
					newX = startingBounds.x - deltaX;
					newY = startingBounds.y - deltaY;
					newW = startingBounds.width + deltaX;
					newH = startingBounds.height + deltaY;
	                break;
	            default:
	                return;
            }

		    getDesktopManager().resizeFrame(frame, newX, newY, newW, newH);
		}

        public void mouseMoved(MouseEvent e) {

		    if(!frame.isResizable())
			return;
		
            if(e.getSource() == frame) {
                Insets i = frame.getInsets();
                if(e.getX() <= i.left) {
                    if(e.getY() < resizeCornerSize + i.top)
						frame.setCursor(Cursor.getPredefinedCursor(Cursor.NW_RESIZE_CURSOR));
                    else if(e.getY() > frame.getHeight() - resizeCornerSize - i.bottom)
						frame.setCursor(Cursor.getPredefinedCursor(Cursor.SW_RESIZE_CURSOR));
                    else                
						frame.setCursor(Cursor.getPredefinedCursor(Cursor.W_RESIZE_CURSOR));
                } else if(e.getX() >= frame.getWidth() - i.right) {
                    if(e.getY() < resizeCornerSize + i.top)
						frame.setCursor(Cursor.getPredefinedCursor(Cursor.NE_RESIZE_CURSOR));
                    else if(e.getY() > frame.getHeight() - resizeCornerSize - i.bottom)
						frame.setCursor(Cursor.getPredefinedCursor(Cursor.SE_RESIZE_CURSOR));
                    else                
						frame.setCursor(Cursor.getPredefinedCursor(Cursor.E_RESIZE_CURSOR));
                } else if(e.getY() <= i.top) {
                    if(e.getX() < resizeCornerSize + i.left)
						frame.setCursor(Cursor.getPredefinedCursor(Cursor.NW_RESIZE_CURSOR));
                    else if(e.getX() > frame.getWidth() - resizeCornerSize - i.right)
						frame.setCursor(Cursor.getPredefinedCursor(Cursor.NE_RESIZE_CURSOR));
                    else                
						frame.setCursor(Cursor.getPredefinedCursor(Cursor.N_RESIZE_CURSOR));
                } else if(e.getY() >= frame.getHeight() - i.bottom) {
                    if(e.getX() < resizeCornerSize + i.left)
						frame.setCursor(Cursor.getPredefinedCursor(Cursor.SW_RESIZE_CURSOR));
                    else if(e.getX() > frame.getWidth() - resizeCornerSize - i.right)
						frame.setCursor(Cursor.getPredefinedCursor(Cursor.SE_RESIZE_CURSOR));
                    else                
						frame.setCursor(Cursor.getPredefinedCursor(Cursor.S_RESIZE_CURSOR));
                }
			return;
            }

		    frame.setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));	
		}         

        public void mouseExited(MouseEvent e) {
			mouseReleased(e);
		    frame.setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));	
		}
    };    /// End BorderListener Class

}
