/*
 * @(#)MacInternalFrameTitlePane.java	1.8 98/04/10
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */
 
 
package com.sun.java.swing.plaf.mac;

import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.event.InternalFrameEvent;
import java.util.EventListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.beans.PropertyVetoException;

/**
 * Package private class that manages a Mac title bar
 *
 * @version @(#)MacInternalFrameTitlePane.java	1.0 11/24/97
 * @author Symantec
 * @author David Bustin
 */

class MacInternalFrameTitlePane 
    extends JComponent implements LayoutManager, ActionListener, PropertyChangeListener 
{
    CloseButton closeButton;
    MinimizeButton minimizeButton;
    ZoomButton zoomButton;
    Title title;
    JInternalFrame iFrame;
    Color color;
    Color highlight;
    Color shadow;

    static final Font defaultTitleFont = new Font("Chicago", Font.PLAIN, 12);
	
	protected static Color GSWColor = UIManager.getColor("GrayscaleAppearanceW");
	protected static Color GS2Color = UIManager.getColor("GrayscaleAppearance2");
	protected static Color GS3Color = UIManager.getColor("GrayscaleAppearance3");
	//protected static Color GS8Color = UIManager.getColor("GrayscaleAppearance8");

    // The width and height of a title pane button
    public final static int BUTTON_SIZE = 17;	// 13 + INDENT
    public final static int INDENT = 4;
    
    public MacInternalFrameTitlePane(JInternalFrame f) {
	iFrame = f;
	
	setPreferredSize(new Dimension(100, BUTTON_SIZE));

    closeButton = new CloseButton();
	closeButton.addActionListener(this);
	closeButton.setActionCommand("Close");

	minimizeButton = new MinimizeButton();
	minimizeButton.addActionListener(this);
	minimizeButton.setActionCommand("Iconify");

	zoomButton = new ZoomButton();
	zoomButton.addActionListener(this);
	zoomButton.setActionCommand("Maximize");

    title = new Title(iFrame.getTitle());
    title.setFont(defaultTitleFont);

	setLayout(this);

	add(closeButton);
    add(title);
	add(minimizeButton);
	add(zoomButton);

	// Make sure these are ok to leave on?
	iFrame.addPropertyChangeListener(this);
    }

    void setColors(Color c, Color h, Color s) {
        color = c;
        highlight = h;
        shadow = s;
    }

    public void actionPerformed(ActionEvent e) {
        try {
            if ("Close".equals(e.getActionCommand()) && iFrame.isClosable()) {
                postClosingEvent(iFrame); 
            } else if ("Iconify".equals(e.getActionCommand()) && 
                     iFrame.isIconifiable()) {
                if (!iFrame.isIcon()) {
                    iFrame.setIcon(true); 
                } else {
                    iFrame.setIcon(false); 
                }
            } else if ("Minimize".equals(e.getActionCommand()) && 
                       iFrame.isMaximizable()) {
                iFrame.setIcon(true);
            } else if ("Maximize".equals(e.getActionCommand()) && 
                       iFrame.isMaximizable()) {
                if(!iFrame.isMaximum()) {
                    iFrame.setMaximum(true);
                } else {
                    iFrame.setMaximum(false);
                }
            }
        } catch (PropertyVetoException e0) { }

    }

    public void propertyChange(PropertyChangeEvent evt) {
	String prop = (String)evt.getPropertyName();
	JInternalFrame f = (JInternalFrame)evt.getSource();
	boolean value = false;
	if(JInternalFrame.IS_SELECTED_PROPERTY.equals(prop)) {
	    repaint();
	} else if(JInternalFrame.IS_MAXIMUM_PROPERTY.equals(prop)) {
	    value = ((Boolean)evt.getNewValue()).booleanValue();
	} else if(JInternalFrame.IS_ICON_PROPERTY.equals(prop)) {
	    value = ((Boolean)evt.getNewValue()).booleanValue();
	} 
    }

    public void addLayoutComponent(String name, Component c) {}
    public void removeLayoutComponent(Component c) {}    
    public Dimension preferredLayoutSize(Container c)  {
	return new Dimension(c.getSize().width, BUTTON_SIZE);
    }
    
    public Dimension minimumLayoutSize(Container c) {
	return new Dimension(c.getSize().width, BUTTON_SIZE);
    }

    public void paint(Graphics g) {
	    Dimension d = getSize();
        if (iFrame.isSelected())
            	g.setColor(GS3Color);
        else
            	g.setColor(GS2Color);
	    g.fillRect(0,0,d.width-1,d.height-1);
		super.paint(g);
	}    

    public void layoutContainer(Container c) {
	int w = getWidth();
	int x = w - BUTTON_SIZE + INDENT;
	if (iFrame.isClosable()) 
		{
		closeButton.setBounds(0, 0, BUTTON_SIZE, BUTTON_SIZE);
		}

	if (iFrame.isIconifiable()) 
		{
	    minimizeButton.setBounds(x, 0, BUTTON_SIZE, BUTTON_SIZE);
	    x -= BUTTON_SIZE;
		} 
	else if (minimizeButton.getParent() != null)
		{
	    minimizeButton.getParent().remove(minimizeButton);
		}

	if (iFrame.isMaximizable())
		{
	    zoomButton.setBounds(x, 0, BUTTON_SIZE, BUTTON_SIZE);
	    x -= BUTTON_SIZE;
		} 
	else 
		if(zoomButton.getParent() != null)
		{
	    zoomButton.getParent().remove(zoomButton);
		}
        
	if (iFrame.isClosable())
	    title.setBounds(BUTTON_SIZE, 0, x-INDENT, BUTTON_SIZE);
	else
	    title.setBounds(0, 0, x+BUTTON_SIZE-INDENT, BUTTON_SIZE);

    }

    /**
     * Post a WINDOW_CLOSING-like event to the frame, so that it can
     * be treated like a regular Frame.
     */
    void postClosingEvent(JInternalFrame frame) {
        InternalFrameEvent e = new InternalFrameEvent(
            frame, InternalFrameEvent.INTERNAL_FRAME_CLOSING);
        // Try posting event, unless there's a SecurityManager.
        if (JInternalFrame.class.getClassLoader() == null) {
            try {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(e);
                return;
            } catch (SecurityException se) {
                // Use dispatchEvent instead.
            }
        }
        frame.dispatchEvent(e);
    }

    static Dimension buttonDimension = new Dimension(BUTTON_SIZE, BUTTON_SIZE);

    private abstract class FrameButton extends JButton {

        FrameButton() {
            super();
            setFocusPainted(false);     
            setBorderPainted(false);
        }

        public boolean isFocusTraversable() { 
            return false; 
        }

        public void requestFocus() {
            // ignore request.
        }

        public Dimension getMinimumSize() {
            return buttonDimension;
        }

        public Dimension getPreferredSize() {
            return buttonDimension;
        }

        public void paint(Graphics g) {
           
           if (iFrame.isSelected())
            	{
            	Dimension d = getSize();
            	int maxX = d.width;
            	int maxY = d.height - 5;

				// draw background
            	g.setColor(GS3Color);
				g.fillRect(0,0,maxX,d.height-1);
				
            	/* Disabled title bar shading to hightlight difference from
            	   normal Mac style frames */
            	/*
            	g.setColor(GSWColor);
				for (int y = 0; y < maxY; y += 2)
					g.drawLine(0,y,d.width - 2,y);
            	
            	g.setColor(GS8Color);
				for (int y = 1; y < maxY; y += 2)
					g.drawLine(1,y,d.width - 1,y);
				*/
				}
			else
				{
     		    g.setColor(GS2Color);

            	Dimension d = getSize();
				g.fillRect(0,0,d.width,d.height-1);
				}
        }
    }
    
    private class MinimizeButton extends FrameButton {
        private Icon minimizeEnabledIcon = UIManager.getIcon("Window.minimizeEnabled");
        private Icon minimizePressedIcon = UIManager.getIcon("Window.minimizePressed");
        public void paint(Graphics g) {
            if (iFrame.isSelected())
            	{
				if (getModel().isPressed())
		        	minimizePressedIcon.paintIcon(this, g, 0, 0);
		    	else
		        	minimizeEnabledIcon.paintIcon(this, g, 0, 0);
		        }
		    else
                super.paint(g);
       }
    }

    private class ZoomButton extends FrameButton {
        private Icon zoomEnabledIcon = UIManager.getIcon("Window.zoomEnabled");
        private Icon zoomPressedIcon = UIManager.getIcon("Window.zoomPressed");
        public void paint(Graphics g) {
            if (iFrame.isSelected())
            	{
				if (getModel().isPressed())
		        	zoomPressedIcon.paintIcon(this, g, 0, 0);
		    	else
		        	zoomEnabledIcon.paintIcon(this, g, 0, 0);
		        }
		    else
                super.paint(g);
        }
    }

    private class CloseButton extends FrameButton {
        private Icon closeEnabledIcon = UIManager.getIcon("Window.closeEnabled");
        private Icon closePressedIcon = UIManager.getIcon("Window.closePressed");
        public boolean isFocusTraversable() { return false; }
        public void requestFocus() {}

        public void paint(Graphics g) {
           if (iFrame.isSelected())
            	{
				if (getModel().isPressed())
	    	    	closePressedIcon.paintIcon(this, g, 0, 0);
	    		else
	        		closeEnabledIcon.paintIcon(this, g, 0, 0);
	        	}
		    else
                super.paint(g);
        }
    }

    private class Title extends FrameButton {
        Title(String title) {
            super();
            setText(title);
            setHorizontalAlignment(SwingConstants.CENTER);
            
            setBorder(BorderFactory.createBevelBorder(
                BevelBorder.RAISED,
                UIManager.getColor("activeCaptionBorder"),
                UIManager.getColor("inactiveCaptionBorder")));

            // Forward mouse events to titlebar for moves.
            addMouseMotionListener(new MouseMotionListener() {
                public void mouseDragged(MouseEvent e) {
                    forwardEventToParent(e);
                }
                public void mouseMoved(MouseEvent e) {
                    forwardEventToParent(e);
                }
            });
            addMouseListener(new MouseListener() {
                public void mouseClicked(MouseEvent e) {
                    forwardEventToParent(e);
                }
                public void mousePressed(MouseEvent e) {
                    forwardEventToParent(e);
                }
                public void mouseReleased(MouseEvent e) {
                    forwardEventToParent(e);
                }
                public void mouseEntered(MouseEvent e) {
                    forwardEventToParent(e);
                }
                public void mouseExited(MouseEvent e) {
                    forwardEventToParent(e);
                }
            });
        }

        void forwardEventToParent(MouseEvent e) {
            getParent().dispatchEvent(new MouseEvent(
                getParent(), e.getID(), e.getWhen(), e.getModifiers(),
                e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger()));
        }

        public void paint(Graphics g) {
            Color background;
            super.paint(g);
            if (iFrame.isSelected()) {
                background = GS3Color;
                g.setColor(UIManager.getColor("activeCaptionText"));
            } else {
                background = GS2Color;
               g.setColor(UIManager.getColor("inactiveCaptionText"));
            }
            Dimension d = getSize();
            MacGraphicsUtils.drawStringInRect(g, iFrame.getTitle(),
                                                0, 0, d.width, d.height,
                                                SwingConstants.CENTER,
                                                background);
        }
    }

}    /// End Title Pane Class
