/*
 * @(#)MacInternalFrameBorder.java	1.6 98/02/02
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */
 
 
package com.sun.java.swing.plaf.mac;

import java.awt.Graphics;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Color;
import java.awt.Insets;

import java.awt.*;
import java.beans.*;

import com.sun.java.swing.*;
import com.sun.java.swing.border.AbstractBorder;

/**
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version @(#)MacInternalFrameBorder.java	1.0 11/24/97
 * @author Symantec
 * @author David Bustin
 */

public class MacInternalFrameBorder extends MacFrameBorder {

    JInternalFrame frame;

    // The size of the bounding box for Mac frame corners.
    public final static int CORNER_SIZE = 22;

    /** Constructs an InternalFrameBorder for the InternalFrame
      * <b>aFrame</b>.
      */
    public MacInternalFrameBorder(JInternalFrame aFrame) {
        super(aFrame);
        frame = aFrame;
    }

    /** Sets the InternalFrameBorder's InternalFrame.
      */
    public void setFrame(JInternalFrame aFrame) {
        frame = aFrame;
    }

    /** Returns the InternalFrameBorder's InternalFrame.
      * @see #setFrame
      */
    public JInternalFrame frame() {
        return frame;
    }

    /** Returns the width of the InternalFrameBorder's resize controls,
      * appearing along the InternalFrameBorder's bottom border.  Clicking
      * and dragging within these controls lets the user change both the
      * InternalFrame's width and height, while dragging between the controls
      * constrains resizing to just the vertical dimension.  Override this
      * method if you implement your own bottom border painting and use a
      * resize control with a different size.
      */
    public int resizePartWidth() {
        if (!frame.isResizable()) {
            return 0;
        }
        return MacFrameBorder.BORDER_SIZE;
    }

    /** Draws the InternalFrameBorder's top border.
     */
    protected boolean drawTopBorder(Component c, Graphics g, 
                                    int x, int y, int width, int height) {
        if (super.drawTopBorder(c, g, x, y, width, height) && 
            frame.isResizable()) {
            return true;
        }
        return false;
    }

    /** Draws the InternalFrameBorder's left border.
      */
    protected boolean drawLeftBorder(Component c, Graphics g, int x, int y, 
                                     int width, int height) {
        if (super.drawLeftBorder(c, g, x, y, width, height) && 
            frame.isResizable()) {

			if (!isActiveFrame() || height < 2 * CORNER_SIZE)
				return true;

			// draw resize marks
	        g.setColor(GS6Color);
        	g.drawLine(x + 2, height - CORNER_SIZE, x + 5, height - CORNER_SIZE);

	        g.setColor(GSWColor);
        	g.drawLine(x + 2, height - CORNER_SIZE + 1, x + 5, height - CORNER_SIZE + 1);
            return true;
        }
        return false;
    }

    /** Draws the InternalFrameBorder's right border.
      */
    protected boolean drawRightBorder(Component c, Graphics g, int x, int y, 
                                      int width, int height) {
        if (super.drawRightBorder(c, g, x, y, width, height) && 
            frame.isResizable()) {

			if (!isActiveFrame() || height < 2 * CORNER_SIZE)
				return true;

			// draw resize marks
	        g.setColor(GS6Color);
        	g.drawLine(width - 6, height - CORNER_SIZE + 1, width - 3, height - CORNER_SIZE + 1);

	        g.setColor(GSWColor);
        	g.drawLine(width - 6, height - CORNER_SIZE, width - 3, height - CORNER_SIZE);
            return true;
        }
        return false;
    }

    /** Draws the InternalFrameBorder's bottom border.
      */
    protected boolean drawBottomBorder(Component c, Graphics g, int x, int y, 
                                       int width, int height) {

        if (super.drawBottomBorder(c, g, x, y, width, height) &&
            frame.isResizable()) {

			if (!isActiveFrame() || height < 2 * CORNER_SIZE)
				return true;

			// draw resize marks
	        g.setColor(GS6Color);
        	g.drawLine(x + CORNER_SIZE - 1, height - 6, x + CORNER_SIZE - 1, height - 3);
        	g.drawLine(width - CORNER_SIZE, height - 6, width - CORNER_SIZE, height - 3);

	        g.setColor(GSWColor);
        	g.drawLine(x + CORNER_SIZE, height - 6, x + CORNER_SIZE, height - 3);
        	g.drawLine(width - CORNER_SIZE + 1, height - 6, width - CORNER_SIZE + 1, height - 3);

            return true;
        }
        return false;
    }

    // Returns true if the associated internal frame has focus.
    protected boolean isActiveFrame() {
        return frame.isSelected();
    }
}
