/*
 * @(#)MacIconFactory.java	1.4 98/02/02
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */
 
 
package com.sun.java.swing.plaf.mac;

import com.sun.java.swing.*;
import com.sun.java.swing.plaf.UIResource;
import com.sun.java.swing.plaf.ComponentUI;

import java.awt.Graphics;
import java.awt.Color;
import java.awt.Component;
import java.awt.Polygon;
import java.io.Serializable;

/**
 * Factory object that can vend Icons appropriate for the Macintosh L & F.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.4 02/02/98
 * @author unknown
 */
public class MacIconFactory implements Serializable
{

	private interface MacControlInterface {
		static final int ENABLED_STATE = 0;
		static final int PRESSED_STATE = 1;
		static final int DISABLED_STATE = 2;
		static final int	NUM_STATES = 3;
	
		static final int OFF = 0;
		static final int ON = 1;
		static final int	NUM_VALUES = 2;

		Icon getIcon(int state, int value);
	}
	
	private static abstract class MacControlIcon implements MacControlInterface, Icon, UIResource, Serializable {

		public void paintIcon(Component c, Graphics g, int x, int y)
		{
			boolean isActive = true;
			ButtonModel model = ((AbstractButton) c).getModel();
			ComponentUI ui = ((AbstractButton) c).getUI();
			if(ui instanceof MacRadioButtonUI)
			{
				isActive = ((MacRadioButtonUI)ui).isActive();
			}

			int isOn = model.isSelected() ? 1 : 0;
			Icon img;

			if (!model.isEnabled() || !isActive)
				img = getIcon(DISABLED_STATE, isOn);
			else if (model.isPressed() && model.isArmed())
				img = getIcon(PRESSED_STATE, isOn);
			else
				img = getIcon(ENABLED_STATE, isOn);

			img.paintIcon(c, g, x, y);
		}

		public int getIconWidth() {
			return getIcon(ENABLED_STATE, OFF).getIconWidth();	// Assume all icons are the same size
		}

		public int getIconHeight() {
			return getIcon(ENABLED_STATE, OFF).getIconHeight();	// Assume all icons are the same size
		}
	}

    private static class MacRadioButtonIcon extends MacControlIcon
    {
		// Constructor of subclasses MUST fill in the icon values
		protected static Icon[][] imageIcons = new Icon[NUM_STATES][NUM_VALUES];

		MacRadioButtonIcon()
		{
			if (imageIcons[ENABLED_STATE][OFF] == null)
			{
				imageIcons[ENABLED_STATE][OFF]	= UIManager.getIcon("RadioButton.enabledOff");
				imageIcons[ENABLED_STATE][ON]	= UIManager.getIcon("RadioButton.enabledOn");
				imageIcons[PRESSED_STATE][OFF]	= UIManager.getIcon("RadioButton.pressedOff");
				imageIcons[PRESSED_STATE][ON]	= UIManager.getIcon("RadioButton.pressedOn");
				imageIcons[DISABLED_STATE][OFF]	= UIManager.getIcon("RadioButton.disabledOff");
				imageIcons[DISABLED_STATE][ON]	= UIManager.getIcon("RadioButton.disabledOn");
			}
		}
		
		public Icon getIcon(int state, int value)
		{
			return imageIcons[state][value];
		}
	}

    private static class MacCheckboxIcon extends MacControlIcon
    {
    	// Constructor of subclasses MUST fill in the icon values
		protected static Icon[][] imageIcons = new Icon[NUM_STATES][NUM_VALUES];

		MacCheckboxIcon()
		{
			if (imageIcons[ENABLED_STATE][OFF] == null)
			{
				imageIcons[ENABLED_STATE][OFF]	= UIManager.getIcon("CheckBox.enabledOff");
				imageIcons[ENABLED_STATE][ON]	= UIManager.getIcon("CheckBox.enabledOn");
				imageIcons[PRESSED_STATE][OFF]	= UIManager.getIcon("CheckBox.pressedOff");
				imageIcons[PRESSED_STATE][ON]	= UIManager.getIcon("CheckBox.pressedOn");
				imageIcons[DISABLED_STATE][OFF]	= UIManager.getIcon("CheckBox.disabledOff");
				imageIcons[DISABLED_STATE][ON]	= UIManager.getIcon("CheckBox.disabledOn");
			}
		}
		
		public Icon getIcon(int state, int value)
		{
			return imageIcons[state][value];
		}
	}

	public static Icon getCheckBoxIcon()
	{
		return new MacCheckboxIcon();
	}
	
	public static Icon getRadioButtonIcon()
	{
		return new MacRadioButtonIcon();
	}
}
