/*
 * @(#)MacGraphicsUtils.java	1.6 98/01/30
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */
 
 
package com.sun.java.swing.plaf.mac;

import com.sun.java.swing.*;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.Component;
import java.awt.Insets;

import com.sun.java.swing.plaf.basic.*;

/**
 * @version @(#)MacGraphicsUtils.java	1.0 11/24/97
 * @author Symantec
 */

public class MacGraphicsUtils implements SwingConstants 
{
    public static final Font controlFont = new Font("Dialog", Font.PLAIN, 12);

    public static Color control = new Color(192,192,192);
    public static Color controlLight = new Color(231, 231, 231);
    public static Color controlShadow = new Color(102,102,102);
    public static Color controlLightShadow = new Color(155,155,155);
    public static Color controlHighlight = Color.white;
    public static Color controlDisabled = new Color(117, 117, 117);
    public static Color controlBlack = Color.black;
    public static Color controlWhite = Color.white;
    
    public final static Color GS3Color = UIManager.getColor("GrayscaleAppearance3");

    /**
     * Convenience method for drawing a button bezel.
     */
    static void drawButtonBezel(Graphics g, int x, int y,
				int width, int height, boolean raised)
    {
	// ** Paint the button in
	if(raised) {
	    g.setColor(MacGraphicsUtils.controlWhite);
	    g.drawLine(x+1, y+1, x+1, y+1);
	    
	    g.setColor(MacGraphicsUtils.controlLight);
	    g.drawLine(x, y, x+width-3, y);
	    g.drawLine(x, y, x, y+height-4);
	    
	    g.setColor(controlLightShadow);
	    g.drawLine(x+1, y+height-2, x+width-3, y+height-2);
	    g.drawLine(x+width-2, y+height-1, x+width-2, y+1);
	    
	    g.drawLine(x+width-3, y+height-3, x+width-3, y+height-3);
	    g.drawLine(x+width-1, y+0, x+width-1, y+0);
	    g.drawLine(x+0, y+height-1, x+0, y+height-1);
	    
	    g.setColor(MacGraphicsUtils.controlShadow);
	    g.drawLine(x+1, y+height-1, x+width-1, y+height-1);
	    g.drawLine(x+width-1, y+height-2, x+width-1, y+1);
	    g.drawLine(x+width-2, y+height-2, x+width-2, y+height-2);
	} else {
	    g.setColor(controlWhite);
	    g.drawLine(x + width-2, y + height-2, x + width-2, y + height-2);
	    
	    g.setColor(controlLight);
	    g.drawLine(x+2,       y+height-1,  x+width-1, y+height-1);
	    g.drawLine(x+width-1, y+height-2,  x+width-1, y+3);
	    
	    g.setColor(controlLightShadow);
	    g.drawLine(x+2, y+1, x+width-2, y+1);
	    g.drawLine(x+1, y+2, x+1,       y+height-2);
	    
	    g.drawLine(width-1, y,          x+width-1, y);
	    g.drawLine(x+2,     y+2,        x+2,       y+2);
	    g.drawLine(x,       y+height-1, x+0,       y+height-1);
	    
	    g.setColor(controlShadow);
	    g.drawLine(x,   y,   x+width-2, y);
	    g.drawLine(x,   y+1, x,         y+height-2);
	    g.drawLine(x+1, y+1, x+1,       y+1);
	}
    }
    
	
    /**
     * Draws the point (<b>x</b>, <b>y</b>) in the current color.
     */
    static void drawPoint(Graphics g, int x, int y) {
        g.drawLine(x, y, x, y);
    }

    /**
     * Draws the Image tiled in the supplied rectangle.  Calls
     * <b>paint()</b> for each tile.
     */
    static void drawTiledIcon(Component c, Icon icon, Graphics g1, int x, int y, int width, int height) {
        Rectangle clipRect;
        int imageWidth, imageHeight, minX, minY, maxX, maxY;

		Graphics g = g1.create();

        clipRect = g1.getClipBounds();

        imageWidth = icon.getIconWidth();
        imageHeight = icon.getIconHeight();

        if (imageWidth <= 0 || imageHeight <= 0)
            return;

        g.setClip(x, y, width, height);

        if (x > clipRect.x)
            minX = x;
        else
            minX = x + imageWidth * ((clipRect.x - x) / imageWidth);

        if ((x + width) < (clipRect.x + clipRect.width))
            maxX = x + width;
        else
            maxX = (clipRect.x + clipRect.width);

        if (y > clipRect.y)
            minY = y;
        else
            minY= y + imageHeight * ((clipRect.y - y) / imageHeight);

        if ((y + height) < (clipRect.y + clipRect.height))
            maxY = (y + height);
        else
            maxY = (clipRect.y + clipRect.height);

        for (x = minX; x < maxX; x += imageWidth) {
            for (y = minY; y < maxY; y += imageHeight) {
                icon.paintIcon(c, g, x, y);
            }
        }
		g.dispose();
    }

    /** Draws <b>aString</b> in the rectangle defined by
      * (<b>x</b>, <b>y</b>, <b>width</b>, <b>height</b>).
      * <b>justification</b> specifies the text's justification, one of
      * LEFT, CENTER, or RIGHT.
      * If <b>background</b> is not null, a background with the specified color 
      * is first drawn.
      * <b>drawStringInRect()</b> does not clip to the rectangle, but instead
      * uses this rectangle and the desired justification to compute the point
      * at which to begin drawing the text.
      * @see #drawString
      */
    public static void drawStringInRect(Graphics g, String aString, int x, int y,
                                 int width, int height, int justification, Color background) {
        FontMetrics  fontMetrics;
        int          drawWidth, startX, startY, delta;

        if (g.getFont() == null) {
//            throw new InconsistencyException("No font set");
            return;
        }
        fontMetrics = g.getFontMetrics();
        if (fontMetrics == null) {
//            throw new InconsistencyException("No metrics for Font " + font());
            return;
        }

        if (justification == CENTER) {
            drawWidth = fontMetrics.stringWidth(aString);
            if (drawWidth > width) {
                drawWidth = width;
            }
            startX = x + (width - drawWidth) / 2;
        } else if (justification == RIGHT) {
            drawWidth = fontMetrics.stringWidth(aString);
            if (drawWidth > width) {
                drawWidth = width;
            }
            startX = x + width - drawWidth;
        } else {
            startX = x;
            drawWidth = width;
        }

        delta = (height - fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
        if (delta < 0) {
            delta = 0;
        }

        startY = y + height - delta - 2 * fontMetrics.getDescent();
		if (background != null)
			{
			startY -= 1;
			Color save = g.getColor();
			g.setColor(background);
			g.fillRect(startX - 4, 0, drawWidth + 8, height - 3);
			g.setColor(save);
			}
		else
			g.setClip(x, y, width, height);

        g.drawString(aString, startX, startY);
    }

    public static Dimension getPreferredButtonSize(AbstractButton b, int textIconGap)
    {
		if (b.getComponentCount() > 0) {
		    return null;
		}

        Icon icon = (Icon) b.getIcon();
        String text = b.getText();

        Font font = b.getFont();
        FontMetrics fm = b.getToolkit().getFontMetrics(font);
	  
        Rectangle iconR = new Rectangle();
        Rectangle textR = new Rectangle();
        Rectangle viewR = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);

        SwingUtilities.layoutCompoundLabel(fm, text, icon,
	    		b.getVerticalAlignment(), b.getHorizontalAlignment(),
	    		b.getVerticalTextPosition(), b.getHorizontalTextPosition(),
	    		viewR, iconR, textR, (text == null ? 0 : textIconGap)
		);

		/* The preferred size of the button is the size of 
		 * the text and icon rectangles plus the buttons insets.
		 */

        Rectangle r = iconR.union(textR);

		Insets insets = b.getInsets();
		r.width += insets.left + insets.right;
		r.height += insets.top + insets.bottom;

        return r.getSize();
    }
}



