/*
 * @(#)MacFrameBorder.java	1.6 98/02/02
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */
 
 
package com.sun.java.swing.plaf.mac;

import java.awt.Graphics;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Color;
import java.awt.Insets;

import java.awt.*;
import java.beans.*;

import com.sun.java.swing.*;
import com.sun.java.swing.border.AbstractBorder;
import com.sun.java.swing.plaf.UIResource;

/**
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version @(#)MacFrameBorder.java	1.0 11/24/97
 * @author Symantec
 * @author David Bustin
 */

public class MacFrameBorder extends AbstractBorder implements UIResource {

    JComponent jcomp;
    Color frameHighlight;
    Color frameColor;
    Color frameShadow;
    Color frameBackground;

    protected static Color GSWColor = UIManager.getColor("GrayscaleAppearanceW");
    protected static Color GSBColor = UIManager.getColor("GrayscaleAppearanceB");
    protected static Color GS2Color = UIManager.getColor("GrayscaleAppearance2");
    protected static Color GS3Color = UIManager.getColor("GrayscaleAppearance3");
    protected static Color GS6Color = UIManager.getColor("GrayscaleAppearance6");
    protected static Color GS10Color = UIManager.getColor("GrayscaleAppearance10");
    
    // The width of the border
    public final static int BORDER_SIZE = 7;

    /** Constructs an FrameBorder for the JComponent <b>comp</b>.
      */
    public MacFrameBorder(JComponent comp) {
        jcomp = comp;
    }

    /** Sets the FrameBorder's JComponent.
      */
    public void setComponent(JComponent comp) {
        jcomp = comp;
    }

    /** Returns the FrameBorder's JComponent.
      * @see #setComponent
      */
    public JComponent component() {
        return jcomp;
    }

    protected Color getFrameHighlight() {
        return frameHighlight;
    }

    protected Color getFrameColor() {
        return frameColor;
    }
    
    protected Color getFrameShadow() {
        return frameShadow;
    }

    protected Color getFrameBackground() {
        return frameBackground;
    }
    
    static Insets insets = new Insets(BORDER_SIZE, BORDER_SIZE,
                                      BORDER_SIZE, BORDER_SIZE);

    public Insets getBorderInsets(Component c) {
        return insets;
    }

   /** Draws the FrameBorder's top border.
     */
    protected boolean drawTopBorder(Component c, Graphics g, 
                                    int x, int y, int width, int height) {
        Rectangle titleBarRect = new Rectangle(x, y, width, BORDER_SIZE);
        if (!g.getClipBounds().intersects(titleBarRect)) {
            return false;
        }

        g.setColor(frameColor);
        g.drawLine(1, 1, width - 2, 1);
        
        g.setColor(frameHighlight);
        g.drawLine(2, 2, width - 3, 2);
        
        g.setColor(frameBackground);
        g.fillRect(3, 3, width - 6, 4);

		return true;
    }

    /** Draws the FrameBorder's left border.
      */
    protected boolean drawLeftBorder(Component c, Graphics g, int x, int y, 
                               int width, int height) {
        Rectangle borderRect = 
            new Rectangle(0, 0, getBorderInsets(c).left, height);
        if (!g.getClipBounds().intersects(borderRect)) {
            return false;
        }
        
        g.setColor(frameBackground);
        g.fillRect(3, 5, 6, height - 11);

        g.setColor(frameColor);
        g.drawLine(1, 2, 1, height - 3);

        g.setColor(frameHighlight);
        g.drawLine(2, 3, 2, height - 4);

        return true;
    }

    /** Draws the FrameBorder's right border.
      */
    protected boolean drawRightBorder(Component c, Graphics g, int x, int y, 
                                int width, int height) {
        Rectangle borderRect = new Rectangle(
            width - getBorderInsets(c).right, 0,
            getBorderInsets(c).right, height);
        if (!g.getClipBounds().intersects(borderRect)) {
            return false;
        }

        int startX = width - BORDER_SIZE;
		
        g.setColor(frameBackground);
        g.fillRect(startX, 5, startX + 3, height - 11);

        g.setColor(GS6Color);
        g.drawLine(startX + 4, 3, startX + 4, height - 4);

        g.setColor(frameColor);
        g.drawLine(startX + 5, 2, startX + 5, height - 3);

        g.setColor(frameShadow);
        g.drawLine(startX + 6, 1, startX + 6, height - 1);

        return true;
    }

    /** Draws the FrameBorder's bottom border.
      */
    protected boolean drawBottomBorder(Component c, Graphics g, int x, int y, 
                                 int width, int height) {
        Rectangle    borderRect;
        int     marginHeight, startY;

        borderRect = new Rectangle(0, height - getBorderInsets(c).bottom,
                                  width, getBorderInsets(c).bottom);
        if (!g.getClipBounds().intersects(borderRect)) {
            return false;
        }

        startY = height - BORDER_SIZE + 1;
		
        g.setColor(frameBackground);
        g.fillRect(3, startY, width - 6, 3);

        g.setColor(GS6Color);
        g.drawLine(2, startY + 3, width - 3, startY + 3);

        g.setColor(frameColor);
        g.drawLine(1, startY + 4, width - 2, startY + 4);
	
        g.setColor(frameShadow);
        g.drawLine(2, startY + 5, width - 1, startY + 5);

        return true;
    }

    // Returns true if the associated component has focus.
    protected boolean isActiveFrame() {
        return jcomp.hasFocus();
    }

    /** Draws the FrameBorder in the given Rect.  Calls
      * <b>drawTitleBar</b>, <b>drawLeftBorder</b>, <b>drawRightBorder</b> and
      * <b>drawBottomBorder</b>.
      */
    public void paintBorder(Component c, Graphics g, 
                            int x, int y, int width, int height) {
        if (isActiveFrame()) {
            frameColor = GSBColor;
	    	frameHighlight = GSWColor;
	    	frameBackground = GS3Color;
        	} 
        else 
        	{
            frameColor = GS10Color;
	    	frameHighlight = GS2Color;
	    	frameBackground = GS2Color;
            }

        frameShadow = frameColor;

        drawTopBorder(c, g, x, y, width, height);
        drawLeftBorder(c, g, x, y, width, height);
        drawRightBorder(c, g, x, y, width, height);
        drawBottomBorder(c, g, x, y, width, height);
        g.setColor(GSBColor);
        g.drawRect(x+BORDER_SIZE-1, y+BORDER_SIZE+16, width-2*BORDER_SIZE+1, height-2*BORDER_SIZE-16);
     }
}
