/*
 * @(#)MacFocusBorder.java	1.5 98/02/02
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */
 
 
package com.sun.java.swing.plaf.mac;

import com.sun.java.swing.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.plaf.*;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Color;
import java.awt.Graphics;

/**
* @version @(#)MacFocusBorder.java	1.0 12/5/97
* @author Symantec
*/

class MacFocusBorder extends AbstractBorder implements UIResource
{
	final static Insets borderInsets = new Insets(3, 3, 3, 3);
    final static Insets noInsets = new Insets(0, 0, 0, 0);
    
    private Color black = MacUtilities.GrayscaleAppearanceB;
    private Color white = MacUtilities.GrayscaleAppearanceW;
    private Color macFive = MacUtilities.GrayscaleAppearance5;
    private Color macEight = MacUtilities.GrayscaleAppearance8;
    
   	boolean containedInScrollPane = false;
   	boolean hasCurrentFocus = false;
      
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) 
    {
    	//don't draw the border if inside a scroll pane
    	Component parent = c.getParent();
		while(parent != null) 
		{
			if(parent instanceof JScrollPane)
				return;
				
			parent = parent.getParent();
		}
		    		
   		boolean ownsFocus = false;
   		
   		if(!(c instanceof com.sun.java.swing.JComponent))
   			return;
   			
   		JComponent jC = (com.sun.java.swing.JComponent)c;

		ownsFocus = jC.hasFocus();
	    
		if(ownsFocus == true)
		{
			if(hasCurrentFocus == false)
			{
				g.setClip(0,0,jC.getWidth(), jC.getHeight());
				hasCurrentFocus = true;
			}
		    g.setColor(black);
			g.drawRect(2, 2, w-5, h-5);
			
			java.awt.Color color = AppearanceFilter.FilterColor(macEight);
			g.setColor(color);
			g.drawRect(1, 1, w-3, h-3);
			g.drawLine(1, 0, w-2, 0);
			g.drawLine(0, 1, 0, h-2);
			g.drawLine(1, h-1, w-2, h-1);
			g.drawLine(w-1, 1, w-1, h-2);
		}
		else
		{
			if(hasCurrentFocus == true)
			{
				g.setClip(0,0,jC.getWidth(), jC.getHeight());
				hasCurrentFocus = false;
			}
		    g.setColor(black);
			g.drawRect(2, 2, w-5, h-5);
			
			g.setColor(macFive);
			g.drawLine(1, 1, w-3, 1);
			g.drawLine(1, 1, 1, h-3);
			
			g.setColor(white);
			g.drawLine(w-2, 2, w-2, h-2);
			g.drawLine(2, h-2, w-3, h-2);
			
			g.setColor(c.getParent().getBackground());
			g.drawRect(0, 0, w-1, h-1);
		}
    }
	
    public Insets getBorderInsets(Component c)
    {
    	//no border if inside a scroll pane
    	Component parent = c.getParent();
		while(parent != null)
		{
			if(parent instanceof JScrollPane)
         		return noInsets;
         		
			parent = parent.getParent();
		}

		return borderInsets;
    }
}
