/*
 * @(#)MacDesktopPaneUI.java	1.4 98/01/30
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */
 
 
package com.sun.java.swing.plaf.mac;

import com.sun.java.swing.*;
import java.awt.Rectangle;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Color;
import java.awt.Graphics;
import com.sun.java.swing.plaf.*;


/**
 * @version @(#)MacDesktopPaneUI.java	1.0 11/24/97
 * @author Symantec
 */

public class MacDesktopPaneUI extends DesktopPaneUI
{
    JDesktopPane desktop;
    DesktopManager desktopManager;

/// DesktopPaneUI methods
    public static ComponentUI createUI(JComponent d)    {
        return new MacDesktopPaneUI();
    }

    public MacDesktopPaneUI() {
    }

    public void installUI(JComponent c)   {
	desktop = (JDesktopPane)c;
	if(desktop.getDesktopManager() == null) {
	    desktopManager = new MacDesktopManager();
	    desktop.setDesktopManager(desktopManager);
	}
	/// PENDING(klobad) should handle iconified frames properly
    }

    public void uninstallUI(JComponent c) {
	if(desktop.getDesktopManager() == desktopManager) {
	    desktop.setDesktopManager(null);
	}
	desktop = null;
    }

    public void paint(Graphics g, JComponent c) {}
    public Dimension getPreferredSize(JComponent c) {return null;}
    public Dimension getMinimumSize(JComponent c) {return new Dimension(0, 0);}
    public Dimension getMaximumSize(JComponent c) {
	return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }
    public Insets getInsets(JComponent c) {return new Insets(0,0,0,0);}

////////////////////////////////////////////////////////////////////////////////////
///  DragPane class
////////////////////////////////////////////////////////////////////////////////////
    private class DragPane extends JComponent {
	public void paint(Graphics g) {
	    g.setColor(Color.darkGray);
	    g.drawRect(0, 0, getWidth()-1, getHeight()-1);
	}
    };

////////////////////////////////////////////////////////////////////////////////////
///  MacDesktopManager class
////////////////////////////////////////////////////////////////////////////////////
    private class MacDesktopManager extends DefaultDesktopManager {
        JComponent dragPane;
        boolean usingDragPane;

    // PENDING(klobad) this should be optimized
    public void setBoundsForFrame(JComponent f, int newX, int newY, 
			int newWidth, int newHeight) {
	if(!usingDragPane) {
            boolean didResize;
            didResize = (f.getWidth() != newWidth || f.getHeight() != newHeight);
	    Rectangle r = f.getBounds();
	    f.setBounds(newX, newY, newWidth, newHeight);		
	    SwingUtilities.computeUnion(newX, newY, newWidth, newHeight, r);
	    f.getParent().repaint(r.x, r.y, r.width, r.height);
	    if(didResize) {
	        f.validate();
  	    }
	} else {
	    Rectangle r = dragPane.getBounds();
	    dragPane.setBounds(newX, newY, newWidth, newHeight);		
	    SwingUtilities.computeUnion(newX, newY, newWidth, newHeight, r);
	    dragPane.getParent().repaint(r.x, r.y, r.width, r.height);
	}
    }

    public void beginDraggingFrame(JComponent f) {	
	usingDragPane = false;
	if(f.getParent() instanceof JLayeredPane) {
	    if(dragPane == null)
		dragPane = new DragPane();
	    JLayeredPane p = (JLayeredPane)f.getParent();
	    p.setLayer(dragPane, Integer.MAX_VALUE);
	    dragPane.setBounds(f.getX(), f.getY(), f.getWidth(), f.getHeight());
	    p.add(dragPane);
	    usingDragPane = true;
	}
    }

    public void dragFrame(JComponent f, int newX, int newY) {
	setBoundsForFrame(f, newX, newY, f.getWidth(), f.getHeight());
    }

    public void endDraggingFrame(JComponent f) {
	if(usingDragPane) {
	    JLayeredPane p = (JLayeredPane)f.getParent();
	    p.remove(dragPane);
	    usingDragPane = false;
            setBoundsForFrame(f, dragPane.getX(), dragPane.getY(), 
				dragPane.getWidth(), dragPane.getHeight());
	}
    }

    public void beginResizingFrame(JComponent f, int direction) {
	usingDragPane = false;
	if(f.getParent() instanceof JLayeredPane) {
	    if(dragPane == null)
		dragPane = new DragPane();
	    JLayeredPane p = (JLayeredPane)f.getParent();
	    p.setLayer(dragPane, Integer.MAX_VALUE);
	    dragPane.setBounds(f.getX(), f.getY(), 
				f.getWidth(), f.getHeight());
	    p.add(dragPane);
	    usingDragPane = true;
	}
    }

    public void resizeFrame(JComponent f, int newX, int newY, 
				int newWidth, int newHeight) {
	setBoundsForFrame(f, newX, newY, newWidth, newHeight);
    }

    public void endResizingFrame(JComponent f) {
	if(usingDragPane) {
	    JLayeredPane p = (JLayeredPane)f.getParent();
	    p.remove(dragPane);
	    usingDragPane = false;
            setBoundsForFrame(f, dragPane.getX(), dragPane.getY(), 
				dragPane.getWidth(), dragPane.getHeight());
	}
    }

    }; /// END of MacDesktopManager

}

